/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.mls;

import boofcv.alg.distort.mls.TypeDeformMLS;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;
import java.util.Arrays;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ejml.data.FMatrix2x2;

public class ImageDeformPointMLS_F32
implements Point2Transform2_F32 {
    DogArray<Control> controls = new DogArray<Control>(Control::new);
    int gridRows;
    int gridCols;
    DogArray<Point2D_F32> deformationGrid = new DogArray<Point2D_F32>(Point2D_F32::new);
    float alpha = 1.5f;
    float scaleX;
    float scaleY;
    Model model;
    DogArray_F32 weights = new DogArray_F32();
    DogArray<FMatrix2x2> matrices = new DogArray<FMatrix2x2>(FMatrix2x2::new);
    DogArray_F32 A = new DogArray_F32();
    Point2D_F32 aveP = new Point2D_F32();
    Point2D_F32 aveQ = new Point2D_F32();
    float totalWeight;
    float mu;

    public ImageDeformPointMLS_F32(TypeDeformMLS type) {
        switch (type) {
            case AFFINE: {
                this.model = new AffineModel();
                break;
            }
            case SIMILARITY: {
                this.model = new SimilarityModel();
                break;
            }
            case RIGID: {
                this.model = new RigidModel();
                break;
            }
            default: {
                throw new RuntimeException("Unknown model type " + type);
            }
        }
    }

    protected ImageDeformPointMLS_F32() {
    }

    public void reset() {
        this.controls.reset();
    }

    public void configure(int width, int height, int gridRows, int gridCols) {
        int s = Math.max(width, height);
        this.scaleX = (float)s / (float)(gridCols - 1);
        this.scaleY = (float)s / (float)(gridRows - 1);
        if (gridRows > gridCols) {
            this.scaleY /= (float)(gridCols - 1) / (float)(gridRows - 1);
        } else {
            this.scaleX /= (float)(gridRows - 1) / (float)(gridCols - 1);
        }
        this.gridRows = gridRows;
        this.gridCols = gridCols;
        this.deformationGrid.resize(gridCols * gridRows);
        this.reset();
    }

    public int addControl(float x, float y) {
        Control c = this.controls.grow();
        c.q.setTo(x, y);
        this.setUndistorted(this.controls.size - 1, x, y);
        return this.controls.size - 1;
    }

    public void setUndistorted(int which, float x, float y) {
        if (this.scaleX <= 0.0f || this.scaleY <= 0.0f) {
            throw new IllegalArgumentException("Must call configure first");
        }
        ((Control)this.controls.get((int)which)).p.setTo(x / this.scaleX, y / this.scaleY);
    }

    public int add(float srcX, float srcY, float dstX, float dstY) {
        int which = this.addControl(srcX, srcY);
        this.setUndistorted(which, dstX, dstY);
        return which;
    }

    public void setDistorted(int which, float x, float y) {
        ((Control)this.controls.get((int)which)).q.setTo(x, y);
    }

    public void fixate() {
        if (this.controls.size < 2) {
            throw new RuntimeException("Not enough control points specified. Found " + this.controls.size);
        }
        this.model.allocate(this.weights, this.A, this.matrices);
        for (int row = 0; row < this.gridRows; ++row) {
            for (int col = 0; col < this.gridCols; ++col) {
                float v_x = col;
                float v_y = row;
                this.computeWeights(v_x, v_y, this.weights.data);
                this.computeAverageP(this.weights.data);
                this.computeAverageQ(this.weights.data);
                this.model.computeIntermediate(v_x, v_y);
                this.model.computeDeformed(col, row, this.getGrid(row, col));
            }
        }
    }

    void computeAverageP(float[] weights) {
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < this.controls.size; ++i) {
            Control c = (Control)this.controls.get(i);
            float w = weights[i];
            x += c.p.x * w;
            y += c.p.y * w;
        }
        this.aveP.setTo(x / this.totalWeight, y / this.totalWeight);
    }

    void computeAverageQ(float[] weights) {
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < this.controls.size; ++i) {
            Control c = (Control)this.controls.get(i);
            float w = weights[i];
            x += c.q.x * w;
            y += c.q.y * w;
        }
        this.aveQ.setTo(x / this.totalWeight, y / this.totalWeight);
    }

    void computeWeights(float v_x, float v_y, float[] weights) {
        float totalWeight = 0.0f;
        for (int i = 0; i < this.controls.size; ++i) {
            Control c = (Control)this.controls.get(i);
            float d2 = c.p.distance2(v_x, v_y);
            if (d2 == 0.0f) {
                Arrays.fill(weights, 0.0f);
                weights[i] = 1.0f;
                totalWeight = 1.0f;
                break;
            }
            weights[i] = 1.0f / (float)Math.pow(d2, this.alpha);
            totalWeight += weights[i];
        }
        this.totalWeight = totalWeight;
    }

    @Override
    public void compute(float x, float y, Point2D_F32 out) {
        this.interpolateDeformedPoint(x / this.scaleX, y / this.scaleY, out);
    }

    @Override
    public ImageDeformPointMLS_F32 copyConcurrent() {
        ImageDeformPointMLS_F32 out = new ImageDeformPointMLS_F32();
        out.controls = this.controls;
        out.gridRows = this.gridRows;
        out.gridCols = this.gridCols;
        out.deformationGrid = this.deformationGrid;
        out.model = this.model;
        out.scaleX = this.scaleX;
        out.scaleY = this.scaleY;
        out.alpha = this.alpha;
        return out;
    }

    void interpolateDeformedPoint(float v_x, float v_y, Point2D_F32 deformed) {
        int x0 = (int)v_x;
        int y0 = (int)v_y;
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        if (x1 >= this.gridCols) {
            x1 = this.gridCols - 1;
        }
        if (y1 >= this.gridRows) {
            y1 = this.gridRows - 1;
        }
        float ax = v_x - (float)x0;
        float ay = v_y - (float)y0;
        float w00 = (1.0f - ax) * (1.0f - ay);
        float w01 = ax * (1.0f - ay);
        float w11 = ax * ay;
        float w10 = (1.0f - ax) * ay;
        Point2D_F32 d00 = this.getGrid(y0, x0);
        Point2D_F32 d01 = this.getGrid(y0, x1);
        Point2D_F32 d10 = this.getGrid(y1, x0);
        Point2D_F32 d11 = this.getGrid(y1, x1);
        deformed.setTo(0.0f, 0.0f);
        deformed.x += w00 * d00.x;
        deformed.x += w01 * d01.x;
        deformed.x += w11 * d11.x;
        deformed.x += w10 * d10.x;
        deformed.y += w00 * d00.y;
        deformed.y += w01 * d01.y;
        deformed.y += w11 * d11.y;
        deformed.y += w10 * d10.y;
    }

    Point2D_F32 getGrid(int row, int col) {
        return ((Point2D_F32[])this.deformationGrid.data)[row * this.gridCols + col];
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public class AffineModel
    implements Model {
        @Override
        public void allocate(DogArray_F32 weights, DogArray_F32 A2, DogArray<FMatrix2x2> matrices) {
            weights.resize(ImageDeformPointMLS_F32.this.controls.size);
            A2.resize(ImageDeformPointMLS_F32.this.controls.size);
            matrices.resize(ImageDeformPointMLS_F32.this.controls.size);
        }

        @Override
        public void computeIntermediate(float v_x, float v_y) {
            float inner00 = 0.0f;
            float inner01 = 0.0f;
            float inner11 = 0.0f;
            for (int i = 0; i < ImageDeformPointMLS_F32.this.controls.size; ++i) {
                Control c = (Control)ImageDeformPointMLS_F32.this.controls.get(i);
                float w = ImageDeformPointMLS_F32.this.weights.data[i];
                float hat_p_x = c.p.x - ImageDeformPointMLS_F32.this.aveP.x;
                float hat_p_y = c.p.y - ImageDeformPointMLS_F32.this.aveP.y;
                inner00 += hat_p_x * hat_p_x * w;
                inner01 += hat_p_y * hat_p_x * w;
                inner11 += hat_p_y * hat_p_y * w;
            }
            float det = inner00 * inner11 - inner01 * inner01;
            if ((double)det == 0.0) {
                if (inner00 == 0.0f && inner11 == 0.0f) {
                    det = 1.0f;
                } else {
                    throw new RuntimeException("Insufficient number of or geometric diversity in control points");
                }
            }
            float inv00 = inner11 / det;
            float inv01 = -inner01 / det;
            float inv11 = inner00 / det;
            float v_m_ap_x = v_x - ImageDeformPointMLS_F32.this.aveP.x;
            float v_m_ap_y = v_y - ImageDeformPointMLS_F32.this.aveP.y;
            float tmp0 = v_m_ap_x * inv00 + v_m_ap_y * inv01;
            float tmp1 = v_m_ap_x * inv01 + v_m_ap_y * inv11;
            for (int i = 0; i < ImageDeformPointMLS_F32.this.controls.size; ++i) {
                Control c = (Control)ImageDeformPointMLS_F32.this.controls.get(i);
                float hat_p_x = c.p.x - ImageDeformPointMLS_F32.this.aveP.x;
                float hat_p_y = c.p.y - ImageDeformPointMLS_F32.this.aveP.y;
                ImageDeformPointMLS_F32.this.A.data[i] = (tmp0 * hat_p_x + tmp1 * hat_p_y) * ImageDeformPointMLS_F32.this.weights.data[i];
            }
        }

        @Override
        public void computeDeformed(float v_x, float v_y, Point2D_F32 deformed) {
            deformed.setTo(0.0f, 0.0f);
            int totalControls = ImageDeformPointMLS_F32.this.controls.size;
            for (int i = 0; i < totalControls; ++i) {
                Control c = ((Control[])ImageDeformPointMLS_F32.this.controls.data)[i];
                float a = ImageDeformPointMLS_F32.this.A.data[i];
                deformed.x += a * (c.q.x - ImageDeformPointMLS_F32.this.aveQ.x);
                deformed.y += a * (c.q.y - ImageDeformPointMLS_F32.this.aveQ.y);
            }
            deformed.x += ImageDeformPointMLS_F32.this.aveQ.x;
            deformed.y += ImageDeformPointMLS_F32.this.aveQ.y;
        }
    }

    private static interface Model {
        public void allocate(DogArray_F32 var1, DogArray_F32 var2, DogArray<FMatrix2x2> var3);

        public void computeIntermediate(float var1, float var2);

        public void computeDeformed(float var1, float var2, Point2D_F32 var3);
    }

    public class SimilarityModel
    implements Model {
        @Override
        public void allocate(DogArray_F32 weights, DogArray_F32 A2, DogArray<FMatrix2x2> matrices) {
            weights.resize(ImageDeformPointMLS_F32.this.controls.size);
            matrices.resize(ImageDeformPointMLS_F32.this.controls.size);
        }

        @Override
        public void computeIntermediate(float v_x, float v_y) {
            float[] weights = ImageDeformPointMLS_F32.this.weights.data;
            ImageDeformPointMLS_F32.this.mu = 0.0f;
            int totalControls = ImageDeformPointMLS_F32.this.controls.size;
            for (int i = 0; i < totalControls; ++i) {
                Control c = (Control)ImageDeformPointMLS_F32.this.controls.get(i);
                float w = weights[i];
                float hat_p_x = c.p.x - ImageDeformPointMLS_F32.this.aveP.x;
                float hat_p_y = c.p.y - ImageDeformPointMLS_F32.this.aveP.y;
                ImageDeformPointMLS_F32.this.mu += w * (hat_p_x * hat_p_x + hat_p_y * hat_p_y);
                float v_ps_x = v_x - ImageDeformPointMLS_F32.this.aveP.x;
                float v_ps_y = v_y - ImageDeformPointMLS_F32.this.aveP.y;
                FMatrix2x2 m = (FMatrix2x2)ImageDeformPointMLS_F32.this.matrices.get(i);
                m.a11 = w * (hat_p_x * v_ps_x + hat_p_y * v_ps_y);
                m.a12 = w * (hat_p_x * v_ps_y - hat_p_y * v_ps_x);
                m.a21 = -m.a12;
                m.a22 = m.a11;
            }
            if (ImageDeformPointMLS_F32.this.mu == 0.0f) {
                ImageDeformPointMLS_F32.this.mu = 1.0f;
            }
        }

        @Override
        public void computeDeformed(float v_x, float v_y, Point2D_F32 deformed) {
            deformed.setTo(0.0f, 0.0f);
            int totalControls = ImageDeformPointMLS_F32.this.controls.size;
            for (int i = 0; i < totalControls; ++i) {
                Control c = (Control)ImageDeformPointMLS_F32.this.controls.get(i);
                FMatrix2x2 m = ((FMatrix2x2[])ImageDeformPointMLS_F32.this.matrices.data)[i];
                float hat_q_x = c.q.x - ImageDeformPointMLS_F32.this.aveQ.x;
                float hat_q_y = c.q.y - ImageDeformPointMLS_F32.this.aveQ.y;
                deformed.x += hat_q_x * m.a11 + hat_q_y * m.a21;
                deformed.y += hat_q_x * m.a12 + hat_q_y * m.a22;
            }
            deformed.x = deformed.x / ImageDeformPointMLS_F32.this.mu + ImageDeformPointMLS_F32.this.aveQ.x;
            deformed.y = deformed.y / ImageDeformPointMLS_F32.this.mu + ImageDeformPointMLS_F32.this.aveQ.y;
        }
    }

    public class RigidModel
    extends SimilarityModel {
        @Override
        public void computeDeformed(float v_x, float v_y, Point2D_F32 deformed) {
            float fr_x = 0.0f;
            float fr_y = 0.0f;
            for (int i = 0; i < ImageDeformPointMLS_F32.this.controls.size; ++i) {
                Control c = (Control)ImageDeformPointMLS_F32.this.controls.get(i);
                float hat_q_x = c.q.x - ImageDeformPointMLS_F32.this.aveQ.x;
                float hat_q_y = c.q.y - ImageDeformPointMLS_F32.this.aveQ.y;
                FMatrix2x2 m = (FMatrix2x2)ImageDeformPointMLS_F32.this.matrices.get(i);
                fr_x += hat_q_x * m.a11 + hat_q_y * m.a21;
                fr_y += hat_q_x * m.a12 + hat_q_y * m.a22;
            }
            float v_avep_x = v_x - ImageDeformPointMLS_F32.this.aveP.x;
            float v_avep_y = v_y - ImageDeformPointMLS_F32.this.aveP.y;
            float norm_fr = (float)Math.sqrt(fr_x * fr_x + fr_y * fr_y);
            float norm_vp = (float)Math.sqrt(v_avep_x * v_avep_x + v_avep_y * v_avep_y);
            if (norm_fr == 0.0f && norm_vp == 0.0f) {
                deformed.x = ImageDeformPointMLS_F32.this.aveQ.x;
                deformed.y = ImageDeformPointMLS_F32.this.aveQ.y;
            } else {
                float scale = norm_vp / norm_fr;
                deformed.x = ImageDeformPointMLS_F32.this.scaleX * fr_x * scale + ImageDeformPointMLS_F32.this.aveQ.x;
                deformed.y = ImageDeformPointMLS_F32.this.scaleY * fr_y * scale + ImageDeformPointMLS_F32.this.aveQ.y;
            }
        }
    }

    public static class Control {
        Point2D_F32 p = new Point2D_F32();
        Point2D_F32 q = new Point2D_F32();
    }
}

