/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.kanbra;

public class KannalaBrandtUtils_F64 {
    public static double polynomial(double[] coefs, double x) {
        double pow = x;
        double result = 0.0;
        for (int i = 0; i < coefs.length; ++i) {
            result += coefs[i] * pow;
            pow *= x * x;
        }
        return result;
    }

    public static double polytrig(double[] coefs, double cos, double sin) {
        if (coefs.length == 0) {
            return 0.0;
        }
        double result = 0.0;
        result += coefs[0] * cos;
        result += coefs[1] * sin;
        result += coefs[2] * 2.0 * cos * sin;
        return result += coefs[3] * (2.0 * cos * cos - 1.0);
    }

    public static void polytrigGradient(double cos, double sin, double[] gradient) {
        gradient[0] = cos;
        gradient[1] = sin;
        gradient[2] = 2.0 * cos * sin;
        gradient[3] = 2.0 * cos * cos - 1.0;
    }

    public static double polynomialDerivative(double[] coefs, double x) {
        double pow = 1.0;
        double left = 1.0;
        double result = 0.0;
        for (int i = 0; i < coefs.length; ++i) {
            result += left * coefs[i] * pow;
            pow *= x * x;
            left += 2.0;
        }
        return result;
    }

    public static double polytrigDerivative(double[] coefs, double cos, double sin) {
        if (coefs.length == 0) {
            return 0.0;
        }
        double result = 0.0;
        result -= coefs[0] * sin;
        result += coefs[1] * cos;
        result += 2.0 * coefs[2] * (cos * cos - sin * sin);
        return result -= 4.0 * coefs[3] * cos * sin;
    }
}

