/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.kanbra;

import boofcv.alg.distort.kanbra.KannalaBrandtUtils_F64;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraKannalaBrandt;
import boofcv.struct.distort.Point3Transform2_F64;
import georegression.geometry.UtilPoint3D_F64;
import georegression.struct.point.Point2D_F64;

public class KannalaBrandtStoP_F64
implements Point3Transform2_F64 {
    protected final CameraKannalaBrandt model;

    public KannalaBrandtStoP_F64(CameraKannalaBrandt model) {
        BoofMiscOps.checkTrue(model.radialTrig.length == 0 || model.radialTrig.length == 4);
        this.model = new CameraKannalaBrandt(model);
    }

    @Override
    public void compute(double x, double y, double z, Point2D_F64 out) {
        double dy;
        double dx;
        double theta = Math.acos(z / UtilPoint3D_F64.norm(x, y, z));
        double r = KannalaBrandtUtils_F64.polynomial(this.model.symmetric, theta);
        double phi = Math.atan2(y, x);
        double cosphi = Math.cos(phi);
        double sinphi = Math.sin(phi);
        if (this.model.isAsymmetricModel()) {
            double disRad = KannalaBrandtUtils_F64.polynomial(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi);
            double disTan = KannalaBrandtUtils_F64.polynomial(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi);
            dx = (r + disRad) * cosphi - disTan * sinphi;
            dy = (r + disRad) * sinphi + disTan * cosphi;
        } else {
            dx = r * cosphi;
            dy = r * sinphi;
        }
        out.x = this.model.fx * dx + this.model.skew * dy + this.model.cx;
        out.y = this.model.fy * dy + this.model.cy;
    }

    @Override
    public Point3Transform2_F64 copyConcurrent() {
        return this;
    }

    public CameraKannalaBrandt getModel() {
        return this.model;
    }
}

