/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.division;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.division.AddDivisionNtoN_F32;
import boofcv.alg.distort.division.AddDivisionNtoN_F64;
import boofcv.alg.distort.division.RemoveDivisionNtoN_F32;
import boofcv.alg.distort.division.RemoveDivisionNtoN_F64;
import boofcv.alg.distort.pinhole.PinholeNtoP_F32;
import boofcv.alg.distort.pinhole.PinholeNtoP_F64;
import boofcv.alg.distort.pinhole.PinholePtoN_F32;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.struct.calib.CameraDivision;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import boofcv.struct.distort.SequencePoint2Transform2_F64;

public class LensDistortionDivision
implements LensDistortionNarrowFOV {
    CameraDivision p;

    public LensDistortionDivision(CameraDivision p) {
        this.p = p;
    }

    @Override
    public Point2Transform2_F64 distort_F64(boolean pixelIn, boolean pixelOut) {
        AddDivisionNtoN_F64 n_to_n = new AddDivisionNtoN_F64().setRadial(this.p.radial);
        if (pixelIn) {
            PinholePtoN_F64 p_to_n = new PinholePtoN_F64().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
            if (pixelOut) {
                PinholeNtoP_F64 n_to_p = new PinholeNtoP_F64().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
                return new SequencePoint2Transform2_F64(p_to_n, n_to_n, n_to_p);
            }
            return new SequencePoint2Transform2_F64(p_to_n, n_to_n);
        }
        if (pixelOut) {
            PinholeNtoP_F64 n_to_p = new PinholeNtoP_F64().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
            return new SequencePoint2Transform2_F64(n_to_n, n_to_p);
        }
        return n_to_n;
    }

    @Override
    public Point2Transform2_F64 undistort_F64(boolean pixelIn, boolean pixelOut) {
        RemoveDivisionNtoN_F64 n_to_n = new RemoveDivisionNtoN_F64().setRadial(this.p.radial);
        if (pixelIn) {
            PinholePtoN_F64 p_to_n = new PinholePtoN_F64().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
            if (pixelOut) {
                PinholeNtoP_F64 n_to_p = new PinholeNtoP_F64().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
                return new SequencePoint2Transform2_F64(p_to_n, n_to_n, n_to_p);
            }
            return new SequencePoint2Transform2_F64(p_to_n, n_to_n);
        }
        if (pixelOut) {
            PinholeNtoP_F64 n_to_p = new PinholeNtoP_F64().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
            return new SequencePoint2Transform2_F64(n_to_n, n_to_p);
        }
        return n_to_n;
    }

    @Override
    public Point2Transform2_F32 distort_F32(boolean pixelIn, boolean pixelOut) {
        AddDivisionNtoN_F32 n_to_n = new AddDivisionNtoN_F32().setRadial((float)this.p.radial);
        if (pixelIn) {
            PinholePtoN_F32 p_to_n = new PinholePtoN_F32().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
            if (pixelOut) {
                PinholeNtoP_F32 n_to_p = new PinholeNtoP_F32().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
                return new SequencePoint2Transform2_F32(p_to_n, n_to_n, n_to_p);
            }
            return new SequencePoint2Transform2_F32(p_to_n, n_to_n);
        }
        if (pixelOut) {
            PinholeNtoP_F32 n_to_p = new PinholeNtoP_F32().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
            return new SequencePoint2Transform2_F32(n_to_n, n_to_p);
        }
        return n_to_n;
    }

    @Override
    public Point2Transform2_F32 undistort_F32(boolean pixelIn, boolean pixelOut) {
        RemoveDivisionNtoN_F32 n_to_n = new RemoveDivisionNtoN_F32().setRadial((float)this.p.radial);
        if (pixelIn) {
            PinholePtoN_F32 p_to_n = new PinholePtoN_F32().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
            if (pixelOut) {
                PinholeNtoP_F32 n_to_p = new PinholeNtoP_F32().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
                return new SequencePoint2Transform2_F32(p_to_n, n_to_n, n_to_p);
            }
            return new SequencePoint2Transform2_F32(p_to_n, n_to_n);
        }
        if (pixelOut) {
            PinholeNtoP_F32 n_to_p = new PinholeNtoP_F32().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
            return new SequencePoint2Transform2_F32(n_to_n, n_to_p);
        }
        return n_to_n;
    }

    @Override
    public Point2Transform2_F32 normalized_F32() {
        return new PinholePtoN_F32().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
    }

    @Override
    public Point2Transform2_F64 normalized_F64() {
        return new PinholePtoN_F64().setK(this.p.fx, this.p.fy, this.p.skew, this.p.cx, this.p.cy);
    }

    public CameraDivision getIntrinsic() {
        return this.p;
    }
}

