/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.sgm.cost;

import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.alg.disparity.sgm.cost.SgmCostBase;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;

public abstract class SgmCostHamming<T extends ImageBase<T>>
extends SgmCostBase<T> {

    public static class S64
    extends SgmCostHamming<GrayS64> {
        @Override
        protected void computeDisparityErrors(int idxLeft, int idxRight, int idxOut, int disparityRange) {
            long valLeft = ((GrayS64)this.left).data[idxLeft];
            for (int d = 0; d < disparityRange; ++d) {
                long valRight = ((GrayS64)this.right).data[idxRight--];
                this.costXD.data[idxOut + d] = (short)(2047 * DescriptorDistance.hamming(valLeft ^ valRight) / 64);
            }
        }
    }

    public static class S32
    extends SgmCostHamming<GrayS32> {
        @Override
        protected void computeDisparityErrors(int idxLeft, int idxRight, int idxOut, int disparityRange) {
            int valLeft = ((GrayS32)this.left).data[idxLeft];
            for (int d = 0; d < disparityRange; ++d) {
                int valRight = ((GrayS32)this.right).data[idxRight--];
                this.costXD.data[idxOut + d] = (short)(2047 * DescriptorDistance.hamming(valLeft ^ valRight) / 32);
            }
        }
    }

    public static class U8
    extends SgmCostHamming<GrayU8> {
        @Override
        protected void computeDisparityErrors(int idxLeft, int idxRight, int idxOut, int disparityRange) {
            int valLeft = ((GrayU8)this.left).data[idxLeft] & 0xFF;
            for (int d = 0; d < disparityRange; ++d) {
                int valRight = ((GrayU8)this.right).data[idxRight--] & 0xFF;
                this.costXD.data[idxOut + d] = (short)(2047 * DescriptorDistance.hamming(valLeft ^ valRight) / 8);
            }
        }
    }
}

