/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.sgm.cost;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.disparity.DisparityBlockMatchRowFormat;
import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.alg.disparity.sgm.SgmDisparityCost;
import boofcv.misc.Compare_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.Planar;
import org.jetbrains.annotations.Nullable;

public class SgmCostFromBlocks<T extends ImageBase<T>>
implements SgmDisparityCost<T>,
DisparitySelect<int[], GrayU8>,
Compare_S32 {
    protected Planar<GrayU16> costYXD;
    protected DisparityBlockMatchRowFormat<T, GrayU8> blockScore;
    private final GrayU8 dummy = new GrayU8(0, 0);
    private int maxRegionError = 0;
    private int disparityMin;
    private int disparityRange;

    @Override
    public void configure(int disparityMin, int disparityRange) {
        this.blockScore.configure(disparityMin, disparityRange);
        this.disparityMin = disparityMin;
        this.disparityRange = disparityRange;
    }

    @Override
    public void process(T left, T right, Planar<GrayU16> costYXD) {
        InputSanityCheck.checkSameShape(left, right);
        this.costYXD = costYXD;
        costYXD.reshape(this.disparityRange, ((ImageBase)left).width, ((ImageBase)left).height);
        this.maxRegionError = this.blockScore.getMaxRegionError();
        this.blockScore.process(left, right, this.dummy, null);
    }

    @Override
    public void configure(GrayU8 imageDisparity, @Nullable GrayF32 score, int minDisparity, int maxDisparity, int radiusX) {
    }

    @Override
    public void process(int row, int[] scoresArray) {
        GrayU16 costXD = this.costYXD.getBand(row);
        int lengthX = costXD.height;
        for (int x = this.disparityMin; x < lengthX; ++x) {
            int d;
            int localRangeD = Math.min(this.disparityRange, x - this.disparityMin + 1);
            int dstIdx = (x - this.disparityMin) * this.disparityRange;
            for (d = 0; d < localRangeD; ++d) {
                int srcIdx = d * lengthX + x - this.disparityMin;
                costXD.data[dstIdx++] = (short)(2047 * scoresArray[srcIdx] / this.maxRegionError);
            }
            for (d = localRangeD; d < this.disparityRange; ++d) {
                costXD.data[dstIdx++] = 2047;
            }
        }
    }

    @Override
    public DisparitySelect<int[], GrayU8> concurrentCopy() {
        return this;
    }

    @Override
    public Class<GrayU8> getDisparityType() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public int compare(int scoreA, int scoreB) {
        return Integer.compare(scoreA, scoreB);
    }

    public void setBlockScore(DisparityBlockMatchRowFormat<T, GrayU8> blockScore) {
        this.blockScore = blockScore;
    }
}

