/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.select;

import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.alg.disparity.block.SelectDisparityBasicWta;
import boofcv.misc.Compare_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import org.jetbrains.annotations.Nullable;

public class SelectCorrelationWta_F32_U8
extends SelectDisparityBasicWta<float[], GrayU8>
implements Compare_F32 {
    @Override
    public void configure(GrayU8 imageDisparity, @Nullable GrayF32 imageScore, int disparityMin, int disparityMax, int radiusX) {
        super.configure(imageDisparity, imageScore, disparityMin, disparityMax, radiusX);
    }

    @Override
    public void process(int row, float[] blockOfScores) {
        int col;
        int indexDisparity = ((GrayU8)this.imageDisparity).startIndex + row * ((GrayU8)this.imageDisparity).stride;
        for (col = 0; col < this.disparityMin; ++col) {
            ((GrayU8)this.imageDisparity).data[indexDisparity++] = (byte)this.disparityRange;
        }
        for (col = this.disparityMin; col < this.imageWidth; ++col) {
            int localMaxRange = this.disparityMaxAtColumnL2R(col) - this.disparityMin + 1;
            int indexScore = col - this.disparityMin;
            int maxIndex = 0;
            float maxValue = blockOfScores[indexScore];
            indexScore += this.imageWidth;
            int i = 1;
            while (i < localMaxRange) {
                float v = blockOfScores[indexScore];
                if (v > maxValue) {
                    maxValue = v;
                    maxIndex = i;
                }
                ++i;
                indexScore += this.imageWidth;
            }
            ((GrayU8)this.imageDisparity).data[indexDisparity++] = (byte)maxIndex;
        }
    }

    @Override
    public DisparitySelect<float[], GrayU8> concurrentCopy() {
        return this;
    }

    @Override
    public Class<GrayU8> getDisparityType() {
        return GrayU8.class;
    }

    @Override
    public int compare(float scoreA, float scoreB) {
        return Float.compare(scoreA, scoreB);
    }
}

