/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block;

import boofcv.alg.disparity.block.score.DisparitySparseRectifiedScoreBM_F32;
import boofcv.alg.disparity.block.score.DisparitySparseRectifiedScoreBM_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public interface SparseScoreRectifiedSad {

    public static class S16
    extends DisparitySparseRectifiedScoreBM_S32<GrayS16> {
        public S16(int radiusX, int radiusY) {
            super(radiusX, radiusY, GrayS16.class);
            this.setSampleRegion(0, 0);
        }

        @Override
        protected void scoreDisparity(int disparityRange, boolean leftToRight) {
            int[] scores = leftToRight ? this.scoreLtoR : this.scoreRtoL;
            short[] dataLeft = ((GrayS16)this.patchTemplate).data;
            short[] dataRight = ((GrayS16)this.patchCompare).data;
            for (int d = 0; d < disparityRange; ++d) {
                int total = 0;
                int idxLeft = 0;
                for (int y = 0; y < this.blockHeight; ++y) {
                    int idxRight = y * ((GrayS16)this.patchCompare).stride + d;
                    for (int x = 0; x < this.blockWidth; ++x) {
                        total += Math.abs((dataLeft[idxLeft++] & 0xFFFF) - (dataRight[idxRight++] & 0xFFFF));
                    }
                }
                int index = leftToRight ? disparityRange - d - 1 : d;
                scores[index] = total;
            }
        }
    }

    public static class U16
    extends DisparitySparseRectifiedScoreBM_S32<GrayU16> {
        public U16(int radiusX, int radiusY) {
            super(radiusX, radiusY, GrayU16.class);
            this.setSampleRegion(0, 0);
        }

        @Override
        protected void scoreDisparity(int disparityRange, boolean leftToRight) {
            int[] scores = leftToRight ? this.scoreLtoR : this.scoreRtoL;
            short[] dataLeft = ((GrayU16)this.patchTemplate).data;
            short[] dataRight = ((GrayU16)this.patchCompare).data;
            for (int d = 0; d < disparityRange; ++d) {
                int total = 0;
                int idxLeft = 0;
                for (int y = 0; y < this.blockHeight; ++y) {
                    int idxRight = y * ((GrayU16)this.patchCompare).stride + d;
                    for (int x = 0; x < this.blockWidth; ++x) {
                        total += Math.abs((dataLeft[idxLeft++] & 0xFFFF) - (dataRight[idxRight++] & 0xFFFF));
                    }
                }
                int index = leftToRight ? disparityRange - d - 1 : d;
                scores[index] = total;
            }
        }
    }

    public static class U8
    extends DisparitySparseRectifiedScoreBM_S32<GrayU8> {
        public U8(int radiusX, int radiusY) {
            super(radiusX, radiusY, GrayU8.class);
            this.setSampleRegion(0, 0);
        }

        @Override
        protected void scoreDisparity(int disparityRange, boolean leftToRight) {
            int[] scores = leftToRight ? this.scoreLtoR : this.scoreRtoL;
            byte[] dataLeft = ((GrayU8)this.patchTemplate).data;
            byte[] dataRight = ((GrayU8)this.patchCompare).data;
            for (int d = 0; d < disparityRange; ++d) {
                int total = 0;
                int idxLeft = 0;
                for (int y = 0; y < this.blockHeight; ++y) {
                    int idxRight = y * ((GrayU8)this.patchCompare).stride + d;
                    for (int x = 0; x < this.blockWidth; ++x) {
                        total += Math.abs((dataLeft[idxLeft++] & 0xFF) - (dataRight[idxRight++] & 0xFF));
                    }
                }
                int index = leftToRight ? disparityRange - d - 1 : d;
                scores[index] = total;
            }
        }
    }

    public static class F32
    extends DisparitySparseRectifiedScoreBM_F32 {
        public F32(int radiusX, int radiusY) {
            super(radiusX, radiusY);
            this.setSampleRegion(0, 0);
        }

        @Override
        protected void scoreDisparity(int disparityRange, boolean leftToRight) {
            float[] scores = leftToRight ? this.scoreLtoR : this.scoreRtoL;
            float[] dataLeft = ((GrayF32)this.patchTemplate).data;
            float[] dataRight = ((GrayF32)this.patchCompare).data;
            for (int d = 0; d < disparityRange; ++d) {
                float total = 0.0f;
                int idxLeft = 0;
                for (int y = 0; y < this.blockHeight; ++y) {
                    int idxRight = y * ((GrayF32)this.patchCompare).stride + d;
                    for (int x = 0; x < this.blockWidth; ++x) {
                        total += Math.abs(dataLeft[idxLeft++] - dataRight[idxRight++]);
                    }
                }
                int index = leftToRight ? disparityRange - d - 1 : d;
                scores[index] = total;
            }
        }
    }
}

