/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.color.ColorXyz;
import boofcv.alg.color.impl.ImplColorLab;
import boofcv.alg.color.impl.ImplColorLab_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class ColorLab {
    public static final double epsilon = 0.008856;
    public static final double kappa = 903.3;
    public static final double Xr = 0.950456;
    public static final double Yr = 1.0;
    public static final double Zr = 1.088754;
    public static final float epsilon_f = 0.008856f;
    public static final float kappa_f = 903.3f;
    public static final float Xr_f = 0.950456f;
    public static final float Yr_f = 1.0f;
    public static final float Zr_f = 1.088754f;

    public static void rgbToLab(int r, int g, int b, double[] lab) {
        ColorLab.linearRgbToLab(ColorXyz.invGamma((double)r / 255.0), ColorXyz.invGamma((double)g / 255.0), ColorXyz.invGamma((double)b / 255.0), lab);
    }

    public static void rgbToLab(int r, int g, int b, float[] lab) {
        ColorLab.linearRgbToLab((float)ColorXyz.invGamma((float)r / 255.0f), (float)ColorXyz.invGamma((float)g / 255.0f), (float)ColorXyz.invGamma((float)b / 255.0f), lab);
    }

    public static void rgbToLab(double r, double g, double b, float[] lab) {
        ColorLab.linearRgbToLab((float)ColorXyz.invGamma(r / 255.0), (float)ColorXyz.invGamma(g / 255.0), (float)ColorXyz.invGamma(b / 255.0), lab);
    }

    public static void labToRgb(double L, double a, double b, double[] linearRgb, int[] rgb) {
        ColorLab.labToLinearRgb(L, a, b, linearRgb);
        rgb[0] = (int)(255.0 * ColorXyz.gamma(linearRgb[0]) + 0.5) & 0xFF;
        rgb[1] = (int)(255.0 * ColorXyz.gamma(linearRgb[1]) + 0.5) & 0xFF;
        rgb[2] = (int)(255.0 * ColorXyz.gamma(linearRgb[2]) + 0.5) & 0xFF;
    }

    public static void labToRgb(float L, float a, float b, float[] linearRgb, int[] rgb) {
        ColorLab.labToLinearRgb(L, a, b, linearRgb);
        rgb[0] = (int)(255.0 * ColorXyz.gamma(linearRgb[0]) + 0.5) & 0xFF;
        rgb[1] = (int)(255.0 * ColorXyz.gamma(linearRgb[1]) + 0.5) & 0xFF;
        rgb[2] = (int)(255.0 * ColorXyz.gamma(linearRgb[2]) + 0.5) & 0xFF;
    }

    public static void labToRgb(float L, float a, float b, float[] linearRgb, float[] rgb) {
        ColorLab.labToLinearRgb(L, a, b, linearRgb);
        rgb[0] = (float)(255.0 * ColorXyz.gamma(linearRgb[0]));
        rgb[1] = (float)(255.0 * ColorXyz.gamma(linearRgb[1]));
        rgb[2] = (float)(255.0 * ColorXyz.gamma(linearRgb[2]));
    }

    public static void labToLinearRgb(float L, float a, float b, float[] linearRgb) {
        ColorLab.labToXyz(L, a, b, linearRgb);
        ColorXyz.xyzToLinearRgb(linearRgb[0], linearRgb[1], linearRgb[2], linearRgb);
    }

    public static void labToLinearRgb(double L, double a, double b, double[] linearRgb) {
        ColorLab.labToXyz(L, a, b, linearRgb);
        ColorXyz.xyzToLinearRgb(linearRgb[0], linearRgb[1], linearRgb[2], linearRgb);
    }

    public static void xyzToLab(double X2, double Y2, double Z2, double[] lab) {
        double xr = X2 / 0.950456;
        double yr = Y2 / 1.0;
        double zr = Z2 / 1.088754;
        double fx = xr > 0.008856 ? Math.pow(xr, 0.3333333333333333) : (903.3 * xr + 16.0) / 116.0;
        double fy = yr > 0.008856 ? Math.pow(yr, 0.3333333333333333) : (903.3 * yr + 16.0) / 116.0;
        double fz = zr > 0.008856 ? Math.pow(zr, 0.3333333333333333) : (903.3 * zr + 16.0) / 116.0;
        lab[0] = 116.0 * fy - 16.0;
        lab[1] = 500.0 * (fx - fy);
        lab[2] = 200.0 * (fy - fz);
    }

    public static void xyzToLab(float X2, float Y2, float Z2, float[] lab) {
        float xr = X2 / 0.950456f;
        float yr = Y2 / 1.0f;
        float zr = Z2 / 1.088754f;
        float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
        float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
        float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
        lab[0] = 116.0f * fy - 16.0f;
        lab[1] = 500.0f * (fx - fy);
        lab[2] = 200.0f * (fy - fz);
    }

    public static void labToXyz(double L, double a, double b, double[] xyz) {
        double left = (L + 16.0) / 116.0;
        xyz[0] = (double)0.950456f * ColorLab.invTran(left + a / 500.0);
        xyz[1] = 1.0 * ColorLab.invTran(left);
        xyz[2] = (double)1.088754f * ColorLab.invTran(left - b / 200.0);
    }

    public static void labToXyz(float L, float a, float b, float[] xyz) {
        float left = (L + 16.0f) / 116.0f;
        xyz[0] = 0.950456f * ColorLab.invTran(left + a / 500.0f);
        xyz[1] = 1.0f * ColorLab.invTran(left);
        xyz[2] = 1.088754f * ColorLab.invTran(left - b / 200.0f);
    }

    public static double invTran(double t) {
        if (t > 0.008856) {
            return t * t * t;
        }
        return 3.0 * t * t * (t - 0.13793103448275862);
    }

    public static float invTran(float t) {
        if (t > 0.008856f) {
            return t * t * t;
        }
        return 3.0f * t * t * (t - 0.13793103f);
    }

    public static void linearRgbToLab(double r, double g, double b, double[] lab) {
        ColorXyz.linearRgbToXyz(r, g, b, lab);
        ColorLab.xyzToLab(lab[0], lab[1], lab[2], lab);
    }

    public static void linearRgbToLab(float r, float g, float b, float[] lab) {
        ColorXyz.linearRgbToXyz(r, g, b, lab);
        ColorLab.xyzToLab(lab[0], lab[1], lab[2], lab);
    }

    public static <T extends ImageGray<T>> void rgbToLab(Planar<T> rgb, Planar<GrayF32> lab) {
        lab.reshape(rgb.width, rgb.height, 3);
        if (rgb.getBandType() == GrayU8.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorLab_MT.rgbToLab_U8(rgb, lab);
            } else {
                ImplColorLab.rgbToLab_U8(rgb, lab);
            }
        } else if (rgb.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorLab_MT.rgbToLab_F32(rgb, lab);
            } else {
                ImplColorLab.rgbToLab_F32(rgb, lab);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + rgb.getBandType().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void labToRgb(Planar<GrayF32> lab, Planar<T> rgb) {
        rgb.reshapeTo(lab);
        if (rgb.getBandType() == GrayU8.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorLab_MT.labToRgb_U8(lab, rgb);
            } else {
                ImplColorLab.labToRgb_U8(lab, rgb);
            }
        } else if (rgb.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorLab_MT.labToRgb_F32(lab, rgb);
            } else {
                ImplColorLab.labToRgb_F32(lab, rgb);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + rgb.getBandType().getSimpleName());
        }
    }
}

