/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.background.stationary.BackgroundStationaryGmm;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import org.jetbrains.annotations.Nullable;

public class BackgroundStationaryGmm_MB<T extends ImageMultiBand<T>>
extends BackgroundStationaryGmm<T> {
    public BackgroundStationaryGmm_MB(float learningPeriod, float decayCoef, int maxGaussians, ImageType<T> imageType) {
        super(learningPeriod, decayCoef, maxGaussians, imageType);
    }

    @Override
    public void updateBackground(T frame, @Nullable GrayU8 mask) {
        super.updateBackground(frame, mask);
        this.common.inputWrapperMB.wrap((ImageBase)frame);
        int pixelStride = this.common.inputWrapperMB.getPixelStride();
        this.common.storagePixels.reset();
        boolean idx0 = false;
        int idx1 = ((ImageMultiBand)frame).height;
        float[] inputPixel = this.common.storagePixels.grow();
        for (int y = 0; y < idx1; ++y) {
            int inputIndex = ((ImageBase)frame).getIndex(0, y);
            float[] dataRow = this.common.model.data[y];
            if (mask == null) {
                int col = 0;
                while (col < this.common.imageWidth) {
                    this.common.inputWrapperMB.getF(inputIndex, inputPixel);
                    int modelIndex = col * this.common.modelStride;
                    this.common.updateMixture(inputPixel, dataRow, modelIndex);
                    ++col;
                    inputIndex += pixelStride;
                }
                continue;
            }
            int indexMask = mask.startIndex + y * mask.stride;
            int col = 0;
            while (col < this.common.imageWidth) {
                this.common.inputWrapperMB.getF(inputIndex, inputPixel);
                int modelIndex = col * this.common.modelStride;
                mask.data[indexMask++] = (byte)this.common.updateMixture(inputPixel, dataRow, modelIndex);
                ++col;
                inputIndex += pixelStride;
            }
        }
    }

    @Override
    public void segment(T frame, GrayU8 segmented) {
        segmented.reshape(((ImageMultiBand)frame).width, ((ImageMultiBand)frame).height);
        if (this.common.imageWidth != ((ImageMultiBand)frame).width || this.common.imageHeight != ((ImageMultiBand)frame).height) {
            ImageMiscOps.fill(segmented, (int)this.unknownValue);
            return;
        }
        this.common.unknownValue = this.unknownValue;
        this.common.inputWrapperMB.wrap((ImageBase)frame);
        int pixelStride = this.common.inputWrapperMB.getPixelStride();
        this.common.storagePixels.reset();
        boolean idx0 = false;
        int idx1 = ((ImageMultiBand)frame).height;
        float[] inputPixel = this.common.storagePixels.grow();
        for (int y = 0; y < idx1; ++y) {
            int indexIn = ((ImageBase)frame).getIndex(0, y);
            int indexOut = segmented.startIndex + y * segmented.stride;
            float[] dataRow = this.common.model.data[y];
            int col = 0;
            while (col < this.common.imageWidth) {
                this.common.inputWrapperMB.getF(indexIn, inputPixel);
                int modelIndex = col * this.common.modelStride;
                segmented.data[indexOut++] = (byte)this.common.checkBackground(inputPixel, dataRow, modelIndex);
                ++col;
                indexIn += pixelStride;
            }
        }
    }
}

