/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGmm;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F32;
import pabeles.concurrency.GrowArray;

public class BackgroundMovingGmm_MB<T extends ImageMultiBand<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGmm<T, Motion> {
    protected GrowArray<Helper> helpers = new GrowArray<Helper>(() -> new Helper(imageType.numBands));
    protected Helper helper = this.helpers.grow();

    public BackgroundMovingGmm_MB(float learningPeriod, float decayCoef, int maxGaussians, Point2Transform2Model_F32<Motion> transformImageType, ImageType<T> imageType) {
        super(learningPeriod, decayCoef, maxGaussians, transformImageType, imageType);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.common.inputWrapperMB.wrap((ImageBase)frame);
        int idx0 = y0;
        int idx1 = y1;
        this.helper.updateBackground(x0, idx0, x1, idx1, frame);
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.common.inputWrapperMB.wrap((ImageBase)frame);
        this.common.unknownValue = this.unknownValue;
        boolean idx0 = false;
        int idx1 = ((ImageMultiBand)frame).height;
        this.helper.segment(0, idx1, currentToWorld, frame, segmented);
    }

    private class Helper {
        private final float[] valueInput;
        private final Point2D_F32 pixel = new Point2D_F32();
        private final Point2Transform2Model_F32<Motion> transform;

        public Helper(int numBands) {
            this.valueInput = new float[numBands];
            this.transform = (Point2Transform2Model_F32)BackgroundMovingGmm_MB.this._transform.copyConcurrent();
        }

        public void updateBackground(int x0, int y0, int x1, int y1, T frame) {
            this.transform.setModel(BackgroundMovingGmm_MB.this.worldToCurrent);
            for (int y = y0; y < y1; ++y) {
                float[] modelRow = BackgroundMovingGmm_MB.this.common.model.data[y];
                for (int x = x0; x < x1; ++x) {
                    int indexModel = x * BackgroundMovingGmm_MB.this.common.modelStride;
                    this.transform.compute(x, y, this.pixel);
                    int xx = (int)(this.pixel.x + 0.5f);
                    int yy = (int)(this.pixel.y + 0.5f);
                    if (!(this.pixel.x >= 0.0f) || xx >= ((ImageMultiBand)frame).width || !(this.pixel.y >= 0.0f) || yy >= ((ImageMultiBand)frame).height) continue;
                    BackgroundMovingGmm_MB.this.common.inputWrapperMB.get(xx, yy, this.valueInput);
                    BackgroundMovingGmm_MB.this.common.updateMixture(this.valueInput, modelRow, indexModel);
                }
            }
        }

        protected void segment(int y0, int y1, Motion currentToWorld, T frame, GrayU8 segmented) {
            this.transform.setModel(currentToWorld);
            for (int y = y0; y < y1; ++y) {
                int indexOut = segmented.startIndex + y * segmented.stride;
                int x = 0;
                while (x < ((ImageMultiBand)frame).width) {
                    this.transform.compute(x, y, this.pixel);
                    int xx = (int)(this.pixel.x + 0.5f);
                    int yy = (int)(this.pixel.y + 0.5f);
                    if (this.pixel.x >= 0.0f && xx < BackgroundMovingGmm_MB.this.backgroundWidth && this.pixel.y >= 0.0f && yy < BackgroundMovingGmm_MB.this.backgroundHeight) {
                        BackgroundMovingGmm_MB.this.common.inputWrapperMB.get(x, y, this.valueInput);
                        float[] modelRow = BackgroundMovingGmm_MB.this.common.model.data[yy];
                        int indexModel = xx * BackgroundMovingGmm_MB.this.common.modelStride;
                        segmented.data[indexOut] = (byte)BackgroundMovingGmm_MB.this.common.checkBackground(this.valueInput, modelRow, indexModel);
                    } else {
                        segmented.data[indexOut] = BackgroundMovingGmm_MB.this.unknownValue;
                    }
                    ++x;
                    ++indexOut;
                }
            }
        }
    }
}

