/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F32;
import pabeles.concurrency.GrowArray;

public class BackgroundMovingBasic_IL_MT<T extends ImageInterleaved<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingBasic<T, Motion> {
    protected InterleavedF32 background;
    protected InterpolatePixelMB<T> _interpolationInput;
    protected InterpolatePixelMB<InterleavedF32> _interpolationBG;
    protected GImageMultiBand inputWrapper;
    protected GrowArray<Helper> helpers;
    protected Helper helper;

    public BackgroundMovingBasic_IL_MT(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, ImageType<T> imageType) {
        super(learnRate, threshold, transform, imageType);
        this._interpolationInput = FactoryInterpolation.createPixelMB(0.0, 255.0, interpType, BorderType.EXTENDED, imageType);
        int numBands = imageType.getNumBands();
        this.background = new InterleavedF32(1, 1, numBands);
        this._interpolationBG = FactoryInterpolation.createPixelMB(0.0, 255.0, interpType, BorderType.EXTENDED, ImageType.il(numBands, InterleavedF32.class));
        this._interpolationBG.setImage(this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.helpers = new GrowArray<Helper>(() -> new Helper(imageType.numBands));
        this.helper = this.helpers.grow();
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill((ImageBase)this.background, 3.4028234663852886E38);
        this.homeToWorld.setTo(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        GImageMiscOps.fill((ImageBase)this.background, 3.4028234663852886E38);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        BoofConcurrency.loopBlocks(y0, y1, 20, this.helpers, (helper, idx0, idx1) -> helper.updateBackground(x0, idx0, x1, idx1, frame));
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.inputWrapper.wrap((ImageBase)frame);
        BoofConcurrency.loopBlocks(0, ((ImageInterleaved)frame).height, 20, this.helpers, (helper, idx0, idx1) -> helper.segment(idx0, idx1, currentToWorld, frame, segmented));
    }

    public InterleavedF32 getBackground() {
        return this.background;
    }

    private class Helper {
        private final float[] valueInput;
        private final float[] valueBG;
        private final Point2D_F32 pixel = new Point2D_F32();
        private final Point2Transform2Model_F32<Motion> transform;
        private final InterpolatePixelMB<T> interpolationInput;
        private final InterpolatePixelMB<InterleavedF32> interpolationBG;

        public Helper(int numBands) {
            this.valueInput = new float[numBands];
            this.valueBG = new float[2 * numBands];
            this.transform = (Point2Transform2Model_F32)BackgroundMovingBasic_IL_MT.this._transform.copyConcurrent();
            this.interpolationInput = BackgroundMovingBasic_IL_MT.this._interpolationInput.copy();
            this.interpolationBG = BackgroundMovingBasic_IL_MT.this._interpolationBG.copy();
            this.interpolationBG.setImage(BackgroundMovingBasic_IL_MT.this.background);
        }

        public void updateBackground(int x0, int y0, int x1, int y1, T frame) {
            this.interpolationInput.setImage(frame);
            int numBands = ((ImageInterleaved)frame).getNumBands();
            float minusLearn = 1.0f - BackgroundMovingBasic_IL_MT.this.learnRate;
            this.transform.setModel(BackgroundMovingBasic_IL_MT.this.worldToCurrent);
            for (int y = y0; y < y1; ++y) {
                int indexBG = BackgroundMovingBasic_IL_MT.this.background.startIndex + y * BackgroundMovingBasic_IL_MT.this.background.stride + x0 * numBands;
                for (int x = x0; x < x1; ++x) {
                    this.transform.compute(x, y, this.pixel);
                    if (this.pixel.x >= 0.0f && this.pixel.x < (float)((ImageInterleaved)frame).width && this.pixel.y >= 0.0f && this.pixel.y < (float)((ImageInterleaved)frame).height) {
                        this.interpolationInput.get(this.pixel.x, this.pixel.y, this.valueInput);
                        int band = 0;
                        while (band < numBands) {
                            float value = this.valueInput[band];
                            float bg = BackgroundMovingBasic_IL_MT.this.background.data[indexBG];
                            BackgroundMovingBasic_IL_MT.this.background.data[indexBG] = bg == Float.MAX_VALUE ? value : minusLearn * bg + BackgroundMovingBasic_IL_MT.this.learnRate * value;
                            ++band;
                            ++indexBG;
                        }
                        continue;
                    }
                    indexBG += numBands;
                }
            }
        }

        protected void segment(int y0, int y1, Motion currentToWorld, T frame, GrayU8 segmented) {
            int numBands = BackgroundMovingBasic_IL_MT.this.background.getNumBands();
            float thresholdSq = (float)numBands * BackgroundMovingBasic_IL_MT.this.threshold * BackgroundMovingBasic_IL_MT.this.threshold;
            this.transform.setModel(currentToWorld);
            for (int y = y0; y < y1; ++y) {
                int indexFrame = ((ImageInterleaved)frame).startIndex + y * ((ImageInterleaved)frame).stride;
                int indexSegmented = segmented.startIndex + y * segmented.stride;
                int x = 0;
                while (x < ((ImageInterleaved)frame).width) {
                    block6: {
                        this.transform.compute(x, y, this.pixel);
                        if (this.pixel.x >= 0.0f && this.pixel.x < (float)BackgroundMovingBasic_IL_MT.this.background.width && this.pixel.y >= 0.0f && this.pixel.y < (float)BackgroundMovingBasic_IL_MT.this.background.height) {
                            this.interpolationBG.get(this.pixel.x, this.pixel.y, this.valueBG);
                            double sumErrorSq = 0.0;
                            for (int band = 0; band < numBands; ++band) {
                                float bg = this.valueBG[band];
                                float pixelFrame = BackgroundMovingBasic_IL_MT.this.inputWrapper.getF(indexFrame + band);
                                if (bg == Float.MAX_VALUE) {
                                    segmented.data[indexSegmented] = BackgroundMovingBasic_IL_MT.this.unknownValue;
                                    break block6;
                                }
                                float diff = bg - pixelFrame;
                                sumErrorSq += (double)(diff * diff);
                            }
                            segmented.data[indexSegmented] = (byte)(!(sumErrorSq <= (double)thresholdSq) ? 1 : 0);
                        } else {
                            segmented.data[indexSegmented] = BackgroundMovingBasic_IL_MT.this.unknownValue;
                        }
                    }
                    ++x;
                    indexFrame += numBands;
                    ++indexSegmented;
                }
            }
        }
    }
}

