/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.Planar;
import boofcv.struct.pyramid.ImagePyramid;
import org.jetbrains.annotations.Nullable;

public class InputSanityCheck {
    public static <T extends ImageGray<T>> T checkReshape(T target, ImageGray testImage, Class<T> targetType) {
        if (target == null) {
            return GeneralizedImageOps.createSingleBand(targetType, testImage.width, testImage.height);
        }
        if (target.width != testImage.width || target.height != testImage.height) {
            target.reshape(testImage.width, testImage.height);
        }
        return target;
    }

    public static <T extends ImageBase<T>> T declareOrReshape(T input, @Nullable T output) {
        if (output == null) {
            output = input.createNew(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        return output;
    }

    public static <T extends ImageBase<T>> T declareOutput(T input, @Nullable T output) {
        if (output == null) {
            return input.createNew(input.width, input.height);
        }
        return output;
    }

    public static <T extends ImageGray<T>> T declareOrReshape(@Nullable T image, int width, int height, Class<T> imageType) {
        if (image == null) {
            image = GeneralizedImageOps.createSingleBand(imageType, width, height);
        } else {
            image.reshape(width, height);
        }
        return image;
    }

    public static <T extends ImageInterleaved<T>> T declareOrReshape(@Nullable T image, int width, int height, int numBands, Class<T> imageType) {
        if (image == null) {
            image = GeneralizedImageOps.createInterleaved(imageType, width, height, numBands);
        } else {
            image.reshape(width, height, numBands);
        }
        return image;
    }

    public static <T extends ImageGray<T>> Planar<T> declareOrReshape(@Nullable Planar<T> image, int width, int height, int numBands, Class<T> imageType) {
        if (image == null) {
            image = new Planar<T>(imageType, width, height, numBands);
        } else {
            image.reshape(width, height, numBands);
        }
        return image;
    }

    public static <In extends ImageGray, Out extends ImageGray> Out declareOrReshape(In input, @Nullable Out output, Class<Out> typeOut) {
        if (output == null) {
            output = GeneralizedImageOps.createSingleBand(typeOut, input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        return output;
    }

    public static void checkReshape(ImageBase<?> imgA, ImageBase<?> imgB) {
        if (imgA == imgB) {
            throw new IllegalArgumentException("Image's can't be the same instance");
        }
        imgB.reshape(imgA.width, imgA.height);
    }

    public static void checkReshapeB(ImageMultiBand<?> imgA, ImageMultiBand<?> imgB) {
        if (imgA == imgB) {
            throw new IllegalArgumentException("Images can't be the same instance");
        }
        imgB.reshapeTo(imgA);
    }

    public static void checkSameShape(ImageBase<?> imgA, ImageBase<?> imgB) {
        if (imgA.width != imgB.width || imgA.height != imgB.height) {
            throw new IllegalArgumentException("Image shapes do not match. " + imgA.width + "x" + imgA.height + " vs " + imgB.width + "x" + imgB.height);
        }
    }

    public static void checkSameShapeB(ImageMultiBand<?> imgA, ImageMultiBand<?> imgB) {
        if (imgA.width != imgB.width || imgA.height != imgB.height) {
            throw new IllegalArgumentException("Image shapes do not match. " + imgA.width + "x" + imgA.height + " vs " + imgB.width + "x" + imgB.height);
        }
        if (imgA.getNumBands() != imgB.getNumBands()) {
            throw new IllegalArgumentException("Number of bands do not match " + imgA.getNumBands() + " " + imgB.getNumBands());
        }
    }

    public static void checkSameShape(ImagePyramid<?> imgA, ImagePyramid<?> imgB) {
        if (imgA.getNumLayers() != imgB.getNumLayers()) {
            throw new IllegalArgumentException("Number of layers do not match. " + imgA.getNumLayers() + " " + imgB.getNumLayers());
        }
        int N = imgA.getNumLayers();
        for (int i = 0; i < N; ++i) {
            if (imgA.getScale(i) == imgB.getScale(i)) continue;
            throw new IllegalArgumentException("Scales do not match at layer " + i);
        }
    }

    public static void checkSameShape(ImageBase<?> imgA, ImageBase<?> imgB, ImageBase<?> imgC) {
        if (imgA.width != imgB.width || imgA.width != imgC.width) {
            throw new IllegalArgumentException("Image widths do not match.");
        }
        if (imgA.height != imgB.height || imgA.height != imgC.height) {
            throw new IllegalArgumentException("Image heights do not match.");
        }
    }

    public static void checkSameShape(ImageBase<?> imgA, ImageBase<?> imgB, ImageBase<?> imgC, ImageBase<?> imgD) {
        if (imgA.width != imgB.width || imgA.width != imgC.width || imgA.width != imgD.width) {
            throw new IllegalArgumentException("Image widths do not match.");
        }
        if (imgA.height != imgB.height || imgA.height != imgC.height || imgA.height != imgD.height) {
            throw new IllegalArgumentException("Image heights do not match.");
        }
    }

    public static void checkSameShape(ImageBase<?> imgA, ImageBase<?> imgB, ImageBase<?> imgC, ImageBase<?> imgD, ImageBase<?> imgE) {
        if (imgA.width != imgB.width || imgA.width != imgC.width || imgA.width != imgD.width || imgA.width != imgE.width) {
            throw new IllegalArgumentException("Image widths do not match.");
        }
        if (imgA.height != imgB.height || imgA.height != imgC.height || imgA.height != imgD.height || imgA.height != imgE.height) {
            throw new IllegalArgumentException("Image heights do not match.");
        }
    }

    public static void reshapeOneIn(ImageBase<?> input, ImageBase<?> outputA) {
        outputA.reshape(input.width, input.height);
    }

    public static void reshapeOneIn(ImageBase<?> input, ImageBase<?> outputA, ImageBase<?> outputB) {
        outputA.reshape(input.width, input.height);
        outputB.reshape(input.width, input.height);
    }

    public static void reshapeOneIn(ImageBase<?> input, ImageBase<?> outputA, ImageBase<?> outputB, ImageBase<?> outputC) {
        outputA.reshape(input.width, input.height);
        outputB.reshape(input.width, input.height);
        outputC.reshape(input.width, input.height);
    }

    public static void reshapeOneIn(ImageBase<?> input, ImageBase<?> outputA, ImageBase<?> outputB, ImageBase<?> outputC, ImageBase<?> outputD) {
        outputA.reshape(input.width, input.height);
        outputB.reshape(input.width, input.height);
        outputC.reshape(input.width, input.height);
        outputD.reshape(input.width, input.height);
    }

    public static void checkSubimage(ImageBase image) {
        if (image.isSubimage()) {
            throw new IllegalArgumentException("Input image cannot be a subimage");
        }
    }

    public static void checkIndexing(ImageBase imgA, ImageBase imgB) {
        if (imgA.stride != imgB.stride) {
            throw new IllegalArgumentException("Strides of images are not the same");
        }
        if (imgA.startIndex != imgB.startIndex) {
            throw new IllegalArgumentException("Start index of the images is not the same");
        }
    }
}

