/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.shapes.polyline;

import boofcv.abst.shapes.polyline.PointsToPolyline;
import boofcv.alg.shapes.polyline.MinimizeEnergyPrune;
import boofcv.alg.shapes.polyline.RefinePolyLineCorner;
import boofcv.alg.shapes.polyline.splitmerge.SplitMergeLineFit;
import boofcv.alg.shapes.polyline.splitmerge.SplitMergeLineFitLoop;
import boofcv.alg.shapes.polyline.splitmerge.SplitMergeLineFitSegment;
import boofcv.factory.shape.ConfigSplitMergeLineFit;
import boofcv.struct.ConfigLength;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.List;
import org.ddogleg.struct.DogArray_I32;

@Deprecated
public class SplitMergeLineRefine_to_PointsToPolyline
implements PointsToPolyline {
    int maxVertexes = Integer.MAX_VALUE;
    int minVertexes = 3;
    SplitMergeLineFit splitMerge;
    RefinePolyLineCorner refine;
    private final DogArray_I32 pruned = new DogArray_I32();
    private MinimizeEnergyPrune pruner;
    boolean convex = true;
    Polygon2D_F64 tmp = new Polygon2D_F64();

    public SplitMergeLineRefine_to_PointsToPolyline(ConfigSplitMergeLineFit config) {
        ConfigLength minimumSplit = config.minimumSide.copy();
        this.splitMerge = config.loop ? new SplitMergeLineFitLoop(config.splitFraction, minimumSplit, config.iterations) : new SplitMergeLineFitSegment(config.splitFraction, minimumSplit, config.iterations);
        if (config.refine > 0) {
            this.refine = new RefinePolyLineCorner(config.loop, config.refine);
        }
        if (config.pruneSplitPenalty > 0.0) {
            this.pruner = new MinimizeEnergyPrune(config.pruneSplitPenalty);
        }
        this.convex = config.convex;
        this.minVertexes = config.minimumSides;
        this.maxVertexes = config.maximumSides;
    }

    @Override
    public boolean process(List<Point2D_I32> input, DogArray_I32 vertexes) {
        if (!this.splitMerge.process(input, vertexes)) {
            return false;
        }
        if (this.refine != null && !this.refine.fit(input, vertexes)) {
            return false;
        }
        if (this.pruner != null && this.pruner.prune(input, vertexes, this.pruned)) {
            vertexes.setTo(this.pruned);
        }
        if (vertexes.size > this.maxVertexes || vertexes.size < this.minVertexes) {
            return false;
        }
        this.tmp.vertexes.resize(vertexes.size);
        for (int i = 0; i < vertexes.size; ++i) {
            Point2D_I32 p = input.get(vertexes.get(i));
            this.tmp.set(i, p.x, p.y);
        }
        return !this.convex || UtilPolygons2D_F64.isConvex(this.tmp);
    }

    @Override
    public void setMinimumSides(int minimum) {
        this.minVertexes = minimum;
    }

    @Override
    public int getMinimumSides() {
        return this.minVertexes;
    }

    @Override
    public void setMaximumSides(int maximum) {
        this.maxVertexes = maximum;
        this.splitMerge.setAbortSplits(maximum * 2);
    }

    @Override
    public int getMaximumSides() {
        return this.maxVertexes;
    }

    @Override
    public boolean isLoop() {
        return this.splitMerge instanceof SplitMergeLineFitLoop;
    }

    @Override
    public void setConvex(boolean convex) {
        this.convex = convex;
    }

    @Override
    public boolean isConvex() {
        return this.convex;
    }
}

