/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.abst.tracker.PointTrack;
import boofcv.alg.sfm.d3.VisOdomMonoPlaneInfinity;
import boofcv.alg.sfm.robust.DistancePlane2DToPixelSq;
import boofcv.alg.sfm.robust.GenerateSe2_PlanePtPixel;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MonoPlaneInfinity_to_MonocularPlaneVisualOdometry<T extends ImageBase<T>>
implements MonocularPlaneVisualOdometry<T>,
AccessPointTracks3D {
    VisOdomMonoPlaneInfinity<T> alg;
    DistancePlane2DToPixelSq distance;
    GenerateSe2_PlanePtPixel generator;
    ImageType<T> imageType;
    boolean fault;
    Se3_F64 cameraToWorld = new Se3_F64();
    @Nullable
    List<PointTrack> active = null;

    public MonoPlaneInfinity_to_MonocularPlaneVisualOdometry(VisOdomMonoPlaneInfinity<T> alg, DistancePlane2DToPixelSq distance, GenerateSe2_PlanePtPixel generator, ImageType<T> imageType) {
        this.alg = alg;
        this.distance = distance;
        this.generator = generator;
        this.imageType = imageType;
    }

    @Override
    public void setCalibration(MonoPlaneParameters param) {
        this.alg.setIntrinsic(param.intrinsic);
        this.distance.setIntrinsic(param.intrinsic.fx, param.intrinsic.fy, param.intrinsic.skew);
        this.alg.setExtrinsic(param.planeToCamera);
        this.generator.setExtrinsic(param.planeToCamera);
        this.distance.setExtrinsic(param.planeToCamera);
    }

    @Override
    public boolean process(T input) {
        this.active = null;
        this.fault = this.alg.process(input);
        return this.fault;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void reset() {
        this.active = null;
        this.alg.reset();
        this.cameraToWorld.reset();
    }

    @Override
    public boolean isFault() {
        return this.fault;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        Se3_F64 worldToCamera = this.alg.getWorldToCurr3D();
        worldToCamera.invert(this.cameraToWorld);
        return this.cameraToWorld;
    }

    @Override
    public long getFrameID() {
        return this.alg.getFrameID();
    }

    @Override
    public boolean getTrackWorld3D(int index, Point3D_F64 world) {
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        VisOdomMonoPlaneInfinity.VoTrack track = (VisOdomMonoPlaneInfinity.VoTrack)this.active.get(index).getCookie();
        if (track.onPlane) {
            world.x = -track.ground.y;
            world.z = track.ground.x;
            world.y = 0.0;
        } else {
            world.x = -track.ground.y * 1000.0;
            world.z = track.ground.x * 1000.0;
            world.y = 0.0;
        }
        return true;
    }

    @Override
    public int getTotalTracks() {
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        return this.active.size();
    }

    @Override
    public long getTrackId(int index) {
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        PointTrack t = this.active.get(index);
        return t.featureId;
    }

    @Override
    public void getTrackPixel(int index, Point2D_F64 pixel) {
        pixel.setTo(Objects.requireNonNull(this.active).get((int)index).pixel);
    }

    @Override
    public List<Point2D_F64> getAllTracks(@Nullable List<Point2D_F64> storage) {
        if (storage == null) {
            storage = new ArrayList<Point2D_F64>();
        } else {
            storage.clear();
        }
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        for (int i = 0; i < this.active.size(); ++i) {
            storage.add(this.active.get((int)i).pixel);
        }
        return storage;
    }

    @Override
    public boolean isTrackInlier(int index) {
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        PointTrack t = this.active.get(index);
        VisOdomMonoPlaneInfinity.VoTrack v = (VisOdomMonoPlaneInfinity.VoTrack)t.getCookie();
        return v.lastInlier == this.alg.getFrameID();
    }

    @Override
    public boolean isTrackNew(int index) {
        return false;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
    }
}

