/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.CalibrateMonoPlanar;
import boofcv.abst.geo.calibration.CalibrationQuality;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricResidualFunction;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.CodecSceneStructureMetric;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.ScoreCalibrationFill;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.ImageDimension;
import georegression.fitting.se.FitSpecialEuclideanOps_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class CalibrateStereoPlanar
implements VerbosePrint {
    List<Se3_F64> viewLeft = new ArrayList<Se3_F64>();
    List<Se3_F64> viewRight = new ArrayList<Se3_F64>();
    CalibrateMonoPlanar calibLeft = new CalibrateMonoPlanar();
    CalibrateMonoPlanar calibRight = new CalibrateMonoPlanar();
    List<Point2D_F64> layout;
    MetricBundleAdjustmentUtils bundleUtils = new MetricBundleAdjustmentUtils();
    @Nullable
    PrintStream verbose;

    public CalibrateStereoPlanar(List<Point2D_F64> layout) {
        this.layout = layout;
    }

    public void initialize(ImageDimension left, ImageDimension right) {
        this.viewLeft.clear();
        this.viewRight.clear();
        this.calibLeft.initialize(left.width, left.height, this.layout);
        this.calibRight.initialize(right.width, right.height, this.layout);
    }

    public void configure(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        this.calibLeft.configurePinhole(assumeZeroSkew, numRadialParam, includeTangential);
        this.calibRight.configurePinhole(assumeZeroSkew, numRadialParam, includeTangential);
    }

    public void addPair(CalibrationObservation left, CalibrationObservation right) {
        this.calibLeft.addImage(left);
        this.calibRight.addImage(right);
    }

    public StereoParameters process() {
        if (this.verbose != null) {
            this.verbose.println("Mono Left");
        }
        CameraPinholeBrown leftParam = this.calibrateMono(this.calibLeft, this.viewLeft);
        if (this.verbose != null) {
            this.verbose.println("Mono right");
        }
        CameraPinholeBrown rightParam = this.calibrateMono(this.calibRight, this.viewRight);
        Se3_F64 rightToLeft = this.computeRightToLeft();
        StereoParameters results = new StereoParameters(leftParam, rightParam, rightToLeft);
        this.refineAll(results);
        return results;
    }

    private CameraPinholeBrown calibrateMono(CalibrateMonoPlanar calib, List<Se3_F64> location) {
        calib.setVerbose(this.verbose, null);
        CameraPinholeBrown intrinsic = (CameraPinholeBrown)calib.process();
        SceneStructureMetric structure = calib.getStructure();
        for (int i = 0; i < structure.motions.size; ++i) {
            location.add(((SceneStructureMetric.Motion[])structure.motions.data)[i].parent_to_view);
        }
        return intrinsic;
    }

    private Se3_F64 computeRightToLeft() {
        List<Point2D_F64> points2D = this.layout;
        ArrayList<Point3D_F64> points3D = new ArrayList<Point3D_F64>();
        for (Point2D_F64 p : points2D) {
            points3D.add(new Point3D_F64(p.x, p.y, 0.0));
        }
        ArrayList<Point3D_F64> left = new ArrayList<Point3D_F64>();
        ArrayList<Point3D_F64> right = new ArrayList<Point3D_F64>();
        for (int i = 0; i < this.viewLeft.size(); ++i) {
            Se3_F64 worldToLeft = this.viewLeft.get(i);
            Se3_F64 worldToRight = this.viewRight.get(i);
            for (Point3D_F64 p : points3D) {
                Point3D_F64 l = SePointOps_F64.transform(worldToLeft, p, null);
                Point3D_F64 r = SePointOps_F64.transform(worldToRight, p, null);
                left.add(l);
                right.add(r);
            }
        }
        return FitSpecialEuclideanOps_F64.fitPoints3D(right, left);
    }

    private void refineAll(StereoParameters parameters) {
        PointIndex2D_F64 p;
        int j;
        int viewIndex;
        Se3_F64 left_to_right = parameters.right_to_left.invert((Se3_F64)null);
        SceneStructureMetric structure = this.bundleUtils.getStructure();
        SceneObservations observations = this.bundleUtils.getObservations();
        SceneStructureMetric structureLeft = this.calibLeft.getStructure();
        SceneStructureMetric structureRight = this.calibRight.getStructure();
        int numViews = structureLeft.views.size;
        structure.initialize(2, numViews * 2, numViews + 1, 0, 1);
        structure.setCamera(0, false, ((SceneStructureCommon.Camera)structureLeft.cameras.get((int)0)).model);
        structure.setCamera(1, false, ((SceneStructureCommon.Camera)structureRight.cameras.get((int)0)).model);
        structure.setRigid(0, true, new Se3_F64(), this.layout.size());
        SceneStructureMetric.Rigid rigid = ((SceneStructureMetric.Rigid[])structure.rigids.data)[0];
        for (int i = 0; i < this.layout.size(); ++i) {
            rigid.setPoint(i, this.layout.get((int)i).x, this.layout.get((int)i).y, 0.0);
        }
        int left_to_right_idx = structure.addMotion(false, left_to_right);
        for (viewIndex = 0; viewIndex < numViews; ++viewIndex) {
            int world_to_left_idx = structure.addMotion(false, ((SceneStructureMetric.Motion)structureLeft.motions.get((int)viewIndex)).parent_to_view);
            structure.setView(viewIndex * 2, 0, world_to_left_idx, -1);
            structure.setView(viewIndex * 2 + 1, 1, left_to_right_idx, viewIndex * 2);
        }
        observations.initialize(structure.views.size, true);
        for (viewIndex = 0; viewIndex < numViews; ++viewIndex) {
            SceneObservations.View oviewLeft = observations.getViewRigid(viewIndex * 2);
            CalibrationObservation left = this.calibLeft.observations.get(viewIndex);
            for (j = 0; j < left.size(); ++j) {
                p = left.get(j);
                oviewLeft.add(p.index, (float)((Point2D_F64)p.p).x, (float)((Point2D_F64)p.p).y);
                rigid.connectPointToView(p.index, viewIndex * 2);
            }
        }
        for (viewIndex = 0; viewIndex < numViews; ++viewIndex) {
            SceneObservations.View oviewRight = observations.getViewRigid(viewIndex * 2 + 1);
            CalibrationObservation right = this.calibRight.observations.get(viewIndex);
            for (j = 0; j < right.size(); ++j) {
                p = right.get(j);
                oviewRight.add(p.index, (float)((Point2D_F64)p.p).x, (float)((Point2D_F64)p.p).y);
                rigid.connectPointToView(p.index, viewIndex * 2 + 1);
            }
        }
        if (this.verbose != null) {
            this.verbose.println("Joint bundle adjustment");
        }
        if (!this.bundleUtils.process()) {
            return;
        }
        ((SceneStructureMetric.Motion)structure.motions.get((int)left_to_right_idx)).parent_to_view.invert(parameters.right_to_left);
        BundleAdjustmentOps.convert((BundlePinholeBrown)((SceneStructureCommon.Camera)structure.cameras.get((int)0)).model, parameters.left.width, parameters.left.height, parameters.left);
        BundleAdjustmentOps.convert((BundlePinholeBrown)((SceneStructureCommon.Camera)structure.cameras.get((int)1)).model, parameters.left.width, parameters.left.height, parameters.right);
    }

    public String computeQualityText(List<String> namesLeft) {
        ScoreCalibrationFill fillScorer = new ScoreCalibrationFill();
        CalibrationQuality qualityLeft = new CalibrationQuality();
        CalibrationQuality qualityRight = new CalibrationQuality();
        CalibrateMonoPlanar.computeQuality(this.getCalibLeft().getIntrinsic(), fillScorer, this.layout, this.getCalibLeft().getObservations(), qualityLeft);
        CalibrateMonoPlanar.computeQuality(this.getCalibRight().getIntrinsic(), fillScorer, this.layout, this.getCalibRight().getObservations(), qualityRight);
        List<ImageResults> errors = this.computeErrors();
        return CalibrateStereoPlanar.computeQualityText(namesLeft, null, errors, qualityLeft, qualityRight);
    }

    public static String computeQualityText(List<String> namesLeft, @Nullable DogArray_B used, List<ImageResults> errors, CalibrationQuality qualityLeft, CalibrationQuality qualityRight) {
        double averageError = 0.0;
        double maxError = 0.0;
        for (int i = 0; i < errors.size(); ++i) {
            ImageResults r = errors.get(i);
            averageError += r.meanError;
            maxError = Math.max(maxError, r.maxError);
        }
        averageError /= (double)errors.size();
        Object text = "";
        text = (String)text + "Metrics             left right \n";
        text = (String)text + String.format("quality.fill_border %3.0f%% %3.0f%%\n", 100.0 * qualityLeft.borderFill, 100.0 * qualityRight.borderFill);
        text = (String)text + String.format("quality.fill_inner  %3.0f%% %3.0f%%\n", 100.0 * qualityLeft.innerFill, 100.0 * qualityRight.innerFill);
        text = (String)text + String.format("quality.geometric   %3.0f%% %3.0f%%\n", 100.0 * qualityLeft.geometric, 100.0 * qualityRight.geometric);
        text = (String)text + "\n";
        text = (String)text + String.format("Reprojection Errors (px):\nmean=%.3f max=%.3f\n\n", averageError, maxError);
        text = (String)text + String.format("%-10s | %8s\n", "image", "max (px)");
        int i = 0;
        for (int imageIdx = 0; imageIdx < namesLeft.size(); ++imageIdx) {
            if (used != null && !used.get(imageIdx)) continue;
            String imageName = namesLeft.get(imageIdx);
            ImageResults r = errors.get(i);
            text = (String)text + String.format("%-12s %8.3f\n", imageName, r.maxError);
            r = errors.get(i + 1);
            text = (String)text + String.format("%-12s %8.3f\n", "", r.maxError);
            i += 2;
        }
        return text;
    }

    public List<ImageResults> computeErrors() {
        SceneStructureMetric structure = this.bundleUtils.getStructure();
        SceneObservations observations = this.bundleUtils.getObservations();
        ArrayList<ImageResults> errors = new ArrayList<ImageResults>();
        double[] parameters = new double[structure.getParameterCount()];
        double[] residuals = new double[observations.getObservationCount() * 2];
        CodecSceneStructureMetric codec = new CodecSceneStructureMetric();
        codec.encode(structure, parameters);
        BundleAdjustmentMetricResidualFunction function = new BundleAdjustmentMetricResidualFunction();
        function.configure(structure, observations);
        function.process(parameters, residuals);
        int idx = 0;
        for (int i = 0; i < observations.viewsRigid.size; ++i) {
            SceneObservations.View v = ((SceneObservations.View[])observations.viewsRigid.data)[i];
            ImageResults r = new ImageResults(v.size());
            double sumX = 0.0;
            double sumY = 0.0;
            double meanErrorMag = 0.0;
            double maxError = 0.0;
            for (int j = 0; j < v.size(); ++j) {
                double x = residuals[idx++];
                double y = residuals[idx++];
                double nerr = r.pointError[j] = Math.sqrt(x * x + y * y);
                meanErrorMag += nerr;
                maxError = Math.max(maxError, nerr);
                sumX += x;
                sumY += y;
            }
            r.biasX = sumX / (double)v.size();
            r.biasY = sumY / (double)v.size();
            r.meanError = meanErrorMag / (double)v.size();
            r.maxError = maxError;
            errors.add(r);
        }
        return errors;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public CalibrateMonoPlanar getCalibLeft() {
        return this.calibLeft;
    }

    public CalibrateMonoPlanar getCalibRight() {
        return this.calibRight;
    }
}

