/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import java.util.Objects;

public class ConfigSquareGrid
implements Configuration {
    public ConfigThreshold thresholding = ConfigThreshold.local(ThresholdType.BLOCK_MEAN, ConfigLength.relative(0.02, 5.0));
    public ConfigPolygonDetector square = new ConfigPolygonDetector();

    public ConfigSquareGrid() {
        this.thresholding.scale = 0.85;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).cornerScorePenalty = 0.5;
        this.square.detector.minimumContour = ConfigLength.fixed(10.0);
        Objects.requireNonNull(this.square.refineGray);
        this.square.refineGray.cornerOffset = 1.0;
        this.square.refineGray.lineSamples = 15;
        this.square.refineGray.convergeTolPixels = 0.2;
        this.square.refineGray.maxIterations = 10;
    }

    public ConfigSquareGrid setTo(ConfigSquareGrid src) {
        this.thresholding.setTo(src.thresholding);
        this.square.setTo(src.square);
        return this;
    }

    @Override
    public void checkValidity() {
        this.thresholding.checkValidity();
        this.square.checkValidity();
    }
}

