/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigChessboardX;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.geo.calibration.DetectSingleFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.feature.detect.chess.DetectChessboardCornersXPyramid;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerClusterFinder;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerClusterToGrid;
import boofcv.alg.fiducial.calib.chess.DetectChessboardXCornerPatterns;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class CalibrationDetectorChessboardX
implements DetectSingleFiducialCalibration {
    int cornerRows;
    int cornerCols;
    DetectChessboardXCornerPatterns<GrayF32> detectorX;
    @Nullable
    Point2Transform2_F64 pixel2undist;
    List<Point2D_F64> layoutPoints;
    CalibrationObservation detected;

    public CalibrationDetectorChessboardX(ConfigChessboardX config, ConfigGridDimen shape) {
        this.detectorX = new DetectChessboardXCornerPatterns<GrayF32>(config, GrayF32.class);
        this.cornerRows = shape.numRows - 1;
        this.cornerCols = shape.numCols - 1;
        this.layoutPoints = CalibrationDetectorChessboardX.gridChess(shape.numRows, shape.numCols, shape.shapeSize);
        this.detectorX.getClusterToGrid().setCheckShape((r, c) -> r == this.cornerRows && c == this.cornerCols);
    }

    @Override
    public boolean process(GrayF32 input) {
        this.detectorX.findPatterns(input);
        DogArray<ChessboardCornerClusterToGrid.GridInfo> found = this.detectorX.getFoundChessboard();
        if (found.size >= 1) {
            int i;
            this.detected = new CalibrationObservation();
            ChessboardCornerClusterToGrid.GridInfo info = (ChessboardCornerClusterToGrid.GridInfo)found.get(0);
            for (i = 0; i < info.nodes.size(); ++i) {
                this.detected.add(i, info.nodes.get((int)i).corner);
            }
            if (this.pixel2undist != null) {
                for (i = 0; i < info.nodes.size(); ++i) {
                    Point2D_F64 p = (Point2D_F64)this.detected.points.get((int)i).p;
                    this.pixel2undist.compute(p.x, p.y, p);
                }
            }
            return true;
        }
        this.detected = new CalibrationObservation();
        return false;
    }

    @Override
    public CalibrationObservation getDetectedPoints() {
        return this.detected;
    }

    @Override
    public List<Point2D_F64> getLayout() {
        return this.layoutPoints;
    }

    @Override
    public void setLensDistortion(@Nullable LensDistortionNarrowFOV distortion, int width, int height) {
        this.pixel2undist = distortion == null ? null : distortion.undistort_F64(true, true);
    }

    public DetectChessboardCornersXPyramid<GrayF32> getDetector() {
        return this.detectorX.getDetector();
    }

    public ChessboardCornerClusterFinder<GrayF32> getClusterFinder() {
        return this.detectorX.getClusterFinder();
    }

    public ChessboardCornerClusterToGrid getClusterToGrid() {
        return this.detectorX.getClusterToGrid();
    }

    public static List<Point2D_F64> gridChess(int numRows, int numCols, double squareWidth) {
        ArrayList<Point2D_F64> all = new ArrayList<Point2D_F64>();
        double startX = -((double)(--numCols - 1) * squareWidth) / 2.0;
        double startY = -((double)(--numRows - 1) * squareWidth) / 2.0;
        for (int i = numRows - 1; i >= 0; --i) {
            double y = startY + (double)i * squareWidth;
            for (int j = 0; j < numCols; ++j) {
                double x = startX + (double)j * squareWidth;
                all.add(new Point2D_F64(x, y));
            }
        }
        return all;
    }

    public int getCornerRows() {
        return this.cornerRows;
    }

    public int getCornerCols() {
        return this.cornerCols;
    }

    public DetectChessboardXCornerPatterns<GrayF32> getDetectorX() {
        return this.detectorX;
    }
}

