/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetectorPnP;
import boofcv.abst.fiducial.MicroQrCodeDetector;
import boofcv.abst.fiducial.MicroQrCodePreciseDetector;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.microqr.MicroQrCode;
import boofcv.alg.fiducial.microqr.MicroQrPose3DUtils;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.util.List;
import org.ejml.UtilEjml;
import org.jetbrains.annotations.Nullable;

public class MicroQrCodeDetectorPnP<T extends ImageGray<T>>
extends FiducialDetectorPnP<T> {
    MicroQrCodeDetector<T> detector;
    ImageType<T> imageType;
    MicroQrPose3DUtils poseUtils = new MicroQrPose3DUtils();
    double sideWidth = 1.0;

    public MicroQrCodeDetectorPnP(MicroQrCodeDetector<T> detector) {
        this.detector = detector;
        this.imageType = ImageType.single(detector.getImageType());
    }

    @Override
    public void setLensDistortion(@Nullable LensDistortionNarrowFOV distortion, int width, int height) {
        super.setLensDistortion(distortion, width, height);
        if (distortion == null) {
            this.poseUtils.setLensDistortion(null, null);
            ((MicroQrCodePreciseDetector)this.detector).setLensDistortion(width, height, null);
        } else {
            Point2D_F64 test = new Point2D_F64();
            Point2Transform2_F64 undistToDist = distortion.distort_F64(true, true);
            undistToDist.compute(0.0, 0.0, test);
            this.poseUtils.setLensDistortion(distortion.undistort_F64(true, false), undistToDist);
            if (test.norm() <= (double)UtilEjml.TEST_F32) {
                ((MicroQrCodePreciseDetector)this.detector).setLensDistortion(width, height, null);
            } else {
                ((MicroQrCodePreciseDetector)this.detector).setLensDistortion(width, height, distortion);
            }
        }
    }

    @Override
    public double getSideWidth(int which) {
        return this.sideWidth;
    }

    @Override
    public double getSideHeight(int which) {
        return this.sideWidth;
    }

    @Override
    public boolean getFiducialToCamera(int which, Se3_F64 fiducialToCamera) {
        if (super.getFiducialToCamera(which, fiducialToCamera)) {
            fiducialToCamera.T.scale(this.sideWidth / 2.0);
            return true;
        }
        return false;
    }

    @Override
    public List<PointIndex2D_F64> getDetectedControl(int which) {
        MicroQrCode qr = this.detector.getDetections().get(which);
        return this.poseUtils.getLandmarkByIndex(qr);
    }

    @Override
    protected List<Point2D3D> getControl3D(int which) {
        MicroQrCode qr = this.detector.getDetections().get(which);
        return this.poseUtils.getLandmark2D3D(qr);
    }

    @Override
    public void detect(T input) {
        this.detector.process(input);
    }

    @Override
    public int totalFound() {
        return this.detector.getDetections().size();
    }

    @Override
    public void getCenter(int which, Point2D_F64 location) {
        MicroQrCode qr = this.detector.getDetections().get(which);
        int halfModules = qr.getNumberOfModules() / 2;
        HomographyPointOps_F64.transform(qr.Hinv, (double)halfModules + 0.5, (double)halfModules + 0.5, location);
    }

    @Override
    public Polygon2D_F64 getBounds(int which, @Nullable Polygon2D_F64 storage) {
        if (storage == null) {
            storage = new Polygon2D_F64();
        }
        storage.setTo(this.detector.getDetections().get((int)which).bounds);
        return storage;
    }

    @Override
    public long getId(int which) {
        return this.detector.getDetections().get((int)which).message.hashCode();
    }

    @Override
    public String getMessage(int which) {
        return this.detector.getDetections().get((int)which).message;
    }

    @Override
    public double getWidth(int which) {
        return this.sideWidth;
    }

    public void setMarkerWidth(double markerWidth) {
        this.sideWidth = markerWidth;
    }

    @Override
    public boolean hasID() {
        return true;
    }

    @Override
    public boolean hasMessage() {
        return true;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.imageType;
    }

    public MicroQrCodeDetector<T> getDetector() {
        return this.detector;
    }
}

