/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetector;
import boofcv.abst.fiducial.FiducialStability;
import boofcv.abst.fiducial.FourPointSyntheticStability;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.RefinePnP;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.WorldToCameraToPixel;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.struct.DogArray_F64;
import org.jetbrains.annotations.Nullable;

public abstract class FiducialDetectorPnP<T extends ImageBase<T>>
implements FiducialDetector<T> {
    @Nullable
    private LensDistortionNarrowFOV lensDistortion;
    @Nullable
    protected Point2Transform2_F64 pixelToNorm;
    private List<Point2D3D> detected2D3D = new ArrayList<Point2D3D>();
    private List<PointIndex2D_F64> detectedPixels;
    boolean hasCameraModel = false;
    private Estimate1ofPnP estimatePnP = FactoryMultiView.computePnPwithEPnP(10, 0.2);
    private RefinePnP refinePnP = FactoryMultiView.pnpRefine(1.0E-8, 100);
    private WorldToCameraToPixel w2p = new WorldToCameraToPixel();
    private Se3_F64 initialEstimate = new Se3_F64();
    private FourPointSyntheticStability stability = new FourPointSyntheticStability();
    private Se3_F64 targetToCamera = new Se3_F64();
    DogArray_F64 errors = new DogArray_F64();
    Point2D_F64 predicted = new Point2D_F64();
    List<Point2D3D> filtered = new ArrayList<Point2D3D>();

    public abstract double getSideWidth(int var1);

    public abstract double getSideHeight(int var1);

    @Override
    public boolean computeStability(int which, double disturbance, FiducialStability results) {
        if (!this.getFiducialToCamera(which, this.targetToCamera)) {
            return false;
        }
        this.stability.setShape(this.getSideWidth(which), this.getSideHeight(which));
        this.stability.computeStability(this.targetToCamera, disturbance, results);
        return true;
    }

    @Override
    public void setLensDistortion(@Nullable LensDistortionNarrowFOV distortion, int width, int height) {
        if (distortion != null) {
            this.hasCameraModel = true;
            this.lensDistortion = distortion;
            this.pixelToNorm = this.lensDistortion.undistort_F64(true, false);
            Point2Transform2_F64 normToPixel = this.lensDistortion.distort_F64(false, true);
            this.stability.setTransforms(this.pixelToNorm, normToPixel);
        } else {
            this.hasCameraModel = false;
            this.lensDistortion = null;
            this.pixelToNorm = null;
        }
    }

    @Override
    @Nullable
    public LensDistortionNarrowFOV getLensDistortion() {
        return this.lensDistortion;
    }

    @Override
    public boolean getFiducialToCamera(int which, Se3_F64 fiducialToCamera) {
        if (!this.hasCameraModel) {
            return false;
        }
        this.detectedPixels = this.getDetectedControl(which);
        if (this.detectedPixels.size() < 3) {
            return false;
        }
        this.createDetectedList(which, this.detectedPixels);
        return this.estimatePose(which, this.detected2D3D, fiducialToCamera);
    }

    private void createDetectedList(int which, List<PointIndex2D_F64> pixels) {
        Objects.requireNonNull(this.pixelToNorm);
        this.detected2D3D.clear();
        List<Point2D3D> all = this.getControl3D(which);
        for (int i = 0; i < pixels.size(); ++i) {
            Point2D_F64 a = (Point2D_F64)pixels.get((int)i).p;
            Point2D3D b = all.get(i);
            this.pixelToNorm.compute(a.x, a.y, b.observation);
            this.detected2D3D.add(b);
        }
    }

    protected boolean estimatePose(int which, List<Point2D3D> points, Se3_F64 fiducialToCamera) {
        if (!this.estimatePnP.process(points, this.initialEstimate)) {
            return false;
        }
        this.filtered.clear();
        if (points.size() > 6) {
            this.w2p.configure(Objects.requireNonNull(this.lensDistortion), this.initialEstimate);
            this.errors.reset();
            for (int idx = 0; idx < this.detectedPixels.size(); ++idx) {
                PointIndex2D_F64 dp = this.detectedPixels.get(idx);
                this.w2p.transform(points.get((int)idx).location, this.predicted);
                this.errors.add(this.predicted.distance2((Point2D_F64)dp.p));
            }
            double stdev = 0.0;
            for (int i = 0; i < this.errors.size; ++i) {
                stdev += this.errors.get(i);
            }
            double sigma3 = Math.max(1.5, 4.0 * stdev);
            for (int i = 0; i < points.size(); ++i) {
                if (!(this.errors.get(i) < sigma3)) continue;
                this.filtered.add(points.get(i));
            }
            if (this.filtered.size() != points.size() && !this.estimatePnP.process(this.filtered, this.initialEstimate)) {
                return false;
            }
        } else {
            this.filtered.addAll(points);
        }
        return this.refinePnP.fitModel(points, this.initialEstimate, fiducialToCamera);
    }

    public abstract List<PointIndex2D_F64> getDetectedControl(int var1);

    protected abstract List<Point2D3D> getControl3D(int var1);

    @Override
    public boolean is3D() {
        return this.hasCameraModel;
    }
}

