/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.AztecCodeDetector;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.aztec.AztecCode;
import boofcv.alg.fiducial.aztec.AztecDecoderImage;
import boofcv.alg.fiducial.aztec.AztecFinderPatternDetector;
import boofcv.alg.fiducial.aztec.AztecPyramid;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class AztecCodePreciseDetector<T extends ImageGray<T>>
implements AztecCodeDetector<T>,
VerbosePrint {
    InputToBinary<T> inputToBinary;
    AztecFinderPatternDetector<T> detectorPyramids;
    AztecDecoderImage<T> decoder;
    GrayU8 binary = new GrayU8(1, 1);
    Class<T> imageType;
    final DogArray<AztecCode> allMarkers = new DogArray<AztecCode>(AztecCode::new, AztecCode::reset);
    final List<AztecCode> detected = new ArrayList<AztecCode>();
    final List<AztecCode> failed = new ArrayList<AztecCode>();
    @Nullable
    PrintStream verbose = null;

    public AztecCodePreciseDetector(InputToBinary<T> inputToBinary, DetectPolygonBinaryGrayRefine<T> squareDetector, Class<T> imageType) {
        this.imageType = imageType;
        this.inputToBinary = inputToBinary;
        this.detectorPyramids = new AztecFinderPatternDetector<T>(squareDetector);
        this.decoder = new AztecDecoderImage<T>(imageType);
    }

    @Override
    public void process(T gray) {
        this.allMarkers.reset();
        this.detected.clear();
        this.failed.clear();
        this.inputToBinary.process(gray, this.binary);
        this.detectorPyramids.process(gray, this.binary);
        List<AztecPyramid> pyramids = this.detectorPyramids.getFound().toList();
        if (this.verbose != null) {
            this.verbose.println("Total pyramids found: " + pyramids.size());
        }
        for (int locatorIdx = 0; locatorIdx < pyramids.size(); ++locatorIdx) {
            AztecCode marker;
            AztecPyramid pyramid = pyramids.get(locatorIdx);
            if (this.verbose != null) {
                this.verbose.println("Considering pyramid at: " + pyramid.get((int)0).center);
            }
            if (this.decoder.process(pyramid, gray, marker = this.allMarkers.grow())) {
                this.detected.add(marker);
                continue;
            }
            this.failed.add(marker);
        }
    }

    @Override
    public List<AztecCode> getDetections() {
        return this.detected;
    }

    @Override
    public List<AztecCode> getFailures() {
        return this.failed;
    }

    @Override
    public Class<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
        BoofMiscOps.verboseChildren(out, configuration, this.decoder, this.detectorPyramids);
    }

    public InputToBinary<T> getInputToBinary() {
        return this.inputToBinary;
    }

    public AztecFinderPatternDetector<T> getDetectorPyramids() {
        return this.detectorPyramids;
    }

    public AztecDecoderImage<T> getDecoder() {
        return this.decoder;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }
}

