/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.orientation;

import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.interest.UnrollSiftScaleSpaceGradient;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class OrientationSiftToImage<T extends ImageGray<T>>
implements OrientationImage<T> {
    UnrollSiftScaleSpaceGradient gradient = new UnrollSiftScaleSpaceGradient();
    OrientationHistogramSift<GrayF32> alg;
    UnrollSiftScaleSpaceGradient.ImageScale image;
    double sigma = 0.16666666666666666;
    Class<T> imageType;
    GrayF32 imageFloat = new GrayF32(1, 1);
    SiftScaleSpace ss;

    public OrientationSiftToImage(OrientationHistogramSift<GrayF32> alg, SiftScaleSpace ss, Class<T> imageType) {
        this.alg = alg;
        this.ss = ss;
        this.imageType = imageType;
        this.gradient.initialize(ss);
    }

    @Override
    public void setImage(T image) {
        GrayF32 input;
        if (image instanceof GrayF32) {
            input = (GrayF32)image;
        } else {
            this.imageFloat.reshape(((ImageGray)image).width, ((ImageGray)image).height);
            GConvertImage.convert(image, this.imageFloat);
            input = this.imageFloat;
        }
        this.ss.process(input);
        this.gradient.process(this.ss);
        this.setObjectRadius(this.sigma * 6.0);
    }

    @Override
    public Class<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void setObjectRadius(double radius) {
        this.sigma = radius / 6.0;
        this.image = this.gradient.lookup(this.sigma);
    }

    @Override
    public double compute(double c_x, double c_y) {
        this.alg.setImageGradient(this.image.derivX, this.image.derivY);
        double imageToInput = this.image.imageToInput;
        this.alg.process(c_x / imageToInput, c_y / imageToInput, this.sigma / imageToInput);
        return this.alg.getPeakOrientation();
    }

    @Override
    public RegionOrientation copy() {
        throw new RuntimeException("IMplement");
    }
}

