/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.HoughTransformBinary;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.line.LineParametric2D_F32;
import java.util.List;

public class HoughBinary_to_DetectLine<I extends ImageGray<I>, D extends ImageGray<D>>
implements DetectLine<I> {
    HoughTransformBinary hough;
    GrayU8 binary = new GrayU8(1, 1);
    InputToBinary<I> binarization;
    public float thresholdEdge = 20.0f;
    public boolean nonMaxSuppression = true;
    ImageGradient<I, D> gradient;
    D derivX;
    D derivY;
    GrayF32 edgeIntensity = new GrayF32(1, 1);
    GrayF32 suppressed = new GrayF32(1, 1);

    public HoughBinary_to_DetectLine(HoughTransformBinary hough, InputToBinary<I> thresholder) {
        this.hough = hough;
        this.binarization = thresholder;
    }

    public HoughBinary_to_DetectLine(HoughTransformBinary hough, ImageGradient<I, D> gradient) {
        this.hough = hough;
        this.gradient = gradient;
        this.derivX = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
        this.derivY = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
    }

    @Override
    public List<LineParametric2D_F32> detect(I input) {
        if (this.isEdge()) {
            this.gradient.process(input, this.derivX, this.derivY);
            GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.edgeIntensity);
            if (this.nonMaxSuppression) {
                GGradientToEdgeFeatures.nonMaxSuppressionCrude4(this.edgeIntensity, this.derivX, this.derivY, this.suppressed);
                ThresholdImageOps.threshold(this.suppressed, this.binary, this.thresholdEdge, false);
            } else {
                ThresholdImageOps.threshold(this.edgeIntensity, this.binary, this.thresholdEdge, false);
            }
        } else {
            this.binarization.process(input, this.binary);
        }
        this.hough.transform(this.binary);
        return this.hough.getLinesMerged();
    }

    @Override
    public ImageType<I> getInputType() {
        return this.binarization.getInputType();
    }

    public boolean isEdge() {
        return this.derivX != null;
    }

    public HoughTransformBinary getHough() {
        return this.hough;
    }

    public InputToBinary<I> getBinarization() {
        return this.binarization;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }
}

