/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;

public abstract class ConfigSurfDescribe
implements Configuration {
    public int widthLargeGrid = 4;
    public int widthSubRegion = 5;
    public double widthSample = 3.0;
    public boolean useHaar = false;

    @Override
    public void checkValidity() {
        BoofMiscOps.checkTrue(this.widthLargeGrid > 0);
        BoofMiscOps.checkTrue(this.widthSubRegion > 0);
        BoofMiscOps.checkTrue(this.widthSample > 0.0);
    }

    public ConfigSurfDescribe setTo(ConfigSurfDescribe src) {
        this.widthLargeGrid = src.widthLargeGrid;
        this.widthSubRegion = src.widthSubRegion;
        this.widthSample = src.widthSample;
        this.useHaar = src.useHaar;
        return this;
    }

    public static class Stability
    extends ConfigSurfDescribe {
        public int overLap = 2;
        public double sigmaLargeGrid = 2.5;
        public double sigmaSubRegion = 2.5;

        @Override
        public void checkValidity() {
            super.checkValidity();
            BoofMiscOps.checkTrue(this.sigmaLargeGrid > 0.0);
            BoofMiscOps.checkTrue(this.sigmaSubRegion > 0.0);
        }

        public Stability setTo(Stability src) {
            super.setTo(src);
            this.overLap = src.overLap;
            this.sigmaLargeGrid = src.sigmaLargeGrid;
            this.sigmaSubRegion = src.sigmaSubRegion;
            return this;
        }
    }

    public static class Fast
    extends ConfigSurfDescribe {
        public double weightSigma = 4.5;

        @Override
        public void checkValidity() {
            super.checkValidity();
            BoofMiscOps.checkTrue(this.weightSigma > 0.0);
        }

        public Fast setTo(Fast src) {
            super.setTo(src);
            this.weightSigma = src.weightSigma;
            return this;
        }
    }
}

