/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.disparity;

import boofcv.abst.disparity.ConfigSpeckleFilter;
import boofcv.abst.disparity.DisparitySmoother;
import boofcv.alg.segmentation.cc.ConnectedSpeckleFiller;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import java.io.PrintStream;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DisparitySmootherSpeckleFilter<Image extends ImageBase<Image>, Disp extends ImageGray<Disp>>
implements DisparitySmoother<Image, Disp> {
    ConnectedSpeckleFiller<Disp> filler;
    ConfigSpeckleFilter config;
    @Nullable
    PrintStream out;

    public DisparitySmootherSpeckleFilter(ConnectedSpeckleFiller<Disp> filler, ConfigSpeckleFilter config) {
        this.config = config;
        this.filler = filler;
    }

    @Override
    public void process(Image image, Disp disp, int disparityRange) {
        int size = this.config.maximumArea.computeI(((ImageBase)disp).totalPixels());
        if (size == 0) {
            return;
        }
        this.filler.process(disp, size, this.config.similarTol, disparityRange);
        if (this.out != null) {
            this.out.println("Speckle maxArea=" + size + " filled=" + this.filler.getTotalFilled());
        }
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.out = out;
    }

    public ConnectedSpeckleFiller<Disp> getFiller() {
        return this.filler;
    }

    public ConfigSpeckleFilter getConfig() {
        return this.config;
    }
}

