'''
Regression test for #226.
'''
import os

import pandas as pd
import pytest

import parsl
from parsl.app.app import App
from parsl.tests.configs.local_threads import config

parsl.clear()
parsl.load(config)


class Foo(object):
    def __init__(self, x):
        self.x = x

    def __eq__(self, value):
        raise NotImplementedError


bar = Foo(1)


@App('python')
def get_foo_x(a, b=bar, c=None):
    return b.x


data = pd.DataFrame({'x': [None, 2, [3]]})


@App('python')
def get_dataframe(d=data):
    return d


@App('bash')
def echo(msg, postfix='there', stdout='std.out'):
    return 'echo {} {}'.format(msg, postfix)


blacklist = os.path.join(os.path.dirname(os.path.dirname(__file__)), 'configs', '*ipp*')


# @pytest.mark.blacklist(blacklist, reason='hangs on Travis')
@pytest.mark.skip("Broke somewhere between PR #525 and PR #652")
def test_no_eq():
    res = get_foo_x('foo').result()
    assert res == 1, 'Expected 1, returned {}'.format(res)


# @pytest.mark.blacklist(blacklist, reason='hangs on Travis')
@pytest.mark.skip("Broke somewhere between PR #525 and PR #652")
def test_get_dataframe():
    res = get_dataframe().result()
    assert res.equals(data), 'Unexpected dataframe'


# @pytest.mark.blacklist(blacklist, reason='hangs on Travis')
@pytest.mark.skip("Broke somewhere between PR #525 and PR #652")
def test_bash_default_arg():
    echo('hello').result()
    with open('std.out', 'r') as f:
        assert f.read().strip() == 'hello there', "Output should be 'hello there'"


if __name__ == '__main__':
    test_no_eq()
    test_bash_default_arg()
    test_get_dataframe()
