"""`Concordance between NACE1 and NACE2 <https://ec.europa.eu/eurostat/documents/1965800/1978760/Copy+of+5225C5EEBF016050E0440003BA9322F9.xls/6e1aec88-f15b-4d0f-bccc-4ee505c7f810>`_.
"""
from ...types import Concordance, Standards
from ..nace2 import NACE2
from . import NACE1

NACE1_to_NACE2 = Concordance(
    src=NACE1,
    dst=NACE2,
    concordances=[
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.11")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.12")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.13")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.14")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.15")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.16")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.19")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.26")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.28")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.29")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.63")),
        ((Standards.NACE1, "01.11"), (Standards.NACE2, "01.64")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "01.11")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "01.13")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "01.19")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "01.25")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "01.28")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "01.3")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "01.64")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "02.1")),
        ((Standards.NACE1, "01.12"), (Standards.NACE2, "02.3")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.21")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.22")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.23")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.24")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.25")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.26")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.27")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.28")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.63")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "01.64")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "02.3")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "10.41")),
        ((Standards.NACE1, "01.13"), (Standards.NACE2, "11.02")),
        ((Standards.NACE1, "01.21"), (Standards.NACE2, "01.41")),
        ((Standards.NACE1, "01.21"), (Standards.NACE2, "01.42")),
        ((Standards.NACE1, "01.22"), (Standards.NACE2, "01.43")),
        ((Standards.NACE1, "01.22"), (Standards.NACE2, "01.45")),
        ((Standards.NACE1, "01.22"), (Standards.NACE2, "01.49")),
        ((Standards.NACE1, "01.23"), (Standards.NACE2, "01.46")),
        ((Standards.NACE1, "01.24"), (Standards.NACE2, "01.47")),
        ((Standards.NACE1, "01.25"), (Standards.NACE2, "01.44")),
        ((Standards.NACE1, "01.25"), (Standards.NACE2, "01.49")),
        ((Standards.NACE1, "01.25"), (Standards.NACE2, "03.22")),
        ((Standards.NACE1, "01.3"), (Standards.NACE2, "01.5")),
        ((Standards.NACE1, "01.41"), (Standards.NACE2, "01.61")),
        ((Standards.NACE1, "01.41"), (Standards.NACE2, "01.63")),
        ((Standards.NACE1, "01.41"), (Standards.NACE2, "01.64")),
        ((Standards.NACE1, "01.41"), (Standards.NACE2, "10.39")),
        ((Standards.NACE1, "01.41"), (Standards.NACE2, "81.3")),
        ((Standards.NACE1, "01.42"), (Standards.NACE2, "01.62")),
        ((Standards.NACE1, "01.5"), (Standards.NACE2, "01.7")),
        ((Standards.NACE1, "01.5"), (Standards.NACE2, "94.99")),
        ((Standards.NACE1, "02.01"), (Standards.NACE2, "01.29")),
        ((Standards.NACE1, "02.01"), (Standards.NACE2, "02.1")),
        ((Standards.NACE1, "02.01"), (Standards.NACE2, "02.2")),
        ((Standards.NACE1, "02.01"), (Standards.NACE2, "02.3")),
        ((Standards.NACE1, "02.01"), (Standards.NACE2, "16.1")),
        ((Standards.NACE1, "02.02"), (Standards.NACE2, "02.4")),
        ((Standards.NACE1, "05.01"), (Standards.NACE2, "03.11")),
        ((Standards.NACE1, "05.01"), (Standards.NACE2, "03.12")),
        ((Standards.NACE1, "05.01"), (Standards.NACE2, "70.22")),
        ((Standards.NACE1, "05.02"), (Standards.NACE2, "03.21")),
        ((Standards.NACE1, "05.02"), (Standards.NACE2, "03.22")),
        ((Standards.NACE1, "10.1"), (Standards.NACE2, "05.1")),
        ((Standards.NACE1, "10.1"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "10.1"), (Standards.NACE2, "19.2")),
        ((Standards.NACE1, "10.2"), (Standards.NACE2, "05.2")),
        ((Standards.NACE1, "10.2"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "10.2"), (Standards.NACE2, "19.2")),
        ((Standards.NACE1, "10.3"), (Standards.NACE2, "08.92")),
        ((Standards.NACE1, "10.3"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "10.3"), (Standards.NACE2, "19.2")),
        ((Standards.NACE1, "11.1"), (Standards.NACE2, "06.1")),
        ((Standards.NACE1, "11.1"), (Standards.NACE2, "06.2")),
        ((Standards.NACE1, "11.1"), (Standards.NACE2, "09.1")),
        ((Standards.NACE1, "11.1"), (Standards.NACE2, "52.21")),
        ((Standards.NACE1, "11.1"), (Standards.NACE2, "52.22")),
        ((Standards.NACE1, "11.2"), (Standards.NACE2, "09.1")),
        ((Standards.NACE1, "12"), (Standards.NACE2, "07.21")),
        ((Standards.NACE1, "12"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "13.1"), (Standards.NACE2, "07.1")),
        ((Standards.NACE1, "13.1"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "13.2"), (Standards.NACE2, "07.29")),
        ((Standards.NACE1, "13.2"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.11"), (Standards.NACE2, "08.11")),
        ((Standards.NACE1, "14.11"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.12"), (Standards.NACE2, "08.11")),
        ((Standards.NACE1, "14.12"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.13"), (Standards.NACE2, "08.11")),
        ((Standards.NACE1, "14.13"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.21"), (Standards.NACE2, "08.12")),
        ((Standards.NACE1, "14.21"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.22"), (Standards.NACE2, "08.12")),
        ((Standards.NACE1, "14.22"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.3"), (Standards.NACE2, "08.91")),
        ((Standards.NACE1, "14.3"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.4"), (Standards.NACE2, "08.93")),
        ((Standards.NACE1, "14.4"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.4"), (Standards.NACE2, "10.84")),
        ((Standards.NACE1, "14.5"), (Standards.NACE2, "08.99")),
        ((Standards.NACE1, "14.5"), (Standards.NACE2, "09.9")),
        ((Standards.NACE1, "14.5"), (Standards.NACE2, "38.21")),
        ((Standards.NACE1, "15.11"), (Standards.NACE2, "10.11")),
        ((Standards.NACE1, "15.12"), (Standards.NACE2, "10.11")),
        ((Standards.NACE1, "15.12"), (Standards.NACE2, "10.12")),
        ((Standards.NACE1, "15.13"), (Standards.NACE2, "10.13")),
        ((Standards.NACE1, "15.13"), (Standards.NACE2, "10.85")),
        ((Standards.NACE1, "15.13"), (Standards.NACE2, "10.89")),
        ((Standards.NACE1, "15.2"), (Standards.NACE2, "10.2")),
        ((Standards.NACE1, "15.2"), (Standards.NACE2, "10.85")),
        ((Standards.NACE1, "15.31"), (Standards.NACE2, "10.31")),
        ((Standards.NACE1, "15.32"), (Standards.NACE2, "10.32")),
        ((Standards.NACE1, "15.33"), (Standards.NACE2, "10.39")),
        ((Standards.NACE1, "15.33"), (Standards.NACE2, "10.85")),
        ((Standards.NACE1, "15.41"), (Standards.NACE2, "10.41")),
        ((Standards.NACE1, "15.42"), (Standards.NACE2, "10.41")),
        ((Standards.NACE1, "15.43"), (Standards.NACE2, "10.42")),
        ((Standards.NACE1, "15.51"), (Standards.NACE2, "10.51")),
        ((Standards.NACE1, "15.52"), (Standards.NACE2, "10.52")),
        ((Standards.NACE1, "15.61"), (Standards.NACE2, "10.61")),
        ((Standards.NACE1, "15.62"), (Standards.NACE2, "10.62")),
        ((Standards.NACE1, "15.62"), (Standards.NACE2, "10.89")),
        ((Standards.NACE1, "15.71"), (Standards.NACE2, "10.91")),
        ((Standards.NACE1, "15.72"), (Standards.NACE2, "10.92")),
        ((Standards.NACE1, "15.81"), (Standards.NACE2, "10.71")),
        ((Standards.NACE1, "15.81"), (Standards.NACE2, "10.85")),
        ((Standards.NACE1, "15.81"), (Standards.NACE2, "10.89")),
        ((Standards.NACE1, "15.82"), (Standards.NACE2, "10.72")),
        ((Standards.NACE1, "15.83"), (Standards.NACE2, "10.81")),
        ((Standards.NACE1, "15.84"), (Standards.NACE2, "10.82")),
        ((Standards.NACE1, "15.85"), (Standards.NACE2, "10.73")),
        ((Standards.NACE1, "15.85"), (Standards.NACE2, "10.85")),
        ((Standards.NACE1, "15.86"), (Standards.NACE2, "10.83")),
        ((Standards.NACE1, "15.87"), (Standards.NACE2, "10.84")),
        ((Standards.NACE1, "15.88"), (Standards.NACE2, "10.86")),
        ((Standards.NACE1, "15.89"), (Standards.NACE2, "10.89")),
        ((Standards.NACE1, "15.91"), (Standards.NACE2, "11.01")),
        ((Standards.NACE1, "15.92"), (Standards.NACE2, "11.01")),
        ((Standards.NACE1, "15.92"), (Standards.NACE2, "20.14")),
        ((Standards.NACE1, "15.93"), (Standards.NACE2, "11.02")),
        ((Standards.NACE1, "15.94"), (Standards.NACE2, "11.03")),
        ((Standards.NACE1, "15.95"), (Standards.NACE2, "11.04")),
        ((Standards.NACE1, "15.96"), (Standards.NACE2, "11.05")),
        ((Standards.NACE1, "15.97"), (Standards.NACE2, "11.06")),
        ((Standards.NACE1, "15.98"), (Standards.NACE2, "11.07")),
        ((Standards.NACE1, "16"), (Standards.NACE2, "12")),
        ((Standards.NACE1, "17.11"), (Standards.NACE2, "13.1")),
        ((Standards.NACE1, "17.12"), (Standards.NACE2, "13.1")),
        ((Standards.NACE1, "17.13"), (Standards.NACE2, "13.1")),
        ((Standards.NACE1, "17.14"), (Standards.NACE2, "13.1")),
        ((Standards.NACE1, "17.15"), (Standards.NACE2, "13.1")),
        ((Standards.NACE1, "17.16"), (Standards.NACE2, "13.1")),
        ((Standards.NACE1, "17.17"), (Standards.NACE2, "13.1")),
        ((Standards.NACE1, "17.21"), (Standards.NACE2, "13.2")),
        ((Standards.NACE1, "17.22"), (Standards.NACE2, "13.2")),
        ((Standards.NACE1, "17.23"), (Standards.NACE2, "13.2")),
        ((Standards.NACE1, "17.24"), (Standards.NACE2, "13.2")),
        ((Standards.NACE1, "17.25"), (Standards.NACE2, "13.2")),
        ((Standards.NACE1, "17.3"), (Standards.NACE2, "13.3")),
        ((Standards.NACE1, "17.4"), (Standards.NACE2, "13.92")),
        ((Standards.NACE1, "17.4"), (Standards.NACE2, "32.5")),
        ((Standards.NACE1, "17.4"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "17.4"), (Standards.NACE2, "95.29")),
        ((Standards.NACE1, "17.51"), (Standards.NACE2, "13.93")),
        ((Standards.NACE1, "17.52"), (Standards.NACE2, "13.94")),
        ((Standards.NACE1, "17.52"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "17.53"), (Standards.NACE2, "13.95")),
        ((Standards.NACE1, "17.54"), (Standards.NACE2, "13.96")),
        ((Standards.NACE1, "17.54"), (Standards.NACE2, "13.99")),
        ((Standards.NACE1, "17.54"), (Standards.NACE2, "17.22")),
        ((Standards.NACE1, "17.6"), (Standards.NACE2, "13.91")),
        ((Standards.NACE1, "17.71"), (Standards.NACE2, "14.19")),
        ((Standards.NACE1, "17.71"), (Standards.NACE2, "14.31")),
        ((Standards.NACE1, "17.72"), (Standards.NACE2, "14.39")),
        ((Standards.NACE1, "18.1"), (Standards.NACE2, "14.11")),
        ((Standards.NACE1, "18.1"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "18.21"), (Standards.NACE2, "14.12")),
        ((Standards.NACE1, "18.22"), (Standards.NACE2, "14.13")),
        ((Standards.NACE1, "18.23"), (Standards.NACE2, "14.14")),
        ((Standards.NACE1, "18.24"), (Standards.NACE2, "14.19")),
        ((Standards.NACE1, "18.24"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "18.3"), (Standards.NACE2, "13.2")),
        ((Standards.NACE1, "18.3"), (Standards.NACE2, "13.91")),
        ((Standards.NACE1, "18.3"), (Standards.NACE2, "14.2")),
        ((Standards.NACE1, "18.3"), (Standards.NACE2, "15.11")),
        ((Standards.NACE1, "19.1"), (Standards.NACE2, "15.11")),
        ((Standards.NACE1, "19.2"), (Standards.NACE2, "15.12")),
        ((Standards.NACE1, "19.2"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "19.3"), (Standards.NACE2, "15.2")),
        ((Standards.NACE1, "19.3"), (Standards.NACE2, "16.29")),
        ((Standards.NACE1, "19.3"), (Standards.NACE2, "22.19")),
        ((Standards.NACE1, "19.3"), (Standards.NACE2, "22.29")),
        ((Standards.NACE1, "20.1"), (Standards.NACE2, "16.1")),
        ((Standards.NACE1, "20.2"), (Standards.NACE2, "16.21")),
        ((Standards.NACE1, "20.3"), (Standards.NACE2, "16.22")),
        ((Standards.NACE1, "20.3"), (Standards.NACE2, "16.23")),
        ((Standards.NACE1, "20.3"), (Standards.NACE2, "41.2")),
        ((Standards.NACE1, "20.3"), (Standards.NACE2, "43.32")),
        ((Standards.NACE1, "20.3"), (Standards.NACE2, "43.91")),
        ((Standards.NACE1, "20.4"), (Standards.NACE2, "16.24")),
        ((Standards.NACE1, "20.4"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "20.51"), (Standards.NACE2, "16.29")),
        ((Standards.NACE1, "20.51"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "20.51"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "20.52"), (Standards.NACE2, "16.29")),
        ((Standards.NACE1, "20.52"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "21.11"), (Standards.NACE2, "17.11")),
        ((Standards.NACE1, "21.12"), (Standards.NACE2, "17.12")),
        ((Standards.NACE1, "21.21"), (Standards.NACE2, "17.21")),
        ((Standards.NACE1, "21.22"), (Standards.NACE2, "17.22")),
        ((Standards.NACE1, "21.22"), (Standards.NACE2, "18.12")),
        ((Standards.NACE1, "21.23"), (Standards.NACE2, "17.23")),
        ((Standards.NACE1, "21.24"), (Standards.NACE2, "17.24")),
        ((Standards.NACE1, "21.25"), (Standards.NACE2, "17.29")),
        ((Standards.NACE1, "21.25"), (Standards.NACE2, "18.12")),
        ((Standards.NACE1, "22.11"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "22.11"), (Standards.NACE2, "58.11")),
        ((Standards.NACE1, "22.11"), (Standards.NACE2, "58.12")),
        ((Standards.NACE1, "22.12"), (Standards.NACE2, "58.13")),
        ((Standards.NACE1, "22.13"), (Standards.NACE2, "58.14")),
        ((Standards.NACE1, "22.14"), (Standards.NACE2, "59.2")),
        ((Standards.NACE1, "22.15"), (Standards.NACE2, "58.19")),
        ((Standards.NACE1, "22.21"), (Standards.NACE2, "18.11")),
        ((Standards.NACE1, "22.22"), (Standards.NACE2, "17.23")),
        ((Standards.NACE1, "22.22"), (Standards.NACE2, "18.12")),
        ((Standards.NACE1, "22.22"), (Standards.NACE2, "58.19")),
        ((Standards.NACE1, "22.23"), (Standards.NACE2, "18.14")),
        ((Standards.NACE1, "22.24"), (Standards.NACE2, "18.13")),
        ((Standards.NACE1, "22.25"), (Standards.NACE2, "18.13")),
        ((Standards.NACE1, "22.31"), (Standards.NACE2, "18.2")),
        ((Standards.NACE1, "22.32"), (Standards.NACE2, "18.2")),
        ((Standards.NACE1, "22.33"), (Standards.NACE2, "18.2")),
        ((Standards.NACE1, "23.1"), (Standards.NACE2, "19.1")),
        ((Standards.NACE1, "23.2"), (Standards.NACE2, "19.2")),
        ((Standards.NACE1, "23.3"), (Standards.NACE2, "20.13")),
        ((Standards.NACE1, "23.3"), (Standards.NACE2, "21.2")),
        ((Standards.NACE1, "23.3"), (Standards.NACE2, "24.46")),
        ((Standards.NACE1, "23.3"), (Standards.NACE2, "38.12")),
        ((Standards.NACE1, "23.3"), (Standards.NACE2, "38.22")),
        ((Standards.NACE1, "24.11"), (Standards.NACE2, "20.11")),
        ((Standards.NACE1, "24.12"), (Standards.NACE2, "20.12")),
        ((Standards.NACE1, "24.13"), (Standards.NACE2, "20.13")),
        ((Standards.NACE1, "24.14"), (Standards.NACE2, "19.1")),
        ((Standards.NACE1, "24.14"), (Standards.NACE2, "20.14")),
        ((Standards.NACE1, "24.15"), (Standards.NACE2, "20.15")),
        ((Standards.NACE1, "24.15"), (Standards.NACE2, "38.21")),
        ((Standards.NACE1, "24.16"), (Standards.NACE2, "20.16")),
        ((Standards.NACE1, "24.17"), (Standards.NACE2, "20.17")),
        ((Standards.NACE1, "24.2"), (Standards.NACE2, "20.2")),
        ((Standards.NACE1, "24.3"), (Standards.NACE2, "20.3")),
        ((Standards.NACE1, "24.41"), (Standards.NACE2, "21.1")),
        ((Standards.NACE1, "24.42"), (Standards.NACE2, "21.2")),
        ((Standards.NACE1, "24.42"), (Standards.NACE2, "32.5")),
        ((Standards.NACE1, "24.51"), (Standards.NACE2, "20.41")),
        ((Standards.NACE1, "24.51"), (Standards.NACE2, "20.42")),
        ((Standards.NACE1, "24.52"), (Standards.NACE2, "20.42")),
        ((Standards.NACE1, "24.61"), (Standards.NACE2, "20.51")),
        ((Standards.NACE1, "24.62"), (Standards.NACE2, "20.52")),
        ((Standards.NACE1, "24.62"), (Standards.NACE2, "20.59")),
        ((Standards.NACE1, "24.63"), (Standards.NACE2, "20.53")),
        ((Standards.NACE1, "24.64"), (Standards.NACE2, "20.59")),
        ((Standards.NACE1, "24.65"), (Standards.NACE2, "26.8")),
        ((Standards.NACE1, "24.66"), (Standards.NACE2, "20.59")),
        ((Standards.NACE1, "24.66"), (Standards.NACE2, "26.11")),
        ((Standards.NACE1, "24.7"), (Standards.NACE2, "20.6")),
        ((Standards.NACE1, "25.11"), (Standards.NACE2, "22.11")),
        ((Standards.NACE1, "25.12"), (Standards.NACE2, "22.11")),
        ((Standards.NACE1, "25.13"), (Standards.NACE2, "22.19")),
        ((Standards.NACE1, "25.13"), (Standards.NACE2, "32.5")),
        ((Standards.NACE1, "25.13"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "25.13"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "25.21"), (Standards.NACE2, "22.21")),
        ((Standards.NACE1, "25.21"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "25.21"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "25.22"), (Standards.NACE2, "22.22")),
        ((Standards.NACE1, "25.23"), (Standards.NACE2, "22.23")),
        ((Standards.NACE1, "25.23"), (Standards.NACE2, "27.33")),
        ((Standards.NACE1, "25.23"), (Standards.NACE2, "41.2")),
        ((Standards.NACE1, "25.23"), (Standards.NACE2, "43.32")),
        ((Standards.NACE1, "25.24"), (Standards.NACE2, "22.29")),
        ((Standards.NACE1, "25.24"), (Standards.NACE2, "27.33")),
        ((Standards.NACE1, "25.24"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "25.24"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "26.11"), (Standards.NACE2, "23.11")),
        ((Standards.NACE1, "26.12"), (Standards.NACE2, "23.12")),
        ((Standards.NACE1, "26.13"), (Standards.NACE2, "23.13")),
        ((Standards.NACE1, "26.14"), (Standards.NACE2, "23.14")),
        ((Standards.NACE1, "26.15"), (Standards.NACE2, "23.19")),
        ((Standards.NACE1, "26.15"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "26.15"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "26.21"), (Standards.NACE2, "23.41")),
        ((Standards.NACE1, "26.22"), (Standards.NACE2, "23.42")),
        ((Standards.NACE1, "26.23"), (Standards.NACE2, "23.43")),
        ((Standards.NACE1, "26.24"), (Standards.NACE2, "23.44")),
        ((Standards.NACE1, "26.25"), (Standards.NACE2, "23.49")),
        ((Standards.NACE1, "26.26"), (Standards.NACE2, "23.2")),
        ((Standards.NACE1, "26.3"), (Standards.NACE2, "23.31")),
        ((Standards.NACE1, "26.4"), (Standards.NACE2, "23.32")),
        ((Standards.NACE1, "26.4"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "26.4"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "26.51"), (Standards.NACE2, "23.51")),
        ((Standards.NACE1, "26.52"), (Standards.NACE2, "23.52")),
        ((Standards.NACE1, "26.53"), (Standards.NACE2, "23.52")),
        ((Standards.NACE1, "26.61"), (Standards.NACE2, "23.61")),
        ((Standards.NACE1, "26.62"), (Standards.NACE2, "23.62")),
        ((Standards.NACE1, "26.63"), (Standards.NACE2, "23.63")),
        ((Standards.NACE1, "26.64"), (Standards.NACE2, "23.64")),
        ((Standards.NACE1, "26.65"), (Standards.NACE2, "23.65")),
        ((Standards.NACE1, "26.66"), (Standards.NACE2, "23.69")),
        ((Standards.NACE1, "26.7"), (Standards.NACE2, "23.7")),
        ((Standards.NACE1, "26.81"), (Standards.NACE2, "23.91")),
        ((Standards.NACE1, "26.81"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "26.81"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "26.82"), (Standards.NACE2, "23.99")),
        ((Standards.NACE1, "27.1"), (Standards.NACE2, "24.1")),
        ((Standards.NACE1, "27.21"), (Standards.NACE2, "24.51")),
        ((Standards.NACE1, "27.22"), (Standards.NACE2, "24.2")),
        ((Standards.NACE1, "27.31"), (Standards.NACE2, "24.31")),
        ((Standards.NACE1, "27.32"), (Standards.NACE2, "24.32")),
        ((Standards.NACE1, "27.33"), (Standards.NACE2, "24.33")),
        ((Standards.NACE1, "27.34"), (Standards.NACE2, "24.34")),
        ((Standards.NACE1, "27.41"), (Standards.NACE2, "24.41")),
        ((Standards.NACE1, "27.42"), (Standards.NACE2, "24.42")),
        ((Standards.NACE1, "27.43"), (Standards.NACE2, "24.43")),
        ((Standards.NACE1, "27.43"), (Standards.NACE2, "25.99")),
        ((Standards.NACE1, "27.44"), (Standards.NACE2, "24.44")),
        ((Standards.NACE1, "27.45"), (Standards.NACE2, "24.45")),
        ((Standards.NACE1, "27.51"), (Standards.NACE2, "24.51")),
        ((Standards.NACE1, "27.52"), (Standards.NACE2, "24.52")),
        ((Standards.NACE1, "27.53"), (Standards.NACE2, "24.53")),
        ((Standards.NACE1, "27.54"), (Standards.NACE2, "24.54")),
        ((Standards.NACE1, "28"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "28.11"), (Standards.NACE2, "24.33")),
        ((Standards.NACE1, "28.11"), (Standards.NACE2, "25.11")),
        ((Standards.NACE1, "28.11"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "28.11"), (Standards.NACE2, "41.2")),
        ((Standards.NACE1, "28.12"), (Standards.NACE2, "25.12")),
        ((Standards.NACE1, "28.12"), (Standards.NACE2, "43.32")),
        ((Standards.NACE1, "28.21"), (Standards.NACE2, "25.29")),
        ((Standards.NACE1, "28.21"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "28.22"), (Standards.NACE2, "25.21")),
        ((Standards.NACE1, "28.22"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "28.3"), (Standards.NACE2, "25.3")),
        ((Standards.NACE1, "28.3"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "28.4"), (Standards.NACE2, "25.5")),
        ((Standards.NACE1, "28.51"), (Standards.NACE2, "25.61")),
        ((Standards.NACE1, "28.52"), (Standards.NACE2, "25.62")),
        ((Standards.NACE1, "28.52"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "28.61"), (Standards.NACE2, "25.71")),
        ((Standards.NACE1, "28.61"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "28.62"), (Standards.NACE2, "25.73")),
        ((Standards.NACE1, "28.62"), (Standards.NACE2, "28.41")),
        ((Standards.NACE1, "28.62"), (Standards.NACE2, "28.49")),
        ((Standards.NACE1, "28.62"), (Standards.NACE2, "28.92")),
        ((Standards.NACE1, "28.62"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "28.63"), (Standards.NACE2, "25.72")),
        ((Standards.NACE1, "28.63"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "28.71"), (Standards.NACE2, "25.91")),
        ((Standards.NACE1, "28.71"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "28.72"), (Standards.NACE2, "25.92")),
        ((Standards.NACE1, "28.73"), (Standards.NACE2, "25.93")),
        ((Standards.NACE1, "28.74"), (Standards.NACE2, "25.93")),
        ((Standards.NACE1, "28.74"), (Standards.NACE2, "25.94")),
        ((Standards.NACE1, "28.75"), (Standards.NACE2, "25.71")),
        ((Standards.NACE1, "28.75"), (Standards.NACE2, "25.72")),
        ((Standards.NACE1, "28.75"), (Standards.NACE2, "25.99")),
        ((Standards.NACE1, "28.75"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "28.75"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "29"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "29.11"), (Standards.NACE2, "28.11")),
        ((Standards.NACE1, "29.11"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.12"), (Standards.NACE2, "28.11")),
        ((Standards.NACE1, "29.12"), (Standards.NACE2, "28.12")),
        ((Standards.NACE1, "29.12"), (Standards.NACE2, "28.13")),
        ((Standards.NACE1, "29.12"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.13"), (Standards.NACE2, "28.12")),
        ((Standards.NACE1, "29.13"), (Standards.NACE2, "28.14")),
        ((Standards.NACE1, "29.13"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.14"), (Standards.NACE2, "28.15")),
        ((Standards.NACE1, "29.14"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.21"), (Standards.NACE2, "28.21")),
        ((Standards.NACE1, "29.21"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.22"), (Standards.NACE2, "28.22")),
        ((Standards.NACE1, "29.22"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.22"), (Standards.NACE2, "43.29")),
        ((Standards.NACE1, "29.23"), (Standards.NACE2, "28.25")),
        ((Standards.NACE1, "29.23"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.24"), (Standards.NACE2, "28.29")),
        ((Standards.NACE1, "29.24"), (Standards.NACE2, "32.5")),
        ((Standards.NACE1, "29.24"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.24"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "29.31"), (Standards.NACE2, "28.3")),
        ((Standards.NACE1, "29.31"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.32"), (Standards.NACE2, "28.3")),
        ((Standards.NACE1, "29.32"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.32"), (Standards.NACE2, "95.22")),
        ((Standards.NACE1, "29.41"), (Standards.NACE2, "28.24")),
        ((Standards.NACE1, "29.41"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.42"), (Standards.NACE2, "28.41")),
        ((Standards.NACE1, "29.42"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.43"), (Standards.NACE2, "27.9")),
        ((Standards.NACE1, "29.43"), (Standards.NACE2, "28.29")),
        ((Standards.NACE1, "29.43"), (Standards.NACE2, "28.49")),
        ((Standards.NACE1, "29.43"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.51"), (Standards.NACE2, "28.91")),
        ((Standards.NACE1, "29.51"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.52"), (Standards.NACE2, "28.92")),
        ((Standards.NACE1, "29.52"), (Standards.NACE2, "28.99")),
        ((Standards.NACE1, "29.52"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.53"), (Standards.NACE2, "28.3")),
        ((Standards.NACE1, "29.53"), (Standards.NACE2, "28.93")),
        ((Standards.NACE1, "29.53"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.54"), (Standards.NACE2, "28.94")),
        ((Standards.NACE1, "29.54"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.55"), (Standards.NACE2, "28.95")),
        ((Standards.NACE1, "29.55"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.56"), (Standards.NACE2, "25.73")),
        ((Standards.NACE1, "29.56"), (Standards.NACE2, "28.94")),
        ((Standards.NACE1, "29.56"), (Standards.NACE2, "28.96")),
        ((Standards.NACE1, "29.56"), (Standards.NACE2, "28.99")),
        ((Standards.NACE1, "29.56"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "29.6"), (Standards.NACE2, "25.4")),
        ((Standards.NACE1, "29.6"), (Standards.NACE2, "30.3")),
        ((Standards.NACE1, "29.6"), (Standards.NACE2, "30.4")),
        ((Standards.NACE1, "29.6"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "29.71"), (Standards.NACE2, "27.51")),
        ((Standards.NACE1, "29.71"), (Standards.NACE2, "28.21")),
        ((Standards.NACE1, "29.71"), (Standards.NACE2, "28.25")),
        ((Standards.NACE1, "29.71"), (Standards.NACE2, "33.14")),
        ((Standards.NACE1, "29.72"), (Standards.NACE2, "27.52")),
        ((Standards.NACE1, "29.72"), (Standards.NACE2, "28.21")),
        ((Standards.NACE1, "30"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "30.01"), (Standards.NACE2, "28.23")),
        ((Standards.NACE1, "30.02"), (Standards.NACE2, "26.2")),
        ((Standards.NACE1, "30.02"), (Standards.NACE2, "62.09")),
        ((Standards.NACE1, "31"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "31.1"), (Standards.NACE2, "26.11")),
        ((Standards.NACE1, "31.1"), (Standards.NACE2, "27.11")),
        ((Standards.NACE1, "31.1"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "31.1"), (Standards.NACE2, "33.14")),
        ((Standards.NACE1, "31.2"), (Standards.NACE2, "26.11")),
        ((Standards.NACE1, "31.2"), (Standards.NACE2, "27.12")),
        ((Standards.NACE1, "31.2"), (Standards.NACE2, "27.33")),
        ((Standards.NACE1, "31.2"), (Standards.NACE2, "27.9")),
        ((Standards.NACE1, "31.2"), (Standards.NACE2, "33.14")),
        ((Standards.NACE1, "31.3"), (Standards.NACE2, "26.11")),
        ((Standards.NACE1, "31.3"), (Standards.NACE2, "27.31")),
        ((Standards.NACE1, "31.3"), (Standards.NACE2, "27.32")),
        ((Standards.NACE1, "31.3"), (Standards.NACE2, "27.9")),
        ((Standards.NACE1, "31.4"), (Standards.NACE2, "27.2")),
        ((Standards.NACE1, "31.5"), (Standards.NACE2, "27.4")),
        ((Standards.NACE1, "31.61"), (Standards.NACE2, "27.4")),
        ((Standards.NACE1, "31.61"), (Standards.NACE2, "29.31")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "23.44")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "25.99")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "26.3")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "26.51")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "27.11")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "27.4")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "27.9")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "28.49")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "28.99")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "29.31")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "30.2")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "31.62"), (Standards.NACE2, "33.14")),
        ((Standards.NACE1, "32"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "32.1"), (Standards.NACE2, "26.11")),
        ((Standards.NACE1, "32.1"), (Standards.NACE2, "26.12")),
        ((Standards.NACE1, "32.1"), (Standards.NACE2, "27.9")),
        ((Standards.NACE1, "32.1"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "32.2"), (Standards.NACE2, "26.3")),
        ((Standards.NACE1, "32.2"), (Standards.NACE2, "95.12")),
        ((Standards.NACE1, "32.3"), (Standards.NACE2, "26.11")),
        ((Standards.NACE1, "32.3"), (Standards.NACE2, "26.2")),
        ((Standards.NACE1, "32.3"), (Standards.NACE2, "26.3")),
        ((Standards.NACE1, "32.3"), (Standards.NACE2, "26.4")),
        ((Standards.NACE1, "32.3"), (Standards.NACE2, "26.7")),
        ((Standards.NACE1, "32.3"), (Standards.NACE2, "28.23")),
        ((Standards.NACE1, "32.3"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "33"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "33.1"), (Standards.NACE2, "26.6")),
        ((Standards.NACE1, "33.1"), (Standards.NACE2, "32.5")),
        ((Standards.NACE1, "33.1"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "33.1"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "33.1"), (Standards.NACE2, "33.14")),
        ((Standards.NACE1, "33.2"), (Standards.NACE2, "26.51")),
        ((Standards.NACE1, "33.2"), (Standards.NACE2, "26.7")),
        ((Standards.NACE1, "33.2"), (Standards.NACE2, "28.29")),
        ((Standards.NACE1, "33.2"), (Standards.NACE2, "28.99")),
        ((Standards.NACE1, "33.2"), (Standards.NACE2, "32.5")),
        ((Standards.NACE1, "33.2"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "33.2"), (Standards.NACE2, "33.14")),
        ((Standards.NACE1, "33.3"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "33.4"), (Standards.NACE2, "26.7")),
        ((Standards.NACE1, "33.4"), (Standards.NACE2, "27.31")),
        ((Standards.NACE1, "33.4"), (Standards.NACE2, "28.99")),
        ((Standards.NACE1, "33.4"), (Standards.NACE2, "32.5")),
        ((Standards.NACE1, "33.4"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "33.5"), (Standards.NACE2, "26.52")),
        ((Standards.NACE1, "33.5"), (Standards.NACE2, "32.12")),
        ((Standards.NACE1, "33.5"), (Standards.NACE2, "32.13")),
        ((Standards.NACE1, "33.5"), (Standards.NACE2, "33.13")),
        ((Standards.NACE1, "34"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "34.1"), (Standards.NACE2, "28.92")),
        ((Standards.NACE1, "34.1"), (Standards.NACE2, "29.1")),
        ((Standards.NACE1, "34.1"), (Standards.NACE2, "30.91")),
        ((Standards.NACE1, "34.2"), (Standards.NACE2, "29.2")),
        ((Standards.NACE1, "34.2"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "34.3"), (Standards.NACE2, "28.11")),
        ((Standards.NACE1, "34.3"), (Standards.NACE2, "29.32")),
        ((Standards.NACE1, "35"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "35.11"), (Standards.NACE2, "30.11")),
        ((Standards.NACE1, "35.11"), (Standards.NACE2, "33.15")),
        ((Standards.NACE1, "35.12"), (Standards.NACE2, "30.12")),
        ((Standards.NACE1, "35.12"), (Standards.NACE2, "33.15")),
        ((Standards.NACE1, "35.2"), (Standards.NACE2, "30.2")),
        ((Standards.NACE1, "35.2"), (Standards.NACE2, "33.17")),
        ((Standards.NACE1, "35.3"), (Standards.NACE2, "28.99")),
        ((Standards.NACE1, "35.3"), (Standards.NACE2, "30.3")),
        ((Standards.NACE1, "35.3"), (Standards.NACE2, "33.16")),
        ((Standards.NACE1, "35.41"), (Standards.NACE2, "30.91")),
        ((Standards.NACE1, "35.42"), (Standards.NACE2, "30.92")),
        ((Standards.NACE1, "35.43"), (Standards.NACE2, "30.92")),
        ((Standards.NACE1, "35.43"), (Standards.NACE2, "33.17")),
        ((Standards.NACE1, "35.5"), (Standards.NACE2, "28.22")),
        ((Standards.NACE1, "35.5"), (Standards.NACE2, "30.99")),
        ((Standards.NACE1, "35.5"), (Standards.NACE2, "31.01")),
        ((Standards.NACE1, "35.5"), (Standards.NACE2, "33.11")),
        ((Standards.NACE1, "35.5"), (Standards.NACE2, "33.17")),
        ((Standards.NACE1, "36"), (Standards.NACE2, "33.2")),
        ((Standards.NACE1, "36.11"), (Standards.NACE2, "29.32")),
        ((Standards.NACE1, "36.11"), (Standards.NACE2, "30.11")),
        ((Standards.NACE1, "36.11"), (Standards.NACE2, "30.2")),
        ((Standards.NACE1, "36.11"), (Standards.NACE2, "30.3")),
        ((Standards.NACE1, "36.11"), (Standards.NACE2, "31.01")),
        ((Standards.NACE1, "36.11"), (Standards.NACE2, "31.02")),
        ((Standards.NACE1, "36.11"), (Standards.NACE2, "31.09")),
        ((Standards.NACE1, "36.11"), (Standards.NACE2, "95.24")),
        ((Standards.NACE1, "36.12"), (Standards.NACE2, "28.23")),
        ((Standards.NACE1, "36.12"), (Standards.NACE2, "31.01")),
        ((Standards.NACE1, "36.12"), (Standards.NACE2, "95.24")),
        ((Standards.NACE1, "36.13"), (Standards.NACE2, "31.02")),
        ((Standards.NACE1, "36.13"), (Standards.NACE2, "95.24")),
        ((Standards.NACE1, "36.14"), (Standards.NACE2, "31.09")),
        ((Standards.NACE1, "36.14"), (Standards.NACE2, "95.24")),
        ((Standards.NACE1, "36.15"), (Standards.NACE2, "31.03")),
        ((Standards.NACE1, "36.21"), (Standards.NACE2, "32.11")),
        ((Standards.NACE1, "36.22"), (Standards.NACE2, "32.12")),
        ((Standards.NACE1, "36.3"), (Standards.NACE2, "32.2")),
        ((Standards.NACE1, "36.3"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "36.3"), (Standards.NACE2, "95.29")),
        ((Standards.NACE1, "36.4"), (Standards.NACE2, "32.3")),
        ((Standards.NACE1, "36.4"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "36.5"), (Standards.NACE2, "26.4")),
        ((Standards.NACE1, "36.5"), (Standards.NACE2, "28.99")),
        ((Standards.NACE1, "36.5"), (Standards.NACE2, "32.4")),
        ((Standards.NACE1, "36.5"), (Standards.NACE2, "33.19")),
        ((Standards.NACE1, "36.61"), (Standards.NACE2, "32.13")),
        ((Standards.NACE1, "36.62"), (Standards.NACE2, "22.19")),
        ((Standards.NACE1, "36.62"), (Standards.NACE2, "32.91")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "13.99")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "15.12")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "16.29")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "17.29")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "20.51")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "22.19")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "22.23")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "22.29")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "25.99")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "28.99")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "30.92")),
        ((Standards.NACE1, "36.63"), (Standards.NACE2, "32.99")),
        ((Standards.NACE1, "37.1"), (Standards.NACE2, "38.31")),
        ((Standards.NACE1, "37.1"), (Standards.NACE2, "38.32")),
        ((Standards.NACE1, "37.2"), (Standards.NACE2, "38.32")),
        ((Standards.NACE1, "40.11"), (Standards.NACE2, "35.11")),
        ((Standards.NACE1, "40.11"), (Standards.NACE2, "38.12")),
        ((Standards.NACE1, "40.12"), (Standards.NACE2, "35.12")),
        ((Standards.NACE1, "40.13"), (Standards.NACE2, "35.13")),
        ((Standards.NACE1, "40.13"), (Standards.NACE2, "35.14")),
        ((Standards.NACE1, "40.21"), (Standards.NACE2, "35.21")),
        ((Standards.NACE1, "40.22"), (Standards.NACE2, "35.22")),
        ((Standards.NACE1, "40.22"), (Standards.NACE2, "35.23")),
        ((Standards.NACE1, "40.3"), (Standards.NACE2, "35.3")),
        ((Standards.NACE1, "41"), (Standards.NACE2, "36")),
        ((Standards.NACE1, "45.11"), (Standards.NACE2, "43.11")),
        ((Standards.NACE1, "45.11"), (Standards.NACE2, "43.12")),
        ((Standards.NACE1, "45.12"), (Standards.NACE2, "43.13")),
        ((Standards.NACE1, "45.21"), (Standards.NACE2, "41.2")),
        ((Standards.NACE1, "45.21"), (Standards.NACE2, "42.12")),
        ((Standards.NACE1, "45.21"), (Standards.NACE2, "42.13")),
        ((Standards.NACE1, "45.21"), (Standards.NACE2, "42.21")),
        ((Standards.NACE1, "45.21"), (Standards.NACE2, "42.22")),
        ((Standards.NACE1, "45.21"), (Standards.NACE2, "42.99")),
        ((Standards.NACE1, "45.21"), (Standards.NACE2, "43.99")),
        ((Standards.NACE1, "45.22"), (Standards.NACE2, "43.91")),
        ((Standards.NACE1, "45.22"), (Standards.NACE2, "43.99")),
        ((Standards.NACE1, "45.23"), (Standards.NACE2, "41.2")),
        ((Standards.NACE1, "45.23"), (Standards.NACE2, "42.11")),
        ((Standards.NACE1, "45.23"), (Standards.NACE2, "42.12")),
        ((Standards.NACE1, "45.23"), (Standards.NACE2, "42.99")),
        ((Standards.NACE1, "45.24"), (Standards.NACE2, "42.21")),
        ((Standards.NACE1, "45.24"), (Standards.NACE2, "42.91")),
        ((Standards.NACE1, "45.24"), (Standards.NACE2, "43.99")),
        ((Standards.NACE1, "45.25"), (Standards.NACE2, "42.21")),
        ((Standards.NACE1, "45.25"), (Standards.NACE2, "43.99")),
        ((Standards.NACE1, "45.31"), (Standards.NACE2, "43.21")),
        ((Standards.NACE1, "45.31"), (Standards.NACE2, "43.22")),
        ((Standards.NACE1, "45.31"), (Standards.NACE2, "43.29")),
        ((Standards.NACE1, "45.31"), (Standards.NACE2, "80.2")),
        ((Standards.NACE1, "45.32"), (Standards.NACE2, "43.29")),
        ((Standards.NACE1, "45.33"), (Standards.NACE2, "43.22")),
        ((Standards.NACE1, "45.34"), (Standards.NACE2, "43.21")),
        ((Standards.NACE1, "45.34"), (Standards.NACE2, "43.29")),
        ((Standards.NACE1, "45.41"), (Standards.NACE2, "43.31")),
        ((Standards.NACE1, "45.42"), (Standards.NACE2, "43.32")),
        ((Standards.NACE1, "45.43"), (Standards.NACE2, "43.33")),
        ((Standards.NACE1, "45.44"), (Standards.NACE2, "43.34")),
        ((Standards.NACE1, "45.45"), (Standards.NACE2, "43.39")),
        ((Standards.NACE1, "45.45"), (Standards.NACE2, "43.99")),
        ((Standards.NACE1, "45.5"), (Standards.NACE2, "43.99")),
        ((Standards.NACE1, "50.1"), (Standards.NACE2, "45.11")),
        ((Standards.NACE1, "50.1"), (Standards.NACE2, "45.19")),
        ((Standards.NACE1, "50.2"), (Standards.NACE2, "45.2")),
        ((Standards.NACE1, "50.2"), (Standards.NACE2, "52.21")),
        ((Standards.NACE1, "50.3"), (Standards.NACE2, "45.31")),
        ((Standards.NACE1, "50.3"), (Standards.NACE2, "45.32")),
        ((Standards.NACE1, "50.4"), (Standards.NACE2, "45.4")),
        ((Standards.NACE1, "50.5"), (Standards.NACE2, "47.3")),
        ((Standards.NACE1, "51.11"), (Standards.NACE2, "46.11")),
        ((Standards.NACE1, "51.12"), (Standards.NACE2, "46.12")),
        ((Standards.NACE1, "51.13"), (Standards.NACE2, "46.13")),
        ((Standards.NACE1, "51.14"), (Standards.NACE2, "46.14")),
        ((Standards.NACE1, "51.15"), (Standards.NACE2, "46.15")),
        ((Standards.NACE1, "51.16"), (Standards.NACE2, "46.16")),
        ((Standards.NACE1, "51.17"), (Standards.NACE2, "46.17")),
        ((Standards.NACE1, "51.18"), (Standards.NACE2, "46.18")),
        ((Standards.NACE1, "51.19"), (Standards.NACE2, "46.19")),
        ((Standards.NACE1, "51.21"), (Standards.NACE2, "46.21")),
        ((Standards.NACE1, "51.22"), (Standards.NACE2, "46.22")),
        ((Standards.NACE1, "51.23"), (Standards.NACE2, "46.23")),
        ((Standards.NACE1, "51.24"), (Standards.NACE2, "46.24")),
        ((Standards.NACE1, "51.25"), (Standards.NACE2, "46.21")),
        ((Standards.NACE1, "51.31"), (Standards.NACE2, "10.39")),
        ((Standards.NACE1, "51.31"), (Standards.NACE2, "46.31")),
        ((Standards.NACE1, "51.32"), (Standards.NACE2, "46.32")),
        ((Standards.NACE1, "51.33"), (Standards.NACE2, "46.33")),
        ((Standards.NACE1, "51.34"), (Standards.NACE2, "11.01")),
        ((Standards.NACE1, "51.34"), (Standards.NACE2, "11.02")),
        ((Standards.NACE1, "51.34"), (Standards.NACE2, "46.34")),
        ((Standards.NACE1, "51.35"), (Standards.NACE2, "46.35")),
        ((Standards.NACE1, "51.36"), (Standards.NACE2, "46.36")),
        ((Standards.NACE1, "51.37"), (Standards.NACE2, "46.37")),
        ((Standards.NACE1, "51.38"), (Standards.NACE2, "46.31")),
        ((Standards.NACE1, "51.38"), (Standards.NACE2, "46.38")),
        ((Standards.NACE1, "51.39"), (Standards.NACE2, "46.39")),
        ((Standards.NACE1, "51.41"), (Standards.NACE2, "46.41")),
        ((Standards.NACE1, "51.42"), (Standards.NACE2, "46.42")),
        ((Standards.NACE1, "51.43"), (Standards.NACE2, "46.43")),
        ((Standards.NACE1, "51.43"), (Standards.NACE2, "46.47")),
        ((Standards.NACE1, "51.43"), (Standards.NACE2, "46.52")),
        ((Standards.NACE1, "51.44"), (Standards.NACE2, "46.44")),
        ((Standards.NACE1, "51.44"), (Standards.NACE2, "46.49")),
        ((Standards.NACE1, "51.44"), (Standards.NACE2, "46.73")),
        ((Standards.NACE1, "51.45"), (Standards.NACE2, "46.45")),
        ((Standards.NACE1, "51.46"), (Standards.NACE2, "46.46")),
        ((Standards.NACE1, "51.47"), (Standards.NACE2, "46.43")),
        ((Standards.NACE1, "51.47"), (Standards.NACE2, "46.47")),
        ((Standards.NACE1, "51.47"), (Standards.NACE2, "46.48")),
        ((Standards.NACE1, "51.47"), (Standards.NACE2, "46.49")),
        ((Standards.NACE1, "51.47"), (Standards.NACE2, "46.73")),
        ((Standards.NACE1, "51.51"), (Standards.NACE2, "46.71")),
        ((Standards.NACE1, "51.52"), (Standards.NACE2, "46.72")),
        ((Standards.NACE1, "51.53"), (Standards.NACE2, "46.73")),
        ((Standards.NACE1, "51.54"), (Standards.NACE2, "46.74")),
        ((Standards.NACE1, "51.55"), (Standards.NACE2, "46.75")),
        ((Standards.NACE1, "51.55"), (Standards.NACE2, "46.76")),
        ((Standards.NACE1, "51.56"), (Standards.NACE2, "46.76")),
        ((Standards.NACE1, "51.57"), (Standards.NACE2, "46.77")),
        ((Standards.NACE1, "51.81"), (Standards.NACE2, "46.62")),
        ((Standards.NACE1, "51.82"), (Standards.NACE2, "46.63")),
        ((Standards.NACE1, "51.83"), (Standards.NACE2, "46.64")),
        ((Standards.NACE1, "51.84"), (Standards.NACE2, "46.51")),
        ((Standards.NACE1, "51.85"), (Standards.NACE2, "46.65")),
        ((Standards.NACE1, "51.85"), (Standards.NACE2, "46.66")),
        ((Standards.NACE1, "51.86"), (Standards.NACE2, "46.52")),
        ((Standards.NACE1, "51.87"), (Standards.NACE2, "46.69")),
        ((Standards.NACE1, "51.88"), (Standards.NACE2, "46.61")),
        ((Standards.NACE1, "51.9"), (Standards.NACE2, "46.9")),
        ((Standards.NACE1, "52.11"), (Standards.NACE2, "47.11")),
        ((Standards.NACE1, "52.12"), (Standards.NACE2, "47.19")),
        ((Standards.NACE1, "52.21"), (Standards.NACE2, "47.21")),
        ((Standards.NACE1, "52.22"), (Standards.NACE2, "47.22")),
        ((Standards.NACE1, "52.23"), (Standards.NACE2, "47.23")),
        ((Standards.NACE1, "52.24"), (Standards.NACE2, "47.24")),
        ((Standards.NACE1, "52.25"), (Standards.NACE2, "47.25")),
        ((Standards.NACE1, "52.26"), (Standards.NACE2, "47.26")),
        ((Standards.NACE1, "52.27"), (Standards.NACE2, "47.21")),
        ((Standards.NACE1, "52.27"), (Standards.NACE2, "47.29")),
        ((Standards.NACE1, "52.31"), (Standards.NACE2, "47.73")),
        ((Standards.NACE1, "52.32"), (Standards.NACE2, "47.74")),
        ((Standards.NACE1, "52.33"), (Standards.NACE2, "47.75")),
        ((Standards.NACE1, "52.41"), (Standards.NACE2, "47.51")),
        ((Standards.NACE1, "52.42"), (Standards.NACE2, "47.71")),
        ((Standards.NACE1, "52.43"), (Standards.NACE2, "47.72")),
        ((Standards.NACE1, "52.44"), (Standards.NACE2, "47.53")),
        ((Standards.NACE1, "52.44"), (Standards.NACE2, "47.59")),
        ((Standards.NACE1, "52.45"), (Standards.NACE2, "47.43")),
        ((Standards.NACE1, "52.45"), (Standards.NACE2, "47.54")),
        ((Standards.NACE1, "52.45"), (Standards.NACE2, "47.59")),
        ((Standards.NACE1, "52.45"), (Standards.NACE2, "47.63")),
        ((Standards.NACE1, "52.46"), (Standards.NACE2, "47.52")),
        ((Standards.NACE1, "52.47"), (Standards.NACE2, "47.61")),
        ((Standards.NACE1, "52.47"), (Standards.NACE2, "47.62")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.41")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.42")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.53")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.59")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.64")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.65")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.76")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.77")),
        ((Standards.NACE1, "52.48"), (Standards.NACE2, "47.78")),
        ((Standards.NACE1, "52.5"), (Standards.NACE2, "47.79")),
        ((Standards.NACE1, "52.61"), (Standards.NACE2, "47.91")),
        ((Standards.NACE1, "52.62"), (Standards.NACE2, "47.81")),
        ((Standards.NACE1, "52.62"), (Standards.NACE2, "47.82")),
        ((Standards.NACE1, "52.62"), (Standards.NACE2, "47.89")),
        ((Standards.NACE1, "52.63"), (Standards.NACE2, "47.79")),
        ((Standards.NACE1, "52.63"), (Standards.NACE2, "47.91")),
        ((Standards.NACE1, "52.63"), (Standards.NACE2, "47.99")),
        ((Standards.NACE1, "52.71"), (Standards.NACE2, "95.23")),
        ((Standards.NACE1, "52.72"), (Standards.NACE2, "95.21")),
        ((Standards.NACE1, "52.72"), (Standards.NACE2, "95.22")),
        ((Standards.NACE1, "52.73"), (Standards.NACE2, "95.25")),
        ((Standards.NACE1, "52.74"), (Standards.NACE2, "13.3")),
        ((Standards.NACE1, "52.74"), (Standards.NACE2, "95.12")),
        ((Standards.NACE1, "52.74"), (Standards.NACE2, "95.23")),
        ((Standards.NACE1, "52.74"), (Standards.NACE2, "95.29")),
        ((Standards.NACE1, "55.1"), (Standards.NACE2, "55.1")),
        ((Standards.NACE1, "55.21"), (Standards.NACE2, "55.2")),
        ((Standards.NACE1, "55.21"), (Standards.NACE2, "55.3")),
        ((Standards.NACE1, "55.22"), (Standards.NACE2, "55.3")),
        ((Standards.NACE1, "55.23"), (Standards.NACE2, "55.2")),
        ((Standards.NACE1, "55.23"), (Standards.NACE2, "55.9")),
        ((Standards.NACE1, "55.3"), (Standards.NACE2, "56.1")),
        ((Standards.NACE1, "55.4"), (Standards.NACE2, "56.3")),
        ((Standards.NACE1, "55.51"), (Standards.NACE2, "56.29")),
        ((Standards.NACE1, "55.52"), (Standards.NACE2, "56.21")),
        ((Standards.NACE1, "55.52"), (Standards.NACE2, "56.29")),
        ((Standards.NACE1, "60.1"), (Standards.NACE2, "49.1")),
        ((Standards.NACE1, "60.1"), (Standards.NACE2, "49.2")),
        ((Standards.NACE1, "60.1"), (Standards.NACE2, "52.21")),
        ((Standards.NACE1, "60.21"), (Standards.NACE2, "49.31")),
        ((Standards.NACE1, "60.21"), (Standards.NACE2, "49.39")),
        ((Standards.NACE1, "60.22"), (Standards.NACE2, "49.32")),
        ((Standards.NACE1, "60.23"), (Standards.NACE2, "49.39")),
        ((Standards.NACE1, "60.24"), (Standards.NACE2, "49.41")),
        ((Standards.NACE1, "60.24"), (Standards.NACE2, "49.42")),
        ((Standards.NACE1, "60.3"), (Standards.NACE2, "49.5")),
        ((Standards.NACE1, "61.1"), (Standards.NACE2, "50.1")),
        ((Standards.NACE1, "61.1"), (Standards.NACE2, "50.2")),
        ((Standards.NACE1, "61.1"), (Standards.NACE2, "52.22")),
        ((Standards.NACE1, "61.2"), (Standards.NACE2, "50.3")),
        ((Standards.NACE1, "61.2"), (Standards.NACE2, "50.4")),
        ((Standards.NACE1, "61.2"), (Standards.NACE2, "52.22")),
        ((Standards.NACE1, "62.1"), (Standards.NACE2, "51.1")),
        ((Standards.NACE1, "62.1"), (Standards.NACE2, "51.21")),
        ((Standards.NACE1, "62.2"), (Standards.NACE2, "51.1")),
        ((Standards.NACE1, "62.2"), (Standards.NACE2, "51.21")),
        ((Standards.NACE1, "62.3"), (Standards.NACE2, "51.22")),
        ((Standards.NACE1, "62.3"), (Standards.NACE2, "52.23")),
        ((Standards.NACE1, "63.11"), (Standards.NACE2, "52.24")),
        ((Standards.NACE1, "63.12"), (Standards.NACE2, "52.1")),
        ((Standards.NACE1, "63.21"), (Standards.NACE2, "52.21")),
        ((Standards.NACE1, "63.22"), (Standards.NACE2, "52.22")),
        ((Standards.NACE1, "63.22"), (Standards.NACE2, "85.32")),
        ((Standards.NACE1, "63.23"), (Standards.NACE2, "52.23")),
        ((Standards.NACE1, "63.23"), (Standards.NACE2, "85.32")),
        ((Standards.NACE1, "63.3"), (Standards.NACE2, "79.11")),
        ((Standards.NACE1, "63.3"), (Standards.NACE2, "79.12")),
        ((Standards.NACE1, "63.3"), (Standards.NACE2, "79.9")),
        ((Standards.NACE1, "63.4"), (Standards.NACE2, "52.29")),
        ((Standards.NACE1, "63.4"), (Standards.NACE2, "74.9")),
        ((Standards.NACE1, "64.11"), (Standards.NACE2, "53.1")),
        ((Standards.NACE1, "64.11"), (Standards.NACE2, "82.19")),
        ((Standards.NACE1, "64.12"), (Standards.NACE2, "53.2")),
        ((Standards.NACE1, "64.2"), (Standards.NACE2, "60.1")),
        ((Standards.NACE1, "64.2"), (Standards.NACE2, "60.2")),
        ((Standards.NACE1, "64.2"), (Standards.NACE2, "61.1")),
        ((Standards.NACE1, "64.2"), (Standards.NACE2, "61.2")),
        ((Standards.NACE1, "64.2"), (Standards.NACE2, "61.3")),
        ((Standards.NACE1, "64.2"), (Standards.NACE2, "61.9")),
        ((Standards.NACE1, "65.11"), (Standards.NACE2, "64.11")),
        ((Standards.NACE1, "65.12"), (Standards.NACE2, "64.19")),
        ((Standards.NACE1, "65.21"), (Standards.NACE2, "64.91")),
        ((Standards.NACE1, "65.22"), (Standards.NACE2, "64.92")),
        ((Standards.NACE1, "65.22"), (Standards.NACE2, "64.99")),
        ((Standards.NACE1, "65.23"), (Standards.NACE2, "64.2")),
        ((Standards.NACE1, "65.23"), (Standards.NACE2, "64.3")),
        ((Standards.NACE1, "65.23"), (Standards.NACE2, "64.99")),
        ((Standards.NACE1, "66.01"), (Standards.NACE2, "65.11")),
        ((Standards.NACE1, "66.01"), (Standards.NACE2, "65.2")),
        ((Standards.NACE1, "66.02"), (Standards.NACE2, "65.2")),
        ((Standards.NACE1, "66.02"), (Standards.NACE2, "65.3")),
        ((Standards.NACE1, "66.03"), (Standards.NACE2, "65.12")),
        ((Standards.NACE1, "66.03"), (Standards.NACE2, "65.2")),
        ((Standards.NACE1, "67.11"), (Standards.NACE2, "66.11")),
        ((Standards.NACE1, "67.12"), (Standards.NACE2, "66.12")),
        ((Standards.NACE1, "67.12"), (Standards.NACE2, "66.3")),
        ((Standards.NACE1, "67.13"), (Standards.NACE2, "66.12")),
        ((Standards.NACE1, "67.13"), (Standards.NACE2, "66.19")),
        ((Standards.NACE1, "67.2"), (Standards.NACE2, "66.21")),
        ((Standards.NACE1, "67.2"), (Standards.NACE2, "66.22")),
        ((Standards.NACE1, "67.2"), (Standards.NACE2, "66.29")),
        ((Standards.NACE1, "70.11"), (Standards.NACE2, "41.1")),
        ((Standards.NACE1, "70.11"), (Standards.NACE2, "42")),
        ((Standards.NACE1, "70.12"), (Standards.NACE2, "68.1")),
        ((Standards.NACE1, "70.2"), (Standards.NACE2, "68.2")),
        ((Standards.NACE1, "70.31"), (Standards.NACE2, "68.31")),
        ((Standards.NACE1, "70.32"), (Standards.NACE2, "68.32")),
        ((Standards.NACE1, "70.32"), (Standards.NACE2, "81.1")),
        ((Standards.NACE1, "71.1"), (Standards.NACE2, "77.11")),
        ((Standards.NACE1, "71.21"), (Standards.NACE2, "77.12")),
        ((Standards.NACE1, "71.21"), (Standards.NACE2, "77.39")),
        ((Standards.NACE1, "71.22"), (Standards.NACE2, "77.34")),
        ((Standards.NACE1, "71.23"), (Standards.NACE2, "77.35")),
        ((Standards.NACE1, "71.31"), (Standards.NACE2, "77.31")),
        ((Standards.NACE1, "71.32"), (Standards.NACE2, "77.32")),
        ((Standards.NACE1, "71.32"), (Standards.NACE2, "77.39")),
        ((Standards.NACE1, "71.33"), (Standards.NACE2, "77.33")),
        ((Standards.NACE1, "71.34"), (Standards.NACE2, "77.39")),
        ((Standards.NACE1, "71.4"), (Standards.NACE2, "77.21")),
        ((Standards.NACE1, "71.4"), (Standards.NACE2, "77.22")),
        ((Standards.NACE1, "71.4"), (Standards.NACE2, "77.29")),
        ((Standards.NACE1, "72.1"), (Standards.NACE2, "62.02")),
        ((Standards.NACE1, "72.21"), (Standards.NACE2, "58.21")),
        ((Standards.NACE1, "72.21"), (Standards.NACE2, "58.29")),
        ((Standards.NACE1, "72.21"), (Standards.NACE2, "62.01")),
        ((Standards.NACE1, "72.22"), (Standards.NACE2, "62.01")),
        ((Standards.NACE1, "72.22"), (Standards.NACE2, "62.02")),
        ((Standards.NACE1, "72.22"), (Standards.NACE2, "62.09")),
        ((Standards.NACE1, "72.3"), (Standards.NACE2, "62.03")),
        ((Standards.NACE1, "72.3"), (Standards.NACE2, "63.11")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "58.11")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "58.12")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "58.13")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "58.14")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "58.19")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "58.21")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "58.29")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "59.2")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "60.1")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "60.2")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "62.01")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "63.11")),
        ((Standards.NACE1, "72.4"), (Standards.NACE2, "63.12")),
        ((Standards.NACE1, "72.5"), (Standards.NACE2, "33.12")),
        ((Standards.NACE1, "72.5"), (Standards.NACE2, "95.11")),
        ((Standards.NACE1, "72.6"), (Standards.NACE2, "62.09")),
        ((Standards.NACE1, "73.1"), (Standards.NACE2, "72.11")),
        ((Standards.NACE1, "73.1"), (Standards.NACE2, "72.19")),
        ((Standards.NACE1, "73.1"), (Standards.NACE2, "72.2")),
        ((Standards.NACE1, "73.2"), (Standards.NACE2, "72.2")),
        ((Standards.NACE1, "74.11"), (Standards.NACE2, "69.1")),
        ((Standards.NACE1, "74.12"), (Standards.NACE2, "69.2")),
        ((Standards.NACE1, "74.13"), (Standards.NACE2, "73.2")),
        ((Standards.NACE1, "74.14"), (Standards.NACE2, "02.4")),
        ((Standards.NACE1, "74.14"), (Standards.NACE2, "70.21")),
        ((Standards.NACE1, "74.14"), (Standards.NACE2, "70.22")),
        ((Standards.NACE1, "74.14"), (Standards.NACE2, "74.9")),
        ((Standards.NACE1, "74.14"), (Standards.NACE2, "85.6")),
        ((Standards.NACE1, "74.15"), (Standards.NACE2, "64.2")),
        ((Standards.NACE1, "74.15"), (Standards.NACE2, "70.1")),
        ((Standards.NACE1, "74.2"), (Standards.NACE2, "71.11")),
        ((Standards.NACE1, "74.2"), (Standards.NACE2, "71.12")),
        ((Standards.NACE1, "74.2"), (Standards.NACE2, "74.2")),
        ((Standards.NACE1, "74.2"), (Standards.NACE2, "74.9")),
        ((Standards.NACE1, "74.3"), (Standards.NACE2, "71.2")),
        ((Standards.NACE1, "74.4"), (Standards.NACE2, "73.11")),
        ((Standards.NACE1, "74.4"), (Standards.NACE2, "73.12")),
        ((Standards.NACE1, "74.5"), (Standards.NACE2, "78.1")),
        ((Standards.NACE1, "74.5"), (Standards.NACE2, "78.2")),
        ((Standards.NACE1, "74.5"), (Standards.NACE2, "78.3")),
        ((Standards.NACE1, "74.6"), (Standards.NACE2, "74.9")),
        ((Standards.NACE1, "74.6"), (Standards.NACE2, "80.1")),
        ((Standards.NACE1, "74.6"), (Standards.NACE2, "80.2")),
        ((Standards.NACE1, "74.6"), (Standards.NACE2, "80.3")),
        ((Standards.NACE1, "74.7"), (Standards.NACE2, "81.21")),
        ((Standards.NACE1, "74.7"), (Standards.NACE2, "81.22")),
        ((Standards.NACE1, "74.7"), (Standards.NACE2, "81.29")),
        ((Standards.NACE1, "74.81"), (Standards.NACE2, "74.2")),
        ((Standards.NACE1, "74.82"), (Standards.NACE2, "82.92")),
        ((Standards.NACE1, "74.85"), (Standards.NACE2, "74.3")),
        ((Standards.NACE1, "74.85"), (Standards.NACE2, "82.11")),
        ((Standards.NACE1, "74.85"), (Standards.NACE2, "82.19")),
        ((Standards.NACE1, "74.85"), (Standards.NACE2, "82.99")),
        ((Standards.NACE1, "74.86"), (Standards.NACE2, "82.2")),
        ((Standards.NACE1, "74.87"), (Standards.NACE2, "59.2")),
        ((Standards.NACE1, "74.87"), (Standards.NACE2, "63.99")),
        ((Standards.NACE1, "74.87"), (Standards.NACE2, "74.1")),
        ((Standards.NACE1, "74.87"), (Standards.NACE2, "74.9")),
        ((Standards.NACE1, "74.87"), (Standards.NACE2, "77.4")),
        ((Standards.NACE1, "74.87"), (Standards.NACE2, "82.3")),
        ((Standards.NACE1, "74.87"), (Standards.NACE2, "82.91")),
        ((Standards.NACE1, "74.87"), (Standards.NACE2, "82.99")),
        ((Standards.NACE1, "75.11"), (Standards.NACE2, "84.11")),
        ((Standards.NACE1, "75.12"), (Standards.NACE2, "84.12")),
        ((Standards.NACE1, "75.13"), (Standards.NACE2, "82.99")),
        ((Standards.NACE1, "75.13"), (Standards.NACE2, "84.13")),
        ((Standards.NACE1, "75.14"), (Standards.NACE2, "81.1")),
        ((Standards.NACE1, "75.14"), (Standards.NACE2, "84.11")),
        ((Standards.NACE1, "75.14"), (Standards.NACE2, "91.01")),
        ((Standards.NACE1, "75.21"), (Standards.NACE2, "84.21")),
        ((Standards.NACE1, "75.21"), (Standards.NACE2, "88.99")),
        ((Standards.NACE1, "75.22"), (Standards.NACE2, "84.22")),
        ((Standards.NACE1, "75.23"), (Standards.NACE2, "84.23")),
        ((Standards.NACE1, "75.24"), (Standards.NACE2, "84.24")),
        ((Standards.NACE1, "75.25"), (Standards.NACE2, "84.25")),
        ((Standards.NACE1, "75.3"), (Standards.NACE2, "84.3")),
        ((Standards.NACE1, "80.1"), (Standards.NACE2, "85.1")),
        ((Standards.NACE1, "80.1"), (Standards.NACE2, "85.2")),
        ((Standards.NACE1, "80.21"), (Standards.NACE2, "85.31")),
        ((Standards.NACE1, "80.22"), (Standards.NACE2, "85.32")),
        ((Standards.NACE1, "80.3"), (Standards.NACE2, "85.41")),
        ((Standards.NACE1, "80.3"), (Standards.NACE2, "85.42")),
        ((Standards.NACE1, "80.41"), (Standards.NACE2, "85.53")),
        ((Standards.NACE1, "80.42"), (Standards.NACE2, "85.32")),
        ((Standards.NACE1, "80.42"), (Standards.NACE2, "85.51")),
        ((Standards.NACE1, "80.42"), (Standards.NACE2, "85.52")),
        ((Standards.NACE1, "80.42"), (Standards.NACE2, "85.59")),
        ((Standards.NACE1, "85.11"), (Standards.NACE2, "86.1")),
        ((Standards.NACE1, "85.11"), (Standards.NACE2, "87.2")),
        ((Standards.NACE1, "85.12"), (Standards.NACE2, "86.21")),
        ((Standards.NACE1, "85.12"), (Standards.NACE2, "86.22")),
        ((Standards.NACE1, "85.13"), (Standards.NACE2, "86.23")),
        ((Standards.NACE1, "85.14"), (Standards.NACE2, "86.9")),
        ((Standards.NACE1, "85.14"), (Standards.NACE2, "87.1")),
        ((Standards.NACE1, "85.14"), (Standards.NACE2, "87.2")),
        ((Standards.NACE1, "85.14"), (Standards.NACE2, "87.3")),
        ((Standards.NACE1, "85.2"), (Standards.NACE2, "75")),
        ((Standards.NACE1, "85.31"), (Standards.NACE2, "87.2")),
        ((Standards.NACE1, "85.31"), (Standards.NACE2, "87.3")),
        ((Standards.NACE1, "85.31"), (Standards.NACE2, "87.9")),
        ((Standards.NACE1, "85.32"), (Standards.NACE2, "88.1")),
        ((Standards.NACE1, "85.32"), (Standards.NACE2, "88.91")),
        ((Standards.NACE1, "85.32"), (Standards.NACE2, "88.99")),
        ((Standards.NACE1, "90.01"), (Standards.NACE2, "37")),
        ((Standards.NACE1, "90.02"), (Standards.NACE2, "38.11")),
        ((Standards.NACE1, "90.02"), (Standards.NACE2, "38.12")),
        ((Standards.NACE1, "90.02"), (Standards.NACE2, "38.21")),
        ((Standards.NACE1, "90.02"), (Standards.NACE2, "38.22")),
        ((Standards.NACE1, "90.03"), (Standards.NACE2, "38.11")),
        ((Standards.NACE1, "90.03"), (Standards.NACE2, "39")),
        ((Standards.NACE1, "90.03"), (Standards.NACE2, "81.29")),
        ((Standards.NACE1, "91.11"), (Standards.NACE2, "94.11")),
        ((Standards.NACE1, "91.12"), (Standards.NACE2, "94.12")),
        ((Standards.NACE1, "91.2"), (Standards.NACE2, "94.2")),
        ((Standards.NACE1, "91.31"), (Standards.NACE2, "94.91")),
        ((Standards.NACE1, "91.32"), (Standards.NACE2, "94.92")),
        ((Standards.NACE1, "91.33"), (Standards.NACE2, "94.99")),
        ((Standards.NACE1, "92.11"), (Standards.NACE2, "59.11")),
        ((Standards.NACE1, "92.11"), (Standards.NACE2, "59.12")),
        ((Standards.NACE1, "92.11"), (Standards.NACE2, "59.2")),
        ((Standards.NACE1, "92.12"), (Standards.NACE2, "59.13")),
        ((Standards.NACE1, "92.13"), (Standards.NACE2, "59.14")),
        ((Standards.NACE1, "92.2"), (Standards.NACE2, "59.11")),
        ((Standards.NACE1, "92.2"), (Standards.NACE2, "59.2")),
        ((Standards.NACE1, "92.2"), (Standards.NACE2, "60.1")),
        ((Standards.NACE1, "92.2"), (Standards.NACE2, "60.2")),
        ((Standards.NACE1, "92.31"), (Standards.NACE2, "90.01")),
        ((Standards.NACE1, "92.31"), (Standards.NACE2, "90.02")),
        ((Standards.NACE1, "92.31"), (Standards.NACE2, "90.03")),
        ((Standards.NACE1, "92.32"), (Standards.NACE2, "79.9")),
        ((Standards.NACE1, "92.32"), (Standards.NACE2, "90.02")),
        ((Standards.NACE1, "92.32"), (Standards.NACE2, "90.04")),
        ((Standards.NACE1, "92.33"), (Standards.NACE2, "93.21")),
        ((Standards.NACE1, "92.34"), (Standards.NACE2, "79.9")),
        ((Standards.NACE1, "92.34"), (Standards.NACE2, "85.52")),
        ((Standards.NACE1, "92.34"), (Standards.NACE2, "90.01")),
        ((Standards.NACE1, "92.34"), (Standards.NACE2, "90.02")),
        ((Standards.NACE1, "92.34"), (Standards.NACE2, "93.29")),
        ((Standards.NACE1, "92.4"), (Standards.NACE2, "63.91")),
        ((Standards.NACE1, "92.4"), (Standards.NACE2, "74.2")),
        ((Standards.NACE1, "92.4"), (Standards.NACE2, "90.03")),
        ((Standards.NACE1, "92.51"), (Standards.NACE2, "91.01")),
        ((Standards.NACE1, "92.52"), (Standards.NACE2, "91.02")),
        ((Standards.NACE1, "92.52"), (Standards.NACE2, "91.03")),
        ((Standards.NACE1, "92.53"), (Standards.NACE2, "91.04")),
        ((Standards.NACE1, "92.61"), (Standards.NACE2, "93.11")),
        ((Standards.NACE1, "92.62"), (Standards.NACE2, "79.9")),
        ((Standards.NACE1, "92.62"), (Standards.NACE2, "85.51")),
        ((Standards.NACE1, "92.62"), (Standards.NACE2, "93.11")),
        ((Standards.NACE1, "92.62"), (Standards.NACE2, "93.12")),
        ((Standards.NACE1, "92.62"), (Standards.NACE2, "93.19")),
        ((Standards.NACE1, "92.62"), (Standards.NACE2, "93.29")),
        ((Standards.NACE1, "92.71"), (Standards.NACE2, "92")),
        ((Standards.NACE1, "92.72"), (Standards.NACE2, "01.62")),
        ((Standards.NACE1, "92.72"), (Standards.NACE2, "78.1")),
        ((Standards.NACE1, "92.72"), (Standards.NACE2, "79.9")),
        ((Standards.NACE1, "92.72"), (Standards.NACE2, "93.29")),
        ((Standards.NACE1, "93.01"), (Standards.NACE2, "96.01")),
        ((Standards.NACE1, "93.02"), (Standards.NACE2, "96.02")),
        ((Standards.NACE1, "93.03"), (Standards.NACE2, "96.03")),
        ((Standards.NACE1, "93.04"), (Standards.NACE2, "93.13")),
        ((Standards.NACE1, "93.04"), (Standards.NACE2, "96.04")),
        ((Standards.NACE1, "93.05"), (Standards.NACE2, "85.51")),
        ((Standards.NACE1, "93.05"), (Standards.NACE2, "96.09")),
        ((Standards.NACE1, "95"), (Standards.NACE2, "97")),
        ((Standards.NACE1, "96"), (Standards.NACE2, "98.1")),
        ((Standards.NACE1, "97"), (Standards.NACE2, "98.2")),
        ((Standards.NACE1, "99"), (Standards.NACE2, "99")),
    ],
)
