"""`Concordance between CAEM2009 (CAEM Rev. 2) and ISIC4 <https://date.gov.md/ckan/ro/dataset/5188-clasificatorul-activitatilor-din-economia-moldovei-caem>`_."""

from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import CAEM2009

CAEM2009_to_ISIC4 = Concordance(
    src=CAEM2009,
    dst=ISIC4,
    concordances=[
        ((Standards.CAEM2009, "01.11"), (Standards.ISIC4, "0111")),
        ((Standards.CAEM2009, "01.12"), (Standards.ISIC4, "0112")),
        ((Standards.CAEM2009, "01.13"), (Standards.ISIC4, "0113")),
        ((Standards.CAEM2009, "01.14"), (Standards.ISIC4, "0114")),
        ((Standards.CAEM2009, "01.15"), (Standards.ISIC4, "0115")),
        ((Standards.CAEM2009, "01.16"), (Standards.ISIC4, "0116")),
        ((Standards.CAEM2009, "01.19"), (Standards.ISIC4, "0119")),
        ((Standards.CAEM2009, "01.21"), (Standards.ISIC4, "0121")),
        ((Standards.CAEM2009, "01.22"), (Standards.ISIC4, "0122")),
        ((Standards.CAEM2009, "01.23"), (Standards.ISIC4, "0123")),
        ((Standards.CAEM2009, "01.24"), (Standards.ISIC4, "0124")),
        ((Standards.CAEM2009, "01.25"), (Standards.ISIC4, "0125")),
        ((Standards.CAEM2009, "01.26"), (Standards.ISIC4, "0126")),
        ((Standards.CAEM2009, "01.27"), (Standards.ISIC4, "0127")),
        ((Standards.CAEM2009, "01.28"), (Standards.ISIC4, "0128")),
        ((Standards.CAEM2009, "01.29"), (Standards.ISIC4, "0129")),
        ((Standards.CAEM2009, "01.30"), (Standards.ISIC4, "0130")),
        ((Standards.CAEM2009, "01.41"), (Standards.ISIC4, "0141")),
        ((Standards.CAEM2009, "01.42"), (Standards.ISIC4, "0141")),
        ((Standards.CAEM2009, "01.43"), (Standards.ISIC4, "0142")),
        ((Standards.CAEM2009, "01.44"), (Standards.ISIC4, "0143")),
        ((Standards.CAEM2009, "01.45"), (Standards.ISIC4, "0144")),
        ((Standards.CAEM2009, "01.46"), (Standards.ISIC4, "0145")),
        ((Standards.CAEM2009, "01.47"), (Standards.ISIC4, "0146")),
        ((Standards.CAEM2009, "01.49"), (Standards.ISIC4, "0149")),
        ((Standards.CAEM2009, "01.50"), (Standards.ISIC4, "0150")),
        ((Standards.CAEM2009, "01.61"), (Standards.ISIC4, "0161")),
        ((Standards.CAEM2009, "01.62"), (Standards.ISIC4, "0162")),
        ((Standards.CAEM2009, "01.63"), (Standards.ISIC4, "0163")),
        ((Standards.CAEM2009, "01.64"), (Standards.ISIC4, "0164")),
        ((Standards.CAEM2009, "01.70"), (Standards.ISIC4, "0170")),
        ((Standards.CAEM2009, "02.10"), (Standards.ISIC4, "0210")),
        ((Standards.CAEM2009, "02.20"), (Standards.ISIC4, "0220")),
        ((Standards.CAEM2009, "02.30"), (Standards.ISIC4, "0230")),
        ((Standards.CAEM2009, "02.40"), (Standards.ISIC4, "0240")),
        ((Standards.CAEM2009, "03.11"), (Standards.ISIC4, "0311")),
        ((Standards.CAEM2009, "03.12"), (Standards.ISIC4, "0312")),
        ((Standards.CAEM2009, "03.21"), (Standards.ISIC4, "0321")),
        ((Standards.CAEM2009, "03.22"), (Standards.ISIC4, "0322")),
        ((Standards.CAEM2009, "05.10"), (Standards.ISIC4, "0510")),
        ((Standards.CAEM2009, "05.20"), (Standards.ISIC4, "0520")),
        ((Standards.CAEM2009, "06.10"), (Standards.ISIC4, "0610")),
        ((Standards.CAEM2009, "06.20"), (Standards.ISIC4, "0620")),
        ((Standards.CAEM2009, "07.10"), (Standards.ISIC4, "0710")),
        ((Standards.CAEM2009, "07.21"), (Standards.ISIC4, "0721")),
        ((Standards.CAEM2009, "07.29"), (Standards.ISIC4, "0729")),
        ((Standards.CAEM2009, "08.11"), (Standards.ISIC4, "0810")),
        ((Standards.CAEM2009, "08.12"), (Standards.ISIC4, "0810")),
        ((Standards.CAEM2009, "08.91"), (Standards.ISIC4, "0891")),
        ((Standards.CAEM2009, "08.92"), (Standards.ISIC4, "0892")),
        ((Standards.CAEM2009, "08.93"), (Standards.ISIC4, "0893")),
        ((Standards.CAEM2009, "08.99"), (Standards.ISIC4, "0899")),
        ((Standards.CAEM2009, "09.10"), (Standards.ISIC4, "0910")),
        ((Standards.CAEM2009, "09.90"), (Standards.ISIC4, "0990")),
        ((Standards.CAEM2009, "10.11"), (Standards.ISIC4, "1010")),
        ((Standards.CAEM2009, "10.12"), (Standards.ISIC4, "1010")),
        ((Standards.CAEM2009, "10.13"), (Standards.ISIC4, "1010")),
        ((Standards.CAEM2009, "10.20"), (Standards.ISIC4, "1020")),
        ((Standards.CAEM2009, "10.31"), (Standards.ISIC4, "1030")),
        ((Standards.CAEM2009, "10.32"), (Standards.ISIC4, "1030")),
        ((Standards.CAEM2009, "10.39"), (Standards.ISIC4, "1030")),
        ((Standards.CAEM2009, "10.41"), (Standards.ISIC4, "1040")),
        ((Standards.CAEM2009, "10.42"), (Standards.ISIC4, "1040")),
        ((Standards.CAEM2009, "10.51"), (Standards.ISIC4, "1050")),
        ((Standards.CAEM2009, "10.52"), (Standards.ISIC4, "1050")),
        ((Standards.CAEM2009, "10.61"), (Standards.ISIC4, "1061")),
        ((Standards.CAEM2009, "10.62"), (Standards.ISIC4, "1062")),
        ((Standards.CAEM2009, "10.71"), (Standards.ISIC4, "1071")),
        ((Standards.CAEM2009, "10.72"), (Standards.ISIC4, "1071")),
        ((Standards.CAEM2009, "10.73"), (Standards.ISIC4, "1074")),
        ((Standards.CAEM2009, "10.81"), (Standards.ISIC4, "1072")),
        ((Standards.CAEM2009, "10.82"), (Standards.ISIC4, "1073")),
        ((Standards.CAEM2009, "10.83"), (Standards.ISIC4, "1079")),
        ((Standards.CAEM2009, "10.84"), (Standards.ISIC4, "1079")),
        ((Standards.CAEM2009, "10.85"), (Standards.ISIC4, "1075")),
        ((Standards.CAEM2009, "10.86"), (Standards.ISIC4, "1079")),
        ((Standards.CAEM2009, "10.89"), (Standards.ISIC4, "1079")),
        ((Standards.CAEM2009, "10.91"), (Standards.ISIC4, "1080")),
        ((Standards.CAEM2009, "10.92"), (Standards.ISIC4, "1080")),
        ((Standards.CAEM2009, "11.01"), (Standards.ISIC4, "1101")),
        ((Standards.CAEM2009, "11.02"), (Standards.ISIC4, "1102")),
        ((Standards.CAEM2009, "11.03"), (Standards.ISIC4, "1102")),
        ((Standards.CAEM2009, "11.04"), (Standards.ISIC4, "1102")),
        ((Standards.CAEM2009, "11.05"), (Standards.ISIC4, "1103")),
        ((Standards.CAEM2009, "11.06"), (Standards.ISIC4, "1103")),
        ((Standards.CAEM2009, "11.07"), (Standards.ISIC4, "1104")),
        ((Standards.CAEM2009, "12.00"), (Standards.ISIC4, "1200")),
        ((Standards.CAEM2009, "13.10"), (Standards.ISIC4, "1311")),
        ((Standards.CAEM2009, "13.20"), (Standards.ISIC4, "1312")),
        ((Standards.CAEM2009, "13.30"), (Standards.ISIC4, "1313")),
        ((Standards.CAEM2009, "13.91"), (Standards.ISIC4, "1391")),
        ((Standards.CAEM2009, "13.92"), (Standards.ISIC4, "1392")),
        ((Standards.CAEM2009, "13.93"), (Standards.ISIC4, "1393")),
        ((Standards.CAEM2009, "13.94"), (Standards.ISIC4, "1394")),
        ((Standards.CAEM2009, "13.95"), (Standards.ISIC4, "1399")),
        ((Standards.CAEM2009, "13.96"), (Standards.ISIC4, "1399")),
        ((Standards.CAEM2009, "13.99"), (Standards.ISIC4, "1399")),
        ((Standards.CAEM2009, "14.11"), (Standards.ISIC4, "1410")),
        ((Standards.CAEM2009, "14.12"), (Standards.ISIC4, "1410")),
        ((Standards.CAEM2009, "14.13"), (Standards.ISIC4, "1410")),
        ((Standards.CAEM2009, "14.14"), (Standards.ISIC4, "1410")),
        ((Standards.CAEM2009, "14.19"), (Standards.ISIC4, "1410")),
        ((Standards.CAEM2009, "14.20"), (Standards.ISIC4, "1420")),
        ((Standards.CAEM2009, "14.31"), (Standards.ISIC4, "1430")),
        ((Standards.CAEM2009, "14.39"), (Standards.ISIC4, "1430")),
        ((Standards.CAEM2009, "15.11"), (Standards.ISIC4, "1511")),
        ((Standards.CAEM2009, "15.12"), (Standards.ISIC4, "1512")),
        ((Standards.CAEM2009, "15.20"), (Standards.ISIC4, "1520")),
        ((Standards.CAEM2009, "16.10"), (Standards.ISIC4, "1610")),
        ((Standards.CAEM2009, "16.21"), (Standards.ISIC4, "1621")),
        ((Standards.CAEM2009, "16.22"), (Standards.ISIC4, "1622")),
        ((Standards.CAEM2009, "16.23"), (Standards.ISIC4, "1622")),
        ((Standards.CAEM2009, "16.24"), (Standards.ISIC4, "1623")),
        ((Standards.CAEM2009, "16.29"), (Standards.ISIC4, "1629")),
        ((Standards.CAEM2009, "17.11"), (Standards.ISIC4, "1701")),
        ((Standards.CAEM2009, "17.12"), (Standards.ISIC4, "1701")),
        ((Standards.CAEM2009, "17.21"), (Standards.ISIC4, "1702")),
        ((Standards.CAEM2009, "17.22"), (Standards.ISIC4, "1709")),
        ((Standards.CAEM2009, "17.23"), (Standards.ISIC4, "1709")),
        ((Standards.CAEM2009, "17.24"), (Standards.ISIC4, "1709")),
        ((Standards.CAEM2009, "17.29"), (Standards.ISIC4, "1709")),
        ((Standards.CAEM2009, "18.11"), (Standards.ISIC4, "1811")),
        ((Standards.CAEM2009, "18.12"), (Standards.ISIC4, "1811")),
        ((Standards.CAEM2009, "18.13"), (Standards.ISIC4, "1812")),
        ((Standards.CAEM2009, "18.14"), (Standards.ISIC4, "1812")),
        ((Standards.CAEM2009, "18.20"), (Standards.ISIC4, "1820")),
        ((Standards.CAEM2009, "19.10"), (Standards.ISIC4, "1910")),
        ((Standards.CAEM2009, "19.20"), (Standards.ISIC4, "1920")),
        ((Standards.CAEM2009, "20.11"), (Standards.ISIC4, "2011")),
        ((Standards.CAEM2009, "20.12"), (Standards.ISIC4, "2011")),
        ((Standards.CAEM2009, "20.13"), (Standards.ISIC4, "2011")),
        ((Standards.CAEM2009, "20.14"), (Standards.ISIC4, "2011")),
        ((Standards.CAEM2009, "20.15"), (Standards.ISIC4, "2012")),
        ((Standards.CAEM2009, "20.16"), (Standards.ISIC4, "2013")),
        ((Standards.CAEM2009, "20.17"), (Standards.ISIC4, "2013")),
        ((Standards.CAEM2009, "20.20"), (Standards.ISIC4, "2021")),
        ((Standards.CAEM2009, "20.30"), (Standards.ISIC4, "2022")),
        ((Standards.CAEM2009, "20.41"), (Standards.ISIC4, "2023")),
        ((Standards.CAEM2009, "20.42"), (Standards.ISIC4, "2023")),
        ((Standards.CAEM2009, "20.51"), (Standards.ISIC4, "2029")),
        ((Standards.CAEM2009, "20.52"), (Standards.ISIC4, "2029")),
        ((Standards.CAEM2009, "20.53"), (Standards.ISIC4, "2029")),
        ((Standards.CAEM2009, "20.59"), (Standards.ISIC4, "2029")),
        ((Standards.CAEM2009, "20.60"), (Standards.ISIC4, "2030")),
        ((Standards.CAEM2009, "21.10"), (Standards.ISIC4, "2100")),
        ((Standards.CAEM2009, "21.20"), (Standards.ISIC4, "2100")),
        ((Standards.CAEM2009, "22.11"), (Standards.ISIC4, "2211")),
        ((Standards.CAEM2009, "22.19"), (Standards.ISIC4, "2219")),
        ((Standards.CAEM2009, "22.21"), (Standards.ISIC4, "2220")),
        ((Standards.CAEM2009, "22.22"), (Standards.ISIC4, "2220")),
        ((Standards.CAEM2009, "22.23"), (Standards.ISIC4, "2220")),
        ((Standards.CAEM2009, "22.29"), (Standards.ISIC4, "2220")),
        ((Standards.CAEM2009, "23.11"), (Standards.ISIC4, "2310")),
        ((Standards.CAEM2009, "23.12"), (Standards.ISIC4, "2310")),
        ((Standards.CAEM2009, "23.13"), (Standards.ISIC4, "2310")),
        ((Standards.CAEM2009, "23.14"), (Standards.ISIC4, "2310")),
        ((Standards.CAEM2009, "23.19"), (Standards.ISIC4, "2310")),
        ((Standards.CAEM2009, "23.20"), (Standards.ISIC4, "2391")),
        ((Standards.CAEM2009, "23.31"), (Standards.ISIC4, "2392")),
        ((Standards.CAEM2009, "23.32"), (Standards.ISIC4, "2392")),
        ((Standards.CAEM2009, "23.41"), (Standards.ISIC4, "2393")),
        ((Standards.CAEM2009, "23.42"), (Standards.ISIC4, "2393")),
        ((Standards.CAEM2009, "23.43"), (Standards.ISIC4, "2393")),
        ((Standards.CAEM2009, "23.44"), (Standards.ISIC4, "2393")),
        ((Standards.CAEM2009, "23.49"), (Standards.ISIC4, "2393")),
        ((Standards.CAEM2009, "23.51"), (Standards.ISIC4, "2394")),
        ((Standards.CAEM2009, "23.52"), (Standards.ISIC4, "2394")),
        ((Standards.CAEM2009, "23.61"), (Standards.ISIC4, "2395")),
        ((Standards.CAEM2009, "23.62"), (Standards.ISIC4, "2395")),
        ((Standards.CAEM2009, "23.63"), (Standards.ISIC4, "2395")),
        ((Standards.CAEM2009, "23.64"), (Standards.ISIC4, "2395")),
        ((Standards.CAEM2009, "23.65"), (Standards.ISIC4, "2395")),
        ((Standards.CAEM2009, "23.69"), (Standards.ISIC4, "2395")),
        ((Standards.CAEM2009, "23.70"), (Standards.ISIC4, "2396")),
        ((Standards.CAEM2009, "23.91"), (Standards.ISIC4, "2399")),
        ((Standards.CAEM2009, "23.99"), (Standards.ISIC4, "2399")),
        ((Standards.CAEM2009, "24.10"), (Standards.ISIC4, "2410")),
        ((Standards.CAEM2009, "24.20"), (Standards.ISIC4, "2410")),
        ((Standards.CAEM2009, "24.31"), (Standards.ISIC4, "2410")),
        ((Standards.CAEM2009, "24.32"), (Standards.ISIC4, "2410")),
        ((Standards.CAEM2009, "24.33"), (Standards.ISIC4, "2410")),
        ((Standards.CAEM2009, "24.34"), (Standards.ISIC4, "2410")),
        ((Standards.CAEM2009, "24.41"), (Standards.ISIC4, "2420")),
        ((Standards.CAEM2009, "24.42"), (Standards.ISIC4, "2420")),
        ((Standards.CAEM2009, "24.43"), (Standards.ISIC4, "2420")),
        ((Standards.CAEM2009, "24.44"), (Standards.ISIC4, "2420")),
        ((Standards.CAEM2009, "24.45"), (Standards.ISIC4, "2420")),
        ((Standards.CAEM2009, "24.46"), (Standards.ISIC4, "2420")),
        ((Standards.CAEM2009, "24.51"), (Standards.ISIC4, "2431")),
        ((Standards.CAEM2009, "24.52"), (Standards.ISIC4, "2431")),
        ((Standards.CAEM2009, "24.53"), (Standards.ISIC4, "2432")),
        ((Standards.CAEM2009, "24.54"), (Standards.ISIC4, "2432")),
        ((Standards.CAEM2009, "25.11"), (Standards.ISIC4, "2511")),
        ((Standards.CAEM2009, "25.12"), (Standards.ISIC4, "2511")),
        ((Standards.CAEM2009, "25.21"), (Standards.ISIC4, "2512")),
        ((Standards.CAEM2009, "25.29"), (Standards.ISIC4, "2512")),
        ((Standards.CAEM2009, "25.30"), (Standards.ISIC4, "2513")),
        ((Standards.CAEM2009, "25.40"), (Standards.ISIC4, "2520")),
        ((Standards.CAEM2009, "25.50"), (Standards.ISIC4, "2591")),
        ((Standards.CAEM2009, "25.61"), (Standards.ISIC4, "2592")),
        ((Standards.CAEM2009, "25.62"), (Standards.ISIC4, "2592")),
        ((Standards.CAEM2009, "25.71"), (Standards.ISIC4, "2593")),
        ((Standards.CAEM2009, "25.72"), (Standards.ISIC4, "2593")),
        ((Standards.CAEM2009, "25.73"), (Standards.ISIC4, "2593")),
        ((Standards.CAEM2009, "25.91"), (Standards.ISIC4, "2599")),
        ((Standards.CAEM2009, "25.92"), (Standards.ISIC4, "2599")),
        ((Standards.CAEM2009, "25.93"), (Standards.ISIC4, "2599")),
        ((Standards.CAEM2009, "25.94"), (Standards.ISIC4, "2599")),
        ((Standards.CAEM2009, "25.99"), (Standards.ISIC4, "2599")),
        ((Standards.CAEM2009, "26.11"), (Standards.ISIC4, "2610")),
        ((Standards.CAEM2009, "26.12"), (Standards.ISIC4, "2610")),
        ((Standards.CAEM2009, "26.20"), (Standards.ISIC4, "2620")),
        ((Standards.CAEM2009, "26.30"), (Standards.ISIC4, "2630")),
        ((Standards.CAEM2009, "26.40"), (Standards.ISIC4, "2640")),
        ((Standards.CAEM2009, "26.51"), (Standards.ISIC4, "2651")),
        ((Standards.CAEM2009, "26.52"), (Standards.ISIC4, "2652")),
        ((Standards.CAEM2009, "26.60"), (Standards.ISIC4, "2660")),
        ((Standards.CAEM2009, "26.70"), (Standards.ISIC4, "2670")),
        ((Standards.CAEM2009, "26.80"), (Standards.ISIC4, "2680")),
        ((Standards.CAEM2009, "27.11"), (Standards.ISIC4, "2710")),
        ((Standards.CAEM2009, "27.12"), (Standards.ISIC4, "2710")),
        ((Standards.CAEM2009, "27.20"), (Standards.ISIC4, "2720")),
        ((Standards.CAEM2009, "27.31"), (Standards.ISIC4, "2731")),
        ((Standards.CAEM2009, "27.32"), (Standards.ISIC4, "2732")),
        ((Standards.CAEM2009, "27.33"), (Standards.ISIC4, "2733")),
        ((Standards.CAEM2009, "27.40"), (Standards.ISIC4, "2740")),
        ((Standards.CAEM2009, "27.51"), (Standards.ISIC4, "2750")),
        ((Standards.CAEM2009, "27.52"), (Standards.ISIC4, "2750")),
        ((Standards.CAEM2009, "27.90"), (Standards.ISIC4, "2790")),
        ((Standards.CAEM2009, "28.11"), (Standards.ISIC4, "2811")),
        ((Standards.CAEM2009, "28.12"), (Standards.ISIC4, "2812")),
        ((Standards.CAEM2009, "28.13"), (Standards.ISIC4, "2813")),
        ((Standards.CAEM2009, "28.14"), (Standards.ISIC4, "2813")),
        ((Standards.CAEM2009, "28.15"), (Standards.ISIC4, "2814")),
        ((Standards.CAEM2009, "28.21"), (Standards.ISIC4, "2815")),
        ((Standards.CAEM2009, "28.22"), (Standards.ISIC4, "2816")),
        ((Standards.CAEM2009, "28.23"), (Standards.ISIC4, "2817")),
        ((Standards.CAEM2009, "28.24"), (Standards.ISIC4, "2818")),
        ((Standards.CAEM2009, "28.25"), (Standards.ISIC4, "2819")),
        ((Standards.CAEM2009, "28.29"), (Standards.ISIC4, "2819")),
        ((Standards.CAEM2009, "28.30"), (Standards.ISIC4, "2821")),
        ((Standards.CAEM2009, "28.41"), (Standards.ISIC4, "2822")),
        ((Standards.CAEM2009, "28.49"), (Standards.ISIC4, "2822")),
        ((Standards.CAEM2009, "28.91"), (Standards.ISIC4, "2823")),
        ((Standards.CAEM2009, "28.92"), (Standards.ISIC4, "2824")),
        ((Standards.CAEM2009, "28.93"), (Standards.ISIC4, "2825")),
        ((Standards.CAEM2009, "28.94"), (Standards.ISIC4, "2826")),
        ((Standards.CAEM2009, "28.95"), (Standards.ISIC4, "2829")),
        ((Standards.CAEM2009, "28.96"), (Standards.ISIC4, "2829")),
        ((Standards.CAEM2009, "28.99"), (Standards.ISIC4, "2829")),
        ((Standards.CAEM2009, "29.10"), (Standards.ISIC4, "2910")),
        ((Standards.CAEM2009, "29.20"), (Standards.ISIC4, "2920")),
        ((Standards.CAEM2009, "29.31"), (Standards.ISIC4, "2930")),
        ((Standards.CAEM2009, "29.32"), (Standards.ISIC4, "2930")),
        ((Standards.CAEM2009, "30.11"), (Standards.ISIC4, "3011")),
        ((Standards.CAEM2009, "30.12"), (Standards.ISIC4, "3012")),
        ((Standards.CAEM2009, "30.20"), (Standards.ISIC4, "3020")),
        ((Standards.CAEM2009, "30.30"), (Standards.ISIC4, "3030")),
        ((Standards.CAEM2009, "30.40"), (Standards.ISIC4, "3040")),
        ((Standards.CAEM2009, "30.91"), (Standards.ISIC4, "3091")),
        ((Standards.CAEM2009, "30.92"), (Standards.ISIC4, "3092")),
        ((Standards.CAEM2009, "30.99"), (Standards.ISIC4, "3099")),
        ((Standards.CAEM2009, "31.01"), (Standards.ISIC4, "3100")),
        ((Standards.CAEM2009, "31.02"), (Standards.ISIC4, "3100")),
        ((Standards.CAEM2009, "31.03"), (Standards.ISIC4, "3100")),
        ((Standards.CAEM2009, "31.09"), (Standards.ISIC4, "3100")),
        ((Standards.CAEM2009, "32.11"), (Standards.ISIC4, "3211")),
        ((Standards.CAEM2009, "32.12"), (Standards.ISIC4, "3211")),
        ((Standards.CAEM2009, "32.13"), (Standards.ISIC4, "3212")),
        ((Standards.CAEM2009, "32.20"), (Standards.ISIC4, "3220")),
        ((Standards.CAEM2009, "32.30"), (Standards.ISIC4, "3230")),
        ((Standards.CAEM2009, "32.40"), (Standards.ISIC4, "3240")),
        ((Standards.CAEM2009, "32.50"), (Standards.ISIC4, "3250")),
        ((Standards.CAEM2009, "32.91"), (Standards.ISIC4, "3290")),
        ((Standards.CAEM2009, "32.99"), (Standards.ISIC4, "3290")),
        ((Standards.CAEM2009, "33.11"), (Standards.ISIC4, "3311")),
        ((Standards.CAEM2009, "33.12"), (Standards.ISIC4, "3312")),
        ((Standards.CAEM2009, "33.13"), (Standards.ISIC4, "3313")),
        ((Standards.CAEM2009, "33.14"), (Standards.ISIC4, "3314")),
        ((Standards.CAEM2009, "33.15"), (Standards.ISIC4, "3315")),
        ((Standards.CAEM2009, "33.16"), (Standards.ISIC4, "3315")),
        ((Standards.CAEM2009, "33.17"), (Standards.ISIC4, "3315")),
        ((Standards.CAEM2009, "33.19"), (Standards.ISIC4, "3319")),
        ((Standards.CAEM2009, "33.20"), (Standards.ISIC4, "3320")),
        ((Standards.CAEM2009, "35.11"), (Standards.ISIC4, "3510")),
        ((Standards.CAEM2009, "35.12"), (Standards.ISIC4, "3510")),
        ((Standards.CAEM2009, "35.13"), (Standards.ISIC4, "3510")),
        ((Standards.CAEM2009, "35.14"), (Standards.ISIC4, "3510")),
        ((Standards.CAEM2009, "35.21"), (Standards.ISIC4, "3520")),
        ((Standards.CAEM2009, "35.22"), (Standards.ISIC4, "3520")),
        ((Standards.CAEM2009, "35.23"), (Standards.ISIC4, "3520")),
        ((Standards.CAEM2009, "35.30"), (Standards.ISIC4, "3530")),
        ((Standards.CAEM2009, "36.00"), (Standards.ISIC4, "3600")),
        ((Standards.CAEM2009, "37.00"), (Standards.ISIC4, "3700")),
        ((Standards.CAEM2009, "38.11"), (Standards.ISIC4, "3811")),
        ((Standards.CAEM2009, "38.12"), (Standards.ISIC4, "3812")),
        ((Standards.CAEM2009, "38.21"), (Standards.ISIC4, "3821")),
        ((Standards.CAEM2009, "38.22"), (Standards.ISIC4, "3822")),
        ((Standards.CAEM2009, "38.31"), (Standards.ISIC4, "3830")),
        ((Standards.CAEM2009, "38.32"), (Standards.ISIC4, "3830")),
        ((Standards.CAEM2009, "39.00"), (Standards.ISIC4, "3900")),
        ((Standards.CAEM2009, "41.10"), (Standards.ISIC4, "4100")),
        ((Standards.CAEM2009, "41.20"), (Standards.ISIC4, "4100")),
        ((Standards.CAEM2009, "42.11"), (Standards.ISIC4, "4210")),
        ((Standards.CAEM2009, "42.12"), (Standards.ISIC4, "4210")),
        ((Standards.CAEM2009, "42.13"), (Standards.ISIC4, "4210")),
        ((Standards.CAEM2009, "42.21"), (Standards.ISIC4, "4220")),
        ((Standards.CAEM2009, "42.22"), (Standards.ISIC4, "4220")),
        ((Standards.CAEM2009, "42.91"), (Standards.ISIC4, "4290")),
        ((Standards.CAEM2009, "42.99"), (Standards.ISIC4, "4290")),
        ((Standards.CAEM2009, "43.11"), (Standards.ISIC4, "4311")),
        ((Standards.CAEM2009, "43.12"), (Standards.ISIC4, "4312")),
        ((Standards.CAEM2009, "43.13"), (Standards.ISIC4, "4312")),
        ((Standards.CAEM2009, "43.21"), (Standards.ISIC4, "4321")),
        ((Standards.CAEM2009, "43.22"), (Standards.ISIC4, "4322")),
        ((Standards.CAEM2009, "43.29"), (Standards.ISIC4, "4329")),
        ((Standards.CAEM2009, "43.31"), (Standards.ISIC4, "4330")),
        ((Standards.CAEM2009, "43.32"), (Standards.ISIC4, "4330")),
        ((Standards.CAEM2009, "43.33"), (Standards.ISIC4, "4330")),
        ((Standards.CAEM2009, "43.34"), (Standards.ISIC4, "4330")),
        ((Standards.CAEM2009, "43.39"), (Standards.ISIC4, "4330")),
        ((Standards.CAEM2009, "43.91"), (Standards.ISIC4, "4390")),
        ((Standards.CAEM2009, "43.99"), (Standards.ISIC4, "4390")),
        ((Standards.CAEM2009, "45.11"), (Standards.ISIC4, "4510")),
        ((Standards.CAEM2009, "45.19"), (Standards.ISIC4, "4510")),
        ((Standards.CAEM2009, "45.20"), (Standards.ISIC4, "4520")),
        ((Standards.CAEM2009, "45.31"), (Standards.ISIC4, "4530")),
        ((Standards.CAEM2009, "45.32"), (Standards.ISIC4, "4530")),
        ((Standards.CAEM2009, "45.40"), (Standards.ISIC4, "4540")),
        ((Standards.CAEM2009, "46.11"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.12"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.13"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.14"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.15"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.16"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.17"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.18"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.19"), (Standards.ISIC4, "4610")),
        ((Standards.CAEM2009, "46.21"), (Standards.ISIC4, "4620")),
        ((Standards.CAEM2009, "46.22"), (Standards.ISIC4, "4620")),
        ((Standards.CAEM2009, "46.23"), (Standards.ISIC4, "4620")),
        ((Standards.CAEM2009, "46.24"), (Standards.ISIC4, "4620")),
        ((Standards.CAEM2009, "46.31"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.32"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.33"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.34"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.35"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.36"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.37"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.38"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.39"), (Standards.ISIC4, "4630")),
        ((Standards.CAEM2009, "46.41"), (Standards.ISIC4, "4641")),
        ((Standards.CAEM2009, "46.42"), (Standards.ISIC4, "4641")),
        ((Standards.CAEM2009, "46.43"), (Standards.ISIC4, "4649")),
        ((Standards.CAEM2009, "46.44"), (Standards.ISIC4, "4649")),
        ((Standards.CAEM2009, "46.45"), (Standards.ISIC4, "4649")),
        ((Standards.CAEM2009, "46.46"), (Standards.ISIC4, "4649")),
        ((Standards.CAEM2009, "46.47"), (Standards.ISIC4, "4649")),
        ((Standards.CAEM2009, "46.48"), (Standards.ISIC4, "4649")),
        ((Standards.CAEM2009, "46.49"), (Standards.ISIC4, "4649")),
        ((Standards.CAEM2009, "46.51"), (Standards.ISIC4, "4651")),
        ((Standards.CAEM2009, "46.52"), (Standards.ISIC4, "4652")),
        ((Standards.CAEM2009, "46.61"), (Standards.ISIC4, "4653")),
        ((Standards.CAEM2009, "46.62"), (Standards.ISIC4, "4659")),
        ((Standards.CAEM2009, "46.63"), (Standards.ISIC4, "4659")),
        ((Standards.CAEM2009, "46.64"), (Standards.ISIC4, "4659")),
        ((Standards.CAEM2009, "46.65"), (Standards.ISIC4, "4659")),
        ((Standards.CAEM2009, "46.66"), (Standards.ISIC4, "4659")),
        ((Standards.CAEM2009, "46.69"), (Standards.ISIC4, "4659")),
        ((Standards.CAEM2009, "46.71"), (Standards.ISIC4, "4661")),
        ((Standards.CAEM2009, "46.72"), (Standards.ISIC4, "4662")),
        ((Standards.CAEM2009, "46.73"), (Standards.ISIC4, "4663")),
        ((Standards.CAEM2009, "46.74"), (Standards.ISIC4, "4663")),
        ((Standards.CAEM2009, "46.75"), (Standards.ISIC4, "4669")),
        ((Standards.CAEM2009, "46.76"), (Standards.ISIC4, "4669")),
        ((Standards.CAEM2009, "46.77"), (Standards.ISIC4, "4669")),
        ((Standards.CAEM2009, "46.90"), (Standards.ISIC4, "4690")),
        ((Standards.CAEM2009, "47.11"), (Standards.ISIC4, "4711")),
        ((Standards.CAEM2009, "47.19"), (Standards.ISIC4, "4719")),
        ((Standards.CAEM2009, "47.21"), (Standards.ISIC4, "4721")),
        ((Standards.CAEM2009, "47.22"), (Standards.ISIC4, "4721")),
        ((Standards.CAEM2009, "47.23"), (Standards.ISIC4, "4721")),
        ((Standards.CAEM2009, "47.24"), (Standards.ISIC4, "4721")),
        ((Standards.CAEM2009, "47.25"), (Standards.ISIC4, "4722")),
        ((Standards.CAEM2009, "47.26"), (Standards.ISIC4, "4723")),
        ((Standards.CAEM2009, "47.29"), (Standards.ISIC4, "4721")),
        ((Standards.CAEM2009, "47.30"), (Standards.ISIC4, "4730")),
        ((Standards.CAEM2009, "47.41"), (Standards.ISIC4, "4741")),
        ((Standards.CAEM2009, "47.42"), (Standards.ISIC4, "4741")),
        ((Standards.CAEM2009, "47.43"), (Standards.ISIC4, "4742")),
        ((Standards.CAEM2009, "47.51"), (Standards.ISIC4, "4751")),
        ((Standards.CAEM2009, "47.52"), (Standards.ISIC4, "4752")),
        ((Standards.CAEM2009, "47.53"), (Standards.ISIC4, "4753")),
        ((Standards.CAEM2009, "47.54"), (Standards.ISIC4, "4759")),
        ((Standards.CAEM2009, "47.59"), (Standards.ISIC4, "4759")),
        ((Standards.CAEM2009, "47.61"), (Standards.ISIC4, "4761")),
        ((Standards.CAEM2009, "47.62"), (Standards.ISIC4, "4761")),
        ((Standards.CAEM2009, "47.63"), (Standards.ISIC4, "4762")),
        ((Standards.CAEM2009, "47.64"), (Standards.ISIC4, "4763")),
        ((Standards.CAEM2009, "47.65"), (Standards.ISIC4, "4764")),
        ((Standards.CAEM2009, "47.71"), (Standards.ISIC4, "4771")),
        ((Standards.CAEM2009, "47.72"), (Standards.ISIC4, "4771")),
        ((Standards.CAEM2009, "47.73"), (Standards.ISIC4, "4772")),
        ((Standards.CAEM2009, "47.74"), (Standards.ISIC4, "4772")),
        ((Standards.CAEM2009, "47.75"), (Standards.ISIC4, "4772")),
        ((Standards.CAEM2009, "47.76"), (Standards.ISIC4, "4773")),
        ((Standards.CAEM2009, "47.77"), (Standards.ISIC4, "4773")),
        ((Standards.CAEM2009, "47.78"), (Standards.ISIC4, "4773")),
        ((Standards.CAEM2009, "47.79"), (Standards.ISIC4, "4774")),
        ((Standards.CAEM2009, "47.81"), (Standards.ISIC4, "4781")),
        ((Standards.CAEM2009, "47.82"), (Standards.ISIC4, "4782")),
        ((Standards.CAEM2009, "47.89"), (Standards.ISIC4, "4789")),
        ((Standards.CAEM2009, "47.91"), (Standards.ISIC4, "4791")),
        ((Standards.CAEM2009, "47.99"), (Standards.ISIC4, "4799")),
        ((Standards.CAEM2009, "49.10"), (Standards.ISIC4, "4911")),
        ((Standards.CAEM2009, "49.20"), (Standards.ISIC4, "4912")),
        ((Standards.CAEM2009, "49.31"), (Standards.ISIC4, "4921")),
        ((Standards.CAEM2009, "49.32"), (Standards.ISIC4, "4922")),
        ((Standards.CAEM2009, "49.39"), (Standards.ISIC4, "4922")),
        ((Standards.CAEM2009, "49.41"), (Standards.ISIC4, "4923")),
        ((Standards.CAEM2009, "49.42"), (Standards.ISIC4, "4923")),
        ((Standards.CAEM2009, "49.50"), (Standards.ISIC4, "4930")),
        ((Standards.CAEM2009, "50.10"), (Standards.ISIC4, "5011")),
        ((Standards.CAEM2009, "50.20"), (Standards.ISIC4, "5012")),
        ((Standards.CAEM2009, "50.30"), (Standards.ISIC4, "5021")),
        ((Standards.CAEM2009, "50.40"), (Standards.ISIC4, "5022")),
        ((Standards.CAEM2009, "51.10"), (Standards.ISIC4, "5110")),
        ((Standards.CAEM2009, "51.21"), (Standards.ISIC4, "5120")),
        ((Standards.CAEM2009, "51.22"), (Standards.ISIC4, "5120")),
        ((Standards.CAEM2009, "52.10"), (Standards.ISIC4, "5210")),
        ((Standards.CAEM2009, "52.21"), (Standards.ISIC4, "5221")),
        ((Standards.CAEM2009, "52.22"), (Standards.ISIC4, "5222")),
        ((Standards.CAEM2009, "52.23"), (Standards.ISIC4, "5223")),
        ((Standards.CAEM2009, "52.24"), (Standards.ISIC4, "5224")),
        ((Standards.CAEM2009, "52.29"), (Standards.ISIC4, "5229")),
        ((Standards.CAEM2009, "53.10"), (Standards.ISIC4, "5310")),
        ((Standards.CAEM2009, "53.20"), (Standards.ISIC4, "5320")),
        ((Standards.CAEM2009, "55.10"), (Standards.ISIC4, "5510")),
        ((Standards.CAEM2009, "55.20"), (Standards.ISIC4, "5510")),
        ((Standards.CAEM2009, "55.30"), (Standards.ISIC4, "5520")),
        ((Standards.CAEM2009, "55.90"), (Standards.ISIC4, "5590")),
        ((Standards.CAEM2009, "56.10"), (Standards.ISIC4, "5610")),
        ((Standards.CAEM2009, "56.21"), (Standards.ISIC4, "5621")),
        ((Standards.CAEM2009, "56.29"), (Standards.ISIC4, "5629")),
        ((Standards.CAEM2009, "56.30"), (Standards.ISIC4, "5630")),
        ((Standards.CAEM2009, "58.11"), (Standards.ISIC4, "5811")),
        ((Standards.CAEM2009, "58.12"), (Standards.ISIC4, "5812")),
        ((Standards.CAEM2009, "58.13"), (Standards.ISIC4, "5813")),
        ((Standards.CAEM2009, "58.14"), (Standards.ISIC4, "5813")),
        ((Standards.CAEM2009, "58.19"), (Standards.ISIC4, "5819")),
        ((Standards.CAEM2009, "58.21"), (Standards.ISIC4, "5820")),
        ((Standards.CAEM2009, "58.29"), (Standards.ISIC4, "5820")),
        ((Standards.CAEM2009, "59.11"), (Standards.ISIC4, "5911")),
        ((Standards.CAEM2009, "59.12"), (Standards.ISIC4, "5912")),
        ((Standards.CAEM2009, "59.13"), (Standards.ISIC4, "5913")),
        ((Standards.CAEM2009, "59.14"), (Standards.ISIC4, "5914")),
        ((Standards.CAEM2009, "59.20"), (Standards.ISIC4, "5920")),
        ((Standards.CAEM2009, "60.10"), (Standards.ISIC4, "6010")),
        ((Standards.CAEM2009, "60.20"), (Standards.ISIC4, "6020")),
        ((Standards.CAEM2009, "61.10"), (Standards.ISIC4, "6110")),
        ((Standards.CAEM2009, "61.20"), (Standards.ISIC4, "6120")),
        ((Standards.CAEM2009, "61.30"), (Standards.ISIC4, "6130")),
        ((Standards.CAEM2009, "61.90"), (Standards.ISIC4, "6190")),
        ((Standards.CAEM2009, "62.01"), (Standards.ISIC4, "6201")),
        ((Standards.CAEM2009, "62.02"), (Standards.ISIC4, "6202")),
        ((Standards.CAEM2009, "62.03"), (Standards.ISIC4, "6202")),
        ((Standards.CAEM2009, "62.09"), (Standards.ISIC4, "6209")),
        ((Standards.CAEM2009, "63.11"), (Standards.ISIC4, "6311")),
        ((Standards.CAEM2009, "63.12"), (Standards.ISIC4, "6312")),
        ((Standards.CAEM2009, "63.91"), (Standards.ISIC4, "6391")),
        ((Standards.CAEM2009, "63.99"), (Standards.ISIC4, "6399")),
        ((Standards.CAEM2009, "64.11"), (Standards.ISIC4, "6411")),
        ((Standards.CAEM2009, "64.19"), (Standards.ISIC4, "6419")),
        ((Standards.CAEM2009, "64.20"), (Standards.ISIC4, "6420")),
        ((Standards.CAEM2009, "64.30"), (Standards.ISIC4, "6430")),
        ((Standards.CAEM2009, "64.91"), (Standards.ISIC4, "6491")),
        ((Standards.CAEM2009, "64.92"), (Standards.ISIC4, "6492")),
        ((Standards.CAEM2009, "64.99"), (Standards.ISIC4, "6499")),
        ((Standards.CAEM2009, "65.11"), (Standards.ISIC4, "6511")),
        ((Standards.CAEM2009, "65.12"), (Standards.ISIC4, "6512")),
        ((Standards.CAEM2009, "65.20"), (Standards.ISIC4, "6520")),
        ((Standards.CAEM2009, "65.30"), (Standards.ISIC4, "6530")),
        ((Standards.CAEM2009, "66.11"), (Standards.ISIC4, "6611")),
        ((Standards.CAEM2009, "66.12"), (Standards.ISIC4, "6612")),
        ((Standards.CAEM2009, "66.19"), (Standards.ISIC4, "6619")),
        ((Standards.CAEM2009, "66.21"), (Standards.ISIC4, "6621")),
        ((Standards.CAEM2009, "66.22"), (Standards.ISIC4, "6622")),
        ((Standards.CAEM2009, "66.29"), (Standards.ISIC4, "6629")),
        ((Standards.CAEM2009, "66.30"), (Standards.ISIC4, "6630")),
        ((Standards.CAEM2009, "68.10"), (Standards.ISIC4, "6810")),
        ((Standards.CAEM2009, "68.20"), (Standards.ISIC4, "6810")),
        ((Standards.CAEM2009, "68.31"), (Standards.ISIC4, "6820")),
        ((Standards.CAEM2009, "68.32"), (Standards.ISIC4, "6820")),
        ((Standards.CAEM2009, "69.10"), (Standards.ISIC4, "6910")),
        ((Standards.CAEM2009, "69.20"), (Standards.ISIC4, "6920")),
        ((Standards.CAEM2009, "70.10"), (Standards.ISIC4, "7010")),
        ((Standards.CAEM2009, "70.21"), (Standards.ISIC4, "7020")),
        ((Standards.CAEM2009, "70.22"), (Standards.ISIC4, "7020")),
        ((Standards.CAEM2009, "71.11"), (Standards.ISIC4, "7110")),
        ((Standards.CAEM2009, "71.12"), (Standards.ISIC4, "7110")),
        ((Standards.CAEM2009, "71.20"), (Standards.ISIC4, "7120")),
        ((Standards.CAEM2009, "72.11"), (Standards.ISIC4, "7210")),
        ((Standards.CAEM2009, "72.19"), (Standards.ISIC4, "7210")),
        ((Standards.CAEM2009, "72.20"), (Standards.ISIC4, "7220")),
        ((Standards.CAEM2009, "73.11"), (Standards.ISIC4, "7310")),
        ((Standards.CAEM2009, "73.12"), (Standards.ISIC4, "7310")),
        ((Standards.CAEM2009, "73.20"), (Standards.ISIC4, "7320")),
        ((Standards.CAEM2009, "74.10"), (Standards.ISIC4, "7410")),
        ((Standards.CAEM2009, "74.20"), (Standards.ISIC4, "7420")),
        ((Standards.CAEM2009, "74.30"), (Standards.ISIC4, "7490")),
        ((Standards.CAEM2009, "74.90"), (Standards.ISIC4, "7490")),
        ((Standards.CAEM2009, "75.00"), (Standards.ISIC4, "7500")),
        ((Standards.CAEM2009, "77.11"), (Standards.ISIC4, "7710")),
        ((Standards.CAEM2009, "77.12"), (Standards.ISIC4, "7710")),
        ((Standards.CAEM2009, "77.21"), (Standards.ISIC4, "7721")),
        ((Standards.CAEM2009, "77.22"), (Standards.ISIC4, "7722")),
        ((Standards.CAEM2009, "77.29"), (Standards.ISIC4, "7729")),
        ((Standards.CAEM2009, "77.31"), (Standards.ISIC4, "7730")),
        ((Standards.CAEM2009, "77.32"), (Standards.ISIC4, "7730")),
        ((Standards.CAEM2009, "77.33"), (Standards.ISIC4, "7730")),
        ((Standards.CAEM2009, "77.34"), (Standards.ISIC4, "7730")),
        ((Standards.CAEM2009, "77.35"), (Standards.ISIC4, "7730")),
        ((Standards.CAEM2009, "77.39"), (Standards.ISIC4, "7730")),
        ((Standards.CAEM2009, "77.40"), (Standards.ISIC4, "7740")),
        ((Standards.CAEM2009, "78.10"), (Standards.ISIC4, "7810")),
        ((Standards.CAEM2009, "78.20"), (Standards.ISIC4, "7820")),
        ((Standards.CAEM2009, "78.30"), (Standards.ISIC4, "7830")),
        ((Standards.CAEM2009, "79.11"), (Standards.ISIC4, "7911")),
        ((Standards.CAEM2009, "79.12"), (Standards.ISIC4, "7912")),
        ((Standards.CAEM2009, "80.10"), (Standards.ISIC4, "8010")),
        ((Standards.CAEM2009, "80.20"), (Standards.ISIC4, "8020")),
        ((Standards.CAEM2009, "80.30"), (Standards.ISIC4, "8030")),
        ((Standards.CAEM2009, "81.10"), (Standards.ISIC4, "8110")),
        ((Standards.CAEM2009, "81.21"), (Standards.ISIC4, "8121")),
        ((Standards.CAEM2009, "81.22"), (Standards.ISIC4, "8129")),
        ((Standards.CAEM2009, "81.29"), (Standards.ISIC4, "8129")),
        ((Standards.CAEM2009, "81.30"), (Standards.ISIC4, "8130")),
        ((Standards.CAEM2009, "82.11"), (Standards.ISIC4, "8211")),
        ((Standards.CAEM2009, "82.19"), (Standards.ISIC4, "8219")),
        ((Standards.CAEM2009, "82.20"), (Standards.ISIC4, "8220")),
        ((Standards.CAEM2009, "82.30"), (Standards.ISIC4, "8230")),
        ((Standards.CAEM2009, "82.91"), (Standards.ISIC4, "8291")),
        ((Standards.CAEM2009, "82.92"), (Standards.ISIC4, "8292")),
        ((Standards.CAEM2009, "82.99"), (Standards.ISIC4, "8299")),
        ((Standards.CAEM2009, "84.11"), (Standards.ISIC4, "8411")),
        ((Standards.CAEM2009, "84.12"), (Standards.ISIC4, "8412")),
        ((Standards.CAEM2009, "84.13"), (Standards.ISIC4, "8413")),
        ((Standards.CAEM2009, "84.21"), (Standards.ISIC4, "8421")),
        ((Standards.CAEM2009, "84.22"), (Standards.ISIC4, "8422")),
        ((Standards.CAEM2009, "84.23"), (Standards.ISIC4, "8423")),
        ((Standards.CAEM2009, "84.24"), (Standards.ISIC4, "8423")),
        ((Standards.CAEM2009, "84.25"), (Standards.ISIC4, "8423")),
        ((Standards.CAEM2009, "84.30"), (Standards.ISIC4, "8430")),
        ((Standards.CAEM2009, "85.10"), (Standards.ISIC4, "8510")),
        ((Standards.CAEM2009, "85.20"), (Standards.ISIC4, "8510")),
        ((Standards.CAEM2009, "85.31"), (Standards.ISIC4, "8521")),
        ((Standards.CAEM2009, "85.32"), (Standards.ISIC4, "8522")),
        ((Standards.CAEM2009, "85.41"), (Standards.ISIC4, "8530")),
        ((Standards.CAEM2009, "85.42"), (Standards.ISIC4, "8530")),
        ((Standards.CAEM2009, "85.51"), (Standards.ISIC4, "8541")),
        ((Standards.CAEM2009, "85.52"), (Standards.ISIC4, "8542")),
        ((Standards.CAEM2009, "85.53"), (Standards.ISIC4, "8549")),
        ((Standards.CAEM2009, "85.59"), (Standards.ISIC4, "8549")),
        ((Standards.CAEM2009, "85.60"), (Standards.ISIC4, "8550")),
        ((Standards.CAEM2009, "86.10"), (Standards.ISIC4, "8610")),
        ((Standards.CAEM2009, "86.21"), (Standards.ISIC4, "8620")),
        ((Standards.CAEM2009, "86.22"), (Standards.ISIC4, "8620")),
        ((Standards.CAEM2009, "86.23"), (Standards.ISIC4, "8620")),
        ((Standards.CAEM2009, "86.90"), (Standards.ISIC4, "8690")),
        ((Standards.CAEM2009, "87.10"), (Standards.ISIC4, "8710")),
        ((Standards.CAEM2009, "87.20"), (Standards.ISIC4, "8720")),
        ((Standards.CAEM2009, "87.30"), (Standards.ISIC4, "8730")),
        ((Standards.CAEM2009, "87.90"), (Standards.ISIC4, "8790")),
        ((Standards.CAEM2009, "88.10"), (Standards.ISIC4, "8810")),
        ((Standards.CAEM2009, "88.91"), (Standards.ISIC4, "8890")),
        ((Standards.CAEM2009, "88.99"), (Standards.ISIC4, "8890")),
        ((Standards.CAEM2009, "90.01"), (Standards.ISIC4, "9000")),
        ((Standards.CAEM2009, "90.02"), (Standards.ISIC4, "9000")),
        ((Standards.CAEM2009, "90.03"), (Standards.ISIC4, "9000")),
        ((Standards.CAEM2009, "90.04"), (Standards.ISIC4, "9000")),
        ((Standards.CAEM2009, "91.01"), (Standards.ISIC4, "9101")),
        ((Standards.CAEM2009, "91.02"), (Standards.ISIC4, "9102")),
        ((Standards.CAEM2009, "91.03"), (Standards.ISIC4, "9102")),
        ((Standards.CAEM2009, "91.04"), (Standards.ISIC4, "9103")),
        ((Standards.CAEM2009, "92.00"), (Standards.ISIC4, "9200")),
        ((Standards.CAEM2009, "93.11"), (Standards.ISIC4, "9311")),
        ((Standards.CAEM2009, "93.12"), (Standards.ISIC4, "9312")),
        ((Standards.CAEM2009, "93.13"), (Standards.ISIC4, "9311")),
        ((Standards.CAEM2009, "93.19"), (Standards.ISIC4, "9319")),
        ((Standards.CAEM2009, "93.21"), (Standards.ISIC4, "9321")),
        ((Standards.CAEM2009, "93.29"), (Standards.ISIC4, "9329")),
        ((Standards.CAEM2009, "94.11"), (Standards.ISIC4, "9411")),
        ((Standards.CAEM2009, "94.12"), (Standards.ISIC4, "9412")),
        ((Standards.CAEM2009, "94.20"), (Standards.ISIC4, "9420")),
        ((Standards.CAEM2009, "94.91"), (Standards.ISIC4, "9491")),
        ((Standards.CAEM2009, "94.92"), (Standards.ISIC4, "9492")),
        ((Standards.CAEM2009, "94.99"), (Standards.ISIC4, "9499")),
        ((Standards.CAEM2009, "95.11"), (Standards.ISIC4, "9511")),
        ((Standards.CAEM2009, "95.12"), (Standards.ISIC4, "9512")),
        ((Standards.CAEM2009, "95.21"), (Standards.ISIC4, "9521")),
        ((Standards.CAEM2009, "95.22"), (Standards.ISIC4, "9522")),
        ((Standards.CAEM2009, "95.23"), (Standards.ISIC4, "9523")),
        ((Standards.CAEM2009, "95.24"), (Standards.ISIC4, "9524")),
        ((Standards.CAEM2009, "95.25"), (Standards.ISIC4, "9529")),
        ((Standards.CAEM2009, "95.29"), (Standards.ISIC4, "9529")),
        ((Standards.CAEM2009, "96.01"), (Standards.ISIC4, "9601")),
        ((Standards.CAEM2009, "96.02"), (Standards.ISIC4, "9602")),
        ((Standards.CAEM2009, "96.03"), (Standards.ISIC4, "9603")),
        ((Standards.CAEM2009, "96.04"), (Standards.ISIC4, "9609")),
        ((Standards.CAEM2009, "96.09"), (Standards.ISIC4, "9609")),
        ((Standards.CAEM2009, "97.00"), (Standards.ISIC4, "9700")),
        ((Standards.CAEM2009, "98.10"), (Standards.ISIC4, "9810")),
        ((Standards.CAEM2009, "98.20"), (Standards.ISIC4, "9820")),
        ((Standards.CAEM2009, "99.00"), (Standards.ISIC4, "9900")),
    ],
)
