"""`CAEM2005 Standard <https://date.gov.md/ckan/ro/dataset/5188-clasificatorul-activitatilor-din-economia-moldovei-caem>`_."""

from ...types import Category, Classification, Standard, Standards

CAEM2005 = Standard(
    standard=Standards.CAEM2005,
    classes=[
        Classification("A", "AGRICULTURA, ECONOMIA VÎNATULUI ŞI SILVICULTURA", Category.SECTION),
        Classification("01", "AGRICULTURA, ECONOMIA VÎNATULUI ŞI SERVICII AUXILIARE", Category.DIVISION),
        Classification("01.1", "Cultura vegetală", Category.GROUP),
        Classification("01.11", "Cultura plantelor cerealiere, tehnice şi a plantelor furajere", Category.CLASS),
        Classification(
            "01.11.1", "Cultura cerealelor şi leguminoaselor boabe, inclusiv producerea seminţelor", Category.SUBCLASS
        ),
        Classification("01.11.2", "Cultura cartofului şi a materialului săditor", Category.SUBCLASS),
        Classification("01.11.3", "Cultura sfeclei de zahăr şi a seminţelor", Category.SUBCLASS),
        Classification("01.11.4", "Cultura plantelor oleaginoase şi a seminţelor", Category.SUBCLASS),
        Classification("01.11.5", "Cultura plantelor furajere şi a seminţelor", Category.SUBCLASS),
        Classification(
            "01.11.8",
            "Cultura tutunului, inclusiv prelucrarea primară: culesul şi uscarea frunzelor",
            Category.SUBCLASS,
        ),
        Classification("01.11.9", "Alte specializări în cultura plantelor", Category.SUBCLASS),
        Classification("01.12", "Cultura legumelor, pomicultura şi creşterea producţiei de pepinieră", Category.CLASS),
        Classification("01.12.1", "Cultura legumelor şi seminţelor", Category.SUBCLASS),
        Classification("01.12.2", "Cultura bostănoaselor şi seminţelor", Category.SUBCLASS),
        Classification("01.12.3", "Cultura florilor şi seminceră", Category.SUBCLASS),
        Classification("01.12.4", "Creşterea producţiei de pepinieră", Category.SUBCLASS),
        Classification("01.13", "Cultura fructelor", Category.CLASS),
        Classification(
            "01.13.1", "Cultura pomuşoarelor, fructelor, nucilor şi altor culturi fructifere", Category.SUBCLASS
        ),
        Classification(
            "01.13.2", "Cultura plantelor aromatice şi a culturilor pentru fabricarea băuturilor", Category.SUBCLASS
        ),
        Classification("01.13.3", "Cultura strugurilor", Category.SUBCLASS),
        Classification("01.2", "Creşterea animalelor", Category.GROUP),
        Classification("01.21", "Creşterea bovinelor", Category.CLASS),
        Classification("01.21.0", "Creşterea bovinelor", Category.SECTION),
        Classification("01.22", "Creşterea ovinelor, caprinelor, cabalinelor, măgarilor şi catîrilor", Category.CLASS),
        Classification("01.22.1", "Creşterea ovinelor şi caprinelor", Category.SUBCLASS),
        Classification("01.22.2", "Creşterea cabalinelor", Category.SUBCLASS),
        Classification("01.22.3", "Creşterea măgarilor şi catîrilor", Category.SUBCLASS),
        Classification("01.23", "Creşterea porcinelor, inclusiv a animalelor de prăsilă", Category.CLASS),
        Classification("01.23.0", "Creşterea porcinelor, inclusiv a animalelor de prăsilă", Category.SUBCLASS),
        Classification("01.24", "Creşterea păsărilor", Category.CLASS),
        Classification("01.24.1", "Creşterea păsărilor pentru carne, de prăsilă şi celor tinere", Category.SUBCLASS),
        Classification("01.24.2", "Producerea ouălor", Category.SUBCLASS),
        Classification("01.24.3", "Activităţi mixte (producerea cărnii şi ouălor)", Category.SUBCLASS),
        Classification("01.24.4", "Activitatea staţiunilor avicole de incubaţie", Category.SUBCLASS),
        Classification("01.25", "Creşterea altor specii de animale", Category.CLASS),
        Classification("01.25.1", "Apicultura", Category.SUBCLASS),
        Classification("01.25.2", "Creşterea altor specii de animale", Category.SUBCLASS),
        Classification("01.3", "Cultura vegetală asociată cu creşterea animalelor", Category.GROUP),
        Classification("01.30", "Cultura vegetală asociată cu creşterea animalelor", Category.CLASS),
        Classification("01.30.0", "Cultura vegetală asociată cu creşterea animalelor", Category.SUBCLASS),
        Classification(
            "01.4",
            "Servicii pentru agricultură şi servicii în creşterea animalelor (cu excepţia celor sanitar-veterinare)",
            Category.GROUP,
        ),
        Classification("01.41", "Servicii pentru agricultură", Category.CLASS),
        Classification("01.41.1", "Exploatarea sistemelor de irigare şi desecare", Category.SUBCLASS),
        Classification("01.41.2", "Servicii agrochimice", Category.SECTION),
        Classification("01.41.9", "Alte servicii în creşterea producţiei agricole", Category.SUBCLASS),
        Classification(
            "01.42", "Servicii în creşterea animalelor (cu excepţia celor sanitar-veterinare)", Category.CLASS
        ),
        Classification(
            "01.42.0", "Servicii în creşterea animalelor (cu excepţia celor sanitar-veterinare)", Category.SUBCLASS
        ),
        Classification("01.5", "Economia vînatului", Category.GROUP),
        Classification("01.50", "Economia vînatului", Category.CLASS),
        Classification("01.50.0", "Economia vînatului", Category.SUBCLASS),
        Classification("02", "SILVICULTURĂ, EXPLOATĂRI FORESTIERE ŞI SERVICII ANEXE", Category.DIVISION),
        Classification("02.0", "Silvicultură, exploatări forestiere şi servicii anexe", Category.GROUP),
        Classification("02.01", "Silvicultură şi exploatări forestiere", Category.CLASS),
        Classification("02.01.1", "Silvicultură", Category.SUBCLASS),
        Classification("02.01.2", "Exploatări forestiere", Category.SUBCLASS),
        Classification("02.01.3", "Recoltarea produselor accesorii ale pădurii", Category.SUBCLASS),
        Classification("02.02", "Servicii anexe silviculturii şi exploatărilor forestiere", Category.CLASS),
        Classification("02.02.0", "Servicii anexe silviculturii şi exploatărilor forestiere", Category.SUBCLASS),
        Classification("B", "PESCUITUL, PISCICULTURA", Category.SECTION),
        Classification("05", "PESCUITUL, PISCICULTURA", Category.DIVISION),
        Classification("05.0", "Pescuitul, activitatea crescătoriilor de peşte şi a fermelor de peşte", Category.GROUP),
        Classification("05.01", "Pescuitul", Category.CLASS),
        Classification("05.01.0", "Pescuitul", Category.SUBCLASS),
        Classification(
            "05.02", "Piscicultura, activitatea crescătoriilor de peşte şi a fermelor de peşte", Category.CLASS
        ),
        Classification(
            "05.02.0", "Piscicultura, activitatea crescătoriilor de peşte şi a fermelor de peşte", Category.SUBCLASS
        ),
        Classification("C", "INDUSTRIA EXTRACTIVĂ", Category.SECTION),
        Classification("10", "EXTRACŢIA HUILEI, LIGNITULUI; PREPARAREA TURBEI", Category.DIVISION),
        Classification("10.1", "Extracţia şi aglomerarea huilei", Category.GROUP),
        Classification("10.10", "Extracţia şi aglomerarea huilei", Category.CLASS),
        Classification("10.10.0", "Extracţia şi aglomerarea huilei", Category.SUBCLASS),
        Classification("10.2", "Extracţia şi aglomerarea lignitului (cărbunelui brun)", Category.GROUP),
        Classification("10.20", "Extracţia şi aglomerarea lignitului (cărbunelui brun)", Category.CLASS),
        Classification("10.20.0", "Extracţia şi aglomerarea lignitului (cărbunelui brun)", Category.SUBCLASS),
        Classification("10.3", "Extracţia şi aglomerarea turbei", Category.GROUP),
        Classification("10.30", "Extracţia şi aglomerarea turbei", Category.CLASS),
        Classification("10.30.0", "Extracţia şi aglomerarea turbei", Category.SUBCLASS),
        Classification(
            "11",
            "EXTRACŢIA PETROLULUI BRUT ŞI A GAZELOR NA­TURALE; SERVICII ANEXE EXTRACŢIEI PETROLU­LUI ŞI GAZELOR NATURALE",
            Category.DIVISION,
        ),
        Classification("11.1", "Extracţia petrolului brut şi a gazelor naturale", Category.GROUP),
        Classification("11.10", "Extracţia petrolului brut şi a gazelor naturale", Category.CLASS),
        Classification("11.10.1", "Extracţia petrolului brut şi a gazelor asociate", Category.SUBCLASS),
        Classification("11.10.2", "Extracţia gazelor naturale", Category.SUBCLASS),
        Classification("11.2", "Servicii anexe extracţiei petrolului  şi gazelor naturale", Category.GROUP),
        Classification("11.20", "Servicii anexe extracţiei petrolului  şi gazelor naturale", Category.CLASS),
        Classification("11.20.0", "Servicii anexe extracţiei petrolului  şi gazelor naturale", Category.SUBCLASS),
        Classification("12", "EXTRACŢIA MINEREURILOR RADIOACTIVE", Category.DIVISION),
        Classification("12.0", "Extracţia minereurilor radioactive", Category.GROUP),
        Classification("12.00", "Extracţia minereurilor radioactive", Category.CLASS),
        Classification("12.00.0", "Extracţia minereurilor radioactive", Category.SUBCLASS),
        Classification("13", "EXTRACŢIA MINEREURILOR METALIFERE", Category.DIVISION),
        Classification("13.1", "Extracţia minereurilor feroase", Category.GROUP),
        Classification("13.10", "Extracţia minereurilor feroase", Category.CLASS),
        Classification("13.10.0", "Extracţia minereurilor feroase", Category.SUBCLASS),
        Classification("13.2", "Extracţia minereurilor neferoase", Category.GROUP),
        Classification("13.20", "Extracţia minereurilor neferoase", Category.CLASS),
        Classification("13.20.0", "Extracţia minereurilor neferoase", Category.SUBCLASS),
        Classification("14", "ALTE RAMURI ALE INDUSTRIEI EXTRACTIVE", Category.DIVISION),
        Classification("14.1", "Exploatarea carierelor de piatră", Category.GROUP),
        Classification("14.11", "Extracţia pietrei pentru construcţii", Category.CLASS),
        Classification("14.11.0", "Extracţia pietrei pentru construcţii", Category.SUBCLASS),
        Classification("14.12", "Extracţia pietrei calcaroase, a ghipsului şi cretei", Category.CLASS),
        Classification("14.12.0", "Extracţia pietrei calcaroase, a ghipsului şi cretei", Category.SUBCLASS),
        Classification("14.13", "Extracţia şisturilor", Category.CLASS),
        Classification("14.13.0", "Extracţia şisturilor", Category.SUBCLASS),
        Classification("14.2", "Extracţia nisipului şi argilei", Category.GROUP),
        Classification("14.21", "Extracţia nisipului şi pietrişului", Category.CLASS),
        Classification("14.21.0", "Extracţia nisipului şi pietrişului", Category.SUBCLASS),
        Classification("14.22", "Extracţia argilei şi caolinului", Category.CLASS),
        Classification("14.22.1", "Extracţia materiei prime pentru ceramică", Category.SUBCLASS),
        Classification(
            "14.22.2", "Extracţia şi înnobilarea materiei prime pentru metalurgia feroasă", Category.SUBCLASS
        ),
        Classification(
            "14.3", "Extracţia minereurilor pentru industria chimică şi prepararea îngrăşămintelor", Category.GROUP
        ),
        Classification(
            "14.30", "Extracţia minereurilor pentru industria chimică şi prepararea îngrăşămintelor", Category.CLASS
        ),
        Classification(
            "14.30.0",
            "Extracţia minereurilor pentru industria chimică şi prepararea îngrăşămintelor",
            Category.SUBCLASS,
        ),
        Classification("14.4", "Extracţia sării", Category.GROUP),
        Classification("14.40", "Extracţia sării", Category.CLASS),
        Classification("14.40.0", "Extracţia sării", Category.SUBCLASS),
        Classification("14.5", "Alte ramuri ale industriei extractive, neincluse în alte categorii", Category.GROUP),
        Classification("14.50", "Alte ramuri ale industriei extractive, neincluse în alte categorii", Category.CLASS),
        Classification("14.50.1", "Extracţia minereurilor de azbest", Category.SUBCLASS),
        Classification("14.50.2", "Extracţia şi înnobilarea minereurilor nemetalifere", Category.SUBCLASS),
        Classification(
            "14.50.3",
            "Extracţia materiei prime pentru producerea de agregate poroase naturale şi artificiale",
            Category.SUBCLASS,
        ),
        Classification("14.50.4", "Extracţia materiei prime pentru industria sticlei", Category.SUBCLASS),
        Classification(
            "14.50.5",
            "Extracţia pietrelor preţioase şi semipreţioase, nestematelor şi a chihlimbarului",
            Category.SUBCLASS,
        ),
        Classification("D", "INDUSTRIA PRELUCRĂTOARE", Category.SECTION),
        Classification("15", "INDUSTRIA ALIMENTARĂ ŞI A BĂUTURILOR", Category.DIVISION),
        Classification(
            "15.1", "Producţia, prelucrarea şi conservarea cărnii şi a produselor din carne", Category.GROUP
        ),
        Classification("15.11", "Producţia cărnii", Category.CLASS),
        Classification("15.11.0", "Producţia cărnii", Category.SUBCLASS),
        Classification("15.12", "Producţia cărnii de pasăre", Category.CLASS),
        Classification("15.12.0", "Producţia cărnii de pasăre", Category.SUBCLASS),
        Classification("15.13", "Produse din carne, carne de pasăre şi de iepure", Category.CLASS),
        Classification("15.13.0", "Produse din carne, carne de pasăre şi de iepure", Category.SUBCLASS),
        Classification("15.2", "Prelucrarea şi conservarea peştelui şi a produselor din peşte", Category.GROUP),
        Classification("15.20", "Prelucrarea şi conservarea peştelui şi a produselor din peşte", Category.CLASS),
        Classification("15.20.0", "Prelucrarea şi conservarea peştelui şi a produselor din peşte", Category.SUBCLASS),
        Classification("15.3", "Prelucrarea şi conservarea fructelor şi legumelor", Category.GROUP),
        Classification("15.31", "Prelucrarea şi conservarea cartofului", Category.CLASS),
        Classification("15.31.0", "Prelucrarea şi conservarea cartofului", Category.SUBCLASS),
        Classification("15.32", "Prepararea sucurilor din fructe şi legume", Category.CLASS),
        Classification("15.32.0", "Prepararea sucurilor din fructe şi legume", Category.SUBCLASS),
        Classification(
            "15.33",
            "Prelucrarea şi conservarea fructelor şi legumelor neincluse în alte categorii (exclusiv a cartofului)",
            Category.CLASS,
        ),
        Classification(
            "15.33.0",
            "Prelucrarea şi conservarea fructelor şi legumelor neincluse în alte categorii (exclusiv a cartofului)",
            Category.SUBCLASS,
        ),
        Classification("15.4", "Fabricarea uleiurilor şi grăsimilor vegetale şi animale", Category.GROUP),
        Classification("15.41", "Fabricarea uleiurilor şi grăsimilor brute", Category.CLASS),
        Classification("15.41.0", "Fabricarea uleiurilor şi grăsimilor brute", Category.SUBCLASS),
        Classification("15.42", "Fabricarea uleiurilor şi grăsimilor rafinate", Category.CLASS),
        Classification("15.42.0", "Fabricarea uleiurilor şi grăsimilor rafinate", Category.SUBCLASS),
        Classification("15.43", "Fabricarea margarinei şi a produselor comestibile similare", Category.CLASS),
        Classification("15.43.0", "Fabricarea margarinei şi a produselor comestibile similare", Category.SUBCLASS),
        Classification("15.5", "Fabricarea produselor lactate", Category.GROUP),
        Classification("15.51", "Prelucrarea laptelui şi fabricarea produselor lactate", Category.CLASS),
        Classification("15.51.0", "Prelucrarea laptelui şi fabricarea produselor lactate", Category.SUBCLASS),
        Classification("15.52", "Fabricarea îngheţatei", Category.CLASS),
        Classification("15.52.0", "Fabricarea îngheţatei", Category.SUBCLASS),
        Classification(
            "15.6", "Fabricarea produselor de morărit, a amidonului şi a produselor din amidon", Category.GROUP
        ),
        Classification("15.61", "Fabricarea produselor de morărit", Category.CLASS),
        Classification("15.61.1", "Fabricarea făinii", Category.SUBCLASS),
        Classification("15.61.2", "Fabricarea crupelor", Category.SUBCLASS),
        Classification("15.61.3", "Fabricarea produselor concentrate alimentare", Category.SUBCLASS),
        Classification("15.62", "Fabricarea amidonului şi a produselor din amidon", Category.CLASS),
        Classification("15.62.0", "Fabricarea amidonului şi a produselor din amidon", Category.SUBCLASS),
        Classification("15.7", "Fabricarea nutreţurilor gata pentru animale", Category.GROUP),
        Classification("15.71", "Fabricarea nutreţurilor gata pentru animale întreţinute la ferme", Category.CLASS),
        Classification(
            "15.71.0", "Fabricarea nutreţurilor gata pentru animale întreţinute la ferme", Category.SUBCLASS
        ),
        Classification("15.72", "Fabricarea nutreţurilor gata destinate animalelor domestice", Category.CLASS),
        Classification("15.72.0", "Fabricarea nutreţurilor gata destinate animalelor domestice", Category.SUBCLASS),
        Classification("15.8", "Fabricarea altor produse alimentare", Category.GROUP),
        Classification("15.81", "Fabricarea pîinii şi a produselor de patiserie proaspete", Category.CLASS),
        Classification("15.81.0", "Fabricarea pîinii şi a produselor de patiserie proaspete", Category.SUBCLASS),
        Classification(
            "15.82",
            "Fabricarea pesmeţilor şi biscuiţilor, a pişcoturilor cu termen de păstrare de lungă durată",
            Category.CLASS,
        ),
        Classification(
            "15.82.0",
            "Fabricarea pesmeţilor şi biscuiţilor, a pişcoturilor cu termen de păstrare de lungă durată",
            Category.SUBCLASS,
        ),
        Classification("15.83", "Fabricarea zahărului", Category.CLASS),
        Classification("15.83.0", "Fabricarea zahărului", Category.SUBCLASS),
        Classification("15.84", "Fabricarea de cacao, ciocolată şi produse zaharoase de cofetărie", Category.CLASS),
        Classification(
            "15.84.0", "Fabricarea de cacao, ciocolată şi produse zaharoase de cofetărie", Category.SUBCLASS
        ),
        Classification("15.85", "Fabricarea macaroanelor, tăieţeilor şi produselor făinoase analoage", Category.CLASS),
        Classification(
            "15.85.0", "Fabricarea macaroanelor, tăieţeilor şi produselor făinoase analoage", Category.SUBCLASS
        ),
        Classification("15.86", "Prelucrarea ceaiului şi cafelei", Category.CLASS),
        Classification("15.86.0", "Prelucrarea ceaiului şi cafelei", Category.SUBCLASS),
        Classification("15.87", "Fabricarea condimentelor şi mirodeniilor", Category.CLASS),
        Classification("15.87.0", "Fabricarea condimentelor şi mirodeniilor", Category.SUBCLASS),
        Classification(
            "15.88",
            "Fabricarea produselor pentru alimentaţia copiilor şi a produselor alimentare dietetice",
            Category.CLASS,
        ),
        Classification(
            "15.88.0",
            "Fabricarea produselor pentru alimentaţia copiilor şi a produselor alimentare dietetice",
            Category.SUBCLASS,
        ),
        Classification("15.89", "Fabricarea altor produse alimentare, neincluse în alte categorii", Category.CLASS),
        Classification("15.89.1", "Fabricarea supelor, bulionurilor şi a produselor din ouă", Category.SUBCLASS),
        Classification("15.89.2", "Fabricarea drojdiilor", Category.SUBCLASS),
        Classification(
            "15.89.9", "Fabricarea altor produse alimentare, neincluse în alte categorii", Category.SUBCLASS
        ),
        Classification("15.9", "Fabricarea băuturilor", Category.GROUP),
        Classification("15.91", "Fabricarea băuturilor alcoolice distilate", Category.CLASS),
        Classification("15.91.0", "Fabricarea băuturilor alcoolice distilate", Category.SUBCLASS),
        Classification("15.92", "Fabricarea alcoolului etilic din materiale fermentate", Category.CLASS),
        Classification("15.92.0", "Fabricarea alcoolului etilic din materiale fermentate", Category.SUBCLASS),
        Classification("15.93", "Fabricarea vinului", Category.CLASS),
        Classification("15.93.0", "Fabricarea vinului", Category.SUBCLASS),
        Classification("15.94", "Fabricarea cidrului", Category.CLASS),
        Classification("15.94.0", "Fabricarea cidrului", Category.SUBCLASS),
        Classification("15.95", "Fabricarea altor băuturi nedistilate din materiale fermentate", Category.CLASS),
        Classification("15.95.0", "Fabricarea altor băuturi nedistilate din materiale fermentate", Category.SUBCLASS),
        Classification("15.96", "Fabricarea berii", Category.CLASS),
        Classification("15.96.0", "Fabricarea berii", Category.SUBCLASS),
        Classification("15.97", "Fabricarea malţului", Category.CLASS),
        Classification("15.97.0", "Fabricarea malţului", Category.SUBCLASS),
        Classification("15.98", "Fabricarea apei minerale şi a băuturilor răcoritoare", Category.CLASS),
        Classification("15.98.0", "Fabricarea apei minerale şi a băuturilor răcoritoare", Category.SUBCLASS),
        Classification("16", "FABRICAREA PRODUSELOR DE TUTUN", Category.DIVISION),
        Classification("16.0", "Fabricarea produselor de tutun", Category.GROUP),
        Classification("16.00", "Fabricarea produselor de tutun", Category.CLASS),
        Classification("16.00.0", "Fabricarea produselor de tutun", Category.SUBCLASS),
        Classification("17", "FABRICAREA PRODUSELOR TEXTILE", Category.DIVISION),
        Classification("17.1", "Pregătirea fibrelor şi filarea în fire", Category.GROUP),
        Classification("17.11", "Pregătirea fibrelor şi filarea în fire tip bumbac", Category.CLASS),
        Classification("17.11.1", "Pregătirea fibrelor tip bumbac", Category.SUBCLASS),
        Classification("17.11.2", "Filarea în fire a fibrelor tip bumbac", Category.SUBCLASS),
        Classification("17.12", "Pregătirea fibrelor şi filarea în fire tip lînă cardată", Category.CLASS),
        Classification("17.12.1", "Pregătirea fibrelor din lînă cardată", Category.SUBCLASS),
        Classification("17.12.2", "Filarea în fire tip lînă cardată", Category.SUBCLASS),
        Classification("17.13", "Pregătirea fibrelor din lînă şi filarea în fire tip lînă pieptănată", Category.CLASS),
        Classification("17.13.1", "Pregătirea fibrelor din lînă pieptănată", Category.SUBCLASS),
        Classification("17.13.2", "Filarea în fire tip lînă pieptănată", Category.SUBCLASS),
        Classification("17.14", "Pregătirea fibrelor şi filarea în fire tip in", Category.CLASS),
        Classification("17.14.1", "Pregătirea fibrelor tip in", Category.SUBCLASS),
        Classification("17.14.2", "Filarea în fire tip in", Category.SUBCLASS),
        Classification(
            "17.15", "Pregătirea şi răsucirea mătăsii naturale şi artificiale şi a fibrelor sintetice", Category.CLASS
        ),
        Classification("17.15.1", "Pregătirea fibrelor de mătase", Category.SUBCLASS),
        Classification("17.15.2", "Producţia firelor de mătase", Category.SUBCLASS),
        Classification("17.16", "Fabricarea aţei pentru cusut", Category.CLASS),
        Classification("17.16.1", "Fabricarea aţei din bumbac", Category.SUBCLASS),
        Classification("17.16.2", "Fabricarea aţei din in", Category.SUBCLASS),
        Classification("17.16.3", "Fabricarea aţei din mătase", Category.SUBCLASS),
        Classification("17.16.4", "Fabricarea aţei din alte tipuri de fibre", Category.SUBCLASS),
        Classification(
            "17.17", "Pregătirea fibrelor şi filarea în fire a altor tipuri de fibre textile", Category.CLASS
        ),
        Classification("17.17.1", "Pregătirea altor tipuri de fibre", Category.SUBCLASS),
        Classification("17.17.2", "Filarea în fire a altor tipuri de fibre", Category.SUBCLASS),
        Classification("17.2", "Ţesătorie", Category.GROUP),
        Classification("17.21", "Producţia de ţesături din bumbac", Category.CLASS),
        Classification("17.21.0", "Producţia de ţesături din bumbac", Category.SUBCLASS),
        Classification("17.22", "Producţia de ţesături din lînă cardată", Category.CLASS),
        Classification("17.22.0", "Producţia de ţesături din lînă cardată", Category.SUBCLASS),
        Classification("17.23", "Producţia de ţesături din lînă pieptănată", Category.CLASS),
        Classification("17.23.0", "Producţia de ţesături din lînă pieptănată", Category.SUBCLASS),
        Classification("17.24", "Producţia de ţesături din mătase", Category.CLASS),
        Classification("17.24.0", "Producţia de ţesături din mătase", Category.SUBCLASS),
        Classification("17.25", "Producţia de ţesături din alte materiale", Category.CLASS),
        Classification("17.25.1", "Producţia de ţesături din in", Category.SUBCLASS),
        Classification("17.25.9", "Producţia altor tipuri de ţesături", Category.SUBCLASS),
        Classification("17.3", "Finisarea ţesăturilor", Category.GROUP),
        Classification("17.30", "Finisarea ţesăturilor", Category.CLASS),
        Classification("17.30.0", "Finisarea ţesăturilor", Category.SUBCLASS),
        Classification(
            "17.4", "Fabricarea de articole confecţionate din textile, cu excepţia îmbrăcămintei", Category.GROUP
        ),
        Classification(
            "17.40", "Fabricarea de articole confecţionate din textile, cu excepţia îmbrăcămintei", Category.CLASS
        ),
        Classification(
            "17.40.0", "Fabricarea de articole confecţionate din textile, cu excepţia îmbrăcămintei", Category.SUBCLASS
        ),
        Classification("17.5", "Fabricarea altor articole textile", Category.GROUP),
        Classification("17.51", "Fabricarea de covoare şi preşuri (mochete)", Category.CLASS),
        Classification("17.51.0", "Fabricarea de covoare şi preşuri (mochete)", Category.SUBCLASS),
        Classification("17.52", "Fabricarea de frînghii, funii, sfori şi plase", Category.CLASS),
        Classification("17.52.1", "Fabricarea de frînghii, funii, sfori", Category.SUBCLASS),
        Classification("17.52.2", "Fabricarea articolelor din funii şi plase", Category.SUBCLASS),
        Classification("17.53", "Fabricarea de textile neţesute şi articole din acestea", Category.CLASS),
        Classification("17.53.0", "Fabricarea de textile neţesute şi articole din acestea", Category.SUBCLASS),
        Classification("17.54", "Fabricarea altor articole textile, neincluse în alte categorii", Category.CLASS),
        Classification("17.54.1", "Fabricarea de galanterie textilă", Category.SUBCLASS),
        Classification("17.54.2", "Fabricarea articolelor de pîslă", Category.SUBCLASS),
        Classification("17.54.9", "Fabricarea altor articole textile", Category.SUBCLASS),
        Classification("17.6", "Fabricarea de metraje prin tricotare sau croşetare", Category.GROUP),
        Classification("17.60", "Fabricarea de metraje prin tricotare sau croşetare", Category.CLASS),
        Classification("17.60.0", "Fabricarea de metraje prin tricotare sau croşetare", Category.SUBCLASS),
        Classification("17.7", "Fabricarea de articole tricotate şi croşetate", Category.GROUP),
        Classification("17.71", "Fabricarea de articole de ciorăpărie prin tricotare sau croşetare", Category.CLASS),
        Classification(
            "17.71.0", "Fabricarea de articole de ciorăpărie prin tricotare sau croşetare", Category.SUBCLASS
        ),
        Classification("17.72", "Fabricarea de pulovere, veste şi articole similare", Category.CLASS),
        Classification("17.72.0", "Fabricarea de pulovere, veste şi articole similare", Category.SUBCLASS),
        Classification(
            "18", "FABRICAREA DE ARTICOLE DE ÎMBRĂCĂMINTE; PREPARAREA ŞI VOPSIREA BLĂNURILOR", Category.DIVISION
        ),
        Classification("18.1", "Fabricarea de articole de îmbrăcăminte din piele", Category.GROUP),
        Classification("18.10", "Fabricarea de articole de îmbrăcăminte din piele", Category.CLASS),
        Classification("18.10.0", "Fabricarea de articole de îmbrăcăminte din piele", Category.SUBCLASS),
        Classification("18.2", "Fabricarea de articole de îmbrăcăminte din materiale textile", Category.GROUP),
        Classification("18.21", "Fabricarea de articole de îmbrăcăminte pentru lucru", Category.CLASS),
        Classification("18.21.0", "Fabricarea de articole de îmbrăcăminte pentru lucru", Category.SUBCLASS),
        Classification("18.22", "Fabricarea de articole de îmbrăcăminte", Category.CLASS),
        Classification("18.22.0", "Fabricarea de articole de îmbrăcăminte", Category.SUBCLASS),
        Classification("18.23", "Fabricarea de articole de lenjerie de corp", Category.CLASS),
        Classification("18.23.0", "Fabricarea de articole de lenjerie de corp", Category.SUBCLASS),
        Classification("18.24", "Fabricarea altor articole de îmbrăcăminte şi accesorii", Category.CLASS),
        Classification("18.24.1", "Fabricarea de articole de acoperit capul", Category.SUBCLASS),
        Classification("18.24.9", "Fabricarea altor articole de îmbrăcăminte şi accesorii", Category.SUBCLASS),
        Classification(
            "18.3", "Prepararea şi vopsirea blănurilor; confecţionarea articolelor din blană", Category.GROUP
        ),
        Classification(
            "18.30", "Prepararea şi vopsirea blănurilor; confecţionarea articolelor din blană", Category.CLASS
        ),
        Classification("18.30.1", "Prepararea şi vopsirea blănurilor", Category.SUBCLASS),
        Classification("18.30.2", "Fabricarea blănurilor artificiale", Category.SUBCLASS),
        Classification("18.30.3", "Fabricarea de articole din blană naturală şi artificială", Category.SUBCLASS),
        Classification("19", "PRODUCŢIA DE PIEI, DE ARTICOLE DIN PIELE ŞI FABRICAREA ÎNCĂLŢĂMINTEI", Category.DIVISION),
        Classification("19.1", "Tăbăcirea şi prepararea pieilor", Category.GROUP),
        Classification("19.10", "Tăbăcirea şi prepararea pieilor", Category.CLASS),
        Classification("19.10.1", "Producţia de piei naturale", Category.SUBCLASS),
        Classification("19.10.2", "Producţia de piei artificiale şi materiale peliculare", Category.SUBCLASS),
        Classification("19.2", "Fabricarea de articole de voiaj şi de marochinărie", Category.GROUP),
        Classification("19.20", "Fabricarea de articole de voiaj şi de marochinărie", Category.CLASS),
        Classification(
            "19.20.1", "Fabricarea de articole de voiaj, de marochinărie şi articole similare", Category.SUBCLASS
        ),
        Classification("19.20.2", "Fabricarea de articole de harnaşament", Category.SUBCLASS),
        Classification("19.3", "Fabricarea încălţămintei", Category.GROUP),
        Classification("19.30", "Fabricarea încălţămintei", Category.CLASS),
        Classification("19.30.0", "Fabricarea încălţămintei", Category.SUBCLASS),
        Classification("20", "PRELUCRAREA LEMNULUI ŞI FABRICAREA ARTICOLELOR DIN LEMN", Category.DIVISION),
        Classification("20.1", "Prelucrarea brută a lemnului şi impregnarea lemnului", Category.GROUP),
        Classification("20.10", "Prelucrarea brută a lemnului şi impregnarea lemnului", Category.CLASS),
        Classification("20.10.1", "Prelucrarea brută a lemnului", Category.SUBCLASS),
        Classification("20.10.2", "Tratarea chimică a lemnului", Category.SUBCLASS),
        Classification(
            "20.10.3", "Fabricarea de pardoseli din lemn necomplete, inclusiv parchete neasamblate", Category.SUBCLASS
        ),
        Classification("20.2", "Producţia de panel din lemn", Category.GROUP),
        Classification("20.20", "Producţia de panel din lemn", Category.CLASS),
        Classification("20.20.0", "Producţia de panel din lemn", Category.SUBCLASS),
        Classification("20.3", "Fabricarea de elemente de dulgherie şi tîmplărie pentru construcţii", Category.GROUP),
        Classification("20.30", "Fabricarea de elemente de dulgherie şi tîmplărie pentru construcţii", Category.CLASS),
        Classification("20.30.1", "Fabricarea articolelor din lemn", Category.SUBCLASS),
        Classification("20.30.2", "Fabricarea de case prefabricate din lemn", Category.SUBCLASS),
        Classification(
            "20.30.3",
            "Fabricarea de clădiri şi încăperi din lemn tip container, monolite şi demontabile",
            Category.SUBCLASS,
        ),
        Classification("20.4", "Producţia de ambalaje din lemn", Category.GROUP),
        Classification("20.40", "Producţia de ambalaje din lemn", Category.CLASS),
        Classification("20.40.0", "Producţia de ambalaje din lemn", Category.SUBCLASS),
        Classification(
            "20.5", "Fabricarea altor articole din lemn, plută, împletituri de nuiele şi paie", Category.GROUP
        ),
        Classification("20.51", "Fabricarea altor articole din lemn", Category.CLASS),
        Classification("20.51.1", "Fabricarea diferitelor articole din lemn", Category.SUBCLASS),
        Classification("20.51.2", "Fabricarea articolelor decorative din lemn", Category.SUBCLASS),
        Classification("20.52", "Fabricarea articolelor din plută, din împletituri de nuiele şi paie", Category.CLASS),
        Classification(
            "20.52.0", "Fabricarea articolelor din plută, din împletituri de nuiele şi paie", Category.SUBCLASS
        ),
        Classification("21", "FABRICAREA HÎRTIEI ŞI CARTONULUI", Category.DIVISION),
        Classification("21.1", "Fabricarea celulozei, hîrtiei şi cartonului", Category.GROUP),
        Classification("21.11", "Fabricarea celulozei", Category.CLASS),
        Classification("21.11.0", "Fabricarea celulozei", Category.SUBCLASS),
        Classification("21.12", "Fabricarea hîrtiei şi cartonului", Category.CLASS),
        Classification("21.12.0", "Fabricarea hîrtiei şi cartonului", Category.SUBCLASS),
        Classification("21.2", "Fabricarea articolelor din hîrtie şi carton", Category.GROUP),
        Classification(
            "21.21", "Fabricarea hîrtiei şi cartonului ondulat, a ambalajelor din hîrtie şi carton", Category.CLASS
        ),
        Classification("21.21.1", "Fabricarea hîrtiei şi cartonului ondulat", Category.SUBCLASS),
        Classification("21.21.2", "Fabricarea ambalajelor din hîrtie şi carton", Category.SUBCLASS),
        Classification("21.22", "Fabricarea articolelor din hîrtie de uz gospodăresc şi sanitar", Category.CLASS),
        Classification("21.22.0", "Fabricarea articolelor din hîrtie de uz gospodăresc şi sanitar", Category.SUBCLASS),
        Classification("21.23", "Fabricarea articolelor de papetărie", Category.CLASS),
        Classification("21.23.0", "Fabricarea articolelor de papetărie", Category.SUBCLASS),
        Classification("21.24", "Fabricarea tapetului", Category.CLASS),
        Classification("21.24.0", "Fabricarea tapetului", Category.SUBCLASS),
        Classification("21.25", "Fabricarea altor articole din hîrtie şi carton", Category.CLASS),
        Classification("21.25.0", "Fabricarea altor articole din hîrtie şi carton", Category.SUBCLASS),
        Classification("22", "EDITURI, POLIGRAFIE ŞI REPRODUCEREA MATERIALELOR INFORMATIVE", Category.DIVISION),
        Classification("22.1", "Edituri", Category.GROUP),
        Classification("22.11", "Editarea cărţilor, broşurilor şi altor publicaţii", Category.CLASS),
        Classification("22.11.0", "Editarea cărţilor, broşurilor şi altor publicaţii", Category.SUBCLASS),
        Classification("22.12", "Editarea ziarelor", Category.CLASS),
        Classification("22.12.0", "Editarea ziarelor", Category.SUBCLASS),
        Classification("22.13", "Editarea revistelor şi periodicelor", Category.CLASS),
        Classification("22.13.0", "Editarea revistelor şi periodicelor", Category.SUBCLASS),
        Classification("22.14", "Editarea înregistrărilor pe suporţi", Category.CLASS),
        Classification("22.14.0", "Editarea înregistrărilor pe suporţi", Category.SUBCLASS),
        Classification("22.15", "Alte activităţi de editare", Category.CLASS),
        Classification("22.15.0", "Alte activităţi de editare", Category.SUBCLASS),
        Classification("22.2", "Tipărire şi activităţi anexe", Category.GROUP),
        Classification("22.21", "Tipărirea ziarelor", Category.CLASS),
        Classification("22.21.0", "Tipărirea ziarelor", Category.SUBCLASS),
        Classification("22.22", "Tipărirea altor publicaţii (cărţi, broşuri etc.)", Category.CLASS),
        Classification("22.22.0", "Tipărirea altor publicaţii (cărţi, broşuri etc.)", Category.SUBCLASS),
        Classification("22.23", "Legătorie şi finisare", Category.CLASS),
        Classification("22.23.0", "Legătorie şi finisare", Category.SUBCLASS),
        Classification("22.24", "Producţia formelor de tipar", Category.CLASS),
        Classification("22.24.0", "Producţia formelor de tipar", Category.SUBCLASS),
        Classification("22.25", "Alte activităţi anexe poligrafiei", Category.CLASS),
        Classification("22.25.0", "Alte activităţi anexe poligrafiei", Category.SUBCLASS),
        Classification("22.3", "Reproducerea înregistrărilor pe suporţi", Category.GROUP),
        Classification("22.31", "Reproducerea pe suporţi a înregistrărilor audio", Category.CLASS),
        Classification("22.31.0", "Reproducerea pe suporţi a înregistrărilor audio", Category.SUBCLASS),
        Classification("22.32", "Reproducerea pe suporţi a înregistrărilor video", Category.CLASS),
        Classification("22.32.0", "Reproducerea pe suporţi a înregistrărilor video", Category.SUBCLASS),
        Classification("22.33", "Reproducerea pe suporţi a înregistrărilor cu caracter informatic", Category.CLASS),
        Classification(
            "22.33.0", "Reproducerea pe suporţi a înregistrărilor cu caracter informatic", Category.SUBCLASS
        ),
        Classification(
            "23",
            "COCSIFICAREA CĂRBUNELUI, DISTILAREA ŢIŢEIULUI ŞI TRATAREA COMBUSTIBILILOR NUCLEARI",
            Category.DIVISION,
        ),
        Classification("23.1", "Cocsificarea cărbunelui", Category.GROUP),
        Classification("23.10", "Cocsificarea cărbunelui", Category.CLASS),
        Classification("23.10.0", "Cocsificarea cărbunelui", Category.SUBCLASS),
        Classification("23.2", "Distilarea ţiţeiului", Category.GROUP),
        Classification("23.20", "Distilarea ţiţeiului", Category.CLASS),
        Classification("23.20.0", "Distilarea ţiţeiului", Category.SUBCLASS),
        Classification("23.3", "Producţia şi prelucrarea combustibililor nucleari", Category.GROUP),
        Classification("23.30", "Producţia şi prelucrarea combustibililor nucleari", Category.CLASS),
        Classification("23.30.0", "Producţia şi prelucrarea combustibililor nucleari", Category.SUBCLASS),
        Classification("24", "INDUSTRIA CHIMICĂ", Category.DIVISION),
        Classification("24.1", "Fabricarea produselor chimice de bază", Category.GROUP),
        Classification("24.11", "Fabricarea gazului industrial", Category.CLASS),
        Classification("24.11.0", "Fabricarea gazului industrial", Category.SUBCLASS),
        Classification("24.12", "Fabricarea coloranţilor şi pigmenţilor", Category.CLASS),
        Classification("24.12.0", "Fabricarea coloranţilor şi pigmenţilor", Category.SUBCLASS),
        Classification("24.13", "Fabricarea altor produse chimice anorganice de bază", Category.CLASS),
        Classification("24.13.0", "Fabricarea altor produse chimice anorganice de bază", Category.SUBCLASS),
        Classification("24.14", "Fabricarea altor produse chimice organice de bază", Category.CLASS),
        Classification("24.14.1", "Fabricarea substanţelor de tăbăcire", Category.SUBCLASS),
        Classification("24.14.9", "Fabricarea altor produse chimice organice de bază", Category.SUBCLASS),
        Classification("24.15", "Fabricarea îngrăşămintelor şi produselor azotoase", Category.CLASS),
        Classification("24.15.1", "Fabricarea îngrăşămintelor", Category.SUBCLASS),
        Classification("24.15.2", "Fabricarea componentelor azotoase", Category.SUBCLASS),
        Classification("24.16", "Fabricarea materialelor plastice primare", Category.CLASS),
        Classification("24.16.0", "Fabricarea materialelor plastice primare", Category.SUBCLASS),
        Classification("24.17", "Fabricarea cauciucului sintetic", Category.CLASS),
        Classification("24.17.0", "Fabricarea cauciucului sintetic", Category.SUBCLASS),
        Classification("24.2", "Fabricarea produselor agrochimice", Category.GROUP),
        Classification("24.20", "Fabricarea produselor agrochimice", Category.CLASS),
        Classification("24.20.0", "Fabricarea produselor agrochimice", Category.SUBCLASS),
        Classification("24.3", "Fabricarea lacurilor şi vopselelor", Category.GROUP),
        Classification("24.30", "Fabricarea lacurilor şi vopselelor", Category.CLASS),
        Classification(
            "24.30.1",
            "Fabricarea vopselelor, lacurilor, emailurilor şi a pigmenţilor minerali pentru ele",
            Category.SUBCLASS,
        ),
        Classification("24.30.2", "Fabricarea solvenţilor şi diluanţilor pentru lacuri şi vopsele", Category.SUBCLASS),
        Classification("24.4", "Fabricarea de medicamente şi produse farmaceutice", Category.GROUP),
        Classification("24.41", "Fabricarea produselor farmaceutice de bază", Category.CLASS),
        Classification("24.41.0", "Fabricarea produselor farmaceutice de bază", Category.SUBCLASS),
        Classification("24.42", "Fabricarea preparatelor farmaceutice", Category.CLASS),
        Classification(
            "24.42.1",
            "Fabricarea preparatelor farmaceutice pentru scopuri terapeutice sau profilactice",
            Category.SUBCLASS,
        ),
        Classification("24.42.2", "Fabricarea preparatelor medicale pentru medicina veterinară", Category.SUBCLASS),
        Classification("24.42.3", "Fabricarea cimentului pentru utilizarea în stomatologie", Category.SUBCLASS),
        Classification(
            "24.5",
            "Fabricarea săpunurilor, detergenţilor, a produselor de întreţinere, de parfumerie şi cosmetice",
            Category.GROUP,
        ),
        Classification("24.51", "Fabricarea săpunurilor, detergenţilor, a produselor de întreţinere", Category.CLASS),
        Classification(
            "24.51.0", "Fabricarea săpunurilor, detergenţilor, a produselor de întreţinere", Category.SUBCLASS
        ),
        Classification("24.52", "Fabricarea parfumurilor şi a produselor cosmetice", Category.CLASS),
        Classification("24.52.0", "Fabricarea parfumurilor şi a produselor cosmetice", Category.SUBCLASS),
        Classification("24.6", "Fabricarea altor produse chimice", Category.GROUP),
        Classification("24.61", "Fabricarea explozivilor", Category.CLASS),
        Classification("24.61.0", "Fabricarea explozivilor", Category.SUBCLASS),
        Classification("24.62", "Fabricarea cleiurilor şi gelatinelor", Category.CLASS),
        Classification("24.62.0", "Fabricarea cleiurilor şi gelatinelor", Category.SUBCLASS),
        Classification("24.63", "Fabricarea uleiurilor eterice", Category.CLASS),
        Classification("24.63.0", "Fabricarea uleiurilor eterice", Category.SUBCLASS),
        Classification("24.64", "Fabricarea preparatelor chimice de uz fotografic", Category.CLASS),
        Classification("24.64.0", "Fabricarea preparatelor chimice de uz fotografic", Category.SUBCLASS),
        Classification("24.65", "Fabricarea suporţilor destinaţi înregistrărilor", Category.CLASS),
        Classification("24.65.0", "Fabricarea suporţilor destinaţi înregistrărilor", Category.SUBCLASS),
        Classification("24.66", "Fabricarea produselor chimice pentru utilizare în industrie", Category.CLASS),
        Classification("24.66.1", "Fabricarea produselor utilizate pentru finisarea textilelor", Category.SUBCLASS),
        Classification("24.66.2", "Fabricarea carbonului industrial (a funinginii)", Category.SUBCLASS),
        Classification("24.66.9", "Fabricarea altor produse chimice", Category.SUBCLASS),
        Classification("24.7", "Fabricarea fibrelor şi firelor sintetice şi artificiale", Category.GROUP),
        Classification("24.70", "Fabricarea fibrelor şi firelor sintetice şi artificiale", Category.CLASS),
        Classification("24.70.0", "Fabricarea fibrelor şi firelor sintetice şi artificiale", Category.SUBCLASS),
        Classification("25", "PRODUCŢIA DE ARTICOLE DIN CAUCIUC  ŞI DIN MATERIAL PLASTIC", Category.DIVISION),
        Classification("25.1", "Producţia de articole din cauciuc", Category.GROUP),
        Classification("25.11", "Fabricarea pneurilor şi a camerelor de aer", Category.CLASS),
        Classification("25.11.0", "Fabricarea pneurilor şi a camerelor de aer", Category.SUBCLASS),
        Classification("25.12", "Reşaparea şi reformarea pneurilor", Category.CLASS),
        Classification("25.12.0", "Reşaparea şi reformarea pneurilor", Category.SUBCLASS),
        Classification("25.13", "Fabricarea altor produse din cauciuc", Category.CLASS),
        Classification("25.13.1", "Fabricarea produselor tehnice din cauciuc", Category.SUBCLASS),
        Classification("25.13.2", "Fabricarea produselor din cauciuc pentru uz sanitar şi medical", Category.SUBCLASS),
        Classification("25.2", "Producţia articolelor din material plastic", Category.GROUP),
        Classification(
            "25.21",
            "Fabricarea plăcilor, benzilor, fîşiilor, tuburilor, profilurilor din material plastic",
            Category.CLASS,
        ),
        Classification(
            "25.21.0",
            "Fabricarea plăcilor, benzilor, fîşiilor, tuburilor, profilurilor din material plastic",
            Category.SUBCLASS,
        ),
        Classification("25.22", "Fabricarea articolelor de ambalaj din material plastic", Category.CLASS),
        Classification("25.22.0", "Fabricarea articolelor de ambalaj din material plastic", Category.SUBCLASS),
        Classification("25.23", "Fabricarea articolelor din material plastic pentru construcţii", Category.CLASS),
        Classification("25.23.0", "Fabricarea articolelor din material plastic pentru construcţii", Category.SUBCLASS),
        Classification("25.24", "Fabricarea altor articole din material plastic", Category.CLASS),
        Classification("25.24.0", "Fabricarea altor articole din material plastic", Category.SUBCLASS),
        Classification("26", "PRODUCTIA ALTOR PRODUSE DIN MINERALE NEMETALIFERE", Category.DIVISION),
        Classification("26.1", "Fabricarea sticlei şi a articolelor din sticlă", Category.GROUP),
        Classification("26.11", "Fabricarea sticlei plate", Category.CLASS),
        Classification("26.11.0", "Fabricarea sticlei plate", Category.SUBCLASS),
        Classification("26.12", "Prelucrarea şi fasonarea sticlei plate", Category.CLASS),
        Classification("26.12.0", "Prelucrarea şi fasonarea sticlei plate", Category.SUBCLASS),
        Classification("26.13", "Fabricarea articolelor tubulare din sticlă", Category.CLASS),
        Classification("26.13.1", "Fabricarea ambalajelor din sticlă", Category.SUBCLASS),
        Classification(
            "26.13.2", "Fabricarea produselor de uz gospodăresc din sticlă şi a veselei din sticlă", Category.SUBCLASS
        ),
        Classification("26.14", "Fabricarea fibrelor din sticlă", Category.CLASS),
        Classification("26.14.0", "Fabricarea fibrelor din sticlă", Category.SUBCLASS),
        Classification("26.15", "Fabricarea şi fasonarea altor articole din sticlă", Category.CLASS),
        Classification("26.15.1", "Fabricarea de sticlărie tehnică", Category.SUBCLASS),
        Classification("26.15.2", "Fabricarea produselor din sticlă pentru laborator", Category.SUBCLASS),
        Classification("26.15.9", "Fabricarea produselor din sticlă, neincluse în alte categorii", Category.SUBCLASS),
        Classification("26.2", "Fabricarea produselor din ceramică (exclusiv cele pentru construcţii)", Category.GROUP),
        Classification("26.21", "Fabricarea articolelor de uz gospodăresc şi decorative din ceramică", Category.CLASS),
        Classification(
            "26.21.1", "Fabricarea articolelor de uz gospodăresc din porţelan şi faianţă", Category.SUBCLASS
        ),
        Classification("26.21.2", "Fabricarea articolelor de uz gospodăresc din ceramică", Category.SUBCLASS),
        Classification("26.22", "Fabricarea de obiecte sanitare din ceramică", Category.CLASS),
        Classification("26.22.0", "Fabricarea de obiecte sanitare din ceramică", Category.SUBCLASS),
        Classification("26.23", "Fabricarea izolatorilor şi pieselor izolante din ceramică", Category.CLASS),
        Classification("26.23.0", "Fabricarea izolatorilor şi pieselor izolante din ceramică", Category.SUBCLASS),
        Classification("26.24", "Fabricarea altor produse ceramice de uz tehnic", Category.CLASS),
        Classification("26.24.0", "Fabricarea altor produse ceramice de uz tehnic", Category.SUBCLASS),
        Classification("26.25", "Fabricarea altor produse ceramice", Category.CLASS),
        Classification("26.25.0", "Fabricarea altor produse ceramice", Category.SUBCLASS),
        Classification("26.26", "Fabricarea produselor ceramice refractare", Category.CLASS),
        Classification("26.26.0", "Fabricarea produselor ceramice refractare", Category.SUBCLASS),
        Classification("26.3", "Fabricarea plăcilor şi dalelor din ceramică", Category.GROUP),
        Classification("26.30", "Fabricarea plăcilor şi dalelor din ceramică", Category.CLASS),
        Classification("26.30.0", "Fabricarea plăcilor şi dalelor din ceramică", Category.SUBCLASS),
        Classification("26.4", "Fabricarea cărămizilor şi ţiglelor din lut ars", Category.GROUP),
        Classification("26.40", "Fabricarea cărămizilor şi ţiglelor din lut ars", Category.CLASS),
        Classification("26.40.0", "Fabricarea cărămizilor şi ţiglelor din lut ars", Category.SUBCLASS),
        Classification("26.5", "Fabricarea cimentului, varului şi ipsosului", Category.GROUP),
        Classification("26.51", "Fabricarea cimentului", Category.CLASS),
        Classification("26.51.0", "Fabricarea cimentului", Category.SUBCLASS),
        Classification("26.52", "Fabricarea varului", Category.CLASS),
        Classification("26.52.1", "Fabricarea varului", Category.SUBCLASS),
        Classification("26.52.2", "Fabricarea făinii de var şi de dolomită", Category.SUBCLASS),
        Classification("26.53", "Fabricarea ipsosului", Category.CLASS),
        Classification("26.53.0", "Fabricarea ipsosului", Category.SUBCLASS),
        Classification("26.6", "Fabricarea elementelor din beton, ipsos şi ciment", Category.GROUP),
        Classification("26.61", "Fabricarea elementelor din beton pentru utilizare în construcţii", Category.CLASS),
        Classification(
            "26.61.1",
            "Fabricarea elementelor montabile din beton armat şi a articolelor şi construcţiilor din beton",
            Category.SUBCLASS,
        ),
        Classification("26.61.2", "Fabricarea blocurilor pentru pereţi", Category.SUBCLASS),
        Classification("26.61.3", "Fabricarea cărămizilor din silicaţi", Category.SUBCLASS),
        Classification("26.62", "Fabricarea elementelor din ipsos pentru construcţii", Category.CLASS),
        Classification("26.62.0", "Fabricarea elementelor din ipsos pentru construcţii", Category.SUBCLASS),
        Classification("26.63", "Fabricarea betonului", Category.CLASS),
        Classification("26.63.1", "Fabricarea betonului-marfă", Category.SUBCLASS),
        Classification("26.63.2", "Fabricarea betonului pentru asfalt", Category.SUBCLASS),
        Classification("26.64", "Fabricarea mortarului", Category.CLASS),
        Classification("26.64.0", "Fabricarea mortarului", Category.SUBCLASS),
        Classification("26.65", "Fabricarea produselor din ciment fibrocelulozic (azbociment)", Category.CLASS),
        Classification("26.65.0", "Fabricarea produselor din ciment fibrocelulozic (azbociment)", Category.SUBCLASS),
        Classification("26.66", "Fabricarea altor elemente din beton, ciment şi ipsos", Category.CLASS),
        Classification("26.66.0", "Fabricarea altor elemente din beton, ciment şi ipsos", Category.SUBCLASS),
        Classification("26.7", "Tăierea, fasonarea şi finisarea pietrei", Category.GROUP),
        Classification("26.70", "Tăierea, fasonarea şi finisarea pietrei", Category.CLASS),
        Classification("26.70.0", "Tăierea, fasonarea şi finisarea pietrei", Category.SUBCLASS),
        Classification("26.8", "Fabricarea altor produse din minerale nemetalifere", Category.GROUP),
        Classification("26.81", "Fabricarea de produse abrazive", Category.CLASS),
        Classification("26.81.0", "Fabricarea de produse abrazive", Category.SUBCLASS),
        Classification(
            "26.82", "Fabricarea altor produse din minerale nemetalifere, neincluse în alte categorii", Category.CLASS
        ),
        Classification("26.82.1", "Fabricarea produselor tehnice din azbest", Category.SUBCLASS),
        Classification("26.82.2", "Fabricarea materialelor izolante din minerale nemetalifere", Category.SUBCLASS),
        Classification(
            "26.82.3",
            "Fabricarea de materiale izolante moi pentru acoperiş şi materiale hidroizolante",
            Category.SUBCLASS,
        ),
        Classification(
            "26.82.4",
            "Fabricarea agregatelor poroase artificiale şi prelucrarea agregatelor poroase naturale",
            Category.SUBCLASS,
        ),
        Classification("26.82.5", "Fabricarea materialelor de modelare", Category.SUBCLASS),
        Classification("26.82.6", "Fabricarea produselor din minerale nemetalifere", Category.SUBCLASS),
        Classification("27", "INDUSTRIA METALURGICĂ", Category.DIVISION),
        Classification("27.1", "Producţia de metale feroase sub forme primare şi semifabricate", Category.GROUP),
        Classification("27.10", "Producţia de metale feroase sub forme primare şi cea de feroaliaje", Category.CLASS),
        Classification(
            "27.10.0", "Producţia de metale feroase sub forme primare şi cea de feroaliaje", Category.SUBCLASS
        ),
        Classification("27.2", "Producţia de ţevi (tuburi)", Category.GROUP),
        Classification("27.21", "Producţia de ţevi din fontă", Category.CLASS),
        Classification("27.21.0", "Producţia de ţevi din fontă", Category.SUBCLASS),
        Classification("27.22", "Producţia de ţevi din oţel", Category.CLASS),
        Classification("27.22.0", "Producţia de ţevi din oţel", Category.SUBCLASS),
        Classification("27.3", "Alte procese de prelucrare primară a fontei şi oţelului", Category.GROUP),
        Classification("27.31", "Tragerea la rece", Category.CLASS),
        Classification("27.31.0", "Tragerea la rece", Category.SUBCLASS),
        Classification("27.32", "Laminarea la rece a benzilor înguste", Category.CLASS),
        Classification("27.32.0", "Laminarea la rece a benzilor înguste", Category.SUBCLASS),
        Classification("27.33", "Ştanţarea sau fălţuirea la rece", Category.CLASS),
        Classification("27.33.0", "Ştanţarea sau fălţuirea la rece", Category.SUBCLASS),
        Classification("27.34", "Fabricarea sîrmei", Category.CLASS),
        Classification("27.34.0", "Fabricarea sîrmei", Category.SUBCLASS),
        Classification("27.4", "Producţia metalelor neferoase", Category.GROUP),
        Classification("27.41", "Producţia metalelor preţioase", Category.CLASS),
        Classification("27.41.0", "Producţia metalelor preţioase", Category.SUBCLASS),
        Classification("27.42", "Producţia aluminiului", Category.CLASS),
        Classification("27.42.0", "Producţia aluminiului", Category.SUBCLASS),
        Classification("27.43", "Producţia plumbului, zincului şi cositorului", Category.CLASS),
        Classification("27.43.0", "Producţia plumbului, zincului şi cositorului", Category.SUBCLASS),
        Classification("27.44", "Producţia cuprului", Category.CLASS),
        Classification("27.44.0", "Producţia cuprului", Category.SUBCLASS),
        Classification("27.45", "Producţia altor metale neferoase", Category.CLASS),
        Classification("27.45.1", "Producţia nichelului şi cobaltului", Category.SUBCLASS),
        Classification("27.45.2", "Producţia titanului şi magneziului, wolframului şi molibdenului", Category.SUBCLASS),
        Classification("27.45.3", "Producţia stibiului şi mercurului", Category.SUBCLASS),
        Classification("27.45.4", "Prelucrarea metalelor neferoase şi a aliajelor", Category.SUBCLASS),
        Classification("27.45.5", "Producţia metalelor rare şi a semiconductorilor", Category.SUBCLASS),
        Classification("27.5", "Turnătorie", Category.GROUP),
        Classification("27.51", "Turnarea fontei", Category.CLASS),
        Classification("27.51.0", "Turnarea fontei", Category.SUBCLASS),
        Classification("27.52", "Turnarea oţelului", Category.CLASS),
        Classification("27.52.0", "Turnarea oţelului", Category.SUBCLASS),
        Classification("27.53", "Turnarea metalelor neferoase uşoare", Category.CLASS),
        Classification("27.53.0", "Turnarea metalelor neferoase uşoare", Category.SUBCLASS),
        Classification("27.54", "Turnarea altor metale neferoase", Category.CLASS),
        Classification("27.54.0", "Turnarea altor metale neferoase", Category.SUBCLASS),
        Classification(
            "28", "FABRICAREA PRODUSELOR FINITE DIN METAL, EXCLUSIV PRODUCŢIA DE MAŞINI ŞI UTILAJE", Category.DIVISION
        ),
        Classification("28.1", "Fabricarea produselor din metal pentru construcţii", Category.GROUP),
        Classification("28.11", "Fabricarea construcţiilor din metal", Category.CLASS),
        Classification("28.11.1", "Fabricarea construcţiilor din oţel pentru construcţii", Category.SUBCLASS),
        Classification("28.11.2", "Fabricarea produselor metalice uşoare", Category.SUBCLASS),
        Classification(
            "28.11.3",
            "Fabricarea de construcţii şi prefabricate din aluminiu şi aliaje de aluminiu pentru construcţii",
            Category.SUBCLASS,
        ),
        Classification("28.11.4", "Fabricarea de clădiri şi încăperi tip container şi  demontabile", Category.SUBCLASS),
        Classification("28.12", "Fabricarea de structuri şi tîmplării metalice pentru construcţii", Category.CLASS),
        Classification(
            "28.12.0", "Fabricarea de structuri şi tîmplării metalice pentru construcţii", Category.SUBCLASS
        ),
        Classification("28.2", "Producţia de rezervoare şi cazane metalice pentru încălzire centrală", Category.GROUP),
        Classification("28.21", "Producţia de cisterne, rezervoare şi containere metalice", Category.CLASS),
        Classification("28.21.0", "Producţia de cisterne, rezervoare şi containere metalice", Category.SUBCLASS),
        Classification("28.22", "Producţia de radiatoare şi cazane pentru încălzire centrală", Category.CLASS),
        Classification("28.22.0", "Producţia de radiatoare şi cazane pentru încălzire centrală", Category.SUBCLASS),
        Classification("28.3", "Producţia generatoarelor de aburi", Category.GROUP),
        Classification("28.30", "Producţia generatoarelor de aburi", Category.CLASS),
        Classification("28.30.0", "Producţia generatoarelor de aburi", Category.SUBCLASS),
        Classification("28.4", "Forjarea, ambutisarea, ştanţarea; metalurgia pulberilor", Category.GROUP),
        Classification("28.40", "Forjarea, ambutisarea, ştanţarea; metalurgia pulberilor", Category.CLASS),
        Classification(
            "28.40.1",
            "Fabricarea produselor metalice finite sau semifinite prin forjare, ambutisare, ştanţare şi laminare",
            Category.SUBCLASS,
        ),
        Classification(
            "28.40.2", "Fabricarea produselor metalice prin metoda metalurgiei pulberilor", Category.SUBCLASS
        ),
        Classification("28.5", "Tratarea şi acoperirea metalelor; operaţiuni de mecanică generală", Category.GROUP),
        Classification("28.51", "Tratarea şi acoperirea metalelor", Category.CLASS),
        Classification("28.51.0", "Tratarea şi acoperirea metalelor", Category.SUBCLASS),
        Classification("28.52", "Operaţiuni de mecanică generală", Category.CLASS),
        Classification("28.52.0", "Operaţiuni de mecanică generală", Category.SUBCLASS),
        Classification("28.6", "Fabricarea produselor de tăiat, a sculelor şi articolelor de fierărie", Category.GROUP),
        Classification("28.61", "Fabricarea produselor de tăiat", Category.CLASS),
        Classification("28.61.0", "Fabricarea produselor de tăiat", Category.SUBCLASS),
        Classification("28.62", "Fabricarea sculelor", Category.CLASS),
        Classification("28.62.1", "Fabricarea uneltelor pentru prelucrarea metalelor şi a lemnului", Category.SUBCLASS),
        Classification(
            "28.62.2", "Fabricarea uneltelor folosite în agricultură şi pomilegumi­cul­tură", Category.SUBCLASS
        ),
        Classification("28.63", "Fabricarea de lacăte şi balamale", Category.CLASS),
        Classification("28.63.0", "Fabricarea de lacăte şi balamale", Category.SUBCLASS),
        Classification("28.7", "Fabricarea altor produse metalice finite", Category.GROUP),
        Classification("28.71", "Fabricarea de butoaie şi alte recipiente din metal", Category.CLASS),
        Classification("28.71.0", "Fabricarea de butoaie şi alte recipiente din metal", Category.SUBCLASS),
        Classification("28.72", "Fabricarea ambalajelor din metale uşoare", Category.CLASS),
        Classification("28.72.0", "Fabricarea ambalajelor din metale uşoare", Category.SUBCLASS),
        Classification("28.73", "Fabricarea articolelor din fire metalice", Category.CLASS),
        Classification("28.73.0", "Fabricarea articolelor din fire metalice", Category.SUBCLASS),
        Classification("28.74", "Fabricarea de şuruburi, buloane, lanţuri şi arcuri", Category.CLASS),
        Classification("28.74.0", "Fabricarea de şuruburi, buloane, lanţuri şi arcuri", Category.SUBCLASS),
        Classification("28.75", "Fabricarea altor articole finite din metal", Category.CLASS),
        Classification("28.75.1", "Fabricarea utilajului tehnico-sanitar din metal", Category.SUBCLASS),
        Classification("28.75.2", "Fabricarea veselei şi a mobilierului de bucătărie", Category.SUBCLASS),
        Classification("28.75.9", "Fabricarea altor articole din metal", Category.SUBCLASS),
        Classification("29", "FABRICAREA DE MAŞINI ŞI ECHIPAMENTE", Category.DIVISION),
        Classification(
            "29.1", "Fabricarea de echipamente pentru producerea şi utilizarea energiei mecanice", Category.GROUP
        ),
        Classification("29.11", "Fabricarea de motoare şi turbine", Category.CLASS),
        Classification("29.11.1", "Fabricarea de motoare", Category.SUBCLASS),
        Classification("29.11.2", "Fabricarea de turbine", Category.SUBCLASS),
        Classification(
            "29.11.9",
            "Instalarea, repararea şi întreţinerea motoarelor şi turbinelor, cu excepţia motoarelor pentru avioane, autovehicule şi motociclete",
            Category.SUBCLASS,
        ),
        Classification("29.12", "Fabricarea de pompe, compresoare şi sisteme hidraulice", Category.CLASS),
        Classification("29.12.1", "Fabricarea pompelor hidraulice", Category.SUBCLASS),
        Classification("29.12.2", "Fabricarea pompelor de aer şi de vid", Category.SUBCLASS),
        Classification("29.12.3", "Fabricarea compresoarelor", Category.SUBCLASS),
        Classification(
            "29.12.9", "Instalarea, repararea şi întreţinerea pompelor şi compresoarelor", Category.SUBCLASS
        ),
        Classification("29.13", "Fabricarea robinetelor şi supapelor", Category.CLASS),
        Classification("29.13.0", "Fabricarea robinetelor şi supapelor", Category.SUBCLASS),
        Classification(
            "29.14",
            "Fabricarea roţilor dinţate, elementelor de transmisie mecanice prin roţi dinţate şi aparatelor de transmisie mecanice",
            Category.CLASS,
        ),
        Classification("29.14.1", "Fabricarea rulmenţilor", Category.SUBCLASS),
        Classification(
            "29.14.2", "Fabricarea de detalii şi încrucişări pentru maşini de utilizare generală", Category.SUBCLASS
        ),
        Classification(
            "29.14.9",
            "Repararea rulmenţilor, detaliilor şi încrucişărilor pentru maşini de utilizare generală",
            Category.SUBCLASS,
        ),
        Classification("29.2", "Fabricarea de maşini de utilizare generală", Category.GROUP),
        Classification("29.21", "Fabricarea cuptoarelor industriale şi a arzătoarelor pentru cuptoare", Category.CLASS),
        Classification(
            "29.21.1",
            "Fabricarea de cuptoare neelectrice, arzătoare, instalaţii şi echipamente pentru cuptoare",
            Category.SUBCLASS,
        ),
        Classification("29.21.2", "Fabricarea de cuptoare electrice", Category.SUBCLASS),
        Classification(
            "29.21.9", "Instalarea, repararea şi întreţinerea cuptoarelor electrice şi neelectrice", Category.SUBCLASS
        ),
        Classification("29.22", "Fabricarea echipamentului de ridicat şi de manipulat", Category.CLASS),
        Classification("29.22.1", "Producţia de macarale (exclusiv pentru construcţii)", Category.SUBCLASS),
        Classification("29.22.2", "Producţia de macarale pentru construcţii", Category.SUBCLASS),
        Classification("29.22.3", "Producţia utilajului pentru transportul continuu", Category.SUBCLASS),
        Classification("29.22.4", "Producţia de lifturi", Category.SUBCLASS),
        Classification("29.22.5", "Producţia de încărcătoare electrice şi autoîncărcătoare", Category.SUBCLASS),
        Classification(
            "29.22.6",
            "Fabricarea altor tipuri de utilaje de ridicat, de tachelaj, încărcat şi descărcat",
            Category.SUBCLASS,
        ),
        Classification(
            "29.22.9",
            "Instalarea, cu excepţia lifturilor şi escalatoarelor, repararea şi întreţinerea echipamentelor de ridicat şi manipulat",
            Category.SUBCLASS,
        ),
        Classification("29.23", "Fabricarea echipamentelor industriale de răcire şi de ventilare", Category.CLASS),
        Classification("29.23.1", "Fabricarea refrigeratoarelor şi congelatoarelor", Category.SUBCLASS),
        Classification(
            "29.23.2", "Fabricarea instalaţiilor pentru aer condiţionat şi a ventilatoarelor", Category.SUBCLASS
        ),
        Classification(
            "29.23.9",
            "Instalarea, repararea şi întreţinerea echipamentelor de răcire şi ventilare, cu excepţia celor pentru uz casnic",
            Category.SUBCLASS,
        ),
        Classification("29.24", "Fabricarea altor maşini de utilizare generală", Category.CLASS),
        Classification(
            "29.24.1",
            "Fabricarea utilajelor şi aparatelor pentru cîntărit (exclusiv cîntarele de precizie pentru laborator)",
            Category.SUBCLASS,
        ),
        Classification("29.24.2", "Fabricarea utilajelor de filtrat şi curăţat", Category.SUBCLASS),
        Classification(
            "29.24.3", "Fabricarea utilajelor de pulverizare a lichidelor sau prafurilor", Category.SUBCLASS
        ),
        Classification("29.24.4", "Fabricarea utilajelor de împachetat şi înfăşurat", Category.SUBCLASS),
        Classification(
            "29.24.5", "Fabricarea echipamentelor şi aparatajului pentru procesele chimice", Category.SUBCLASS
        ),
        Classification(
            "29.24.8", "Fabricarea altor maşini şi echipamente, subansambluri şi accesorii", Category.SUBCLASS
        ),
        Classification(
            "29.24.9", "Instalarea, repararea şi întreţinerea maşinilor de utilizare generală", Category.SUBCLASS
        ),
        Classification("29.3", "Fabricarea de maşini agricole", Category.GROUP),
        Classification("29.31", "Fabricarea tractoarelor agricole", Category.CLASS),
        Classification("29.31.1", "Fabricarea tractoarelor agricole (exclusiv reparaţii)", Category.SUBCLASS),
        Classification("29.31.9", "Repararea tractoarelor agricole", Category.SUBCLASS),
        Classification("29.32", "Fabricarea altor maşini agricole", Category.CLASS),
        Classification("29.32.1", "Fabricarea maşinilor agricole", Category.SUBCLASS),
        Classification(
            "29.32.2", "Fabricarea utilajului zootehnic şi pentru producerea nutreţurilor", Category.SUBCLASS
        ),
        Classification(
            "29.32.3", "Fabricarea utilajelor pentru exploatări forestiere şi ameliorări", Category.SUBCLASS
        ),
        Classification(
            "29.32.9",
            "Instalarea, repararea şi întreţinerea maşinilor şi utilajelor pentru agricultură şi silvicultură",
            Category.SUBCLASS,
        ),
        Classification("29.4", "Fabricarea maşinilor-unelte mecanice", Category.GROUP),
        Classification("29.41", "Fabricarea maşinilor-unelte portabile acţionate mecanic", Category.CLASS),
        Classification("29.41.0", "Fabricarea maşinilor-unelte portabile acţionate mecanic", Category.SUBCLASS),
        Classification("29.42", "Fabricarea altor maşini-unelte mecanice pentru prelucrarea metalelor", Category.CLASS),
        Classification(
            "29.42.0", "Fabricarea altor maşini-unelte mecanice pentru prelucrarea metalelor", Category.SUBCLASS
        ),
        Classification("29.43", "Fabricarea altor maşini-unelte mecanice, neincluse în alte categorii", Category.CLASS),
        Classification(
            "29.43.0", "Fabricarea altor maşini-unelte mecanice, neincluse în alte categorii", Category.SUBCLASS
        ),
        Classification("29.5", "Fabricarea altor maşini cu destinaţie specială", Category.GROUP),
        Classification("29.51", "Fabricarea de maşini pentru metalurgie", Category.CLASS),
        Classification("29.51.1", "Fabricarea utilajelor pentru metalurgie (exclusiv reparaţii)", Category.SUBCLASS),
        Classification(
            "29.51.9", "Instalarea, repararea şi întreţinerea utilajelor pentru metalurgie", Category.SUBCLASS
        ),
        Classification("29.52", "Fabricarea utilajelor pentru industria extractivă şi construcţii", Category.CLASS),
        Classification(
            "29.52.1",
            "Fabricarea echipamentelor pentru lucrări miniere şi de extracţie a minereurilor",
            Category.SUBCLASS,
        ),
        Classification(
            "29.52.2", "Fabricarea maşinilor pentru construcţia drumurilor şi a excavatoarelor", Category.SUBCLASS
        ),
        Classification("29.52.3", "Fabricarea maşinilor pentru construcţii", Category.SUBCLASS),
        Classification(
            "29.52.4", "Fabricarea utilajelor pentru prelucrarea materialelor de construcţie", Category.SUBCLASS
        ),
        Classification("29.52.5", "Fabricarea utilajelor pentru extragerea turbei", Category.SUBCLASS),
        Classification(
            "29.52.9",
            "Instalarea, repararea şi întreţinerea maşinilor pentru industria extractivă şi pentru construcţii",
            Category.SUBCLASS,
        ),
        Classification("29.53", "Fabricarea maşinilor pentru prelucrarea producţiei agricole", Category.CLASS),
        Classification(
            "29.53.1",
            "Fabricarea maşinilor pentru prelucrarea producţiei agricole (exclusiv reparaţii)",
            Category.SUBCLASS,
        ),
        Classification(
            "29.53.9",
            "Instalarea, repararea şi întreţinerea maşinilor pentru prelucrarea producţiei agricole",
            Category.SUBCLASS,
        ),
        Classification(
            "29.54", "Fabricarea maşinilor pentru industria textilă, de confecţii şi a pielăriei", Category.CLASS
        ),
        Classification("29.54.1", "Fabricarea maşinilor şi utilajelor pentru industria textilă", Category.SUBCLASS),
        Classification(
            "29.54.2",
            "Fabricarea maşinilor şi utilajelor pentru industria de confecţii şi de tricotaje",
            Category.SUBCLASS,
        ),
        Classification("29.54.3", "Fabricarea maşinilor de cusut de uz casnic", Category.SUBCLASS),
        Classification(
            "29.54.4",
            "Fabricarea maşinilor şi utilajelor pentru industria încălţămintei, a blănurilor, de pielărie şi de galanterie din piele",
            Category.SUBCLASS,
        ),
        Classification(
            "29.54.5", "Fabricarea de utilaje speciale pentru întreprinderile de deservire socială", Category.SUBCLASS
        ),
        Classification(
            "29.54.9",
            "Instalarea, repararea şi întreţinerea maşinilor pentru industria textilă, de confecţii şi de pielărie",
            Category.SUBCLASS,
        ),
        Classification("29.55", "Fabricarea maşinilor pentru industria hîrtiei şi cartonului", Category.CLASS),
        Classification(
            "29.55.1",
            "Fabricarea maşinilor pentru industria hîrtiei şi cartonului (exclusiv reparaţii)",
            Category.SUBCLASS,
        ),
        Classification(
            "29.55.9",
            "Instalarea, repararea şi întreţinerea maşinilor pentru industria hîrtiei şi cartonului",
            Category.SUBCLASS,
        ),
        Classification("29.56", "Fabricarea altor maşini cu destinaţie specială", Category.CLASS),
        Classification("29.56.1", "Fabricarea de utilaje pentru foraj şi exploatarea sondelor", Category.SUBCLASS),
        Classification("29.56.2", "Fabricarea utilajelor de prelucrare a ţiţeiului şi gazelor", Category.SUBCLASS),
        Classification(
            "29.56.3", "Fabricarea utilajelor tehnologice speciale pentru industria electronică", Category.SUBCLASS
        ),
        Classification(
            "29.56.4", "Fabricarea utilajelor tehnologice pentru producţia de fibre chimice", Category.SUBCLASS
        ),
        Classification(
            "29.56.5",
            "Fabricarea utilajelor pentru prelucrarea cauciucului, materialelor plastice şi altor materiale polimere",
            Category.SUBCLASS,
        ),
        Classification("29.56.6", "Fabricarea utilajelor tehnologice pentru industria sticlei", Category.SUBCLASS),
        Classification("29.56.7", "Fabricarea utilajelor tehnologice pentru poligrafie", Category.SUBCLASS),
        Classification("29.56.8", "Fabricarea altor maşini cu destinaţie specială", Category.SUBCLASS),
        Classification(
            "29.56.9", "Instalarea, repararea şi întreţinerea altor maşini cu destinaţie specială", Category.SUBCLASS
        ),
        Classification("29.6", "Fabricarea armamentului şi muniţiei", Category.GROUP),
        Classification("29.60", "Fabricarea armamentului şi muniţiei", Category.CLASS),
        Classification("29.60.0", "Fabricarea armamentului şi muniţiei", Category.SUBCLASS),
        Classification("29.7", "Fabricarea aparatelor de uz casnic", Category.GROUP),
        Classification("29.71", "Fabricarea aparatelor electrice de uz casnic", Category.CLASS),
        Classification(
            "29.71.1",
            "Fabricarea aparatelor electrice de uz casnic, exclusiv frigidere şi congelatoare",
            Category.SUBCLASS,
        ),
        Classification("29.71.2", "Fabricarea frigiderelor şi congelatoarelor de uz casnic", Category.SUBCLASS),
        Classification("29.72", "Fabricarea aparatelor neelectrice de uz casnic", Category.CLASS),
        Classification("29.72.0", "Fabricarea aparatelor neelectrice de uz casnic", Category.SUBCLASS),
        Classification("30", "FABRICAREA DE MIJLOACE ALE TEHNICII DE CALCUL ŞI DE BIROU", Category.DIVISION),
        Classification("30.0", "Fabricarea de mijloace ale tehnicii de calcul şi de birou", Category.GROUP),
        Classification("30.01", "Fabricarea maşinilor de birou", Category.CLASS),
        Classification("30.01.0", "Fabricarea maşinilor de birou", Category.SUBCLASS),
        Classification(
            "30.02",
            "Fabricarea calculatoarelor şi altor echipamente electronice pentru prelucrarea informaţiei",
            Category.CLASS,
        ),
        Classification(
            "30.02.0",
            "Fabricarea calculatoarelor şi altor echipamente electronice pentru prelucrarea informaţiei",
            Category.SUBCLASS,
        ),
        Classification("31", "PRODUCŢIA DE MAŞINI ŞI APARATE ELECTRICE", Category.DIVISION),
        Classification("31.1", "Producţia de motoare electrice, generatoare şi transformatoare", Category.GROUP),
        Classification("31.10", "Producţia de motoare electrice, generatoare şi transformatoare", Category.CLASS),
        Classification(
            "31.10.1",
            "Producţia de motoare electrice, generatoare şi transformatoare (exclusiv reparaţii)",
            Category.SUBCLASS,
        ),
        Classification("31.10.9", "Repararea de motoare electrice, generatoare şi transformatoare", Category.SUBCLASS),
        Classification("31.2", "Producţia de aparate pentru distribuţie şi comandă electrică", Category.GROUP),
        Classification("31.20", "Producţia de aparate pentru distribuţie şi comandă electrică", Category.CLASS),
        Classification(
            "31.20.1",
            "Producţia de aparate pentru distribuţie şi comandă electrică (exclusiv reparaţii)",
            Category.SUBCLASS,
        ),
        Classification("31.20.9", "Repararea aparatelor pentru distribuţie şi comandă electrică", Category.SUBCLASS),
        Classification("31.3", "Producţia de fire şi cabluri izolate", Category.GROUP),
        Classification("31.30", "Producţia de fire şi cabluri izolate", Category.CLASS),
        Classification("31.30.0", "Producţia de fire şi cabluri izolate", Category.SUBCLASS),
        Classification("31.4", "Producţia de acumulatori, baterii şi pile electrice", Category.GROUP),
        Classification("31.40", "Producţia de acumulatori, baterii şi pile electrice", Category.CLASS),
        Classification("31.40.0", "Producţia de acumulatori, baterii şi pile electrice", Category.SUBCLASS),
        Classification("31.5", "Producţia de lămpi electrice şi echipamente de iluminat", Category.GROUP),
        Classification("31.50", "Producţia de lămpi electrice şi echipamente de iluminat", Category.CLASS),
        Classification("31.50.1", "Fabricarea de lămpi electrice", Category.SUBCLASS),
        Classification("31.50.2", "Fabricarea de echipamente de iluminat", Category.SUBCLASS),
        Classification("31.6", "Producţia de alte aparate şi echipamente electrice", Category.GROUP),
        Classification(
            "31.61", "Producţia de componente electrice pentru motoare şi mijloace de transport", Category.CLASS
        ),
        Classification(
            "31.61.1",
            "Producţia de componente electrice pentru motoare şi mijloace de transport (exclusiv reparaţii)",
            Category.SUBCLASS,
        ),
        Classification(
            "31.61.9", "Repararea componentelor electrice pentru motoare şi mijloace de transport", Category.SUBCLASS
        ),
        Classification(
            "31.62",
            "Producţia altor componente electrice, exclusiv componente electrice pentru motoare şi mijloace de transport",
            Category.CLASS,
        ),
        Classification("31.62.1", "Producţia de electrozi", Category.SUBCLASS),
        Classification("31.62.2", "Producţia de izolatori electrici", Category.SUBCLASS),
        Classification(
            "31.62.3", "Producţia de aparatură electrică de semnalizare acustică şi optică", Category.SUBCLASS
        ),
        Classification("31.62.8", "Producţia altor mecanisme şi aparate electrice", Category.SUBCLASS),
        Classification(
            "31.62.9", "Repararea altor echipamente electrice, neincluse în alte categorii", Category.SUBCLASS
        ),
        Classification(
            "32", "PRODUCŢIA DE ECHIPAMENTE ŞI APARATE PENTRU RADIO, TELEVIZIUNE ŞI COMUNICAŢII", Category.DIVISION
        ),
        Classification("32.1", "Producţia componentelor electronice", Category.GROUP),
        Classification("32.10", "Producţia componentelor electronice", Category.CLASS),
        Classification("32.10.0", "Producţia componentelor electronice", Category.SUBCLASS),
        Classification("32.2", "Producţia de aparate de emisie", Category.GROUP),
        Classification("32.20", "Producţia de aparate de emisie", Category.CLASS),
        Classification(
            "32.20.1", "Producţia de aparate de radio şi televiziune pentru uz industrial", Category.SUBCLASS
        ),
        Classification("32.20.2", "Producţia de aparate pentru telefonie şi telegrafie cu fir", Category.SUBCLASS),
        Classification("32.20.9", "Repararea echipamentului telegrafic", Category.SUBCLASS),
        Classification(
            "32.3",
            "Producţia de receptoare de radio şi televiziune; aparate de înregistrare şi reproducere audio şi video",
            Category.GROUP,
        ),
        Classification(
            "32.30",
            "Producţia de receptoare de radio şi televiziune; aparate de înregistrare şi reproducere audio şi video",
            Category.CLASS,
        ),
        Classification(
            "32.30.1",
            "Producţia de aparate de radio şi televiziune; aparate de înregistrare şi reproducere audio şi video şi mărfuri accesorii (exclusiv reparaţii)",
            Category.SUBCLASS,
        ),
        Classification("32.30.9", "Repararea aparatelor de radio şi televiziune", Category.SUBCLASS),
        Classification(
            "33",
            "PRODUCŢIA DE APARATURĂ ŞI INSTRUMENTE MEDICALE, DE PRECIZIE, OPTICE ŞI PRODUCŢIA DE CEASURI",
            Category.DIVISION,
        ),
        Classification(
            "33.1", "Fabricarea utilajului medical şi chirurgical şi a dispozitivelor ortopedice", Category.GROUP
        ),
        Classification(
            "33.10", "Fabricarea utilajului medical şi chirurgical şi a dispozitivelor ortopedice", Category.CLASS
        ),
        Classification(
            "33.10.1",
            "Fabricarea aparatelor pentru medicină, medicina veterinară şi cercetări ştiinţifice",
            Category.SUBCLASS,
        ),
        Classification("33.10.2", "Fabricarea instrumentelor, aparatelor şi utilajelor medicale", Category.SUBCLASS),
        Classification("33.10.3", "Producţia de dispozitive chirurgicale şi ortopedice", Category.SUBCLASS),
        Classification(
            "33.10.4",
            "Fabricarea mobilierului medical, chirurgical, stomatologic şi pentru medicina veterinară",
            Category.SUBCLASS,
        ),
        Classification(
            "33.2", "Producţia de aparatură şi instrumente de măsură, verificare şi control", Category.GROUP
        ),
        Classification(
            "33.20", "Producţia de aparatură şi instrumente de măsură, verificare şi control", Category.CLASS
        ),
        Classification("33.20.1", "Fabricarea aparatelor pentru măsurarea de mărimi mecanice", Category.SUBCLASS),
        Classification("33.20.2", "Fabricarea aparatelor electrice de măsurat", Category.SUBCLASS),
        Classification("33.20.3", "Fabricarea aparatelor pentru măsurări radio", Category.SUBCLASS),
        Classification("33.20.4", "Producţia de aparatură optică şi optică mecanică", Category.SUBCLASS),
        Classification("33.20.5", "Fabricarea aparatelor pentru cercetarea fenomenelor fizice", Category.SUBCLASS),
        Classification(
            "33.20.6",
            "Fabricarea instrumentelor de desenat, a sculelor de trasat şi a instrumentelor de măsurat",
            Category.SUBCLASS,
        ),
        Classification("33.20.9", "Reparaţii de instrumente şi aparatură", Category.SUBCLASS),
        Classification("33.3", "Producţia echipamentului de control pentru procesele industriale", Category.GROUP),
        Classification("33.30", "Producţia echipamentului de control pentru procesele industriale", Category.CLASS),
        Classification(
            "33.30.1",
            "Producţia echipamentului de control pentru procesele industriale (exclusiv reparaţii)",
            Category.SUBCLASS,
        ),
        Classification("33.30.9", "Repararea echipamentului de control", Category.SUBCLASS),
        Classification("33.4", "Producţia de aparatură şi instrumente optice şi fotografice", Category.GROUP),
        Classification("33.40", "Producţia de aparatură şi instrumente optice şi fotografice", Category.CLASS),
        Classification("33.40.1", "Producţia de aparatură şi instrumente optice", Category.SUBCLASS),
        Classification("33.40.2", "Producţia de echipament fotografic şi cinematografic", Category.SUBCLASS),
        Classification("33.40.3", "Producţia de fibre optice şi cabluri", Category.SUBCLASS),
        Classification("33.40.9", "Repararea instrumentelor optice şi a echipamentului fotografic", Category.SUBCLASS),
        Classification("33.5", "Producţia de ceasuri", Category.GROUP),
        Classification("33.50", "Producţia de ceasuri", Category.CLASS),
        Classification("33.50.1", "Producţia de ceasuri de toate tipurile", Category.SUBCLASS),
        Classification("33.50.2", "Fabricarea de aparate de înregistrare a timpului", Category.SUBCLASS),
        Classification("33.50.3", "Fabricarea de piese şi accesorii pentru ceasuri", Category.SUBCLASS),
        Classification("34", "PRODUCŢIA MIJLOACELOR DE TRANSPORT RUTIER", Category.DIVISION),
        Classification("34.1", "Producţia de autovehicule", Category.GROUP),
        Classification("34.10", "Producţia de autovehicule", Category.CLASS),
        Classification(
            "34.10.1", "Producţia de autovehicule şi alte mijloace de transport cu motor", Category.SUBCLASS
        ),
        Classification("34.10.2", "Fabricarea de motoare", Category.SUBCLASS),
        Classification("34.2", "Producţia de caroserii pentru autovehicule şi de remorci", Category.GROUP),
        Classification("34.20", "Producţia de caroserii pentru autovehicule şi de remorci", Category.CLASS),
        Classification("34.20.1", "Producţia de caroserii pentru autovehicule", Category.SUBCLASS),
        Classification("34.20.2", "Producţia de remorci şi semiremorci", Category.SUBCLASS),
        Classification("34.3", "Producţia de echipamente pentru autovehicule", Category.GROUP),
        Classification("34.30", "Producţia de echipamente pentru autovehicule", Category.CLASS),
        Classification(
            "34.30.1",
            "Producţia de piese şi accesorii pentru autovehicule şi motoare de autovehicule",
            Category.SUBCLASS,
        ),
        Classification(
            "34.30.2",
            "Producţia de utilaje şi echipamente pentru garaje şi staţii de alimentare cu combustibil",
            Category.SUBCLASS,
        ),
        Classification("35", "PRODUCŢIA ALTOR MIJLOACE DE TRANSPORT", Category.DIVISION),
        Classification("35.1", "Construcţii navale", Category.GROUP),
        Classification("35.11", "Construcţii şi reparaţii navale", Category.CLASS),
        Classification("35.11.1", "Construcţii navale", Category.SUBCLASS),
        Classification("35.11.9", "Reparaţii de nave", Category.SUBCLASS),
        Classification("35.12", "Construcţii şi reparaţii de bărci sportive şi de agrement", Category.CLASS),
        Classification("35.12.1", "Construcţia bărcilor de agrement şi sportive", Category.SUBCLASS),
        Classification("35.12.9", "Reparaţii de bărci de agrement şi sportive", Category.SUBCLASS),
        Classification("35.2", "Producţia mijloacelor de transport feroviar şi a materialului rulant", Category.GROUP),
        Classification("35.20", "Producţia mijloacelor de transport feroviar şi a materialului rulant", Category.CLASS),
        Classification(
            "35.20.1",
            "Producţia de locomotive pentru garnituri de tren şi pentru tramvaie, vagoane pentru metrou şi material rulant (exclusiv reparaţii)",
            Category.SUBCLASS,
        ),
        Classification("35.20.8", "Repararea materialului rulant al căilor ferate", Category.SUBCLASS),
        Classification("35.20.9", "Reparaţii de tramvaie, vagoane de metrou şi troleibuze", Category.SUBCLASS),
        Classification("35.3", "Construcţia aparatelor de zbor şi a tehnicii spaţiale", Category.GROUP),
        Classification("35.30", "Construcţia aparatelor de zbor şi a tehnicii spaţiale", Category.CLASS),
        Classification("35.30.1", "Construcţia aparatelor de zbor", Category.SUBCLASS),
        Classification("35.30.2", "Construcţia navelor spaţiale", Category.SUBCLASS),
        Classification("35.30.9", "Reparaţia aparatelor de zbor şi a tehnicii spaţiale", Category.SUBCLASS),
        Classification("35.4", "Producţia de motociclete şi biciclete", Category.GROUP),
        Classification("35.41", "Producţia de motociclete", Category.CLASS),
        Classification("35.41.0", "Producţia de motociclete", Category.SUBCLASS),
        Classification("35.42", "Producţia de biciclete", Category.CLASS),
        Classification("35.42.0", "Producţia de biciclete", Category.SUBCLASS),
        Classification("35.43", "Producţia de cărucioare pentru invalizi", Category.CLASS),
        Classification("35.43.0", "Producţia de cărucioare pentru invalizi", Category.SUBCLASS),
        Classification("35.5", "Producţia altor mijloace de transport, neincluse în alte categorii", Category.GROUP),
        Classification("35.50", "Producţia altor mijloace de transport, neincluse în alte categorii", Category.CLASS),
        Classification(
            "35.50.0", "Producţia altor mijloace de transport, neincluse în alte categorii", Category.SUBCLASS
        ),
        Classification("36", "PRODUCŢIA DE MOBILIER ŞI ALTE ACTIVITĂŢI INDUSTRIALE", Category.DIVISION),
        Classification("36.1", "Producţia de mobilier", Category.GROUP),
        Classification("36.11", "Producţia de scaune şi scaune pentru vehicule", Category.CLASS),
        Classification("36.11.0", "Producţia de scaune şi scaune pentru vehicule", Category.SUBCLASS),
        Classification("36.12", "Producţia mobilierului pentru birou şi magazine", Category.CLASS),
        Classification("36.12.0", "Producţia mobilierului pentru birou şi magazine", Category.SUBCLASS),
        Classification("36.13", "Producţia mobilierului pentru bucătărie", Category.CLASS),
        Classification("36.13.0", "Producţia mobilierului pentru bucătărie", Category.SUBCLASS),
        Classification("36.14", "Producţia altor tipuri de mobilier", Category.CLASS),
        Classification("36.14.0", "Producţia altor tipuri de mobilier", Category.SUBCLASS),
        Classification("36.15", "Producţia de saltele", Category.CLASS),
        Classification("36.15.0", "Producţia de saltele", Category.SUBCLASS),
        Classification("36.2", "Fabricarea bijuteriilor", Category.GROUP),
        Classification("36.21", "Baterea monedelor şi medaliilor", Category.CLASS),
        Classification("36.21.0", "Baterea monedelor şi medaliilor", Category.SUBCLASS),
        Classification("36.22", "Fabricarea bijuteriilor", Category.CLASS),
        Classification("36.22.0", "Fabricarea bijuteriilor", Category.SUBCLASS),
        Classification("36.3", "Fabricarea instrumentelor muzicale", Category.GROUP),
        Classification("36.30", "Fabricarea instrumentelor muzicale", Category.CLASS),
        Classification("36.30.1", "Fabricarea instrumentelor muzicale (exclusiv reparaţii)", Category.SUBCLASS),
        Classification("36.30.9", "Repararea instrumentelor muzicale", Category.SUBCLASS),
        Classification("36.4", "Fabricarea articolelor sportive", Category.GROUP),
        Classification("36.40", "Fabricarea articolelor sportive", Category.CLASS),
        Classification("36.40.0", "Fabricarea articolelor sportive", Category.SUBCLASS),
        Classification("36.5", "Fabricarea jocurilor şi jucăriilor", Category.GROUP),
        Classification("36.50", "Fabricarea jocurilor şi jucăriilor", Category.CLASS),
        Classification("36.50.0", "Fabricarea jocurilor şi jucăriilor", Category.SUBCLASS),
        Classification("36.6", "Fabricarea altor produse, neincluse în alte categorii", Category.GROUP),
        Classification(
            "36.61", "Fabricarea bijuteriilor din materiale nepreţioase (imitaţii de bijuterii)", Category.CLASS
        ),
        Classification(
            "36.61.0", "Fabricarea bijuteriilor din materiale nepreţioase (imitaţii de bijuterii)", Category.SUBCLASS
        ),
        Classification("36.62", "Confecţionarea măturilor şi periilor", Category.CLASS),
        Classification("36.62.0", "Confecţionarea măturilor şi periilor", Category.SUBCLASS),
        Classification("36.63", "Fabricarea altor articole, neincluse în alte categorii", Category.CLASS),
        Classification("36.63.1", "Fabricarea rechizitelor de birou", Category.SUBCLASS),
        Classification("36.63.2", "Fabricarea cărucioarelor pentru copii", Category.SUBCLASS),
        Classification("36.63.3", "Fabricarea articolelor de galanterie metalică", Category.SUBCLASS),
        Classification("36.63.4", "Fabricarea chibriturilor", Category.SUBCLASS),
        Classification(
            "36.63.5", "Fabricarea de carusele, scrîncioburi, standuri de tir şi alte atracţii", Category.SUBCLASS
        ),
        Classification("36.63.6", "Fabricarea linoleumului şi altor pardoseli tari pentru duşumele", Category.SUBCLASS),
        Classification("36.63.9", "Fabricarea altor articole", Category.SUBCLASS),
        Classification("37", "RECUPERAREA DEŞEURILOR ŞI RESTURILOR DE MATERIALE RECICLABILE", Category.DIVISION),
        Classification("37.1", "Recuperarea deşeurilor şi resturilor metalice reciclabile", Category.GROUP),
        Classification("37.10", "Recuperarea deşeurilor şi resturilor metalice reciclabile", Category.CLASS),
        Classification(
            "37.10.1", "Prelucrarea deşeurilor şi resturilor reciclabile din metale feroase", Category.SUBCLASS
        ),
        Classification(
            "37.10.2", "Prelucrarea deşeurilor şi resturilor reciclabile din metale neferoase", Category.SUBCLASS
        ),
        Classification("37.2", "Recuperarea deşeurilor şi resturilor nemetalice reciclabile", Category.GROUP),
        Classification("37.20", "Recuperarea deşeurilor şi resturilor nemetalice reciclabile", Category.CLASS),
        Classification("37.20.0", "Recuperarea deşeurilor şi resturilor nemetalice reciclabile", Category.SUBCLASS),
        Classification("E", "ENERGIE ELECTRICĂ ŞI TERMICĂ, GAZE ŞI APĂ", Category.SECTION),
        Classification(
            "40", "PRODUCŢIA ŞI DISTRIBUŢIA DE ENERGIE ELECTRICĂ ŞI TERMICĂ, GAZE ŞI APĂ CALDĂ", Category.DIVISION
        ),
        Classification("40.1", "Producţia şi distribuţia energiei electrice", Category.GROUP),
        Classification("40.11", "Producţia energiei electrice", Category.CLASS),
        Classification("40.11.1", "Producţia energiei electrice în termocentralele electrice", Category.SUBCLASS),
        Classification("40.11.2", "Producţia energiei electrice în centralele hidroelectrice", Category.SUBCLASS),
        Classification(
            "40.11.3", "Producţia energiei electrice în centralele nucleare (atomice) electrice", Category.SUBCLASS
        ),
        Classification("40.11.4", "Producţia energiei electrice de alte surse de energie", Category.SUBCLASS),
        Classification("40.12", "Transportul energiei electrice", Category.CLASS),
        Classification("40.12.0", "Transportul energiei electrice", Category.SUBCLASS),
        Classification("40.13", "Distribuţia şi comercializarea energiei electrice", Category.CLASS),
        Classification("40.13.0", "Distribuţia şi comercializarea energiei electrice", Category.SUBCLASS),
        Classification("40.2", "Producţia şi distribuţia combustibilului gazos", Category.GROUP),
        Classification("40.21", "Producţia combustibilului gazos", Category.CLASS),
        Classification("40.21.0", "Producţia combustibilului gazos", Category.SUBCLASS),
        Classification("40.22", "Distribuţia şi comercializarea combustibilului gazos, prin conducte", Category.CLASS),
        Classification(
            "40.22.0", "Distribuţia şi comercializarea combustibilului gazos, prin conducte", Category.SUBCLASS
        ),
        Classification("40.3", "Aprovizionarea cu aburi şi apă caldă", Category.GROUP),
        Classification("40.30", "Aprovizionarea cu aburi şi apă caldă", Category.CLASS),
        Classification("40.30.1", "Producţia energiei termice de centralele termice", Category.SUBCLASS),
        Classification("40.30.2", "Producţia energiei termice de centrele termice independente", Category.SUBCLASS),
        Classification("40.30.3", "Termoficare", Category.SUBCLASS),
        Classification("41", "CAPTAREA, EPURAREA ŞI DISTRIBUŢIA APEI", Category.DIVISION),
        Classification("41.0", "Captarea, epurarea şi distribuţia apei", Category.GROUP),
        Classification("41.00", "Captarea, epurarea şi distribuţia apei", Category.CLASS),
        Classification("41.00.0", "Captarea, epurarea şi distribuţia apei", Category.SUBCLASS),
        Classification("F", "CONSTRUCŢII", Category.SECTION),
        Classification("45", "CONSTRUCŢII", Category.DIVISION),
        Classification("45.1", "Pregătirea terenului pentru construcţii", Category.GROUP),
        Classification("45.11", "Demolarea clădirilor; lucrări de terasament", Category.CLASS),
        Classification("45.11.1", "Demolarea clădirilor", Category.SUBCLASS),
        Classification("45.11.2", "Lucrări de terasament", Category.SUBCLASS),
        Classification("45.11.3", "Executarea stratului de fundaţie", Category.SUBCLASS),
        Classification("45.11.4", "Lucrări explozive", Category.SUBCLASS),
        Classification("45.11.5", "Lucrări de antisurpare", Category.SUBCLASS),
        Classification("45.12", "Lucrări de explorare prin forare şi găurire", Category.CLASS),
        Classification("45.12.0", "Lucrări de explorare prin forare şi găurire", Category.SUBCLASS),
        Classification(
            "45.2",
            "Construcţii complete şi parţiale de clădiri şi construcţii inginereşti; construcţii  civile",
            Category.SECTION,
        ),
        Classification("45.21", "Lucrări de construcţii", Category.CLASS),
        Classification("45.21.1", "Construcţii generale de clădiri", Category.SUBCLASS),
        Classification("45.21.2", "Construcţii inginereşti civile", Category.SUBCLASS),
        Classification("45.22", "Lucrări de învelitori", Category.CLASS),
        Classification("45.22.0", "Lucrări de învelitori", Category.SUBCLASS),
        Classification(
            "45.23",
            "Construcţii de autostrăzi, drumuri, aerodromuri  şi construcţii destinate sportului",
            Category.CLASS,
        ),
        Classification(
            "45.23.0",
            "Construcţii de autostrăzi, drumuri, aerodromuri şi construcţii destinate sportului",
            Category.SUBCLASS,
        ),
        Classification("45.24", "Construcţii hidrotehnice", Category.CLASS),
        Classification("45.24.0", "Construcţii hidrotehnice", Category.SUBCLASS),
        Classification("45.25", "Alte lucrări de construcţii", Category.CLASS),
        Classification("45.25.1", "Construcţii de gospodărire a apelor", Category.SUBCLASS),
        Classification("45.25.9", "Alte lucrări de construcţii, care necesită o pregătire specială", Category.SUBCLASS),
        Classification("45.3", "Utilarea clădirilor", Category.GROUP),
        Classification("45.31", "Lucrări de instalaţii electrice şi montare a armăturii electrice", Category.CLASS),
        Classification(
            "45.31.0", "Lucrări de instalaţii electrice şi montare a armăturii electrice", Category.SUBCLASS
        ),
        Classification("45.32", "Lucrări de izolaţii", Category.CLASS),
        Classification("45.32.0", "Lucrări de izolaţii", Category.SUBCLASS),
        Classification("45.33", "Lucrări de lăcătuşerie şi apeduct", Category.CLASS),
        Classification("45.33.0", "Lucrări de lăcătuşerie şi apeduct", Category.SUBCLASS),
        Classification("45.34", "Alte lucrări de utilare a construcţiilor", Category.CLASS),
        Classification("45.34.0", "Alte lucrări de utilare a construcţiilor", Category.SUBCLASS),
        Classification("45.4", "Lucrări de finisare a construcţiilor", Category.GROUP),
        Classification("45.41", "Lucrări de tencuire", Category.CLASS),
        Classification("45.41.0", "Lucrări de tencuire", Category.SUBCLASS),
        Classification("45.42", "Lucrări de tîmplărie", Category.CLASS),
        Classification("45.42.0", "Lucrări de tîmplărie", Category.SUBCLASS),
        Classification("45.43", "Lucrări de pardosire şi placare a podelelor şi pereţilor", Category.CLASS),
        Classification("45.43.0", "Lucrări de pardosire şi placare a podelelor şi pereţilor", Category.SUBCLASS),
        Classification("45.44", "Lucrări de vopsire şi montare a geamurilor", Category.CLASS),
        Classification("45.44.0", "Lucrări de vopsire şi montare a geamurilor", Category.SUBCLASS),
        Classification("45.45", "Alte lucrări de finisare a construcţiilor", Category.CLASS),
        Classification("45.45.0", "Alte lucrări de finisare a construcţiilor", Category.SUBCLASS),
        Classification(
            "45.5", "Închirierea  echipamentelor pentru construcţii cu personal de deservire aferent", Category.GROUP
        ),
        Classification(
            "45.50", "Închirierea  echipamentelor pentru construcţii cu personal de deservire aferent", Category.CLASS
        ),
        Classification(
            "45.50.0",
            "Închirierea  echipamentelor pentru construcţii cu personal de deservire aferent",
            Category.SUBCLASS,
        ),
        Classification(
            "G",
            "COMERŢ CU RIDICATA ŞI CU AMĂNUNTUL; REPARAREA AUTOVEHICULELOR, MOTOCICLETELOR, A BUNURILOR CASNICE ŞI PERSONALE",
            Category.SECTION,
        ),
        Classification(
            "50",
            "VÎNZAREA, ÎNTREŢINEREA ŞI REPARAREA AUTOVEHICULELOR ŞI MOTOCICLETELOR; COMERŢUL CU AMĂNUNTUL AL CARBURANŢILOR PENTRU MIJLOACELE DE TRANSPORT CU MOTOARE CU ARDERE INTERNĂ",
            Category.DIVISION,
        ),
        Classification("50.1", "Comerţul cu autovehicule", Category.GROUP),
        Classification("50.10", "Comerţul cu autovehicule", Category.CLASS),
        Classification("50.10.1", "Comerţul cu ridicata al autovehiculelor", Category.SUBCLASS),
        Classification("50.10.2", "Comerţul cu amănuntul al autovehiculelor", Category.SUBCLASS),
        Classification("50.2", "Întreţinerea şi repararea autovehiculelor", Category.GROUP),
        Classification("50.20", "Întreţinerea şi repararea autovehiculelor", Category.CLASS),
        Classification("50.20.0", "Întreţinerea şi repararea autovehiculelor", Category.SUBCLASS),
        Classification("50.3", "Comerţul cu piese şi accesorii pentru autovehicule", Category.GROUP),
        Classification("50.30", "Comerţul cu piese şi accesorii pentru autovehicule", Category.CLASS),
        Classification(
            "50.30.1",
            "Comerţul cu ridicata al pieselor, componentelor şi accesoriilor pentru autovehicule",
            Category.SUBCLASS,
        ),
        Classification(
            "50.30.2",
            "Comerţul cu amănuntul al pieselor, componentelor şi accesoriilor pentru autovehicule",
            Category.SUBCLASS,
        ),
        Classification(
            "50.4",
            "Vînzarea, întreţinerea şi repararea motocicletelor; vînzări de piese şi accesorii aferente",
            Category.GROUP,
        ),
        Classification(
            "50.40",
            "Vînzarea, întreţinerea şi repararea motocicletelor; vînzări de piese şi accesorii aferente",
            Category.CLASS,
        ),
        Classification(
            "50.40.1",
            "Comerţul cu ridicata al motocicletelor, scuterelor, pieselor şi accesoriilor aferente",
            Category.SUBCLASS,
        ),
        Classification(
            "50.40.2",
            "Comerţul cu amănuntul al motocicletelor, scuterelor, pieselor şi accesoriilor aferente",
            Category.SUBCLASS,
        ),
        Classification("50.40.3", "Întreţinerea şi repararea motocicletelor şi scuterelor", Category.SUBCLASS),
        Classification("50.5", "Comerţul cu amănuntul al carburanţilor", Category.GROUP),
        Classification("50.50", "Comerţul cu amănuntul al carburanţilor", Category.CLASS),
        Classification("50.50.0", "Comerţul cu amănuntul al carburanţilor", Category.SUBCLASS),
        Classification(
            "51",
            "COMERŢ CU RIDICATA ŞI INTERMEDIERI, EXCLUSIV COMERŢUL CU AUTOVEHICULE ŞI MOTOCICLETE",
            Category.DIVISION,
        ),
        Classification("51.1", "Comerţul cu ridicata pe bază de tarife sau contracte", Category.GROUP),
        Classification(
            "51.11",
            "Intermedieri pentru vînzarea materiei prime agricole, animalelor vii, materiei prime textile şi a semiproduselor",
            Category.CLASS,
        ),
        Classification(
            "51.11.0",
            "Intermedieri pentru vînzarea materiei prime agricole, animalelor vii, materiei prime textile şi a semiproduselor",
            Category.SUBCLASS,
        ),
        Classification(
            "51.12",
            "Intermedieri pentru vînzarea carburanţilor, mineralelor, metalelor şi chimicalelor pentru industrie",
            Category.CLASS,
        ),
        Classification(
            "51.12.0",
            "Intermedieri pentru vînzarea carburanţilor, mineralelor, a metalelor şi chimicalelor pentru industrie",
            Category.SUBCLASS,
        ),
        Classification("51.13", "Intermedieri pentru vînzarea materialului lemnos şi de construcţii", Category.CLASS),
        Classification(
            "51.13.0", "Intermedieri pentru vînzarea materialului lemnos şi de construcţii", Category.SUBCLASS
        ),
        Classification(
            "51.14",
            "Intermedieri pentru vînzarea maşinilor, echipamentelor industriale, navelor şi avioanelor",
            Category.CLASS,
        ),
        Classification(
            "51.14.0",
            "Intermedieri pentru vînzarea maşinilor, echipamentelor industriale, navelor şi avioanelor",
            Category.SUBCLASS,
        ),
        Classification(
            "51.15",
            "Intermedieri pentru vînzarea mobilei, articolelor de menaj, articolelor de fierărie şi altor articole metalice mici",
            Category.CLASS,
        ),
        Classification(
            "51.15.0",
            "Intermedieri pentru vînzarea mobilei, articolelor de menaj, articolelor de fierărie şi altor articole metalice mici",
            Category.SUBCLASS,
        ),
        Classification(
            "51.16",
            "Intermedieri pentru vînzarea textilelor, îmbrăcămintei, încălţămintei şi articolelor din piele",
            Category.CLASS,
        ),
        Classification(
            "51.16.0",
            "Intermedieri pentru vînzarea textilelor, îmbrăcămintei, încălţămintei şi articolelor din piele",
            Category.SUBCLASS,
        ),
        Classification(
            "51.17",
            "Intermedieri pentru vînzarea produselor alimentare, băuturilor şi produselor din tutun",
            Category.CLASS,
        ),
        Classification(
            "51.17.0",
            "Intermedieri pentru vînzarea produselor alimentare, băuturilor şi produselor din tutun",
            Category.SUBCLASS,
        ),
        Classification(
            "51.18",
            "Intermedieri pentru vînzarea unor anumite categorii de mărfuri cu caracter specific",
            Category.CLASS,
        ),
        Classification(
            "51.18.0",
            "Intermedieri pentru vînzarea unor anumite categorii de mărfuri cu caracter specific",
            Category.SUBCLASS,
        ),
        Classification("51.19", "Intermedieri pentru vînzarea unui asortiment larg de mărfuri", Category.CLASS),
        Classification("51.19.0", "Intermedieri pentru vînzarea unui asortiment larg de mărfuri", Category.SUBCLASS),
        Classification("51.2", "Comerţul cu ridicata al produselor agricole brute şi animalelor vii", Category.GROUP),
        Classification(
            "51.21", "Comerţul cu ridicata al cerealelor, seminţelor şi furajelor pentru animale", Category.CLASS
        ),
        Classification(
            "51.21.0", "Comerţul cu ridicata al cerealelor, seminţelor şi furajelor pentru animale", Category.SUBCLASS
        ),
        Classification("51.22", "Comerţul cu ridicata al florilor şi plantelor", Category.CLASS),
        Classification("51.22.0", "Comerţul cu ridicata al florilor şi plantelor", Category.SUBCLASS),
        Classification("51.23", "Comerţul cu ridicata al animalelor vii", Category.CLASS),
        Classification("51.23.0", "Comerţul cu ridicata al animalelor vii", Category.SUBCLASS),
        Classification("51.24", "Comerţul cu ridicata al pieilor brute şi pieilor prelucrate", Category.CLASS),
        Classification("51.24.0", "Comerţul cu ridicata al pieilor brute şi pieilor prelucrate", Category.SUBCLASS),
        Classification("51.25", "Comerţul cu ridicata al tutunului neprelucrat", Category.CLASS),
        Classification("51.25.0", "Comerţul cu ridicata al tutunului neprelucrat", Category.SUBCLASS),
        Classification(
            "51.3", "Comerţul cu ridicata al produselor alimentare, băuturilor şi produselor din tutun", Category.GROUP
        ),
        Classification("51.31", "Comerţul cu ridicata al cartofilor, legumelor şi fructelor", Category.CLASS),
        Classification("51.31.0", "Comerţul cu ridicata al cartofilor, legumelor şi fructelor", Category.SUBCLASS),
        Classification("51.32", "Comerţul cu ridicata al cărnii şi produselor din carne", Category.CLASS),
        Classification("51.32.0", "Comerţul cu ridicata al cărnii şi produselor din carne", Category.SUBCLASS),
        Classification(
            "51.33",
            "Comerţul cu ridicata al laptelui şi produselor lactate, ouălor, uleiurilor şi grăsimilor",
            Category.CLASS,
        ),
        Classification(
            "51.33.0",
            "Comerţul cu ridicata al laptelui şi produselor lactate, ouălor, uleiurilor şi grăsimilor",
            Category.SUBCLASS,
        ),
        Classification("51.34", "Comerţul cu ridicata al băuturilor alcoolice şi altor băuturi", Category.CLASS),
        Classification("51.34.0", "Comerţul cu ridicata al băuturilor alcoolice şi altor băuturi", Category.SUBCLASS),
        Classification("51.35", "Comerţul cu ridicata al produselor din tutun", Category.CLASS),
        Classification("51.35.0", "Comerţul cu ridicata al produselor din tutun", Category.SUBCLASS),
        Classification(
            "51.36", "Comerţul cu ridicata al zahărului, produselor de cofetărie şi din ciocolată", Category.CLASS
        ),
        Classification(
            "51.36.0", "Comerţul cu ridicata al zahărului, produselor de cofetărie şi din ciocolată", Category.SUBCLASS
        ),
        Classification("51.37", "Comerţul cu ridicata cu cafea, ceai, cacao, condimente şi infuzii", Category.CLASS),
        Classification(
            "51.37.0", "Comerţul cu ridicata cu cafea, ceai, cacao, condimente şi infuzii", Category.SUBCLASS
        ),
        Classification("51.38", "Comerţul cu ridicata al altor produse alimentare", Category.CLASS),
        Classification("51.38.1", "Comerţul cu ridicata al peştelui şi produselor din peşte", Category.SUBCLASS),
        Classification("51.38.2", "Comerţul cu ridicata al făinii, inclusiv făină de porumb", Category.SUBCLASS),
        Classification("51.38.3", "Comerţul cu ridicata al crupelor, inclusiv leguminoase boabe", Category.SUBCLASS),
        Classification("51.38.4", "Comerţul cu ridicata al pastelor făinoase", Category.SUBCLASS),
        Classification("51.38.9", "Comerţul cu ridicata al altor produse alimentare", Category.SUBCLASS),
        Classification(
            "51.39",
            "Comerţul cu ridicata în magazine nespecializate cu produse alimentare, băuturi şi produse din tutun",
            Category.CLASS,
        ),
        Classification(
            "51.39.0",
            "Comerţul cu ridicata în magazine nespecializate cu produse alimentare, băuturi şi produse din tutun",
            Category.SUBCLASS,
        ),
        Classification("51.4", "Comerţul cu ridicata al mărfurilor nealimentare de larg consum", Category.GROUP),
        Classification("51.41", "Comerţul cu ridicata al textilelor", Category.CLASS),
        Classification("51.41.0", "Comerţul cu ridicata al textilelor", Category.SUBCLASS),
        Classification("51.42", "Comerţul cu ridicata al îmbrăcămintei şi încălţămintei", Category.CLASS),
        Classification(
            "51.42.1", "Comerţul cu ridicata al articolelor de tricotaje şi de ciorăpărie", Category.SUBCLASS
        ),
        Classification(
            "51.42.2",
            "Comerţul cu ridicata al îmbrăcămintei, cu excepţia articolelor de tricotaje şi de ciorăpărie",
            Category.SUBCLASS,
        ),
        Classification("51.42.3", "Comerţul cu ridicata al încălţămintei", Category.SUBCLASS),
        Classification(
            "51.43", "Comerţul cu ridicata al aparatelor electrice de uz casnic şi aparatelor de radio", Category.CLASS
        ),
        Classification("51.43.1", "Comerţul cu ridicata al aparatelor electrice de uz casnic", Category.SUBCLASS),
        Classification("51.43.2", "Comerţul cu ridicata al aparatelor de radio şi electronice", Category.SUBCLASS),
        Classification(
            "51.44",
            "Comerţul cu ridicata al produselor din porţelan şi sticlă, al tapetelor şi produselor de întreţinere",
            Category.CLASS,
        ),
        Classification(
            "51.44.0",
            "Comerţul cu ridicata al produselor din porţelan şi sticlă, al tapetelor şi produselor de întreţinere",
            Category.SUBCLASS,
        ),
        Classification("51.45", "Comerţul cu ridicata al parfumurilor şi produselor cosmetice", Category.CLASS),
        Classification("51.45.0", "Comerţul cu ridicata al parfumurilor şi produselor cosmetice", Category.SUBCLASS),
        Classification("51.46", "Comerţul cu ridicata al produselor farmaceutice", Category.CLASS),
        Classification("51.46.0", "Comerţul cu ridicata al produselor farmaceutice", Category.SUBCLASS),
        Classification("51.47", "Comerţul cu ridicata al altor produse nealimentare de larg consum", Category.CLASS),
        Classification(
            "51.47.1",
            "Comerţul cu ridicata al mobilei, covoarelor şi pardoselilor pentru podea, al mărfurilor de uz casnic neelectrice",
            Category.SUBCLASS,
        ),
        Classification(
            "51.47.2",
            "Comerţul cu  ridicata al articolelor de papetărie şi de birou, al cărţilor, revistelor, ziarelor",
            Category.SUBCLASS,
        ),
        Classification(
            "51.47.9", "Comerţul cu ridicata al altor produse nealimentare de larg consum", Category.SUBCLASS
        ),
        Classification(
            "51.5",
            "Comerţul cu ridicata al produselor intermediare neagricole, al deşeurilor şi resturilor metalice",
            Category.GROUP,
        ),
        Classification(
            "51.51",
            "Comerţul cu ridicata al combustibililor solizi, lichizi şi gazoşi şi al produselor derivate",
            Category.CLASS,
        ),
        Classification("51.51.1", "Comerţul cu ridicata al petrolului brut şi gazelor asociate", Category.SUBCLASS),
        Classification("51.51.2", "Comerţul cu ridicata al gazului natural", Category.SUBCLASS),
        Classification("51.51.3", "Comerţul cu ridicata al cărbunelui de pămînt", Category.SUBCLASS),
        Classification("51.51.4", "Comerţul cu ridicata al cărbunelui brun şi lignitului", Category.SUBCLASS),
        Classification(
            "51.51.5", "Comerţul cu ridicata al benzinei pentru avioane şi al gazului lampant", Category.SUBCLASS
        ),
        Classification("51.51.6", "Comerţul cu ridicata al benzinei pentru autovehicule", Category.SUBCLASS),
        Classification("51.51.7", "Comerţul cu ridicata al motorinei", Category.SUBCLASS),
        Classification("51.51.8", "Comerţul cu ridicata al păcurii", Category.SUBCLASS),
        Classification("51.51.9", "Comerţul cu ridicata al altor tipuri de combustibil", Category.SUBCLASS),
        Classification("51.52", "Comerţul cu ridicata al metalelor şi minereurilor metalifere", Category.CLASS),
        Classification("51.52.0", "Comerţul cu ridicata al metalelor şi minereurilor metalifere", Category.SUBCLASS),
        Classification(
            "51.53",
            "Comerţul cu ridicata al materialelor lemnoase, al materialelor de construcţie şi echipamentului sanitar",
            Category.CLASS,
        ),
        Classification("51.53.1", "Comerţul cu ridicata al materialului lemnos", Category.SUBCLASS),
        Classification("51.53.2", "Comerţul cu ridicata al echipamentului sanitar", Category.SUBCLASS),
        Classification("51.53.3", "Comerţul cu ridicata al vopselelor, lacurilor şi emailurilor", Category.SUBCLASS),
        Classification(
            "51.53.4", "Comerţul cu ridicata al sticlei: în foi, pentru geamuri şi oglinzi", Category.SUBCLASS
        ),
        Classification(
            "51.53.5",
            "Comerţul cu ridicata al nisipului, cimentului, pietrişului, ghipsului, teracotei etc.",
            Category.SUBCLASS,
        ),
        Classification(
            "51.53.6",
            "Comerţul cu ridicata al elementelor din beton, ciment, ghips şi materiale similare",
            Category.SUBCLASS,
        ),
        Classification(
            "51.53.7",
            "Comerţul cu ridicata al pietrei pentru monumente sau construcţii şi al articolelor din aceasta, al blocurilor de perete",
            Category.SUBCLASS,
        ),
        Classification(
            "51.53.8",
            "Comerţul cu ridicata al construcţiilor prefabricate, al structurilor şi pieselor din metal pentru construcţii",
            Category.SUBCLASS,
        ),
        Classification("51.53.9", "Comerţul cu ridicata al altor materiale de construcţie", Category.SUBCLASS),
        Classification(
            "51.54",
            "Comerţul cu ridicata al articolelor de fierărie, utilajului de apeduct şi de încălzire",
            Category.CLASS,
        ),
        Classification(
            "51.54.0",
            "Comerţul cu ridicata al articolelor de fierărie, utilajului de apeduct şi de încălzire",
            Category.SUBCLASS,
        ),
        Classification("51.55", "Comerţul cu ridicata al produselor chimice", Category.CLASS),
        Classification(
            "51.55.1", "Comerţul cu ridicata al substanţelor chimice şi produselor chimice", Category.SUBCLASS
        ),
        Classification("51.55.2", "Comerţul cu ridicata al articolelor din cauciuc tehnic", Category.SUBCLASS),
        Classification("51.55.3", "Comerţul cu ridicata al îngrăşămintelor minerale", Category.SUBCLASS),
        Classification(
            "51.55.4", "Comerţul cu ridicata al pesticidelor şi altor produse agrochimice", Category.SUBCLASS
        ),
        Classification(
            "51.55.5",
            "Comerţul cu ridicata al maselor plastice în formă primară şi al cauciucului sintetic",
            Category.SUBCLASS,
        ),
        Classification("51.56", "Comerţul cu ridicata al altor produse intermediare", Category.CLASS),
        Classification("51.56.0", "Comerţul cu ridicata al altor produse intermediare", Category.SUBCLASS),
        Classification(
            "51.57", "Comerţul cu ridicata al resturilor, deşeurilor şi materialelor recuperabile", Category.CLASS
        ),
        Classification(
            "51.57.1",
            "Comerţul cu ridicata al resturilor şi deşeurilor de metale feroase şi neferoase",
            Category.SUBCLASS,
        ),
        Classification(
            "51.57.2",
            "Comerţul cu ridicata al resturilor şi deşeurilor de metale nobile şi de pietre preţioase",
            Category.SUBCLASS,
        ),
        Classification("51.57.3", "Comerţul cu ridicata al altor resturi şi deşeuri metalice", Category.SUBCLASS),
        Classification("51.57.4", "Comerţul cu ridicata al resturilor şi deşeurilor nemetalice", Category.SUBCLASS),
        Classification("51.8", "Comerţul cu ridicata al maşinilor, echipamentelor şi furniturilor", Category.GROUP),
        Classification("51.81", "Comerţul cu ridicata al maşinilor-unelte", Category.CLASS),
        Classification("51.81.0", "Comerţul cu ridicata al maşinilor-unelte", Category.SUBCLASS),
        Classification(
            "51.82",
            "Comerţul cu ridicata al maşinilor şi echipamentelor pentru industria minieră şi construcţii",
            Category.CLASS,
        ),
        Classification(
            "51.82.0",
            "Comerţul cu ridicata al maşinilor şi echipamentelor pentru industria minieră şi construcţii",
            Category.SUBCLASS,
        ),
        Classification(
            "51.83",
            "Comerţul cu ridicata al maşinilor pentru industria textilă şi al maşinilor de cusut şi de tricotat",
            Category.CLASS,
        ),
        Classification(
            "51.83.0",
            "Comerţul cu ridicata al maşinilor pentru industria textilă şi al maşinilor de cusut şi de tricotat",
            Category.SUBCLASS,
        ),
        Classification(
            "51.84",
            "Comerţul cu ridicata al calculatoarelor, echipamentelor periferice şi software-ului",
            Category.CLASS,
        ),
        Classification(
            "51.84.0",
            "Comerţul cu ridicata al calculatoarelor, echipamentelor periferice şi software-ului",
            Category.SUBCLASS,
        ),
        Classification("51.85", "Comerţul cu ridicata al altor maşini şi echipamente de birou", Category.CLASS),
        Classification("51.85.0", "Comerţul cu ridicata al altor maşini şi echipamente de birou", Category.SUBCLASS),
        Classification("51.86", "Comerţul cu ridicata al altor componente şi echipamente electronice", Category.CLASS),
        Classification(
            "51.86.0", "Comerţul cu ridicata al altor componente şi echipamente electronice", Category.SUBCLASS
        ),
        Classification(
            "51.87",
            "Comerţul cu ridicata al altor maşini şi echipamente utilizate în industrie, comerţ şi transporturi",
            Category.CLASS,
        ),
        Classification(
            "51.87.0",
            "Comerţul cu ridicata al altor maşini şi echipamente utilizate în industrie, comerţ şi transporturi",
            Category.SUBCLASS,
        ),
        Classification(
            "51.88",
            "Comerţul cu ridicata al maşinilor agricole, echipamentului şi furniturilor, inclusiv tractoare",
            Category.CLASS,
        ),
        Classification(
            "51.88.0",
            "Comerţul cu ridicata al maşinilor agricole, echipamentului şi furniturilor, inclusiv tractoare",
            Category.SUBCLASS,
        ),
        Classification("51.9", "Alte tipuri de comerţ cu ridicata", Category.GROUP),
        Classification("51.90", "Alte tipuri de comerţ cu ridicata", Category.CLASS),
        Classification("51.90.0", "Alte tipuri de comerţ cu ridicata", Category.SUBCLASS),
        Classification("52", "COMERŢ CU AMĂNUNTUL; REPARAREA OBIECTELOR DE UZ CASNIC ŞI PERSONALE", Category.DIVISION),
        Classification("52.1", "Comerţul cu amănuntul în magazine nespecializate", Category.GROUP),
        Classification(
            "52.11",
            "Comerţul cu amănuntul în magazine nespecializate, cu vînzare predominantă de produse alimentare, băuturi şi produse din tutun",
            Category.CLASS,
        ),
        Classification(
            "52.11.0",
            "Comerţul cu amănuntul în magazine nespecializate, cu vînzare predominantă de produse alimentare, băuturi şi produse din tutun",
            Category.SUBCLASS,
        ),
        Classification("52.12", "Alte tipuri de comerţ cu amănuntul în magazine nespecializate", Category.CLASS),
        Classification("52.12.0", "Alte tipuri de comerţ cu amănuntul în magazine nespecializate", Category.SUBCLASS),
        Classification(
            "52.2", "Comerţul cu amănuntul al produselor alimentare în magazine specializate", Category.GROUP
        ),
        Classification(
            "52.21", "Comerţul cu amănuntul al cartofilor, legumelor şi fructelor proaspete", Category.CLASS
        ),
        Classification(
            "52.21.0", "Comerţul cu amănuntul al cartofilor, legumelor şi fructelor proaspete", Category.SUBCLASS
        ),
        Classification("52.22", "Comerţul cu amănuntul al cărnii şi produselor din carne", Category.CLASS),
        Classification(
            "52.22.1",
            "Comerţul cu amănuntul al păsărilor de casă, vînatului şi produselor din acestea",
            Category.SUBCLASS,
        ),
        Classification(
            "52.22.9", "Alte tipuri de comerţ cu amănuntul al cărnii şi altor produse din carne", Category.SUBCLASS
        ),
        Classification("52.23", "Comerţul cu amănuntul al peştelui, crustaceelor şi moluştelor", Category.CLASS),
        Classification("52.23.0", "Comerţul cu amănuntul al peştelui, crustaceelor şi moluştelor", Category.SUBCLASS),
        Classification(
            "52.24", "Comerţul cu amănuntul al pîinii, produselor de patiserie şi de cofetărie", Category.CLASS
        ),
        Classification(
            "52.24.0", "Comerţul cu amănuntul al pîinii, produselor de patiserie şi de cofetărie", Category.SUBCLASS
        ),
        Classification("52.25", "Comerţul cu amănuntul al băuturilor alcoolice şi altor băuturi", Category.CLASS),
        Classification("52.25.0", "Comerţul cu amănuntul al băuturilor alcoolice şi altor băuturi", Category.SUBCLASS),
        Classification("52.26", "Comerţul cu amănuntul al produselor din tutun", Category.CLASS),
        Classification("52.26.0", "Comerţul cu amănuntul al produselor din tutun", Category.SUBCLASS),
        Classification(
            "52.27",
            "Alte tipuri de comerţ cu amănuntul al produselor alimentare în magazine specializate",
            Category.CLASS,
        ),
        Classification(
            "52.27.1",
            "Comerţul cu amănuntul al laptelui şi produselor lactate, ouălor, grăsimilor şi uleiurilor alimentare",
            Category.SUBCLASS,
        ),
        Classification(
            "52.27.2", "Comerţul cu amănuntul  al altor produse alimentare în magazine specializate", Category.SUBCLASS
        ),
        Classification("52.3", "Comerţul cu amănuntul al produselor farmaceutice şi de parfumerie", Category.GROUP),
        Classification("52.31", "Comerţul cu amănuntul al produselor farmaceutice", Category.CLASS),
        Classification("52.31.0", "Comerţul cu amănuntul al produselor farmaceutice", Category.SUBCLASS),
        Classification("52.32", "Comerţul cu amănuntul al articolelor medicale şi ortopedice", Category.CLASS),
        Classification("52.32.0", "Comerţul cu amănuntul al articolelor medicale şi ortopedice", Category.SUBCLASS),
        Classification(
            "52.33",
            "Comerţul cu amănuntul al produselor cosmetice şi de parfumerie, articolelor de toaletă",
            Category.CLASS,
        ),
        Classification(
            "52.33.0",
            "Comerţul cu amănuntul al produselor cosmetice şi de parfumerie, articolelor de toaletă",
            Category.SUBCLASS,
        ),
        Classification("52.4", "Alte tipuri de comerţ cu amănuntul în magazine specializate", Category.GROUP),
        Classification("52.41", "Comerţul cu amănuntul al textilelor", Category.CLASS),
        Classification("52.41.0", "Comerţul cu amănuntul al textilelor", Category.SUBCLASS),
        Classification("52.42", "Comerţul cu amănuntul al îmbrăcămintei", Category.CLASS),
        Classification("52.42.1", "Comerţul cu amănuntul al îmbrăcămintei", Category.SUBCLASS),
        Classification("52.42.2", "Comerţul cu amănuntul al accesoriilor pentru îmbrăcăminte", Category.SUBCLASS),
        Classification("52.43", "Comerţul cu amănuntul al încălţămintei şi articolelor din piele", Category.CLASS),
        Classification("52.43.1", "Comerţul cu amănuntul al încălţămintei", Category.SUBCLASS),
        Classification("52.43.2", "Comerţul cu amănuntul al articolelor din piele", Category.SUBCLASS),
        Classification("52.44", "Comerţul cu amănuntul al mobilei şi echipamentelor de uz casnic", Category.CLASS),
        Classification("52.44.1", "Comerţul cu amănuntul al mobilei", Category.SUBCLASS),
        Classification(
            "52.44.9",
            "Comerţul cu amănuntul al aparatelor de iluminat şi articolelor de uz casnic, neincluse în alte categorii",
            Category.SUBCLASS,
        ),
        Classification(
            "52.45",
            "Comerţul cu amănuntul al articolelor şi aparatelor electrice de uz casnic şi aparatelor de radio",
            Category.CLASS,
        ),
        Classification("52.45.1", "Comerţul cu amănuntul al articolelor electrice de uz casnic", Category.SUBCLASS),
        Classification("52.45.2", "Comerţul cu amănuntul al aparatelor de radio şi televiziune", Category.SUBCLASS),
        Classification(
            "52.45.3", "Comerţul cu amănuntul al instrumentelor muzicale şi partiturilor", Category.SUBCLASS
        ),
        Classification(
            "52.45.9",
            "Comerţul cu amănuntul al altor articole electrice de uz casnic şi aparate de radio şi televiziune",
            Category.SUBCLASS,
        ),
        Classification(
            "52.46", "Comerţul cu amănuntul al articolelor de fierărie, al vopselelor şi sticlei", Category.CLASS
        ),
        Classification(
            "52.46.0", "Comerţul cu amănuntul al articolelor de fierărie, al vopselelor şi sticlei", Category.SUBCLASS
        ),
        Classification("52.47", "Comerţul cu amănuntul al cărţilor, ziarelor şi rechizitelor de birou", Category.CLASS),
        Classification(
            "52.47.0", "Comerţul cu amănuntul al cărţilor, ziarelor şi rechizitelor de birou", Category.SUBCLASS
        ),
        Classification("52.48", "Alte tipuri de comerţ cu amănuntul în magazine specializate", Category.CLASS),
        Classification(
            "52.48.1", "Comerţul cu amănuntul al echipamentului fotografic, optic şi de precizie", Category.SUBCLASS
        ),
        Classification("52.48.2", "Comerţul cu amănuntul al covoarelor şi preşurilor (mochetelor)", Category.SUBCLASS),
        Classification(
            "52.48.3",
            "Comerţul cu amănuntul al produselor de curăţat, al tapetelor şi pardoselilor pentru podea, inclusiv plăci din plută",
            Category.SUBCLASS,
        ),
        Classification("52.48.4", "Comerţul cu amănuntul al ceasurilor şi bijuteriilor", Category.SUBCLASS),
        Classification("52.48.5", "Comerţul cu amănuntul al mărfurilor pentru sport şi turism", Category.SUBCLASS),
        Classification("52.48.6", "Comerţul cu amănuntul cu combustibil şi cărbune", Category.SUBCLASS),
        Classification("52.48.7", "Comerţul cu amănuntul cu flori, plante, seminţe şi îngrăşăminte", Category.SUBCLASS),
        Classification("52.48.9", "Alte tipuri de comerţ cu amănuntul în magazine specializate", Category.SUBCLASS),
        Classification("52.5", "Comerţul cu amănuntul al bunurilor de ocazie vîndute în magazine", Category.GROUP),
        Classification("52.50", "Comerţul cu amănuntul al bunurilor de ocazie vîndute în magazine", Category.CLASS),
        Classification(
            "52.50.0", "Comerţul cu amănuntul al bunurilor de ocazie vîndute în magazine", Category.SUBCLASS
        ),
        Classification("52.6", "Comerţul cu amănuntul neefectuat prin magazine", Category.GROUP),
        Classification("52.61", "Comerţul cu amănuntul prin corespondenţă", Category.CLASS),
        Classification("52.61.0", "Comerţul cu amănuntul prin corespondenţă", Category.SUBCLASS),
        Classification("52.62", "Comerţul cu amănuntul prin standuri şi pieţe", Category.CLASS),
        Classification(
            "52.62.1", "Comerţul cu amănuntul prin standuri şi pieţe cu produse alimentare", Category.SUBCLASS
        ),
        Classification(
            "52.62.2",
            "Comerţul cu amănuntul prin standuri şi pieţe cu alte tipuri de produse şi mărfuri",
            Category.SUBCLASS,
        ),
        Classification("52.63", "Alte tipuri de comerţ cu amănuntul neefectuat prin magazine", Category.CLASS),
        Classification("52.63.1", "Comerţul cu amănuntul ambulant", Category.SUBCLASS),
        Classification("52.63.9", "Alte tipuri de comerţ cu amănuntul neefectuat prin magazine", Category.SUBCLASS),
        Classification("52.7", "Repararea articolelor de uz casnic şi a obiectelor personale", Category.GROUP),
        Classification("52.71", "Reparaţii de încălţăminte şi alte articole din piele", Category.CLASS),
        Classification("52.71.1", "Reparaţii de încălţăminte", Category.SUBCLASS),
        Classification(
            "52.71.2",
            "Reparaţii de articole de voiaj şi de galanterie din piele naturală şi artificială",
            Category.SUBCLASS,
        ),
        Classification("52.72", "Reparaţii de articole şi aparate electrice de uz casnic", Category.CLASS),
        Classification("52.72.0", "Reparaţii de articole şi aparate electrice de uz casnic", Category.SUBCLASS),
        Classification("52.73", "Reparaţii de ceasuri şi bijuterii", Category.CLASS),
        Classification("52.73.1", "Reparaţii de ceasuri", Category.SUBCLASS),
        Classification("52.73.2", "Reparaţii de bijuterii", Category.SUBCLASS),
        Classification(
            "52.74", "Alte reparaţii de bunuri casnice şi personale, neincluse în alte categorii", Category.CLASS
        ),
        Classification("52.74.1", "Reparaţii de articole tricotate şi croşetate", Category.SUBCLASS),
        Classification(
            "52.74.2",
            "Reparaţii de articole de confecţii, acoperăminte pentru cap şi articole de galanterie textilă",
            Category.SUBCLASS,
        ),
        Classification("52.74.3", "Reparaţii de articole din blănuri şi din piele", Category.SUBCLASS),
        Classification("52.74.4", "Reparaţia şi restaurarea mobilei casnice", Category.SUBCLASS),
        Classification("52.74.5", "Reparaţii de covoare şi preşuri", Category.SUBCLASS),
        Classification("52.74.6", "Reparaţii de biciclete", Category.SUBCLASS),
        Classification("52.74.9", "Reparaţii ale altor articole de uz casnic şi obiecte personale", Category.SUBCLASS),
        Classification("H", "HOTELURI ŞI RESTAURANTE", Category.SECTION),
        Classification("55", "HOTELURI ŞI RESTAURANTE", Category.DIVISION),
        Classification("55.1", "Hoteluri", Category.GROUP),
        Classification("55.10", "Hoteluri", Category.CLASS),
        Classification("55.10.0", "Hoteluri", Category.SUBCLASS),
        Classification("55.2", "Campinguri şi alte posibilităţi de cazare de scurtă durată", Category.GROUP),
        Classification("55.21", "Tabere pentru tineret şi baze turistice", Category.CLASS),
        Classification("55.21.0", "Tabere pentru tineret şi baze turistice", Category.SUBCLASS),
        Classification("55.22", "Campinguri", Category.CLASS),
        Classification("55.22.0", "Campinguri", Category.SUBCLASS),
        Classification("55.23", "Alte mijloace de cazare", Category.CLASS),
        Classification("55.23.0", "Alte mijloace de cazare", Category.SUBCLASS),
        Classification("55.3", "Restaurante", Category.GROUP),
        Classification("55.30", "Restaurante", Category.CLASS),
        Classification("55.30.0", "Restaurante", Category.SUBCLASS),
        Classification("55.4", "Baruri", Category.GROUP),
        Classification("55.40", "Baruri", Category.CLASS),
        Classification("55.40.0", "Baruri", Category.SUBCLASS),
        Classification("55.5", "Cantine şi desfacerea alimentelor gata", Category.GROUP),
        Classification("55.51", "Cantine", Category.CLASS),
        Classification("55.51.0", "Cantine", Category.SUBCLASS),
        Classification("55.52", "Activitatea de desfacere a alimentelor gata", Category.CLASS),
        Classification("55.52.0", "Activitatea de desfacere a alimentelor gata", Category.SUBCLASS),
        Classification("I", "TRANSPORTURI ŞI COMUNICAŢII", Category.SECTION),
        Classification("60", "TRANSPORTURI TERESTRE", Category.DIVISION),
        Classification("60.1", "Transporturi pe calea ferată", Category.GROUP),
        Classification("60.10", "Transporturi pe calea ferată", Category.CLASS),
        Classification("60.10.0", "Transporturi pe calea ferată", Category.SUBCLASS),
        Classification("60.2", "Transporturi urbane terestre", Category.GROUP),
        Classification("60.21", "Transporturi terestre de călători pe bază de grafic", Category.CLASS),
        Classification("60.21.1", "Transporturi cu autobuze", Category.SUBCLASS),
        Classification("60.21.2", "Transporturi cu tramvaie", Category.SUBCLASS),
        Classification("60.21.3", "Transporturi cu troleibuze", Category.SUBCLASS),
        Classification("60.21.4", "Transporturi cu metroul", Category.SUBCLASS),
        Classification("60.21.9", "Transporturi cu alte tipuri de transport pe bază de grafic", Category.SUBCLASS),
        Classification("60.22", "Transporturi cu taxiuri de toate tipurile, inclusiv după itinerar", Category.CLASS),
        Classification(
            "60.22.0", "Transporturi cu taxiuri de toate tipurile, inclusiv după itinerar", Category.SUBCLASS
        ),
        Classification("60.23", "Alte transporturi terestre de călători", Category.CLASS),
        Classification("60.23.0", "Alte transporturi terestre de călători", Category.SUBCLASS),
        Classification("60.24", "Transporturi rutiere de mărfuri", Category.CLASS),
        Classification("60.24.0", "Transporturi rutiere de mărfuri", Category.SUBCLASS),
        Classification("60.3", "Transporturi prin conducte", Category.GROUP),
        Classification("60.30", "Transporturi prin conducte", Category.CLASS),
        Classification("60.30.0", "Transporturi prin conducte", Category.SUBCLASS),
        Classification("61", "TRANSPORTURI PE APĂ", Category.DIVISION),
        Classification("61.1", "Transporturi maritime şi de cabotaj", Category.GROUP),
        Classification("61.10", "Transporturi maritime şi de cabotaj", Category.CLASS),
        Classification("61.10.0", "Transporturi maritime şi de cabotaj", Category.SUBCLASS),
        Classification("61.2", "Transporturi pe căi navigabile", Category.GROUP),
        Classification("61.20", "Transporturi pe căi navigabile", Category.CLASS),
        Classification("61.20.0", "Transporturi pe căi navigabile", Category.SUBCLASS),
        Classification("62", "TRANSPORTURI AERIENE", Category.DIVISION),
        Classification("62.1", "Transporturi aeriene pe bază de grafic", Category.GROUP),
        Classification("62.10", "Transporturi aeriene pe bază de grafic", Category.CLASS),
        Classification("62.10.0", "Transporturi aeriene pe bază de grafic", Category.SUBCLASS),
        Classification("62.2", "Transporturi aeriene ocazionale", Category.GROUP),
        Classification("62.20", "Transporturi aeriene ocazionale", Category.CLASS),
        Classification("62.20.0", "Transporturi aeriene ocazionale", Category.SUBCLASS),
        Classification("62.3", "Transporturi spaţiale", Category.GROUP),
        Classification("62.30", "Transporturi spaţiale", Category.CLASS),
        Classification("62.30.0", "Transporturi spaţiale", Category.SUBCLASS),
        Classification(
            "63", "ACTIVITĂŢI ANEXE ŞI AUXILIARE DE TRANSPORT; ACTIVITĂŢI ALE AGENŢIILOR DE TURISM", Category.DIVISION
        ),
        Classification("63.1", "Manipulări şi depozitări", Category.GROUP),
        Classification("63.11", "Manipulări", Category.CLASS),
        Classification("63.11.0", "Manipulări", Category.SUBCLASS),
        Classification("63.12", "Depozitări", Category.CLASS),
        Classification("63.12.0", "Depozitări", Category.SUBCLASS),
        Classification("63.2", "Alte activităţi anexe transporturilor", Category.GROUP),
        Classification("63.21", "Alte activităţi anexe transporturilor terestre", Category.CLASS),
        Classification("63.21.1", "Exploatarea căilor ferate", Category.SUBCLASS),
        Classification("63.21.2", "Exploatarea autostrăzilor", Category.SUBCLASS),
        Classification("63.21.3", "Servicii ale terminalelor", Category.SUBCLASS),
        Classification("63.21.4", "Servicii de păstrare a mijloacelor de transport personale", Category.SUBCLASS),
        Classification("63.22", "Alte activităţi anexe transporturilor pe apă", Category.CLASS),
        Classification("63.22.0", "Alte activităţi anexe transporturilor pe apă", Category.SUBCLASS),
        Classification("63.23", "Alte activităţi anexe transporturilor aeriene", Category.CLASS),
        Classification("63.23.1", "Servicii de dirijare a traficului aerian", Category.SUBCLASS),
        Classification("63.23.9", "Alte activităţi anexe transporturilor de călători şi mărfuri", Category.SUBCLASS),
        Classification("63.3", "Activităţi ale agenţiilor de voiaj şi ghizilor", Category.GROUP),
        Classification("63.30", "Activităţi ale agenţiilor de voiaj şi ghizilor", Category.CLASS),
        Classification("63.30.0", "Activităţi ale agenţiilor de voiaj şi ghizilor", Category.SUBCLASS),
        Classification("63.4", "Organizarea activităţilor de transport", Category.GROUP),
        Classification("63.40", "Organizarea activităţilor de transport", Category.CLASS),
        Classification("63.40.1", "Servicii de expediere şi transport", Category.SUBCLASS),
        Classification("63.40.2", "Controlul tehnic în transporturi", Category.SUBCLASS),
        Classification("63.40.9", "Alte activităţi de expediere şi transport", Category.SUBCLASS),
        Classification("64", "POŞTĂ ŞI TELECOMUNICAŢII", Category.DIVISION),
        Classification("64.1", "Activităţi de poştă şi de curier", Category.GROUP),
        Classification("64.11", "Activităţi de poştă naţională", Category.CLASS),
        Classification("64.11.0", "Activităţi de poştă naţională", Category.SUBCLASS),
        Classification("64.12", "Activităţi de curier", Category.CLASS),
        Classification("64.12.0", "Activităţi de curier", Category.SUBCLASS),
        Classification("64.2", "Telecomunicaţii", Category.GROUP),
        Classification("64.20", "Telecomunicaţii", Category.CLASS),
        Classification("64.20.1", "Activităţi de telefonie interurbană", Category.SUBCLASS),
        Classification("64.20.2", "Activităţi de telefonie urbană şi rurală", Category.SUBCLASS),
        Classification("64.20.3", "Activităţi de telegrafie", Category.SUBCLASS),
        Classification("64.20.4", "Activităţi de poştă electronică", Category.SUBCLASS),
        Classification("64.20.5", "Alte activităţi de telecomunicaţii", Category.SUBCLASS),
        Classification("J", "ACTIVITĂŢI FINANCIARE", Category.SECTION),
        Classification("65", "ACTIVITĂŢI FINANCIARE", Category.DIVISION),
        Classification("65.1", "Intermediere monetară", Category.GROUP),
        Classification("65.11", "Activităţi ale băncii centrale", Category.CLASS),
        Classification("65.11.0", "Activităţi ale băncii centrale", Category.SUBCLASS),
        Classification("65.12", "Alte activităţi de intermedieri monetare", Category.CLASS),
        Classification("65.12.1", "Activităţi ale băncilor, birourilor de cambii", Category.SUBCLASS),
        Classification("65.12.2", "Activităţi ale băncilor de economii", Category.SUBCLASS),
        Classification("65.12.9", "Intermedieri monetare ale altor instituţii financiare", Category.SUBCLASS),
        Classification("65.2", "Alte intermedieri financiare", Category.GROUP),
        Classification("65.21", "Leasing financiar", Category.CLASS),
        Classification("65.21.0", "Leasing financiar", Category.SUBCLASS),
        Classification("65.22", "Activităţi de creditare", Category.CLASS),
        Classification("65.22.0", "Activităţi de creditare", Category.SUBCLASS),
        Classification("65.23", "Alte intermedieri financiare, neincluse în alte categorii", Category.CLASS),
        Classification("65.23.0", "Alte intermedieri financiare, neincluse în alte categorii", Category.SUBCLASS),
        Classification("66", "ACTIVITĂŢI DE ASIGURĂRI", Category.DIVISION),
        Classification("66.0", "Activităţi de asigurări", Category.GROUP),
        Classification("66.01", "Activităţi de asigurări pe viaţă şi capitalizare", Category.CLASS),
        Classification("66.01.1", "Asigurări pe viaţă efectuate de stat", Category.SUBCLASS),
        Classification("66.01.2", "Asigurări pe viaţă neefectuate de stat", Category.SUBCLASS),
        Classification("66.02", "Activităţi ale caselor de pensii", Category.CLASS),
        Classification("66.02.1", "Activităţi de asigurare cu pensii de stat", Category.SUBCLASS),
        Classification("66.02.2", "Activităţi de asigurare cu pensii, cu excepţia celei de stat", Category.SUBCLASS),
        Classification("66.03", "Alte activităţi de asigurări", Category.CLASS),
        Classification("66.03.1", "Activităţi de asigurări de stat", Category.SUBCLASS),
        Classification("66.03.2", "Activităţi de asigurări neefectuate de stat", Category.SUBCLASS),
        Classification("67", "ACTIVITĂŢI AUXILIARE ALE INSTITUŢIILOR FINANCIARE ŞI DE ASIGURĂRI", Category.DIVISION),
        Classification("67.1", "Activităţi auxiliare ale instituţiilor financiare", Category.GROUP),
        Classification("67.11", "Administrarea pieţelor financiare", Category.CLASS),
        Classification("67.11.0", "Administrarea pieţelor financiare", Category.SUBCLASS),
        Classification("67.12", "Operaţii de bursă", Category.CLASS),
        Classification("67.12.0", "Operaţii de bursă", Category.SUBCLASS),
        Classification("67.13", "Alte activităţi auxiliare ale instituţiilor financiare", Category.CLASS),
        Classification("67.13.0", "Alte activităţi auxiliare ale instituţiilor financiare", Category.SUBCLASS),
        Classification("67.2", "Activităţi auxiliare de asigurări şi de asigurare cu pensii", Category.GROUP),
        Classification("67.20", "Activităţi auxiliare de asigurări şi de asigurare cu pensii", Category.CLASS),
        Classification("67.20.0", "Activităţi auxiliare de asigurări şi de asigurare cu pensii", Category.SUBCLASS),
        Classification(
            "K",
            "TRANZACŢII IMOBILIARE, ÎNCHIRIERI ŞI ACTIVITĂŢI DE SERVICII PRESTATE ÎNTREPRINDERILOR",
            Category.SECTION,
        ),
        Classification("70", "TRANZACŢII IMOBILIARE", Category.DIVISION),
        Classification("70.1", "Activităţi imobiliare asupra bunurilor proprii", Category.GROUP),
        Classification("70.11", "Activităţi de pregătire către vînzare a bunurilor imobiliare", Category.CLASS),
        Classification("70.11.0", "Activităţi de pregătire către vînzare a bunurilor imobiliare", Category.SUBCLASS),
        Classification("70.12", "Cumpărarea şi vînzarea de bunuri imobiliare proprii", Category.CLASS),
        Classification("70.12.0", "Cumpărarea şi vînzarea de bunuri imobiliare proprii", Category.SUBCLASS),
        Classification("70.2", "Închirierea bunurilor imobiliare proprii", Category.GROUP),
        Classification("70.20", "Închirierea bunurilor imobiliare proprii", Category.CLASS),
        Classification("70.20.0", "Închirierea bunurilor imobiliare proprii", Category.SUBCLASS),
        Classification("70.3", "Activităţi imobiliare pe bază de tarife sau contracte", Category.GROUP),
        Classification("70.31", "Activităţi ale agenţiilor imobiliare", Category.CLASS),
        Classification(
            "70.31.1",
            "Intermedieri pentru cumpărarea, vînzarea şi închirierea bunurilor imobiliare cu destinaţie tehnică şi de producţie",
            Category.SUBCLASS,
        ),
        Classification(
            "70.31.2",
            "Intermedieri pentru cumpărarea, vînzarea, schimbul şi închirierea locuinţelor şi altor bunuri imobiliare cu destinaţie neproductivă; activitatea birourilor de inventariere tehnică",
            Category.SUBCLASS,
        ),
        Classification("70.32", "Administrarea imobilelor", Category.CLASS),
        Classification("70.32.0", "Administrarea imobilelor", Category.SUBCLASS),
        Classification(
            "71",
            "ÎNCHIRIEREA MAŞINILOR ŞI A ECHIPAMENTELOR FĂRĂ OPERATOR, A BUNURILOR PERSONALE ŞI DE UZ CASNIC",
            Category.DIVISION,
        ),
        Classification("71.1", "Închirierea autoturismelor", Category.GROUP),
        Classification("71.10", "Închirierea autoturismelor", Category.CLASS),
        Classification("71.10.0", "Închirierea autoturismelor", Category.SUBCLASS),
        Classification("71.2", "Închirierea altor mijloace de transport", Category.GROUP),
        Classification(
            "71.21", "Închirierea altor mijloace de transport terestru, inclusiv containere", Category.CLASS
        ),
        Classification(
            "71.21.0", "Închirierea altor mijloace de transport terestru, inclusiv containere", Category.SUBCLASS
        ),
        Classification("71.22", "Închirierea mijloacelor de transport pe apă fără echipaj", Category.CLASS),
        Classification("71.22.0", "Închirierea mijloacelor de transport pe apă fără echipaj", Category.SUBCLASS),
        Classification("71.23", "Închirierea mijloacelor de transport aerian fără echipaj", Category.CLASS),
        Classification("71.23.0", "Închirierea mijloacelor de transport aerian fără echipaj", Category.SUBCLASS),
        Classification("71.3", "Închirierea maşinilor şi echipamentelor", Category.GROUP),
        Classification("71.31", "Închirierea maşinilor şi echipamentelor agricole", Category.CLASS),
        Classification("71.31.0", "Închirierea maşinilor şi echipamentelor agricole", Category.SUBCLASS),
        Classification("71.32", "Închirierea maşinilor şi echipamentelor pentru construcţii", Category.CLASS),
        Classification("71.32.0", "Închirierea maşinilor şi echipamentelor pentru construcţii", Category.SUBCLASS),
        Classification("71.33", "Închirierea maşinilor de birou şi tehnicii de calcul", Category.CLASS),
        Classification("71.33.0", "Închirierea maşinilor de birou şi tehnicii de calcul", Category.SUBCLASS),
        Classification("71.34", "Închirierea altor maşini şi echipamente", Category.CLASS),
        Classification("71.34.0", "Închirierea altor maşini şi echipamente", Category.SUBCLASS),
        Classification(
            "71.4",
            "Închirierea bunurilor personale şi a obiectelor cu destinaţie culturală şi de uz gospodăresc",
            Category.GROUP,
        ),
        Classification(
            "71.40",
            "Închirierea bunurilor personale şi a obiectelor cu destinaţie culturală şi de uz gospodăresc",
            Category.CLASS,
        ),
        Classification(
            "71.40.0",
            "Închirierea bunurilor personale şi a obiectelor cu destinaţie culturală şi de uz gospodăresc",
            Category.SUBCLASS,
        ),
        Classification("72", "TEHNICĂ DE CALCUL ŞI ACTIVITĂŢI CONEXE", Category.DIVISION),
        Classification("72.1", "Consultaţii în domeniul sistemelor de calcul", Category.GROUP),
        Classification("72.10", "Consultaţii în domeniul sistemelor de calcul", Category.CLASS),
        Classification("72.10.0", "Consultaţii in domeniul sistemelor de calcul", Category.SUBCLASS),
        Classification("72.2", "Realizarea de programe şi consultanţă în domeniul dat", Category.GROUP),
        Classification("72.21", "Editarea de programe", Category.CLASS),
        Classification("72.21.0", "Editarea de programe", Category.SUBCLASS),
        Classification("72.22", "Realizarea de programe şi consultanţă în domeniul dat", Category.CLASS),
        Classification("72.22.0", "Realizarea de programe şi consultanţă în domeniul dat", Category.SUBCLASS),
        Classification("72.3", "Prelucrarea datelor", Category.GROUP),
        Classification("72.30", "Prelucrarea datelor", Category.CLASS),
        Classification("72.30.0", "Prelucrarea datelor", Category.SUBCLASS),
        Classification("72.4", "Activităţi legate de băncile de date", Category.GROUP),
        Classification("72.40", "Activităţi legate de băncile de date", Category.CLASS),
        Classification("72.40.0", "Activităţi legate de băncile de date", Category.SUBCLASS),
        Classification("72.5", "Întreţinerea şi repararea maşinilor de birou şi a tehnicii de calcul", Category.GROUP),
        Classification("72.50", "Întreţinerea şi repararea maşinilor de birou şi a tehnicii de calcul", Category.CLASS),
        Classification(
            "72.50.0", "Întreţinerea şi repararea maşinilor de birou şi a tehnicii de calcul", Category.SUBCLASS
        ),
        Classification("72.6", "Alte activităţi legate de tehnica de calcul", Category.GROUP),
        Classification("72.60", "Alte activităţi legate de tehnica de calcul", Category.CLASS),
        Classification("72.60.0", "Alte activităţi legate de tehnica de calcul", Category.SUBCLASS),
        Classification("73", "CERCETARE ŞI DEZVOLTARE", Category.DIVISION),
        Classification("73.1", "Cercetare şi dezvoltare în ştiinţe fizice şi naturale", Category.GROUP),
        Classification("73.10", "Cercetare şi dezvoltare în ştiinţe fizice şi naturale", Category.CLASS),
        Classification("73.10.0", "Cercetare şi dezvoltare în ştiinţe fizice şi naturale", Category.SUBCLASS),
        Classification("73.2", "Cercetare şi dezvoltare în ştiinţe sociale şi umanistice", Category.GROUP),
        Classification("73.20", "Cercetare şi dezvoltare în ştiinţe sociale şi umanistice", Category.CLASS),
        Classification("73.20.0", "Cercetare şi dezvoltare în ştiinţe sociale şi umanistice", Category.SUBCLASS),
        Classification("74", "ALTE ACTIVITĂŢI DE SERVICII PRESTATE ÎN PRINCIPAL ÎNTREPRINDERILOR", Category.DIVISION),
        Classification(
            "74.1",
            "Activităţi juridice, de contabilitate şi revizie contabilă şi consultaţii pentru management",
            Category.GROUP,
        ),
        Classification("74.11", "Activităţi juridice", Category.CLASS),
        Classification(
            "74.11.1",
            "Activităţi ale birourilor şi serviciilor de consultatii juridice (inclusiv ale avocaţilor particulari)",
            Category.SUBCLASS,
        ),
        Classification("74.11.2", "Activităţi de notariat", Category.SUBCLASS),
        Classification("74.12", "Activităţi în domeniul evidenţei contabile", Category.CLASS),
        Classification("74.12.0", "Activităţi în domeniul evidenţei contabile", Category.SUBCLASS),
        Classification("74.13", "Activităţi de cercetare a pieţei şi de sondaj al opiniei publice", Category.CLASS),
        Classification(
            "74.13.0", "Activităţi de cercetare a pieţei şi de sondaj al opiniei publice", Category.SUBCLASS
        ),
        Classification("74.14", "Activităţi de consultare pentru afaceri şi management", Category.CLASS),
        Classification("74.14.0", "Activităţi de consultare pentru afaceri şi management", Category.SUBCLASS),
        Classification("74.15", "Activităţi de administrare a companiilor holding", Category.CLASS),
        Classification("74.15.0", "Activităţi de administrare a companiilor holding", Category.SUBCLASS),
        Classification("74.2", "Activităţi în domeniul arhitecturii şi inginerie", Category.GROUP),
        Classification("74.20", "Activităţi în domeniul arhitecturii şi inginerie", Category.CLASS),
        Classification("74.20.1", "Activităţi de arhitectură, inginerie şi activităţi tehnice", Category.SUBCLASS),
        Classification(
            "74.20.2",
            "Activităţi de cercetare, explorare, prospectare geologică (exclusiv cercetări şi elaborări ştiinţifice)",
            Category.SUBCLASS,
        ),
        Classification("74.20.3", "Servicii de cercetări geodezice", Category.SUBCLASS),
        Classification("74.20.4", "Activităţi ale serviciilor de hidrometeorologie", Category.SUBCLASS),
        Classification("74.20.5", "Activităţi de organizare a regimului proprietăţii funciare", Category.SUBCLASS),
        Classification("74.3", "Activităţi de testări şi analize tehnice", Category.GROUP),
        Classification("74.30", "Activităţi de testări şi analize tehnice", Category.CLASS),
        Classification("74.30.1", "Activităţi ale instituţiilor sanitaro-epidemiologice", Category.SUBCLASS),
        Classification("74.30.2", "Activităţi ale instituţiilor de instruire sanitară", Category.SUBCLASS),
        Classification(
            "74.30.9",
            "Activităţi ale altor instituţii care efectuează activităţi de testare şi analize tehnice",
            Category.SUBCLASS,
        ),
        Classification("74.4", "Publicitate", Category.GROUP),
        Classification("74.40", "Publicitate", Category.CLASS),
        Classification("74.40.0", "Publicitate", Category.SUBCLASS),
        Classification("74.5", "Selecţia şi plasarea forţei de muncă", Category.GROUP),
        Classification("74.50", "Selecţia şi plasarea forţei de muncă", Category.CLASS),
        Classification("74.50.0", "Selecţia şi plasarea forţei de muncă", Category.SUBCLASS),
        Classification("74.6", "Activităţi de investigaţie şi protecţie a bunurilor şi persoanelor", Category.GROUP),
        Classification("74.60", "Activităţi de investigaţie şi protecţie a bunurilor şi persoanelor", Category.CLASS),
        Classification(
            "74.60.0", "Activităţi de investigaţie şi protecţie a bunurilor şi persoanelor", Category.SUBCLASS
        ),
        Classification("74.7", "Activităţi de întreţinere şi curăţare a clădirilor", Category.GROUP),
        Classification("74.70", "Activităţi de întreţinere şi curăţare a clădirilor", Category.CLASS),
        Classification("74.70.0", "Activităţi de întreţinere şi curăţare a clădirilor", Category.SUBCLASS),
        Classification("74.8", "Alte activităţi de servicii prestate în principal întreprinderilor", Category.GROUP),
        Classification("74.81", "Activităţi fotografice", Category.CLASS),
        Classification("74.81.0", "Activităţi fotografice", Category.SUBCLASS),
        Classification("74.82", "Activităţi de ambalare", Category.CLASS),
        Classification("74.82.0", "Activităţi de ambalare", Category.SUBCLASS),
        Classification("74.85", "Activităţi de secretariat şi traducere", Category.CLASS),
        Classification("74.85.0", "Activităţi de secretariat şi traducere", Category.SUBCLASS),
        Classification("74.86", "Activităţi ale centrelor de informare telefonică", Category.CLASS),
        Classification("74.86.0", "Activităţi ale centrelor de informare telefonică", Category.SUBCLASS),
        Classification(
            "74.87",
            "Alte activităţi de servicii prestate întreprinderilor, neincluse în alte categorii",
            Category.CLASS,
        ),
        Classification(
            "74.87.0",
            "Alte activităţi de servicii prestate întreprinderilor, neincluse în alte categorii",
            Category.SUBCLASS,
        ),
        Classification("L", "ADMINISTRAŢIE PUBLICĂ", Category.SECTION),
        Classification("75", "ADMINISTRAŢIE PUBLICĂ", Category.DIVISION),
        Classification("75.1", "Activităţi de administraţie generală, administrarea social-economică", Category.GROUP),
        Classification("75.11", "Activităţi de administraţie generală", Category.CLASS),
        Classification(
            "75.11.1",
            "Activităţi de administraţie publică generală ale organelor executive şi legislative republicane",
            Category.SUBCLASS,
        ),
        Classification(
            "75.11.2", "Activităţi de administraţie publică generală ale organelor regionale", Category.SUBCLASS
        ),
        Classification("75.11.3", "Activităţi de administraţie publică ale organelor locale", Category.SUBCLASS),
        Classification(
            "75.11.4",
            "Activităţi de administraţie publică ale organelor locale (primăriilor) din sate (comune)",
            Category.SUBCLASS,
        ),
        Classification("75.11.5", "Activităţi de administraţie fiscală", Category.SUBCLASS),
        Classification("75.11.6", "Activitatea vămilor", Category.SUBCLASS),
        Classification(
            "75.11.7", "Activităţi de administrare a serviciilor statistice şi sociologice", Category.SUBCLASS
        ),
        Classification("75.12", "Administrarea şi susţinerea programelor sociale", Category.CLASS),
        Classification("75.12.0", "Administrarea şi susţinerea programelor sociale", Category.SUBCLASS),
        Classification("75.13", "Reglementarea şi susţinerea activităţilor economice", Category.CLASS),
        Classification("75.13.0", "Reglementarea şi susţinerea activităţilor economice", Category.SUBCLASS),
        Classification("75.14", "Activităţi auxiliare pentru organele administraţiei publice", Category.CLASS),
        Classification("75.14.0", "Activităţi auxiliare pentru organele administraţiei publice", Category.SUBCLASS),
        Classification("75.2", "Activităţi de servicii pentru societate", Category.GROUP),
        Classification("75.21", "Activităţi de afaceri externe", Category.CLASS),
        Classification("75.21.0", "Activităţi de afaceri externe", Category.SUBCLASS),
        Classification("75.22", "Activităţi de apărare naţională", Category.CLASS),
        Classification("75.22.0", "Activităţi de apărare naţională", Category.SUBCLASS),
        Classification("75.23", "Activităţi de justiţie", Category.CLASS),
        Classification("75.23.0", "Activităţi de justiţie", Category.SUBCLASS),
        Classification("75.24", "Activităţi în domeniul ocrotirii ordinii publice şi a securităţii", Category.CLASS),
        Classification(
            "75.24.0", "Activităţi în domeniul ocrotirii ordinii publice şi a securităţii", Category.SUBCLASS
        ),
        Classification("75.25", "Activităţi ale unităţilor de pompieri", Category.CLASS),
        Classification("75.25.0", "Activităţi ale unităţilor de pompieri", Category.SUBCLASS),
        Classification("75.3", "Activităţi de protecţie socială obligatorie", Category.GROUP),
        Classification("75.30", "Activităţi de protecţie socială obligatorie", Category.CLASS),
        Classification("75.30.0", "Activităţi de protecţie socială obligatorie", Category.SUBCLASS),
        Classification("M", "ÎNVĂŢĂMÎNT", Category.SECTION),
        Classification("80", "ÎNVĂŢĂMÎNT", Category.DIVISION),
        Classification("80.1", "Învăţămînt primar", Category.GROUP),
        Classification("80.10", "Învăţămînt primar", Category.CLASS),
        Classification("80.10.1", "Învăţămînt preşcolar", Category.SUBCLASS),
        Classification("80.10.2", "Învăţămînt primar", Category.SUBCLASS),
        Classification("80.10.3", "Învăţămînt extraşcolar", Category.SUBCLASS),
        Classification("80.2", "Învăţămînt secundar", Category.GROUP),
        Classification("80.21", "Învăţămînt secundar general", Category.CLASS),
        Classification("80.21.1", "Învăţămînt gimnazial", Category.SUBCLASS),
        Classification("80.21.2", "Învăţămînt liceal, învăţămînt mediu de cultură generală", Category.SUBCLASS),
        Classification("80.22", "Învăţămînt secundar tehnic şi profesional", Category.CLASS),
        Classification("80.22.1", "Învăţămînt secundar profesional", Category.SUBCLASS),
        Classification("80.22.2", "Învăţămînt mediu de specialitate (colegii)", Category.SUBCLASS),
        Classification("80.3", "Învăţămînt superior", Category.GROUP),
        Classification("80.30", "Învăţămînt superior", Category.CLASS),
        Classification("80.30.1", "Învăţămînt superior universitar", Category.SUBCLASS),
        Classification("80.30.2", "Învăţămînt postuniversitar", Category.SUBCLASS),
        Classification("80.4", "Învăţămînt pentru adulţi şi alte forme de învăţămînt", Category.GROUP),
        Classification("80.41", "Activitatea şcolilor de conducere", Category.CLASS),
        Classification("80.41.0", "Activitatea şcolilor de conducere", Category.SUBCLASS),
        Classification(
            "80.42", "Învăţămînt pentru adulţi şi alte forme de învăţămînt, neincluse în alte categorii", Category.CLASS
        ),
        Classification("80.42.1", "Activitatea şcolilor serale de cultură generală", Category.SUBCLASS),
        Classification("80.42.2", "Activitatea lectoratelor şi a universităţilor populare", Category.SUBCLASS),
        Classification(
            "80.42.9",
            "Alte forme de învăţămînt pentru adulţi şi alt învăţămînt, neinclus în alte categorii",
            Category.SUBCLASS,
        ),
        Classification("N", "SĂNĂTATE ŞI ASISTENŢĂ SOCIALĂ", Category.SECTION),
        Classification("85", "SĂNĂTATE ŞI ASISTENŢĂ SOCIALĂ", Category.DIVISION),
        Classification("85.1", "Activităţi referitoare la sănătatea umană", Category.GROUP),
        Classification("85.11", "Activităţi de asistenţă spitalicească", Category.CLASS),
        Classification(
            "85.11.1", "Activitatea spitalelor de profil larg şi a spitalelor specializate", Category.SUBCLASS
        ),
        Classification("85.11.2", "Activitatea maternităţilor", Category.SUBCLASS),
        Classification("85.11.3", "Activitatea instituţiilor sanatorial-curative", Category.SUBCLASS),
        Classification("85.11.4", "Activitatea leprozeriilor", Category.SUBCLASS),
        Classification("85.11.9", "Activitatea altor instituţii medicale cu staţionar", Category.SUBCLASS),
        Classification("85.12", "Practica medicală", Category.CLASS),
        Classification("85.12.0", "Practica medicală", Category.SUBCLASS),
        Classification("85.13", "Practica stomatologică", Category.CLASS),
        Classification("85.13.0", "Practica stomatologică", Category.SUBCLASS),
        Classification("85.14", "Alte activităţi de asistenţă medicală", Category.CLASS),
        Classification("85.14.0", "Alte activităţi de asistenţă medicală", Category.SUBCLASS),
        Classification("85.2", "Activităţi veterinare", Category.GROUP),
        Classification("85.20", "Activităţi veterinare", Category.CLASS),
        Classification("85.20.0", "Activităţi veterinare", Category.SUBCLASS),
        Classification("85.3", "Activităţi de asistenţă socială", Category.GROUP),
        Classification("85.31", "Activităţi de asistentă socială cu cazare", Category.CLASS),
        Classification("85.31.0", "Activităţi de asistentă socială cu cazare", Category.SUBCLASS),
        Classification("85.32", "Activităţi de asistenţă socială fără cazare", Category.CLASS),
        Classification("85.32.0", "Activităţi de asistenţă socială fără cazare", Category.SUBCLASS),
        Classification("O", "ALTE ACTIVITĂŢI DE SERVICII COLECTIVE, SOCIALE ŞI PERSONALE", Category.SECTION),
        Classification(
            "90",
            "Eliminarea deşeurilor şi a apelor uzate; asanare, SALUBRITATE ŞI ACTIVITĂŢI SIMILARE",
            Category.DIVISION,
        ),
        Classification(
            "90.0",
            "Eliminarea deşeurilor şi a apelor uzate; asanare, SALUBRITATE ŞI ACTIVITĂŢI SIMILARE",
            Category.GROUP,
        ),
        Classification("90.01", "Colectarea şi tratarea apelor uzate", Category.CLASS),
        Classification("90.01.0", "Colectarea şi tratarea apelor uzate", Category.SUBCLASS),
        Classification("90.02", "Colectarea şi tratarea altor reziduuri", Category.CLASS),
        Classification("90.02.0", "Colectarea şi tratarea altor reziduuri", Category.SUBCLASS),
        Classification("90.03", "Salubritate, depoluare şi activităţi similare", Category.CLASS),
        Classification("90.03.0", "Salubritate, depoluare şi activităţi similare", Category.SUBCLASS),
        Classification("91", "ACTIVITĂŢI ASOCIATIVE", Category.DIVISION),
        Classification("91.1", "Activităţi ale organizaţiilor economice, patronale şi profesionale", Category.GROUP),
        Classification("91.11", "Activităţi ale organizaţiilor economice şi patronale", Category.CLASS),
        Classification("91.11.0", "Activităţi ale organizaţiilor economice şi patronale", Category.SUBCLASS),
        Classification("91.12", "Activităţi ale organizaţiilor profesionale", Category.CLASS),
        Classification("91.12.0", "Activităţi ale organizaţiilor profesionale", Category.SUBCLASS),
        Classification("91.2", "Activităţi ale sindicatelor salariaţilor", Category.GROUP),
        Classification("91.20", "Activităţi ale sindicatelor salariaţilor", Category.CLASS),
        Classification("91.20.0", "Activităţi ale sindicatelor salariaţilor", Category.SUBCLASS),
        Classification("91.3", "Alte activităţi asociative", Category.SECTION),
        Classification("91.31", "Activităţi ale organizaţiilor religioase", Category.CLASS),
        Classification("91.31.0", "Activităţi ale organizaţiilor religioase", Category.SUBCLASS),
        Classification("91.32", "Activităţi ale organizaţiilor politice", Category.CLASS),
        Classification("91.32.0", "Activităţi ale organizaţiilor politice", Category.SUBCLASS),
        Classification("91.33", "Alte activităţi asociative, neincluse în alte categorii", Category.CLASS),
        Classification("91.33.0", "Alte activităţi asociative, neincluse în alte categorii", Category.SUBCLASS),
        Classification("92", "ACTIVITĂŢI RECREATIVE, CULTURALE ŞI SPORTIVE", Category.DIVISION),
        Classification("92.1", "Activităţi cinematografice şi video", Category.GROUP),
        Classification("92.11", "Producţia de filme cinematografice şi video", Category.CLASS),
        Classification("92.11.0", "Producţia de filme cinematografice şi video", Category.SUBCLASS),
        Classification("92.12", "Distribuţia de filme cinematografice şi video", Category.CLASS),
        Classification("92.12.0", "Distribuţia de filme cinematografice şi video", Category.SUBCLASS),
        Classification("92.13", "Proiecţia de filme cinematografice", Category.CLASS),
        Classification("92.13.0", "Proiecţia de filme cinematografice", Category.SUBCLASS),
        Classification("92.2", "Activităţi de radio şi televiziune", Category.GROUP),
        Classification("92.20", "Activităţi de radio şi televiziune", Category.CLASS),
        Classification("92.20.0", "Activităţi de radio şi televiziune", Category.SUBCLASS),
        Classification("92.3", "Alte activităţi de spectacole şi recreative", Category.GROUP),
        Classification("92.31", "Activităţi de spectacole, muzică şi alte genuri de artă", Category.CLASS),
        Classification("92.31.1", "Activităţi de spectacole", Category.SUBCLASS),
        Classification("92.31.2", "Activităţi de concerte", Category.SUBCLASS),
        Classification(
            "92.31.3", "Activităţi ale studiourilor de arte plastice, organizaţiilor de prezentare", Category.SUBCLASS
        ),
        Classification("92.32", "Activităţi ale sălilor de spectacole", Category.CLASS),
        Classification("92.32.0", "Activităţi ale sălilor de spectacole", Category.SUBCLASS),
        Classification("92.33", "Activităţi ale parcurilor de distracţii şi odihnă", Category.CLASS),
        Classification("92.33.0", "Activităţi ale parcurilor de distracţii şi odihnă", Category.SUBCLASS),
        Classification("92.34", "Alte activităţi recreative, neincluse în alte categorii", Category.CLASS),
        Classification("92.34.1", "Activităţi ale circurilor, rodeo, sălilor de tir", Category.SUBCLASS),
        Classification("92.34.2", "Activităţi ale teatrelor de marionete", Category.SUBCLASS),
        Classification(
            "92.34.3", "Activităţi ale sălilor de dans, discotecilor şi şcolilor de dans", Category.SUBCLASS
        ),
        Classification("92.4", "Activităţi ale agenţiilor de presă", Category.GROUP),
        Classification("92.40", "Activităţi ale agenţiilor de presă", Category.CLASS),
        Classification("92.40.0", "Activităţi ale agenţiilor de presă", Category.SUBCLASS),
        Classification("92.5", "Alte activităţi culturale", Category.GROUP),
        Classification("92.51", "Activităţi ale bibliotecilor", Category.CLASS),
        Classification("92.51.1", "Activităţi ale fonotecilor şi filmotecilor", Category.SUBCLASS),
        Classification(
            "92.51.2",
            "Activităţi ale bibliotecilor, inclusiv activităţi ale sălilor de lectură, de audiţie (de conferinţe), ale sălilor de proiecţie (de prezentare)",
            Category.SUBCLASS,
        ),
        Classification("92.51.3", "Activităţi ale arhivelor", Category.SUBCLASS),
        Classification("92.51.4", "Activităţi ale camerelor cărţii", Category.SUBCLASS),
        Classification("92.51.5", "Activităţi ale instituţiilor de cultură tip club", Category.SUBCLASS),
        Classification("92.52", "Administrarea patrimoniului cultural", Category.CLASS),
        Classification("92.52.1", "Activităţi ale muzeelor", Category.SUBCLASS),
        Classification(
            "92.52.2",
            "Paza şi conservarea locurilor şi clădirilor istorice şi a monumentelor de cultură",
            Category.SUBCLASS,
        ),
        Classification("92.52.3", "Activităţi ale expoziţiilor", Category.SUBCLASS),
        Classification("92.53", "Administrarea patrimoniului natural", Category.CLASS),
        Classification("92.53.1", "Activităţi ale grădinilor botanice şi zoologice", Category.SUBCLASS),
        Classification(
            "92.53.2", "Activităţi ale rezervaţiilor naturale, ocrotirea naturii virgine", Category.SUBCLASS
        ),
        Classification("92.6", "Activităţi sportive", Category.GROUP),
        Classification("92.61", "Activităţi ale bazelor şi amenajărilor sportive", Category.CLASS),
        Classification("92.61.0", "Activităţi ale bazelor şi amenajărilor sportive", Category.SUBCLASS),
        Classification("92.62", "Alte activităţi sportive", Category.CLASS),
        Classification("92.62.0", "Alte activităţi sportive", Category.SUBCLASS),
        Classification("92.7", "Activităţi recreative", Category.GROUP),
        Classification("92.71", "Activităţi legate de jocurile de noroc şi pariuri", Category.CLASS),
        Classification("92.71.0", "Activităţi legate de jocurile de noroc şi pariuri", Category.SUBCLASS),
        Classification("92.72", "Alte activităţi recreative", Category.CLASS),
        Classification("92.72.0", "Alte activităţi recreative", Category.SUBCLASS),
        Classification("93", "ACTIVITĂŢI DE SERVICII PARTICULARE", Category.SECTION),
        Classification("93.0", "Activităţi de servicii particulare", Category.GROUP),
        Classification("93.01", "Spălarea, curăţarea şi vopsirea textilelor şi blănurilor", Category.CLASS),
        Classification("93.01.1", "Spălarea şi călcatul lenjeriei", Category.SUBCLASS),
        Classification("93.01.2", "Curăţarea chimică şi vopsirea", Category.SUBCLASS),
        Classification(
            "93.02", "Servicii ale frizeriilor şi alte servicii ale cabinetelor de cosmetică", Category.CLASS
        ),
        Classification(
            "93.02.0", "Servicii ale frizeriilor şi alte servicii ale cabinetelor de cosmetică", Category.SUBCLASS
        ),
        Classification("93.03", "Activităţi de pompe funebre şi servicii similare", Category.CLASS),
        Classification("93.03.0", "Activităţi de pompe funebre şi servicii similare", Category.SUBCLASS),
        Classification("93.04", "Activităţi de întreţinere corporală", Category.CLASS),
        Classification("93.04.0", "Activităţi de întreţinere corporală", Category.SUBCLASS),
        Classification("93.05", "Alte activităţi de servicii individuale", Category.CLASS),
        Classification("93.05.0", "Alte activităţi de servicii individuale", Category.SUBCLASS),
        Classification(
            "P",
            "Servicii acordate GOSPODĂRIIlor PARTICULARE de către personalul angajat şi activitatea gospodăriilor particulare privind producerea bunurilor şi serviciilor destinate consumului propriu",
            Category.SECTION,
        ),
        Classification("95", "ACTIVITĂŢI ALE PERSONALULUI ANGAJAT ÎN GOSPODĂRII PARTICULARE", Category.DIVISION),
        Classification("95.0", "Activităţi ale personalului angajat în gospodării particulare", Category.GROUP),
        Classification("95.00", "Activităţi ale personalului angajat în gospodării particulare", Category.CLASS),
        Classification("95.00.0", "Activităţi ale personalului angajat în gospodării particulare", Category.SUBCLASS),
        Classification(
            "96",
            "Activităţi desfăşurate în gospodării private de producere a bunurilor destinate consumului propriu",
            Category.DIVISION,
        ),
        Classification(
            "96.0",
            "Activităţi desfăşurate în gospodării private de producere a bunurilor destinate consumului propriu",
            Category.GROUP,
        ),
        Classification(
            "96.00",
            "Activităţi desfăşurate în gospodării private de producere a bunurilor destinate consumului propriu",
            Category.CLASS,
        ),
        Classification(
            "96.00.0",
            "Activităţi desfăşurate în gospodării private de producere a bunurilor destinate consumului propriu",
            Category.SUBCLASS,
        ),
        Classification(
            "97", "Activităţi ale gospodăriilor private, de servicii pentru scopuri proprii", Category.DIVISION
        ),
        Classification(
            "97.0", "Activităţi ale gospodăriilor private, de servicii pentru scopuri proprii", Category.GROUP
        ),
        Classification(
            "97.00", "Activităţi ale gospodăriilor private, de servicii pentru scopuri proprii", Category.CLASS
        ),
        Classification(
            "97.00.0", "Activităţi ale gospodăriilor private, de servicii pentru scopuri proprii", Category.SUBCLASS
        ),
        Classification("Q", "ACTIVITĂŢI ALE ORGANIZAŢIILOR EXTRATERITORIALE", Category.SECTION),
        Classification("99", "Activităţi ale organizaţiilor extrateritoriale", Category.DIVISION),
        Classification("99.0", "Activităţi ale organizaţiilor extrateritoriale", Category.GROUP),
        Classification("99.00", "Activităţi ale organizaţiilor extrateritoriale", Category.CLASS),
        Classification("99.00.0", "Activităţi ale organizaţiilor extrateritoriale", Category.SUBCLASS),
    ],
)
