# mypy-boto3-batch

Type annotations for
[boto3.Batch 1.10.41](https://boto3.amazonaws.com/v1/documentation/api/1.10.41/reference/services/batch.html#Batch) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

More information can be found [here](https://vemel.github.io/mypy_boto3/).

- [mypy-boto3-batch](#mypy-boto3-batch)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Batch` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-batch]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import batch
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_batch as batch

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("batch")
client: batch.BatchClient = boto3.client("batch")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: batch.BatchClient = session.client("batch")


# Paginators need type annotation on creation
describe_compute_environments_paginator: batch.DescribeComputeEnvironmentsPaginator = client.get_paginator("describe_compute_environments")
describe_job_definitions_paginator: batch.DescribeJobDefinitionsPaginator = client.get_paginator("describe_job_definitions")
describe_job_queues_paginator: batch.DescribeJobQueuesPaginator = client.get_paginator("describe_job_queues")
list_jobs_paginator: batch.ListJobsPaginator = client.get_paginator("list_jobs")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.