
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in pycam02ucs.cm.viscm
parameters = {'xp': [0.86269718792866001, 6.009652361175199, 12.524034763882469, 10.94500171467763, 4.4635202331961636, -7.4191958161865443],
              'yp': [2.0576131687242878, 7.466159052453463, 11.907783417935718, 18.261316872428011, 29.063786008230466, 16.820987654321016],
              'min_Jp': 15.0,
              'max_Jp': 95.0}

cm_data = [[ 0.13399213, 0.11971138, 0.10619267],
           [ 0.13788616, 0.12236452, 0.10817502],
           [ 0.14178245, 0.1250035 , 0.11014172],
           [ 0.14568096, 0.12762883, 0.11209297],
           [ 0.14958171, 0.13024099, 0.11402893],
           [ 0.15348472, 0.13284043, 0.11594979],
           [ 0.15739005, 0.13542757, 0.11785572],
           [ 0.16129774, 0.13800281, 0.11974689],
           [ 0.16520787, 0.14056654, 0.12162345],
           [ 0.16912051, 0.14311912, 0.12348554],
           [ 0.17303574, 0.14566089, 0.12533331],
           [ 0.17695362, 0.1481922 , 0.12716687],
           [ 0.18087425, 0.15071336, 0.12898633],
           [ 0.18479769, 0.15322469, 0.13079179],
           [ 0.18872403, 0.15572648, 0.13258333],
           [ 0.19265334, 0.15821903, 0.13436103],
           [ 0.1965857 , 0.16070261, 0.13612494],
           [ 0.20052118, 0.1631775 , 0.13787511],
           [ 0.20445985, 0.16564396, 0.13961158],
           [ 0.20840178, 0.16810225, 0.14133436],
           [ 0.21234703, 0.17055262, 0.14304348],
           [ 0.21629568, 0.17299532, 0.14473894],
           [ 0.22024776, 0.17543059, 0.14642072],
           [ 0.22420335, 0.17785866, 0.14808882],
           [ 0.22816249, 0.18027976, 0.1497432 ],
           [ 0.23212523, 0.18269412, 0.15138382],
           [ 0.23609162, 0.18510196, 0.15301064],
           [ 0.24006169, 0.18750349, 0.1546236 ],
           [ 0.24403549, 0.18989895, 0.15622264],
           [ 0.24801304, 0.19228853, 0.15780767],
           [ 0.25199437, 0.19467245, 0.15937863],
           [ 0.2559795 , 0.19705092, 0.16093541],
           [ 0.25996846, 0.19942415, 0.16247792],
           [ 0.26396126, 0.20179233, 0.16400606],
           [ 0.26795789, 0.20415569, 0.1655197 ],
           [ 0.27195838, 0.20651441, 0.16701873],
           [ 0.27596271, 0.2088687 , 0.16850302],
           [ 0.27997087, 0.21121876, 0.16997243],
           [ 0.28398286, 0.21356481, 0.17142682],
           [ 0.28799865, 0.21590704, 0.17286605],
           [ 0.29201822, 0.21824565, 0.17428995],
           [ 0.29604153, 0.22058085, 0.17569837],
           [ 0.30006855, 0.22291285, 0.17709115],
           [ 0.30409923, 0.22524186, 0.17846811],
           [ 0.30813351, 0.22756808, 0.17982907],
           [ 0.31217135, 0.22989172, 0.18117386],
           [ 0.31621274, 0.23221296, 0.18250219],
           [ 0.3202577 , 0.23453198, 0.18381375],
           [ 0.32430601, 0.23684907, 0.18510854],
           [ 0.32835756, 0.23916444, 0.18638636],
           [ 0.33241225, 0.24147832, 0.18764703],
           [ 0.33646999, 0.24379093, 0.18889033],
           [ 0.34053064, 0.24610252, 0.19011606],
           [ 0.34459409, 0.24841331, 0.19132403],
           [ 0.34866019, 0.25072355, 0.19251403],
           [ 0.35272881, 0.25303348, 0.19368584],
           [ 0.3567998 , 0.25534333, 0.19483924],
           [ 0.36087335, 0.25765321, 0.19597352],
           [ 0.36494892, 0.25996354, 0.19708898],
           [ 0.36902633, 0.26227457, 0.19818543],
           [ 0.37310537, 0.26458658, 0.19926266],
           [ 0.37718583, 0.26689984, 0.2003205 ],
           [ 0.3812675 , 0.26921464, 0.20135875],
           [ 0.38535015, 0.27153126, 0.20237724],
           [ 0.38943387, 0.27384983, 0.20337522],
           [ 0.39351818, 0.27617075, 0.20435286],
           [ 0.39760271, 0.27849439, 0.20531022],
           [ 0.40168716, 0.28082104, 0.20624715],
           [ 0.40577124, 0.28315104, 0.2071635 ],
           [ 0.40985466, 0.28548469, 0.20805916],
           [ 0.41393747, 0.28782216, 0.20893331],
           [ 0.41801909, 0.29016391, 0.20978634],
           [ 0.42209904, 0.29251032, 0.21061836],
           [ 0.42617698, 0.29486174, 0.21142931],
           [ 0.43025255, 0.29721853, 0.21221915],
           [ 0.43432568, 0.29958089, 0.21298723],
           [ 0.43839585, 0.30194926, 0.21373378],
           [ 0.44246248, 0.30432409, 0.21445918],
           [ 0.44652517, 0.30670574, 0.21516346],
           [ 0.45058349, 0.30909459, 0.21584668],
           [ 0.45463748, 0.31149081, 0.21650795],
           [ 0.45868623, 0.31389501, 0.21714835],
           [ 0.46272931, 0.31630755, 0.21776801],
           [ 0.46676627, 0.31872884, 0.21836709],
           [ 0.47079694, 0.32115912, 0.2189451 ],
           [ 0.47482065, 0.32359888, 0.21950271],
           [ 0.47883684, 0.32604855, 0.22004041],
           [ 0.48284504, 0.32850852, 0.22055847],
           [ 0.48684501, 0.33097908, 0.2210566 ],
           [ 0.4908361 , 0.33346069, 0.22153554],
           [ 0.49481775, 0.33595376, 0.22199587],
           [ 0.49878951, 0.33845868, 0.22243799],
           [ 0.50275108, 0.34097574, 0.22286173],
           [ 0.50670179, 0.34350541, 0.22326812],
           [ 0.51064114, 0.34604804, 0.22365772],
           [ 0.51456871, 0.348604  , 0.22403092],
           [ 0.5184841 , 0.35117361, 0.22438803],
           [ 0.52238672, 0.35375727, 0.22473004],
           [ 0.52627611, 0.35635533, 0.22505754],
           [ 0.53015188, 0.3589681 , 0.22537099],
           [ 0.53401354, 0.36159592, 0.22567117],
           [ 0.53786062, 0.36423912, 0.22595888],
           [ 0.54169271, 0.36689801, 0.22623484],
           [ 0.54550938, 0.3695729 , 0.22649972],
           [ 0.54931021, 0.37226407, 0.22675441],
           [ 0.55309477, 0.37497182, 0.2269997 ],
           [ 0.55686267, 0.37769641, 0.22723646],
           [ 0.5606135 , 0.38043812, 0.22746557],
           [ 0.5643469 , 0.3831972 , 0.22768784],
           [ 0.56806249, 0.38597389, 0.22790415],
           [ 0.57175986, 0.38876844, 0.22811569],
           [ 0.57543869, 0.39158106, 0.22832317],
           [ 0.57909864, 0.39441197, 0.22852751],
           [ 0.58273935, 0.39726139, 0.22872981],
           [ 0.58636045, 0.40012951, 0.22893126],
           [ 0.58996167, 0.40301651, 0.22913257],
           [ 0.59354267, 0.40592259, 0.22933476],
           [ 0.59710311, 0.40884791, 0.22953924],
           [ 0.60064269, 0.41179264, 0.22974695],
           [ 0.60416113, 0.41475694, 0.22995876],
           [ 0.60765812, 0.41774097, 0.23017579],
           [ 0.61113333, 0.42074485, 0.23039975],
           [ 0.61458651, 0.42376873, 0.23063131],
           [ 0.61801735, 0.42681274, 0.23087155],
           [ 0.62142558, 0.42987703, 0.23112168],
           [ 0.62481089, 0.43296166, 0.23138362],
           [ 0.62817301, 0.43606678, 0.23165793],
           [ 0.63151166, 0.43919252, 0.23194585],
           [ 0.63482655, 0.44233896, 0.23224868],
           [ 0.63811743, 0.44550616, 0.23256847],
           [ 0.64138399, 0.44869425, 0.23290586],
           [ 0.64462596, 0.45190333, 0.2332622 ],
           [ 0.64784305, 0.45513348, 0.23363888],
           [ 0.65103503, 0.45838472, 0.23403788],
           [ 0.65420161, 0.46165715, 0.23446031],
           [ 0.65734248, 0.46495086, 0.23490744],
           [ 0.66045737, 0.46826591, 0.23538076],
           [ 0.66354603, 0.47160233, 0.23588203],
           [ 0.66660826, 0.47496011, 0.23641317],
           [ 0.66964372, 0.47833936, 0.23697519],
           [ 0.67265213, 0.48174012, 0.2375697 ],
           [ 0.67563323, 0.48516242, 0.23819834],
           [ 0.67858688, 0.4886062 , 0.2388632 ],
           [ 0.68151283, 0.49207145, 0.2395659 ],
           [ 0.68441077, 0.49555825, 0.24030777],
           [ 0.68728046, 0.49906659, 0.24109054],
           [ 0.6901217 , 0.50259645, 0.24191594],
           [ 0.69293438, 0.50614772, 0.24278601],
           [ 0.6957184 , 0.50972028, 0.24370267],
           [ 0.69847345, 0.51331421, 0.24466721],
           [ 0.70119936, 0.51692942, 0.24568138],
           [ 0.70389601, 0.52056583, 0.24674692],
           [ 0.70656328, 0.52422334, 0.24786557],
           [ 0.70920134, 0.52790167, 0.24903951],
           [ 0.71181008, 0.53160072, 0.25027024],
           [ 0.71438933, 0.53532044, 0.25155916],
           [ 0.7169391 , 0.53906066, 0.25290789],
           [ 0.71945941, 0.54282119, 0.25431803],
           [ 0.72195034, 0.54660183, 0.2557911 ],
           [ 0.724412  , 0.55040235, 0.25732861],
           [ 0.72684491, 0.55422228, 0.25893238],
           [ 0.72924911, 0.55806146, 0.26060351],
           [ 0.73162465, 0.56191971, 0.26234308],
           [ 0.73397181, 0.56579673, 0.26415228],
           [ 0.73629088, 0.5696922 , 0.2660322 ],
           [ 0.73858224, 0.5736058 , 0.26798385],
           [ 0.74084627, 0.57753717, 0.27000813],
           [ 0.74308341, 0.58148594, 0.27210583],
           [ 0.74529416, 0.58545174, 0.27427764],
           [ 0.74747902, 0.58943418, 0.27652413],
           [ 0.74963858, 0.59343284, 0.27884576],
           [ 0.75177354, 0.59744726, 0.28124289],
           [ 0.75388476, 0.60147688, 0.28371577],
           [ 0.75597255, 0.60552149, 0.28626438],
           [ 0.75803761, 0.60958066, 0.28888871],
           [ 0.76008063, 0.61365394, 0.29158862],
           [ 0.76210238, 0.61774092, 0.29436388],
           [ 0.7641036 , 0.62184117, 0.29721414],
           [ 0.76608507, 0.62595425, 0.30013896],
           [ 0.76804758, 0.63007976, 0.30313777],
           [ 0.76999192, 0.63421728, 0.30620996],
           [ 0.77191901, 0.63836635, 0.3093548 ],
           [ 0.77383044, 0.6425262 , 0.31257131],
           [ 0.77572638, 0.64669677, 0.31585869],
           [ 0.77760765, 0.65087769, 0.31921599],
           [ 0.77947503, 0.6550686 , 0.32264222],
           [ 0.7813293 , 0.65926917, 0.32613634],
           [ 0.78317122, 0.66347909, 0.32969726],
           [ 0.7850015 , 0.66769808, 0.33332391],
           [ 0.78682085, 0.67192585, 0.33701518],
           [ 0.78862994, 0.67616218, 0.34076995],
           [ 0.79042938, 0.68040682, 0.34458712],
           [ 0.79222382, 0.68465779, 0.3484636 ],
           [ 0.79401088, 0.68891625, 0.35239953],
           [ 0.7957906 , 0.69318226, 0.35639404],
           [ 0.7975635 , 0.69745568, 0.36044607],
           [ 0.79933001, 0.7017364 , 0.36455459],
           [ 0.80109199, 0.70602372, 0.36871773],
           [ 0.80285453, 0.71031558, 0.37293152],
           [ 0.80461256, 0.71461427, 0.37719818],
           [ 0.80636635, 0.71891976, 0.38151687],
           [ 0.80811614, 0.72323206, 0.38588678],
           [ 0.80986949, 0.72754816, 0.39030199],
           [ 0.81162258, 0.73186978, 0.39476429],
           [ 0.813373  , 0.73619803, 0.39927478],
           [ 0.81512083, 0.74053296, 0.40383288],
           [ 0.81687743, 0.74487018, 0.40842935],
           [ 0.81863351, 0.74921355, 0.41307053],
           [ 0.82038791, 0.75356362, 0.41775687],
           [ 0.82214756, 0.75791781, 0.42248232],
           [ 0.8239136 , 0.76227586, 0.4272453 ],
           [ 0.82567856, 0.76664076, 0.43205146],
           [ 0.82744797, 0.77101054, 0.43689575],
           [ 0.82922751, 0.77538321, 0.44177277],
           [ 0.83100631, 0.77976299, 0.44669145],
           [ 0.83279191, 0.78414721, 0.45164484],
           [ 0.83458779, 0.78853475, 0.45662933],
           [ 0.83638303, 0.79292976, 0.46165442],
           [ 0.83819092, 0.79732754, 0.46670762],
           [ 0.84000532, 0.80173047, 0.47179418],
           [ 0.84181974, 0.80614103, 0.47691997],
           [ 0.84365489, 0.81055198, 0.48206501],
           [ 0.84548938, 0.81497108, 0.48724941],
           [ 0.84733547, 0.81939415, 0.49246112],
           [ 0.84919219, 0.82382169, 0.49770079],
           [ 0.85105061, 0.82825693, 0.50297708],
           [ 0.85293078, 0.83269316, 0.50826969],
           [ 0.85480977, 0.83713834, 0.51360152],
           [ 0.85670839, 0.8415856 , 0.51895122],
           [ 0.85861179, 0.84604008, 0.52433384],
           [ 0.86052811, 0.85049922, 0.52974081],
           [ 0.86245682, 0.85496335, 0.53517252],
           [ 0.86439284, 0.8594343 , 0.54063422],
           [ 0.86634766, 0.86390849, 0.54611354],
           [ 0.86830532, 0.86839123, 0.55162751],
           [ 0.87028696, 0.87287588, 0.55715317],
           [ 0.87226814, 0.87737042, 0.56271705],
           [ 0.87427719, 0.88186601, 0.56828799],
           [ 0.87628373, 0.88637239, 0.57389949],
           [ 0.87832071, 0.8908794 , 0.57951484],
           [ 0.88035438, 0.8953977 , 0.58517178],
           [ 0.88241971, 0.89991665, 0.59083084],
           [ 0.88448221, 0.90444699, 0.59653114],
           [ 0.88657626, 0.90897841, 0.60223338],
           [ 0.88866925, 0.91352092, 0.60797504],
           [ 0.89079231, 0.91806535, 0.61372008],
           [ 0.89291737, 0.92262023, 0.61950119],
           [ 0.89506967, 0.92717824, 0.62528881],
           [ 0.89722833, 0.93174568, 0.63110756],
           [ 0.89941005, 0.93631784, 0.63693766],
           [ 0.90160377, 0.94089809, 0.64279232],
           [ 0.90381505, 0.94548499, 0.64866493],
           [ 0.90604523, 0.95007831, 0.65455386],
           [ 0.90828616, 0.95468053, 0.66046911],
           [ 0.91055414, 0.95928721, 0.66639076],
           [ 0.91282478, 0.96390535, 0.67234889]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
