
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in pycam02ucs.cm.viscm
parameters = {'xp': [12.083124471935321, 31.017789474016041, 34.659071205185427, 33.93081485895155, 32.27851430976432, -0.7196049621778116],
              'yp': [-13.935705368289632, -11.750936329588001, -1.1912193091968106, 11.553266749895982, 22.829861111111114, 15.377428998505223],
              'min_Jp': 15.0,
              'max_Jp': 95.0}

cm_data = [[ 0.18517171, 0.05913349, 0.24304267],
           [ 0.19008219, 0.06057894, 0.24651605],
           [ 0.1950016 , 0.06199021, 0.24996805],
           [ 0.19993023, 0.06336778, 0.25339803],
           [ 0.2048691 , 0.06471124, 0.25680549],
           [ 0.20982353, 0.06601486, 0.26019056],
           [ 0.21478769, 0.06728631, 0.26355148],
           [ 0.21976179, 0.06852599, 0.26688759],
           [ 0.22474604, 0.0697343 , 0.27019819],
           [ 0.22974485, 0.07090635, 0.27348302],
           [ 0.2347553 , 0.07204628, 0.27674091],
           [ 0.23977611, 0.07315619, 0.27997094],
           [ 0.24480741, 0.07423648, 0.28317235],
           [ 0.24984931, 0.07528753, 0.28634437],
           [ 0.25490478, 0.07630599, 0.28948629],
           [ 0.25997231, 0.07729426, 0.29259714],
           [ 0.26505035, 0.07825478, 0.295676  ],
           [ 0.27013893, 0.07918798, 0.29872202],
           [ 0.27523807, 0.08009433, 0.30173433],
           [ 0.28034773, 0.08097432, 0.30471204],
           [ 0.28546798, 0.08182832, 0.30765422],
           [ 0.29060135, 0.08265337, 0.31055974],
           [ 0.29574478, 0.083454  , 0.3134278 ],
           [ 0.30089818, 0.08423083, 0.31625744],
           [ 0.30606141, 0.08498453, 0.3190477 ],
           [ 0.31123432, 0.08571579, 0.32179759],
           [ 0.31641672, 0.08642536, 0.32450613],
           [ 0.32160842, 0.08711404, 0.32717232],
           [ 0.32680918, 0.08778266, 0.32979513],
           [ 0.33201875, 0.08843214, 0.33237355],
           [ 0.33723686, 0.08906342, 0.33490656],
           [ 0.3424632 , 0.08967752, 0.33739313],
           [ 0.34769744, 0.09027551, 0.33983225],
           [ 0.35293923, 0.09085853, 0.34222288],
           [ 0.35818819, 0.09142777, 0.34456401],
           [ 0.36344392, 0.0919845 , 0.34685464],
           [ 0.36870599, 0.09253005, 0.34909377],
           [ 0.37397397, 0.0930658 , 0.35128042],
           [ 0.37924738, 0.09359321, 0.35341364],
           [ 0.38452573, 0.0941138 , 0.35549249],
           [ 0.38980852, 0.09462915, 0.35751606],
           [ 0.39509521, 0.0951409 , 0.35948347],
           [ 0.40038526, 0.09565075, 0.36139387],
           [ 0.40567812, 0.09616044, 0.36324644],
           [ 0.4109732 , 0.09667179, 0.36504042],
           [ 0.41626992, 0.09718665, 0.36677507],
           [ 0.42156767, 0.09770691, 0.36844971],
           [ 0.42686586, 0.09823449, 0.37006371],
           [ 0.43216478, 0.09876992, 0.37161577],
           [ 0.43746355, 0.09931556, 0.37310547],
           [ 0.44276088, 0.0998745 , 0.37453284],
           [ 0.44805611, 0.10044877, 0.37589749],
           [ 0.45334861, 0.1010404 , 0.37719908],
           [ 0.45863773, 0.10165142, 0.37843733],
           [ 0.46392333, 0.1022831 , 0.37961155],
           [ 0.46920552, 0.10293623, 0.38072076],
           [ 0.47448238, 0.10361485, 0.38176614],
           [ 0.47975329, 0.10432087, 0.38274769],
           [ 0.48501765, 0.1050562 , 0.3836655 ],
           [ 0.49027555, 0.10582154, 0.38451884],
           [ 0.49552659, 0.10661841, 0.3853076 ],
           [ 0.50076923, 0.10745003, 0.38603324],
           [ 0.50600291, 0.10831803, 0.38669608],
           [ 0.51122751, 0.10922327, 0.38729597],
           [ 0.51644309, 0.11016633, 0.38783247],
           [ 0.52164803, 0.11115027, 0.38830764],
           [ 0.52684188, 0.11217633, 0.38872207],
           [ 0.53202486, 0.11324458, 0.38907529],
           [ 0.53719631, 0.11435643, 0.38936827],
           [ 0.54235522, 0.11551369, 0.38960269],
           [ 0.54750131, 0.11671701, 0.38977915],
           [ 0.552635  , 0.11796595, 0.38989699],
           [ 0.55775491, 0.11926261, 0.38995887],
           [ 0.5628607 , 0.12060752, 0.38996572],
           [ 0.56795278, 0.12200003, 0.38991698],
           [ 0.57303015, 0.12344147, 0.38981494],
           [ 0.57809238, 0.12493225, 0.38966089],
           [ 0.58313973, 0.1264718 , 0.38945465],
           [ 0.58817152, 0.12806077, 0.3891981 ],
           [ 0.5931873 , 0.12969941, 0.38889274],
           [ 0.59818726, 0.13138711, 0.38853858],
           [ 0.60317083, 0.13312418, 0.38813742],
           [ 0.60813763, 0.13491065, 0.38769077],
           [ 0.61308782, 0.13674584, 0.38719864],
           [ 0.61802083, 0.13862993, 0.386663  ],
           [ 0.62293634, 0.14056274, 0.38608522],
           [ 0.62783454, 0.14254354, 0.38546523],
           [ 0.63271477, 0.14457248, 0.38480529],
           [ 0.63757687, 0.14664919, 0.38410635],
           [ 0.64242081, 0.14877308, 0.38336876],
           [ 0.64724605, 0.15094418, 0.38259458],
           [ 0.65205246, 0.15316203, 0.38178446],
           [ 0.65683983, 0.15542627, 0.38093931],
           [ 0.66160768, 0.15773679, 0.38006084],
           [ 0.66635592, 0.16009315, 0.37914944],
           [ 0.67108412, 0.16249519, 0.37820659],
           [ 0.67579188, 0.16494277, 0.37723366],
           [ 0.68047906, 0.16743548, 0.37623081],
           [ 0.68514508, 0.16997338, 0.37520008],
           [ 0.68978961, 0.17255625, 0.37414221],
           [ 0.69441228, 0.17518398, 0.37305808],
           [ 0.69901252, 0.1778566 , 0.3719494 ],
           [ 0.70359001, 0.18057398, 0.37081657],
           [ 0.70814412, 0.18333622, 0.36966126],
           [ 0.71267433, 0.18614338, 0.36848468],
           [ 0.71718017, 0.1889955 , 0.36728743],
           [ 0.7216609 , 0.19189279, 0.36607151],
           [ 0.72611598, 0.19483537, 0.36483758],
           [ 0.73054471, 0.19782348, 0.36358718],
           [ 0.73494635, 0.20085737, 0.36232191],
           [ 0.73932024, 0.20393732, 0.36104238],
           [ 0.74366551, 0.20706364, 0.35975091],
           [ 0.74798139, 0.21023669, 0.35844838],
           [ 0.75226701, 0.21345683, 0.35713657],
           [ 0.75652144, 0.21672446, 0.35581731],
           [ 0.76074383, 0.22004003, 0.35449167],
           [ 0.76493312, 0.22340394, 0.35316213],
           [ 0.76908837, 0.22681667, 0.35183001],
           [ 0.7732085 , 0.23027866, 0.35049752],
           [ 0.77729245, 0.23379036, 0.34916672],
           [ 0.78133913, 0.23735228, 0.34783945],
           [ 0.78534739, 0.24096482, 0.3465183 ],
           [ 0.78931609, 0.24462845, 0.34520528],
           [ 0.79324405, 0.24834357, 0.34390302],
           [ 0.79713009, 0.25211056, 0.34261402],
           [ 0.80097301, 0.25592978, 0.34134093],
           [ 0.80477161, 0.25980154, 0.34008638],
           [ 0.80852469, 0.26372603, 0.33885362],
           [ 0.81223105, 0.26770354, 0.33764514],
           [ 0.81588953, 0.27173408, 0.33646439],
           [ 0.819499  , 0.27581774, 0.33531442],
           [ 0.82305829, 0.27995459, 0.33419807],
           [ 0.82656645, 0.28414414, 0.33311978],
           [ 0.83002232, 0.28838659, 0.33208153],
           [ 0.83342508, 0.29268122, 0.33108793],
           [ 0.8367738 , 0.29702773, 0.33014193],
           [ 0.84006752, 0.30142586, 0.32924624],
           [ 0.84330599, 0.30587398, 0.32840668],
           [ 0.84648807, 0.31037235, 0.32762406],
           [ 0.84961352, 0.31491948, 0.32690313],
           [ 0.85268212, 0.31951405, 0.32624774],
           [ 0.855693  , 0.32415591, 0.32565907],
           [ 0.85864675, 0.32884252, 0.32514279],
           [ 0.86154301, 0.33357304, 0.32470075],
           [ 0.86438132, 0.33834687, 0.32433433],
           [ 0.86716293, 0.34316081, 0.32404903],
           [ 0.86988775, 0.34801394, 0.32384604],
           [ 0.87255551, 0.35290558, 0.3237261 ],
           [ 0.8751674 , 0.35783305, 0.32369276],
           [ 0.87772497, 0.36279339, 0.32374939],
           [ 0.88022743, 0.36778691, 0.32389464],
           [ 0.88267554, 0.37281188, 0.32412991],
           [ 0.88507136, 0.37786501, 0.32445816],
           [ 0.88741638, 0.38294391, 0.32488078],
           [ 0.88971012, 0.38804876, 0.32539617],
           [ 0.89195365, 0.39317783, 0.32600483],
           [ 0.89414811, 0.3983294 , 0.32670706],
           [ 0.89629551, 0.40350084, 0.32750381],
           [ 0.89839827, 0.40868922, 0.32839594],
           [ 0.90045568, 0.41389524, 0.32938102],
           [ 0.90246898, 0.41911741, 0.33045857],
           [ 0.90443943, 0.42435429, 0.33162793],
           [ 0.90636827, 0.42960453, 0.33288831],
           [ 0.90825675, 0.43486684, 0.33423877],
           [ 0.91010609, 0.44014   , 0.33567825],
           [ 0.9119175 , 0.4454229 , 0.33720557],
           [ 0.91369216, 0.45071447, 0.33881946],
           [ 0.9154312 , 0.45601377, 0.34051856],
           [ 0.91713572, 0.4613199 , 0.34230146],
           [ 0.91880676, 0.46663207, 0.34416665],
           [ 0.92044532, 0.47194958, 0.3461126 ],
           [ 0.92205233, 0.47727179, 0.34813776],
           [ 0.92362867, 0.48259816, 0.35024054],
           [ 0.92517515, 0.4879282 , 0.35241933],
           [ 0.92669252, 0.49326154, 0.35467254],
           [ 0.92818145, 0.49859784, 0.35699858],
           [ 0.92964257, 0.50393685, 0.35939586],
           [ 0.93107641, 0.50927839, 0.36186284],
           [ 0.93248345, 0.51462233, 0.364398  ],
           [ 0.93386574, 0.51996726, 0.36700002],
           [ 0.93522801, 0.52530964, 0.36966771],
           [ 0.93656551, 0.53065374, 0.37239898],
           [ 0.93787845, 0.53599965, 0.37519244],
           [ 0.93916701, 0.54134751, 0.37804676],
           [ 0.94043129, 0.54669749, 0.38096067],
           [ 0.94167798, 0.55204474, 0.38393283],
           [ 0.94290654, 0.55739007, 0.38696177],
           [ 0.94411192, 0.56273764, 0.39004635],
           [ 0.94529398, 0.56808778, 0.39318551],
           [ 0.94645531, 0.57343881, 0.39637803],
           [ 0.94760645, 0.57878343, 0.39962183],
           [ 0.9487348 , 0.58413113, 0.40291682],
           [ 0.94984002, 0.58948232, 0.40626218],
           [ 0.95092987, 0.5948318 , 0.40965603],
           [ 0.95200784, 0.60017752, 0.41309682],
           [ 0.95306267, 0.60552755, 0.4165852 ],
           [ 0.95409505, 0.61088157, 0.42012037],
           [ 0.95512504, 0.61622639, 0.42369803],
           [ 0.95613153, 0.6215765 , 0.42732096],
           [ 0.95711389, 0.62693242, 0.43098874],
           [ 0.95809626, 0.63227868, 0.43469575],
           [ 0.95905559, 0.63763057, 0.43844592],
           [ 0.95999158, 0.64298842, 0.44223886],
           [ 0.96092933, 0.6483366 , 0.44606817],
           [ 0.9618419 , 0.65369237, 0.44993943],
           [ 0.9627383 , 0.65905026, 0.45385005],
           [ 0.9636302 , 0.6644034 , 0.45779644],
           [ 0.96449566, 0.6697654 , 0.46178377],
           [ 0.96535776, 0.67512254, 0.46580546],
           [ 0.96620304, 0.68048317, 0.46986463],
           [ 0.9670273 , 0.68584991, 0.4739621 ],
           [ 0.96785315, 0.6912098 , 0.47809096],
           [ 0.9686504 , 0.6965806 , 0.48225963],
           [ 0.96944845, 0.7019456 , 0.48645901],
           [ 0.97022616, 0.7073171 , 0.49069515],
           [ 0.97099121, 0.71269094, 0.49496543],
           [ 0.97174984, 0.71806387, 0.49926753],
           [ 0.97248364, 0.72344627, 0.50360719],
           [ 0.97322354, 0.7288214 , 0.507974  ],
           [ 0.97393124, 0.73421027, 0.51238049],
           [ 0.97464928, 0.7395902 , 0.51681211],
           [ 0.97533754, 0.7449828 , 0.52128239],
           [ 0.97602903, 0.75037081, 0.52577975],
           [ 0.97669802, 0.75576791, 0.53031308],
           [ 0.97736473, 0.76116379, 0.53487508],
           [ 0.97801457, 0.76656615, 0.53947089],
           [ 0.97865835, 0.77196968, 0.5440965 ],
           [ 0.97928916, 0.77737806, 0.54875439],
           [ 0.9799119 , 0.78278902, 0.55344266],
           [ 0.98052378, 0.78820414, 0.55816232],
           [ 0.98112747, 0.7936223 , 0.56291231],
           [ 0.98172055, 0.79904486, 0.56769355],
           [ 0.98230724, 0.80446999, 0.57250437],
           [ 0.98288171, 0.80990066, 0.57734705],
           [ 0.98345358, 0.8153325 , 0.58221775],
           [ 0.98400967, 0.82077189, 0.58712176],
           [ 0.98456902, 0.82621018, 0.59205135],
           [ 0.98510705, 0.83165888, 0.59701657],
           [ 0.9856563 , 0.83710333, 0.60200398],
           [ 0.98617668, 0.84256188, 0.60703023],
           [ 0.98671839, 0.8480122 , 0.61207428],
           [ 0.98722803, 0.8534783 , 0.61715857],
           [ 0.9877585 , 0.858937  , 0.6222606 ],
           [ 0.9882647 , 0.86440831, 0.62739957],
           [ 0.98878008, 0.86987788, 0.632561  ],
           [ 0.98928575, 0.87535412, 0.63775296],
           [ 0.98978682, 0.88083501, 0.64297311],
           [ 0.99029495, 0.88631589, 0.64821615],
           [ 0.99078259, 0.89180853, 0.65349411],
           [ 0.99129627, 0.89729384, 0.65878604],
           [ 0.99178436, 0.9027934 , 0.6641148 ],
           [ 0.99229377, 0.90828822, 0.66945902],
           [ 0.99279222, 0.91379173, 0.67483294],
           [ 0.99329154, 0.91929937, 0.68023089],
           [ 0.99380347, 0.92480678, 0.68564709],
           [ 0.99429361, 0.9303278 , 0.6910969 ]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
