
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in pycam02ucs.cm.viscm
parameters = {'xp': [-0.69960421522915794, 12.12090860528366, -23.135501651126589, -1.9015272921522239, -27.542552933177888, -17.125886266511202, -9.9143478049727491, -7.5105016511265887],
              'yp': [-9.0544871794871824, -35.09615384615384, -31.089743589743591, -18.669871794871796, -12.259615384615387, -5.048076923076934, -5.849358974358978, -3.0448717948717956],
              'min_Jp': 5.14851485149,
              'max_Jp': 98.0198019802}

cm_data = [[ 0.01531167, 0.02252059, 0.07272874],
           [ 0.0180055 , 0.02544552, 0.07841879],
           [ 0.02090133, 0.02852652, 0.08407772],
           [ 0.02399819, 0.03176264, 0.0897075 ],
           [ 0.02729776, 0.03514909, 0.09532647],
           [ 0.03080428, 0.03867708, 0.10096627],
           [ 0.03450984, 0.04229956, 0.10658282],
           [ 0.0384136 , 0.04587404, 0.11217763],
           [ 0.0424579 , 0.04939964, 0.11779608],
           [ 0.04645778, 0.0528849 , 0.1234176 ],
           [ 0.05041622, 0.05633789, 0.12902168],
           [ 0.0543378 , 0.05975738, 0.13462392],
           [ 0.05823   , 0.06313586, 0.14026517],
           [ 0.06208647, 0.06648866, 0.14589217],
           [ 0.06590891, 0.0698176 , 0.15150562],
           [ 0.0697067 , 0.0731091 , 0.15717011],
           [ 0.07347361, 0.07637816, 0.16283083],
           [ 0.07720982, 0.0796282 , 0.16848004],
           [ 0.08092191, 0.08284857, 0.17416973],
           [ 0.08460723, 0.0860472 , 0.17987258],
           [ 0.08826408, 0.08923087, 0.18556525],
           [ 0.09189749, 0.09238992, 0.19129533],
           [ 0.09550606, 0.09552937, 0.19704663],
           [ 0.0990876 , 0.09865736, 0.20278851],
           [ 0.10264643, 0.10176328, 0.2085729 ],
           [ 0.10618075, 0.1048534 , 0.21437716],
           [ 0.1096889 , 0.10793517, 0.22017219],
           [ 0.11317482, 0.11099513, 0.22602364],
           [ 0.11663557, 0.11404484, 0.23188363],
           [ 0.12007068, 0.11708837, 0.23773723],
           [ 0.12348311, 0.12010958, 0.24366409],
           [ 0.12686948, 0.1231272 , 0.24958092],
           [ 0.13023079, 0.12613483, 0.25552177],
           [ 0.13356695, 0.12912934, 0.26150605],
           [ 0.13687687, 0.13212284, 0.26747923],
           [ 0.14016072, 0.13510078, 0.27351646],
           [ 0.14341772, 0.13807648, 0.27955643],
           [ 0.14664749, 0.14104684, 0.28561838],
           [ 0.14984897, 0.14400828, 0.29172467],
           [ 0.15302294, 0.14697296, 0.29781705],
           [ 0.15616589, 0.14992378, 0.30398848],
           [ 0.15928037, 0.15287968, 0.31014411],
           [ 0.16236275, 0.15582876, 0.31635122],
           [ 0.16541424, 0.15877962, 0.32256801],
           [ 0.1684328 , 0.16172931, 0.32881489],
           [ 0.17141745, 0.16467906, 0.33508977],
           [ 0.17436826, 0.16763191, 0.34137988],
           [ 0.1772819 , 0.17058464, 0.34770888],
           [ 0.18016036, 0.17354351, 0.35404476],
           [ 0.18299849, 0.17650348, 0.36042297],
           [ 0.18579938, 0.17947155, 0.36680604],
           [ 0.18855724, 0.18244322, 0.37322757],
           [ 0.19127464, 0.18542401, 0.37965796],
           [ 0.19394722, 0.188412  , 0.38611587],
           [ 0.19657462, 0.19140947, 0.39259226],
           [ 0.19915672, 0.19441854, 0.39907853],
           [ 0.20168703, 0.19743702, 0.40559795],
           [ 0.20417332, 0.2004721 , 0.41210346],
           [ 0.20659892, 0.20351633, 0.41866115],
           [ 0.208977  , 0.20657923, 0.42520322],
           [ 0.21129685, 0.20965752, 0.43176498],
           [ 0.21355801, 0.2127534 , 0.43833741],
           [ 0.21576549, 0.2158706 , 0.44489464],
           [ 0.21790275, 0.21900569, 0.45148217],
           [ 0.21998016, 0.22216408, 0.45805652],
           [ 0.22199703, 0.22534707, 0.46461293],
           [ 0.22393594, 0.22855285, 0.47119005],
           [ 0.22580933, 0.23178597, 0.47774457],
           [ 0.22761504, 0.23504748, 0.48427492],
           [ 0.22934111, 0.23833757, 0.49080012],
           [ 0.23099051, 0.24165846, 0.49730374],
           [ 0.23256539, 0.24501182, 0.50377332],
           [ 0.23406342, 0.2483988 , 0.5102062 ],
           [ 0.23547394, 0.25182056, 0.51661336],
           [ 0.23680103, 0.25527869, 0.52297876],
           [ 0.23804591, 0.25877435, 0.529293  ],
           [ 0.23920692, 0.26230862, 0.53555174],
           [ 0.24028265, 0.26588249, 0.54175028],
           [ 0.24126904, 0.26949715, 0.54788707],
           [ 0.24216465, 0.27315361, 0.55395673],
           [ 0.24297377, 0.2768522 , 0.55994789],
           [ 0.24369643, 0.2805934 , 0.56585499],
           [ 0.24433314, 0.28437755, 0.5716724 ],
           [ 0.2448849 , 0.28820479, 0.57739441],
           [ 0.24535323, 0.29207505, 0.5830154 ],
           [ 0.24574017, 0.29598806, 0.58852986],
           [ 0.24604835, 0.29994331, 0.59393251],
           [ 0.24628095, 0.30394008, 0.59921837],
           [ 0.2464417 , 0.30797739, 0.60438286],
           [ 0.2465349 , 0.31205404, 0.60942183],
           [ 0.24656536, 0.31616862, 0.61433167],
           [ 0.2465384 , 0.32031951, 0.61910933],
           [ 0.24645977, 0.32450489, 0.6237524 ],
           [ 0.24633566, 0.32872279, 0.62825909],
           [ 0.24617258, 0.33297109, 0.6326283 ],
           [ 0.24597735, 0.33724755, 0.63685958],
           [ 0.24575701, 0.34154984, 0.64095315],
           [ 0.24551877, 0.34587559, 0.64490987],
           [ 0.24526992, 0.35022239, 0.64873121],
           [ 0.24501778, 0.35458782, 0.65241923],
           [ 0.24476962, 0.35896949, 0.6559765 ],
           [ 0.24453264, 0.36336505, 0.65940606],
           [ 0.24431385, 0.36777225, 0.66271137],
           [ 0.24412005, 0.37218889, 0.66589627],
           [ 0.2439578 , 0.37661289, 0.66896489],
           [ 0.24383334, 0.38104229, 0.6719216 ],
           [ 0.24375272, 0.3854752 , 0.67477099],
           [ 0.24372159, 0.3899099 , 0.67751781],
           [ 0.24374497, 0.39434483, 0.68016682],
           [ 0.24382759, 0.39877858, 0.68272286],
           [ 0.24397378, 0.40320985, 0.68519075],
           [ 0.24418744, 0.40763748, 0.68757528],
           [ 0.24447207, 0.41206045, 0.68988119],
           [ 0.24483074, 0.41647785, 0.6921131 ],
           [ 0.24526613, 0.4208889 , 0.69427555],
           [ 0.24578055, 0.42529292, 0.69637292],
           [ 0.24637589, 0.42968935, 0.69840946],
           [ 0.24705372, 0.43407771, 0.70038927],
           [ 0.24781523, 0.43845764, 0.70231628],
           [ 0.2486613 , 0.44282884, 0.70419426],
           [ 0.24959252, 0.44719108, 0.70602681],
           [ 0.25060917, 0.45154422, 0.70781736],
           [ 0.25171129, 0.45588817, 0.70956918],
           [ 0.25289865, 0.4602229 , 0.71128535],
           [ 0.25417082, 0.46454843, 0.71296882],
           [ 0.25552716, 0.46886482, 0.71462235],
           [ 0.25696687, 0.47317219, 0.71624858],
           [ 0.25848896, 0.47747067, 0.71784998],
           [ 0.26009232, 0.48176042, 0.71942887],
           [ 0.2617757 , 0.48604166, 0.72098746],
           [ 0.26353778, 0.49031459, 0.7225278 ],
           [ 0.26537711, 0.49457945, 0.72405184],
           [ 0.26729219, 0.49883651, 0.7255614 ],
           [ 0.26928146, 0.50308602, 0.72705818],
           [ 0.27134332, 0.50732827, 0.72854378],
           [ 0.27347612, 0.51156355, 0.73001971],
           [ 0.27567821, 0.51579214, 0.73148736],
           [ 0.27794793, 0.52001436, 0.73294804],
           [ 0.2802836 , 0.52423051, 0.73440296],
           [ 0.28268357, 0.52844088, 0.73585328],
           [ 0.28514622, 0.53264579, 0.73730005],
           [ 0.28766991, 0.53684554, 0.73874426],
           [ 0.29025309, 0.54104043, 0.74018682],
           [ 0.29289419, 0.54523076, 0.74162858],
           [ 0.29559174, 0.54941683, 0.74307033],
           [ 0.29834428, 0.55359893, 0.74451279],
           [ 0.30115042, 0.55777733, 0.74595664],
           [ 0.30400882, 0.56195234, 0.74740249],
           [ 0.3069182 , 0.5661242 , 0.74885089],
           [ 0.30987735, 0.57029319, 0.75030237],
           [ 0.31288513, 0.57445957, 0.75175739],
           [ 0.31594045, 0.57862358, 0.75321637],
           [ 0.31904231, 0.58278547, 0.7546797 ],
           [ 0.32218978, 0.58694546, 0.7561477 ],
           [ 0.325382  , 0.59110377, 0.75762068],
           [ 0.32861818, 0.5952606 , 0.7590989 ],
           [ 0.33189762, 0.59941617, 0.76058259],
           [ 0.3352197 , 0.60357064, 0.76207194],
           [ 0.33858388, 0.60772419, 0.76356711],
           [ 0.34198969, 0.61187699, 0.76506822],
           [ 0.34543677, 0.61602918, 0.76657539],
           [ 0.34892482, 0.62018088, 0.76808867],
           [ 0.35245366, 0.62433221, 0.76960811],
           [ 0.35602315, 0.62848328, 0.77113373],
           [ 0.3596333 , 0.63263416, 0.77266552],
           [ 0.36328417, 0.63678492, 0.77420346],
           [ 0.36697594, 0.64093562, 0.7757475 ],
           [ 0.37070887, 0.64508626, 0.77729756],
           [ 0.37448333, 0.64923687, 0.77885356],
           [ 0.37829979, 0.65338743, 0.78041541],
           [ 0.38215883, 0.6575379 , 0.78198297],
           [ 0.38606113, 0.66168821, 0.78355612],
           [ 0.39000748, 0.66583833, 0.78513436],
           [ 0.39399882, 0.66998823, 0.78671676],
           [ 0.39803619, 0.67413764, 0.78830412],
           [ 0.40212077, 0.6782864 , 0.78989626],
           [ 0.40625381, 0.68243429, 0.79149303],
           [ 0.41043672, 0.68658107, 0.79309427],
           [ 0.41467103, 0.69072647, 0.79469983],
           [ 0.4189584 , 0.69487019, 0.79630958],
           [ 0.42330076, 0.69901195, 0.79792237],
           [ 0.42770031, 0.70315144, 0.79953693],
           [ 0.43215888, 0.70728805, 0.80115515],
           [ 0.43667866, 0.7114213 , 0.802777  ],
           [ 0.44126199, 0.71555064, 0.80440251],
           [ 0.44591175, 0.71967561, 0.80603022],
           [ 0.4506311 , 0.72379561, 0.8076587 ],
           [ 0.45542205, 0.72790979, 0.80929102],
           [ 0.46028743, 0.73201742, 0.8109275 ],
           [ 0.46523129, 0.7361178 , 0.81256547],
           [ 0.47025671, 0.74021004, 0.81420586],
           [ 0.47536584, 0.74429316, 0.81585182],
           [ 0.480563  , 0.74836626, 0.81750143],
           [ 0.48585194, 0.75242831, 0.81915472],
           [ 0.49123401, 0.75647827, 0.82081642],
           [ 0.49671496, 0.76051503, 0.82248288],
           [ 0.50229586, 0.76453755, 0.82415903],
           [ 0.5079798 , 0.76854472, 0.82584588],
           [ 0.51377031, 0.77253541, 0.82754379],
           [ 0.51966727, 0.77650874, 0.82925804],
           [ 0.52567488, 0.78046351, 0.83098749],
           [ 0.53179094, 0.78439917, 0.83273894],
           [ 0.5380184 , 0.78831467, 0.8345121 ],
           [ 0.544354  , 0.79220975, 0.83631331],
           [ 0.55079789, 0.79608381, 0.83814427],
           [ 0.55734648, 0.79993683, 0.84000992],
           [ 0.56399647, 0.80376887, 0.84191391],
           [ 0.57074395, 0.80758021, 0.84385969],
           [ 0.57758278, 0.81137158, 0.84585184],
           [ 0.58450804, 0.81514366, 0.84789305],
           [ 0.59151241, 0.81889765, 0.84998727],
           [ 0.59858923, 0.8226348 , 0.85213717],
           [ 0.60573106, 0.8263566 , 0.85434539],
           [ 0.6129312 , 0.83006454, 0.85661357],
           [ 0.62018101, 0.8337606 , 0.85894417],
           [ 0.62747522, 0.8374462 , 0.86133712],
           [ 0.63480525, 0.84112351, 0.8637942 ],
           [ 0.64216625, 0.84479403, 0.86631468],
           [ 0.64955148, 0.84845972, 0.86889888],
           [ 0.65695573, 0.85212228, 0.87154615],
           [ 0.66437458, 0.85578326, 0.87425541],
           [ 0.67180273, 0.85944449, 0.87702608],
           [ 0.67923764, 0.86310717, 0.87985618],
           [ 0.6866745 , 0.86677306, 0.88274497],
           [ 0.69411182, 0.87044318, 0.88569014],
           [ 0.70154587, 0.87411906, 0.88869057],
           [ 0.70897547, 0.87780166, 0.89174404],
           [ 0.71639823, 0.88149221, 0.89484897],
           [ 0.72381291, 0.88519169, 0.89800335],
           [ 0.7312183 , 0.88890104, 0.90120526],
           [ 0.73861316, 0.89262124, 0.90445285],
           [ 0.74599695, 0.89635308, 0.90774403],
           [ 0.7533689 , 0.90009739, 0.91107686],
           [ 0.76072821, 0.90385503, 0.91444944],
           [ 0.76807541, 0.9076265 , 0.91785934],
           [ 0.77540864, 0.91141295, 0.92130508],
           [ 0.78272987, 0.91521448, 0.92478363],
           [ 0.79003624, 0.91903253, 0.92829379],
           [ 0.79733058, 0.92286698, 0.93183206],
           [ 0.80460936, 0.9267195 , 0.93539728],
           [ 0.81187625, 0.93058973, 0.93898531],
           [ 0.81912624, 0.93447982, 0.9425952 ],
           [ 0.82636495, 0.9383889 , 0.94622154],
           [ 0.83358579, 0.94231965, 0.94986338],
           [ 0.84079256, 0.9462718 , 0.9535152 ],
           [ 0.84798207, 0.95024718, 0.95717374],
           [ 0.85515095, 0.95424775, 0.96083521],
           [ 0.86230259, 0.95827357, 0.96449203],
           [ 0.86942981, 0.96232795, 0.96814019],
           [ 0.87652837, 0.96641348, 0.9717733 ],
           [ 0.88359326, 0.97053314, 0.97538393],
           [ 0.89061741, 0.97469071, 0.9789641 ],
           [ 0.89759175, 0.9788908 , 0.98250515],
           [ 0.90450134, 0.9831399 , 0.98600058],
           [ 0.91133005, 0.98744495, 0.98944426],
           [ 0.9180593 , 0.99181354, 0.99283286]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
