
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in pycam02ucs.cm.viscm
parameters = {'xp': [-0.039688657870597055, -1.9058661328602291],
              'yp': [-0.11498367904144047, -0.3865272391038701],
              'min_Jp': 0.0267022696929,
              'max_Jp': 99.8931909212}

cm_data = [[  5.11911384e-07,  2.05227020e-06,  5.98257794e-06],
           [  2.59844080e-04,  2.62594402e-04,  2.77062284e-04],
           [  8.65615639e-04,  8.57063803e-04,  8.79420737e-04],
           [  1.76940324e-03,  1.74036806e-03,  1.76860710e-03],
           [  2.94947216e-03,  2.89190338e-03,  2.92418039e-03],
           [  4.39232353e-03,  4.29890474e-03,  4.33343105e-03],
           [  6.08855312e-03,  5.95251932e-03,  5.98752738e-03],
           [  8.03119172e-03,  7.84622292e-03,  7.87995030e-03],
           [  1.02148752e-02,  9.97502609e-03,  1.00057061e-02],
           [  1.26353723e-02,  1.23350216e-02,  1.23608772e-02],
           [  1.52892907e-02,  1.49231036e-02,  1.49423429e-02],
           [  1.81738841e-02,  1.77367815e-02,  1.77475948e-02],
           [  2.12869166e-02,  2.07740516e-02,  2.07746089e-02],
           [  2.46265667e-02,  2.40333039e-02,  2.40217533e-02],
           [  2.81913551e-02,  2.75132539e-02,  2.74877200e-02],
           [  3.19800900e-02,  3.12128901e-02,  3.11714730e-02],
           [  3.59918244e-02,  3.51314333e-02,  3.50722081e-02],
           [  4.02258229e-02,  3.92683046e-02,  3.91893206e-02],
           [  4.44900792e-02,  4.35012249e-02,  4.34064003e-02],
           [  4.87036743e-02,  4.76784669e-02,  4.75679027e-02],
           [  5.28736210e-02,  5.18133437e-02,  5.16870540e-02],
           [  5.70031475e-02,  5.59090125e-02,  5.57670015e-02],
           [  6.10951372e-02,  5.99682933e-02,  5.98105568e-02],
           [  6.51521801e-02,  6.39937182e-02,  6.38202452e-02],
           [  6.91766135e-02,  6.79875725e-02,  6.77983461e-02],
           [  7.31705571e-02,  7.19519279e-02,  7.17469263e-02],
           [  7.71359406e-02,  7.58886705e-02,  7.56678676e-02],
           [  8.10745277e-02,  7.97995239e-02,  7.95628900e-02],
           [  8.49879366e-02,  8.36860689e-02,  8.34335714e-02],
           [  8.88776560e-02,  8.75497602e-02,  8.72813637e-02],
           [  9.27450605e-02,  9.13919405e-02,  9.11076073e-02],
           [  9.65914227e-02,  9.52138527e-02,  9.49135432e-02],
           [  1.00417924e-01,  9.90166504e-02,  9.87003234e-02],
           [  1.04225663e-01,  1.02801407e-01,  1.02469020e-01],
           [  1.08015666e-01,  1.06569124e-01,  1.06220632e-01],
           [  1.11788891e-01,  1.10320737e-01,  1.09956096e-01],
           [  1.15546237e-01,  1.14057124e-01,  1.13676287e-01],
           [  1.19288547e-01,  1.17779107e-01,  1.17382027e-01],
           [  1.23016614e-01,  1.21487461e-01,  1.21074090e-01],
           [  1.26731186e-01,  1.25182915e-01,  1.24753205e-01],
           [  1.30432967e-01,  1.28866157e-01,  1.28420060e-01],
           [  1.34122626e-01,  1.32537839e-01,  1.32075304e-01],
           [  1.37800792e-01,  1.36198576e-01,  1.35719554e-01],
           [  1.41468066e-01,  1.39848954e-01,  1.39353393e-01],
           [  1.45125017e-01,  1.43489526e-01,  1.42977377e-01],
           [  1.48772184e-01,  1.47120821e-01,  1.46592032e-01],
           [  1.52410083e-01,  1.50743342e-01,  1.50197862e-01],
           [  1.56039206e-01,  1.54357567e-01,  1.53795344e-01],
           [  1.59660020e-01,  1.57963954e-01,  1.57384936e-01],
           [  1.63272975e-01,  1.61562939e-01,  1.60967075e-01],
           [  1.66878499e-01,  1.65154942e-01,  1.64542178e-01],
           [  1.70477002e-01,  1.68740362e-01,  1.68110646e-01],
           [  1.74068878e-01,  1.72319584e-01,  1.71672864e-01],
           [  1.77654506e-01,  1.75892976e-01,  1.75229199e-01],
           [  1.81234248e-01,  1.79460893e-01,  1.78780006e-01],
           [  1.84808453e-01,  1.83023675e-01,  1.82325625e-01],
           [  1.88377459e-01,  1.86581650e-01,  1.85866384e-01],
           [  1.91941588e-01,  1.90135134e-01,  1.89402599e-01],
           [  1.95501154e-01,  1.93684432e-01,  1.92934574e-01],
           [  1.99056457e-01,  1.97229838e-01,  1.96462603e-01],
           [  2.02607789e-01,  2.00771635e-01,  1.99986971e-01],
           [  2.06155432e-01,  2.04310099e-01,  2.03507951e-01],
           [  2.09699657e-01,  2.07845496e-01,  2.07025810e-01],
           [  2.13240730e-01,  2.11378081e-01,  2.10540804e-01],
           [  2.16778904e-01,  2.14908106e-01,  2.14053183e-01],
           [  2.20314429e-01,  2.18435811e-01,  2.17563189e-01],
           [  2.23847544e-01,  2.21961431e-01,  2.21071055e-01],
           [  2.27378483e-01,  2.25485193e-01,  2.24577010e-01],
           [  2.30907473e-01,  2.29007320e-01,  2.28081275e-01],
           [  2.34434735e-01,  2.32528026e-01,  2.31584065e-01],
           [  2.37960483e-01,  2.36047521e-01,  2.35085589e-01],
           [  2.41484927e-01,  2.39566009e-01,  2.38586051e-01],
           [  2.45008269e-01,  2.43083689e-01,  2.42085651e-01],
           [  2.48530709e-01,  2.46600753e-01,  2.45584580e-01],
           [  2.52052441e-01,  2.50117391e-01,  2.49083029e-01],
           [  2.55573652e-01,  2.53633788e-01,  2.52581181e-01],
           [  2.59094528e-01,  2.57150123e-01,  2.56079217e-01],
           [  2.62615249e-01,  2.60666573e-01,  2.59577312e-01],
           [  2.66135991e-01,  2.64183309e-01,  2.63075638e-01],
           [  2.69656927e-01,  2.67700500e-01,  2.66574364e-01],
           [  2.73178225e-01,  2.71218310e-01,  2.70073654e-01],
           [  2.76700052e-01,  2.74736902e-01,  2.73573669e-01],
           [  2.80222567e-01,  2.78256432e-01,  2.77074568e-01],
           [  2.83745932e-01,  2.81777056e-01,  2.80576504e-01],
           [  2.87270300e-01,  2.85298925e-01,  2.84079631e-01],
           [  2.90795825e-01,  2.88822190e-01,  2.87584097e-01],
           [  2.94322656e-01,  2.92346995e-01,  2.91090047e-01],
           [  2.97850941e-01,  2.95873486e-01,  2.94597627e-01],
           [  3.01380825e-01,  2.99401803e-01,  2.98106977e-01],
           [  3.04912449e-01,  3.02932085e-01,  3.01618236e-01],
           [  3.08445954e-01,  3.06464468e-01,  3.05131540e-01],
           [  3.11981478e-01,  3.09999089e-01,  3.08647023e-01],
           [  3.15519155e-01,  3.13536077e-01,  3.12164819e-01],
           [  3.19059119e-01,  3.17075565e-01,  3.15685056e-01],
           [  3.22601501e-01,  3.20617680e-01,  3.19207865e-01],
           [  3.26146432e-01,  3.24162548e-01,  3.22733370e-01],
           [  3.29694038e-01,  3.27710296e-01,  3.26261696e-01],
           [  3.33244446e-01,  3.31261045e-01,  3.29792967e-01],
           [  3.36797780e-01,  3.34814918e-01,  3.33327304e-01],
           [  3.40354163e-01,  3.38372034e-01,  3.36864827e-01],
           [  3.43913715e-01,  3.41932512e-01,  3.40405654e-01],
           [  3.47476558e-01,  3.45496469e-01,  3.43949903e-01],
           [  3.51042808e-01,  3.49064020e-01,  3.47497687e-01],
           [  3.54612584e-01,  3.52635281e-01,  3.51049123e-01],
           [  3.58186000e-01,  3.56210364e-01,  3.54604323e-01],
           [  3.61763171e-01,  3.59789381e-01,  3.58163399e-01],
           [  3.65344211e-01,  3.63372443e-01,  3.61726461e-01],
           [  3.68929232e-01,  3.66959660e-01,  3.65293620e-01],
           [  3.72518344e-01,  3.70551141e-01,  3.68864983e-01],
           [  3.76111658e-01,  3.74146993e-01,  3.72440659e-01],
           [  3.79709283e-01,  3.77747323e-01,  3.76020753e-01],
           [  3.83311328e-01,  3.81352237e-01,  3.79605372e-01],
           [  3.86917898e-01,  3.84961840e-01,  3.83194621e-01],
           [  3.90529101e-01,  3.88576237e-01,  3.86788603e-01],
           [  3.94145043e-01,  3.92195529e-01,  3.90387422e-01],
           [  3.97765827e-01,  3.95819821e-01,  3.93991180e-01],
           [  4.01391559e-01,  3.99449214e-01,  3.97599979e-01],
           [  4.05022341e-01,  4.03083809e-01,  4.01213919e-01],
           [  4.08658276e-01,  4.06723707e-01,  4.04833102e-01],
           [  4.12299466e-01,  4.10369008e-01,  4.08457628e-01],
           [  4.15946013e-01,  4.14019811e-01,  4.12087594e-01],
           [  4.19598017e-01,  4.17676215e-01,  4.15723101e-01],
           [  4.23255579e-01,  4.21338319e-01,  4.19364246e-01],
           [  4.26918798e-01,  4.25006220e-01,  4.23011127e-01],
           [  4.30587775e-01,  4.28680015e-01,  4.26663840e-01],
           [  4.34262606e-01,  4.32359802e-01,  4.30322483e-01],
           [  4.37943392e-01,  4.36045677e-01,  4.33987153e-01],
           [  4.41630230e-01,  4.39737736e-01,  4.37657944e-01],
           [  4.45323217e-01,  4.43436075e-01,  4.41334952e-01],
           [  4.49022452e-01,  4.47140789e-01,  4.45018274e-01],
           [  4.52728030e-01,  4.50851973e-01,  4.48708003e-01],
           [  4.56440049e-01,  4.54569723e-01,  4.52404234e-01],
           [  4.60158604e-01,  4.58294132e-01,  4.56107062e-01],
           [  4.63883793e-01,  4.62025296e-01,  4.59816580e-01],
           [  4.67615710e-01,  4.65763308e-01,  4.63532883e-01],
           [  4.71354452e-01,  4.69508262e-01,  4.67256064e-01],
           [  4.75100113e-01,  4.73260251e-01,  4.70986217e-01],
           [  4.78852790e-01,  4.77019370e-01,  4.74723435e-01],
           [  4.82612577e-01,  4.80785712e-01,  4.78467811e-01],
           [  4.86379569e-01,  4.84559369e-01,  4.82219438e-01],
           [  4.90153861e-01,  4.88340436e-01,  4.85978410e-01],
           [  4.93935548e-01,  4.92129005e-01,  4.89744818e-01],
           [  4.97724724e-01,  4.95925170e-01,  4.93518756e-01],
           [  5.01521485e-01,  4.99729022e-01,  4.97300317e-01],
           [  5.05325924e-01,  5.03540656e-01,  5.01089594e-01],
           [  5.09138136e-01,  5.07360164e-01,  5.04886678e-01],
           [  5.12958216e-01,  5.11187639e-01,  5.08691663e-01],
           [  5.16786259e-01,  5.15023174e-01,  5.12504641e-01],
           [  5.20622358e-01,  5.18866862e-01,  5.16325705e-01],
           [  5.24466609e-01,  5.22718796e-01,  5.20154949e-01],
           [  5.28319107e-01,  5.26579069e-01,  5.23992463e-01],
           [  5.32179945e-01,  5.30447775e-01,  5.27838343e-01],
           [  5.36049219e-01,  5.34325006e-01,  5.31692680e-01],
           [  5.39927024e-01,  5.38210856e-01,  5.35555568e-01],
           [  5.43813455e-01,  5.42105418e-01,  5.39427101e-01],
           [  5.47708606e-01,  5.46008787e-01,  5.43307370e-01],
           [  5.51612575e-01,  5.49921056e-01,  5.47196471e-01],
           [  5.55525455e-01,  5.53842319e-01,  5.51094496e-01],
           [  5.59447342e-01,  5.57772670e-01,  5.55001540e-01],
           [  5.63378334e-01,  5.61712203e-01,  5.58917697e-01],
           [  5.67318525e-01,  5.65661014e-01,  5.62843061e-01],
           [  5.71268012e-01,  5.69619197e-01,  5.66777726e-01],
           [  5.75226891e-01,  5.73586846e-01,  5.70721788e-01],
           [  5.79195260e-01,  5.77564058e-01,  5.74675341e-01],
           [  5.83173215e-01,  5.81550928e-01,  5.78638481e-01],
           [  5.87160854e-01,  5.85547552e-01,  5.82611303e-01],
           [  5.91158275e-01,  5.89554026e-01,  5.86593903e-01],
           [  5.95165575e-01,  5.93570446e-01,  5.90586377e-01],
           [  5.99182852e-01,  5.97596909e-01,  5.94588823e-01],
           [  6.03210206e-01,  6.01633513e-01,  5.98601335e-01],
           [  6.07247734e-01,  6.05680354e-01,  6.02624013e-01],
           [  6.11295538e-01,  6.09737531e-01,  6.06656952e-01],
           [  6.15353715e-01,  6.13805142e-01,  6.10700252e-01],
           [  6.19422366e-01,  6.17883285e-01,  6.14754010e-01],
           [  6.23501592e-01,  6.21972059e-01,  6.18818325e-01],
           [  6.27591494e-01,  6.26071564e-01,  6.22893295e-01],
           [  6.31692172e-01,  6.30181900e-01,  6.26979022e-01],
           [  6.35803728e-01,  6.34303166e-01,  6.31075604e-01],
           [  6.39926266e-01,  6.38435464e-01,  6.35183141e-01],
           [  6.44059886e-01,  6.42578895e-01,  6.39301736e-01],
           [  6.48204692e-01,  6.46733559e-01,  6.43431488e-01],
           [  6.52360788e-01,  6.50899560e-01,  6.47572499e-01],
           [  6.56528279e-01,  6.55077000e-01,  6.51724873e-01],
           [  6.60707267e-01,  6.59265982e-01,  6.55888711e-01],
           [  6.64897859e-01,  6.63466610e-01,  6.60064117e-01],
           [  6.69100160e-01,  6.67678987e-01,  6.64251194e-01],
           [  6.73314277e-01,  6.71903219e-01,  6.68450048e-01],
           [  6.77540315e-01,  6.76139411e-01,  6.72660783e-01],
           [  6.81778383e-01,  6.80387668e-01,  6.76883504e-01],
           [  6.86028588e-01,  6.84648098e-01,  6.81118317e-01],
           [  6.90291039e-01,  6.88920807e-01,  6.85365330e-01],
           [  6.94565844e-01,  6.93205902e-01,  6.89624649e-01],
           [  6.98853114e-01,  6.97503492e-01,  6.93896382e-01],
           [  7.03152959e-01,  7.01813687e-01,  6.98180638e-01],
           [  7.07465490e-01,  7.06136594e-01,  7.02477526e-01],
           [  7.11790819e-01,  7.10472326e-01,  7.06787155e-01],
           [  7.16129057e-01,  7.14820991e-01,  7.11109637e-01],
           [  7.20480319e-01,  7.19182703e-01,  7.15445082e-01],
           [  7.24844717e-01,  7.23557574e-01,  7.19793602e-01],
           [  7.29222367e-01,  7.27945715e-01,  7.24155310e-01],
           [  7.33613383e-01,  7.32347242e-01,  7.28530318e-01],
           [  7.38017881e-01,  7.36762268e-01,  7.32918742e-01],
           [  7.42435979e-01,  7.41190908e-01,  7.37320696e-01],
           [  7.46867793e-01,  7.45633279e-01,  7.41736295e-01],
           [  7.51313442e-01,  7.50089498e-01,  7.46165655e-01],
           [  7.55773044e-01,  7.54559681e-01,  7.50608894e-01],
           [  7.60246720e-01,  7.59043948e-01,  7.55066130e-01],
           [  7.64734591e-01,  7.63542417e-01,  7.59537481e-01],
           [  7.69236777e-01,  7.68055208e-01,  7.64023067e-01],
           [  7.73753402e-01,  7.72582442e-01,  7.68523009e-01],
           [  7.78284588e-01,  7.77124242e-01,  7.73037426e-01],
           [  7.82830460e-01,  7.81680728e-01,  7.77566442e-01],
           [  7.87391143e-01,  7.86252026e-01,  7.82110180e-01],
           [  7.91966762e-01,  7.90838259e-01,  7.86668763e-01],
           [  7.96557444e-01,  7.95439553e-01,  7.91242317e-01],
           [  8.01163318e-01,  8.00056033e-01,  7.95830967e-01],
           [  8.05784512e-01,  8.04687827e-01,  8.00434839e-01],
           [  8.10421156e-01,  8.09335064e-01,  8.05054062e-01],
           [  8.15073380e-01,  8.13997872e-01,  8.09688764e-01],
           [  8.19741316e-01,  8.18676381e-01,  8.14339074e-01],
           [  8.24425097e-01,  8.23370723e-01,  8.19005124e-01],
           [  8.29124857e-01,  8.28081029e-01,  8.23687044e-01],
           [  8.33840731e-01,  8.32807434e-01,  8.28384968e-01],
           [  8.38572854e-01,  8.37550070e-01,  8.33099030e-01],
           [  8.43321364e-01,  8.42309074e-01,  8.37829363e-01],
           [  8.48086398e-01,  8.47084582e-01,  8.42576105e-01],
           [  8.52868095e-01,  8.51876731e-01,  8.47339391e-01],
           [  8.57666597e-01,  8.56685661e-01,  8.52119361e-01],
           [  8.62482045e-01,  8.61511510e-01,  8.56916153e-01],
           [  8.67314580e-01,  8.66354420e-01,  8.61729908e-01],
           [  8.72164348e-01,  8.71214534e-01,  8.66560768e-01],
           [  8.77031493e-01,  8.76091993e-01,  8.71408874e-01],
           [  8.81916161e-01,  8.80986944e-01,  8.76274371e-01],
           [  8.86818500e-01,  8.85899531e-01,  8.81157405e-01],
           [  8.91738659e-01,  8.90829901e-01,  8.86058122e-01],
           [  8.96676787e-01,  8.95778204e-01,  8.90976669e-01],
           [  9.01633037e-01,  9.00744588e-01,  8.95913195e-01],
           [  9.06607560e-01,  9.05729205e-01,  9.00867851e-01],
           [  9.11600510e-01,  9.10732206e-01,  9.05840788e-01],
           [  9.16612044e-01,  9.15753745e-01,  9.10832159e-01],
           [  9.21642317e-01,  9.20793978e-01,  9.15842119e-01],
           [  9.26691488e-01,  9.25853059e-01,  9.20870823e-01],
           [  9.31759717e-01,  9.30931148e-01,  9.25918428e-01],
           [  9.36847164e-01,  9.36028403e-01,  9.30985093e-01],
           [  9.41953991e-01,  9.41144984e-01,  9.36070977e-01],
           [  9.47080363e-01,  9.46281054e-01,  9.41176242e-01],
           [  9.52226446e-01,  9.51436776e-01,  9.46301050e-01],
           [  9.57392405e-01,  9.56612315e-01,  9.51445567e-01],
           [  9.62578409e-01,  9.61807838e-01,  9.56609957e-01],
           [  9.67784629e-01,  9.67023513e-01,  9.61794389e-01],
           [  9.73011236e-01,  9.72259509e-01,  9.66999031e-01],
           [  9.78258403e-01,  9.77515998e-01,  9.72224054e-01],
           [  9.83526305e-01,  9.82793152e-01,  9.77469630e-01],
           [  9.88815119e-01,  9.88091146e-01,  9.82735932e-01],
           [  9.94125022e-01,  9.93410157e-01,  9.88023137e-01],
           [  9.99456196e-01,  9.98750362e-01,  9.93331422e-01]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
