
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in pycam02ucs.cm.viscm
parameters = {'xp': [-3.4830597643097576, 0.6289831887553419, -17.483059764309758, -36.149726430976415, -10.119506350699233, -1.5386153198653005],
              'yp': [-16.277777777777771, -46.80680359435172, -12.0, -2.6666666666666572, -4.590430134624931, 5.8888888888888857],
              'min_Jp': 15.1681957187,
              'max_Jp': 98.6544342508}

cm_data = [[ 0.06597739, 0.12386005, 0.24948116],
           [ 0.06865758, 0.1266325 , 0.25557624],
           [ 0.07132312, 0.12939515, 0.26166391],
           [ 0.07396584, 0.13214058, 0.2677948 ],
           [ 0.07658629, 0.13486916, 0.27396904],
           [ 0.07919242, 0.13758843, 0.28014206],
           [ 0.08176925, 0.14028419, 0.28640499],
           [ 0.08433407, 0.14297318, 0.29265629],
           [ 0.08687299, 0.14564215, 0.29898019],
           [ 0.08939564, 0.14830082, 0.30531941],
           [ 0.09189721, 0.15094484, 0.311703  ],
           [ 0.09437767, 0.1535746 , 0.31813071],
           [ 0.09684032, 0.15619402, 0.32458157],
           [ 0.09927797, 0.15879644, 0.33109756],
           [ 0.10169939, 0.16139154, 0.33762358],
           [ 0.10409298, 0.1639684 , 0.34422672],
           [ 0.10647003, 0.16653949, 0.35083602],
           [ 0.10881765, 0.16909286, 0.35752405],
           [ 0.11114624, 0.1716403 , 0.36422476],
           [ 0.11344526, 0.17417268, 0.37099405],
           [ 0.11572015, 0.17669703, 0.37779407],
           [ 0.11796711, 0.17921142, 0.38463932],
           [ 0.12018172, 0.18171361, 0.39154591],
           [ 0.12237222, 0.18421369, 0.39845983],
           [ 0.12451836, 0.18669519, 0.40547913],
           [ 0.12663654, 0.18917624, 0.41250469],
           [ 0.12871435, 0.19164859, 0.41958831],
           [ 0.13074695, 0.19411179, 0.42673806],
           [ 0.13274084, 0.19657524, 0.43390608],
           [ 0.13468282, 0.19903239, 0.44113668],
           [ 0.13656674, 0.2014837 , 0.44843501],
           [ 0.13839602, 0.20393744, 0.4557622 ],
           [ 0.14016368, 0.20639447, 0.46312314],
           [ 0.14185409, 0.20885126, 0.47055044],
           [ 0.14345986, 0.21131167, 0.47803591],
           [ 0.14497642, 0.2137823 , 0.485557  ],
           [ 0.146391  , 0.21626634, 0.49311434],
           [ 0.14768864, 0.218768  , 0.50070638],
           [ 0.14885173, 0.22129285, 0.50832846],
           [ 0.14985965, 0.22384818, 0.51597154],
           [ 0.1506884 , 0.2264434 , 0.52362079],
           [ 0.15131023, 0.22909058, 0.53125369],
           [ 0.15168425, 0.23180303, 0.53885457],
           [ 0.15175702, 0.23459819, 0.54640144],
           [ 0.15150762, 0.23750367, 0.55379602],
           [ 0.15085272, 0.24054407, 0.56100954],
           [ 0.149778  , 0.24375297, 0.56790391],
           [ 0.1482413 , 0.24715977, 0.57437788],
           [ 0.14626774, 0.25078506, 0.58029534],
           [ 0.14393556, 0.25462901, 0.58555075],
           [ 0.14135408, 0.25866955, 0.59010335],
           [ 0.13864079, 0.26286871, 0.59397852],
           [ 0.13589174, 0.26718438, 0.59724867],
           [ 0.13319563, 0.27157423, 0.60000635],
           [ 0.13058114, 0.2760103 , 0.60234289],
           [ 0.12806719, 0.28047115, 0.60433583],
           [ 0.12569199, 0.28493491, 0.60605594],
           [ 0.12343537, 0.28939604, 0.60755039],
           [ 0.12131237, 0.29384382, 0.60886431],
           [ 0.1193314 , 0.29827105, 0.61003449],
           [ 0.11747335, 0.3026784 , 0.61108156],
           [ 0.11574105, 0.30706267, 0.61202824],
           [ 0.11415261, 0.31141804, 0.61290024],
           [ 0.11269166, 0.31574724, 0.61370617],
           [ 0.11135538, 0.32005035, 0.61445721],
           [ 0.11014377, 0.32432716, 0.6151638 ],
           [ 0.10905648, 0.32857778, 0.61583463],
           [ 0.10809281, 0.3328026 , 0.61647697],
           [ 0.10725185, 0.33700217, 0.61709693],
           [ 0.10653241, 0.34117717, 0.61769964],
           [ 0.10593314, 0.34532836, 0.61828945],
           [ 0.1054525 , 0.34945656, 0.61887003],
           [ 0.10508879, 0.35356261, 0.61944452],
           [ 0.10484013, 0.35764738, 0.62001559],
           [ 0.10470452, 0.36171173, 0.62058554],
           [ 0.10467981, 0.36575652, 0.62115635],
           [ 0.10476371, 0.36978259, 0.62172971],
           [ 0.10495382, 0.37379076, 0.62230709],
           [ 0.10524762, 0.37778184, 0.62288978],
           [ 0.10564252, 0.3817566 , 0.62347886],
           [ 0.1061358 , 0.38571579, 0.62407531],
           [ 0.10672471, 0.38966014, 0.62467996],
           [ 0.10740642, 0.39359035, 0.62529352],
           [ 0.10817806, 0.39750711, 0.62591662],
           [ 0.10903675, 0.40141105, 0.62654981],
           [ 0.10998202, 0.40530231, 0.62719516],
           [ 0.11100819, 0.40918206, 0.62785128],
           [ 0.11211222, 0.41305092, 0.62851837],
           [ 0.11329127, 0.41690943, 0.62919672],
           [ 0.11454253, 0.42075813, 0.62988653],
           [ 0.11586327, 0.42459754, 0.63058799],
           [ 0.11725083, 0.42842816, 0.63130122],
           [ 0.1187026 , 0.43225046, 0.63202632],
           [ 0.12021702, 0.4360647 , 0.63276403],
           [ 0.12179033, 0.43987161, 0.6335134 ],
           [ 0.1234202 , 0.44367161, 0.63427436],
           [ 0.12510445, 0.4474651 , 0.6350469 ],
           [ 0.12684102, 0.45125247, 0.63583095],
           [ 0.12862799, 0.45503408, 0.63662642],
           [ 0.13046351, 0.45881028, 0.6374332 ],
           [ 0.13234563, 0.46258148, 0.63825092],
           [ 0.13427263, 0.46634802, 0.63907929],
           [ 0.13624311, 0.4701102 , 0.63991816],
           [ 0.13825578, 0.47386832, 0.64076733],
           [ 0.14030945, 0.47762263, 0.64162657],
           [ 0.14240307, 0.48137341, 0.64249562],
           [ 0.14453572, 0.48512091, 0.64337422],
           [ 0.14670608, 0.48886546, 0.64426159],
           [ 0.14891319, 0.49260737, 0.64515709],
           [ 0.15115711, 0.49634669, 0.64606096],
           [ 0.15343746, 0.50008362, 0.64697283],
           [ 0.15575396, 0.50381833, 0.64789234],
           [ 0.15810648, 0.50755096, 0.64881909],
           [ 0.160495  , 0.51128167, 0.64975267],
           [ 0.16291965, 0.51501059, 0.65069263],
           [ 0.16538066, 0.51873781, 0.6516385 ],
           [ 0.16787709, 0.52246378, 0.65258827],
           [ 0.17041079, 0.52618823, 0.65354289],
           [ 0.17298246, 0.52991124, 0.65450185],
           [ 0.17559291, 0.53363281, 0.65546464],
           [ 0.1782431 , 0.53735298, 0.65643069],
           [ 0.18093416, 0.54107173, 0.65739946],
           [ 0.18366735, 0.54478903, 0.65837034],
           [ 0.18644408, 0.54850484, 0.65934275],
           [ 0.18926596, 0.55221906, 0.66031605],
           [ 0.19213472, 0.5559316 , 0.66128961],
           [ 0.19505228, 0.55964231, 0.66226278],
           [ 0.19802076, 0.56335105, 0.66323489],
           [ 0.20104242, 0.5670576 , 0.66420528],
           [ 0.20411976, 0.57076173, 0.66517325],
           [ 0.20725543, 0.57446319, 0.66613812],
           [ 0.21045232, 0.57816165, 0.6670992 ],
           [ 0.2137135 , 0.58185676, 0.66805579],
           [ 0.21704227, 0.58554813, 0.6690072 ],
           [ 0.22044214, 0.58923531, 0.66995277],
           [ 0.22391686, 0.59291779, 0.67089183],
           [ 0.22747037, 0.59659503, 0.67182375],
           [ 0.23110686, 0.6002664 , 0.67274791],
           [ 0.23483073, 0.60393124, 0.67366376],
           [ 0.2386466 , 0.60758879, 0.67457077],
           [ 0.24255928, 0.61123826, 0.67546847],
           [ 0.24657379, 0.61487875, 0.67635647],
           [ 0.25069532, 0.61850931, 0.67723446],
           [ 0.25492963, 0.62212933, 0.67809791],
           [ 0.25928228, 0.62573723, 0.67895065],
           [ 0.26375886, 0.62933183, 0.67979274],
           [ 0.26836502, 0.63291182, 0.68062438],
           [ 0.27310635, 0.63647586, 0.68144595],
           [ 0.27799067, 0.64002284, 0.68225204],
           [ 0.28302187, 0.64355084, 0.68304906],
           [ 0.28820489, 0.64705829, 0.68383831],
           [ 0.29354581, 0.65054365, 0.68461866],
           [ 0.29905039, 0.65400523, 0.68538993],
           [ 0.30471967, 0.65744127, 0.68615859],
           [ 0.31055832, 0.66085014, 0.68692427],
           [ 0.31656915, 0.66423017, 0.68768878],
           [ 0.32274951, 0.66757995, 0.68845924],
           [ 0.32910283, 0.67089793, 0.68923459],
           [ 0.33562308, 0.67418311, 0.69002275],
           [ 0.34230732, 0.67743451, 0.69082687],
           [ 0.34914976, 0.68065146, 0.69165158],
           [ 0.35614127, 0.68383379, 0.69250293],
           [ 0.36327369, 0.68698145, 0.69338491],
           [ 0.37053484, 0.69009497, 0.6943034 ],
           [ 0.37791226, 0.69317522, 0.69526327],
           [ 0.38539385, 0.69622324, 0.69626827],
           [ 0.39296332, 0.69924082, 0.697324  ],
           [ 0.4006094 , 0.70222938, 0.69843223],
           [ 0.40831594, 0.70519122, 0.69959724],
           [ 0.41607015, 0.7081284 , 0.7008209 ],
           [ 0.42386201, 0.71104276, 0.70210342],
           [ 0.43167256, 0.71393771, 0.70344961],
           [ 0.43949947, 0.71681422, 0.70485557],
           [ 0.44732849, 0.71967527, 0.70632366],
           [ 0.45514951, 0.72252334, 0.70785413],
           [ 0.46296115, 0.72535947, 0.70944335],
           [ 0.47075349, 0.72818626, 0.71109189],
           [ 0.47851694, 0.73100635, 0.71280025],
           [ 0.48625412, 0.73382019, 0.71456376],
           [ 0.49396102, 0.73662941, 0.716381  ],
           [ 0.50163106, 0.73943622, 0.71825179],
           [ 0.50925965, 0.74224248, 0.72017521],
           [ 0.51685029, 0.74504841, 0.72214731],
           [ 0.52440134, 0.74785523, 0.72416643],
           [ 0.53191155, 0.75066408, 0.72623094],
           [ 0.53938005, 0.753476  , 0.72833923],
           [ 0.54680444, 0.75629239, 0.73049037],
           [ 0.55418394, 0.75911426, 0.73268299],
           [ 0.5615215 , 0.76194178, 0.73491438],
           [ 0.56881727, 0.7647757 , 0.73718308],
           [ 0.57607152, 0.76761672, 0.73948764],
           [ 0.58328469, 0.7704655 , 0.74182668],
           [ 0.5904573 , 0.77332263, 0.74419886],
           [ 0.59758995, 0.77618869, 0.74660289],
           [ 0.60468333, 0.77906419, 0.7490375 ],
           [ 0.61173817, 0.78194964, 0.75150151],
           [ 0.61875522, 0.7848455 , 0.75399375],
           [ 0.62573528, 0.7877522 , 0.7565131 ],
           [ 0.63267915, 0.79067016, 0.75905849],
           [ 0.63958763, 0.79359978, 0.76162887],
           [ 0.64646151, 0.79654145, 0.76422323],
           [ 0.6533016 , 0.79949552, 0.76684059],
           [ 0.66010867, 0.80246236, 0.76948001],
           [ 0.66688348, 0.80544232, 0.77214056],
           [ 0.67362676, 0.80843573, 0.77482134],
           [ 0.68033922, 0.81144292, 0.77752145],
           [ 0.68702155, 0.81446423, 0.78024002],
           [ 0.69367439, 0.81749998, 0.7829762 ],
           [ 0.7002975 , 0.82055075, 0.78572944],
           [ 0.70689165, 0.82361681, 0.78849881],
           [ 0.71345823, 0.82669826, 0.79128316],
           [ 0.7199978 , 0.82979542, 0.79408159],
           [ 0.72651088, 0.83290861, 0.7968932 ],
           [ 0.73299796, 0.83603816, 0.79971707],
           [ 0.73945951, 0.8391844 , 0.80255223],
           [ 0.74589598, 0.84234767, 0.8053977 ],
           [ 0.7523078 , 0.84552831, 0.80825242],
           [ 0.75869517, 0.84872673, 0.81111536],
           [ 0.76505775, 0.85194348, 0.81398568],
           [ 0.77139709, 0.85517859, 0.81686163],
           [ 0.77771359, 0.85843239, 0.81974187],
           [ 0.78400765, 0.86170526, 0.82262493],
           [ 0.79027967, 0.86499755, 0.82550921],
           [ 0.79653012, 0.8683096 , 0.82839299],
           [ 0.8027595 , 0.87164177, 0.83127437],
           [ 0.80896806, 0.87499448, 0.83415141],
           [ 0.8151567 , 0.87836796, 0.83702171],
           [ 0.82132643, 0.88176244, 0.83988264],
           [ 0.82747812, 0.88517819, 0.84273144],
           [ 0.83361281, 0.88861542, 0.8455651 ],
           [ 0.83973174, 0.89207431, 0.84838033],
           [ 0.84583638, 0.89555495, 0.85117353],
           [ 0.85192854, 0.89905734, 0.85394079],
           [ 0.85801043, 0.90258135, 0.85667786],
           [ 0.86408444, 0.90612679, 0.85938032],
           [ 0.87015339, 0.9096933 , 0.86204351],
           [ 0.87622047, 0.9132804 , 0.8646626 ],
           [ 0.88228934, 0.9168874 , 0.86723268],
           [ 0.88836402, 0.92051348, 0.86974885],
           [ 0.89444909, 0.92415756, 0.87220619],
           [ 0.90054949, 0.92781839, 0.87459995],
           [ 0.90666975, 0.93149475, 0.87692634],
           [ 0.91281478, 0.93518523, 0.87918186],
           [ 0.91898934, 0.93888836, 0.88136368],
           [ 0.92519787, 0.94260271, 0.88346979],
           [ 0.93144429, 0.94632694, 0.88549899],
           [ 0.93773184, 0.95005986, 0.88745092],
           [ 0.94406341, 0.95380038, 0.88932539],
           [ 0.95044015, 0.95754793, 0.89112376],
           [ 0.95686223, 0.96130226, 0.89284794],
           [ 0.963329  , 0.96506343, 0.8944999 ],
           [ 0.96983887, 0.96883187, 0.89608183],
           [ 0.97638938, 0.97260834, 0.89759591],
           [ 0.98297732, 0.97639393, 0.89904421],
           [ 0.98959887, 0.98019003, 0.90042859],
           [ 0.99624974, 0.98399826, 0.90175064]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
