
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in pycam02ucs.cm.viscm
parameters = {'xp': [7.039639164310671, 0.5240894490237622, -11.740474720928063, -31.287123866788761, -25.960353398260537, -3.6918544843971688],
              'yp': [-7.2766097240472618, -43.303766973280744, -13.792159439334171, -4.2104686815593197, 17.06026058631923, 12.270039421813436],
              'min_Jp': 15.1681957187,
              'max_Jp': 98.6544342508}

cm_data = [[ 0.15610197, 0.10260825, 0.17272157],
           [ 0.15879951, 0.10562813, 0.17808215],
           [ 0.16148781, 0.10863318, 0.18344165],
           [ 0.16415718, 0.11162318, 0.18883992],
           [ 0.16681176, 0.11459941, 0.19425947],
           [ 0.16945091, 0.11756264, 0.19970233],
           [ 0.17207033, 0.12051292, 0.20518607],
           [ 0.17467698, 0.12345223, 0.21067979],
           [ 0.17725957, 0.12637929, 0.21623094],
           [ 0.17983088, 0.12929727, 0.22178284],
           [ 0.18237518, 0.13220381, 0.2274021 ],
           [ 0.18490718, 0.13510267, 0.23302318],
           [ 0.18741252, 0.13799155, 0.23870629],
           [ 0.18990318, 0.1408738 , 0.24439758],
           [ 0.19236658, 0.14374739, 0.25014898],
           [ 0.19481375, 0.14661556, 0.2559107 ],
           [ 0.19723196, 0.14947616, 0.26173441],
           [ 0.19963336, 0.15233276, 0.26756593],
           [ 0.20200284, 0.15518269, 0.2734655 ],
           [ 0.20435511, 0.15803011, 0.27936892],
           [ 0.20667286, 0.16087193, 0.28534375],
           [ 0.20897027, 0.16371219, 0.29132868],
           [ 0.21123508, 0.16654905, 0.29736908],
           [ 0.21347308, 0.16938469, 0.30343772],
           [ 0.21568192, 0.17221954, 0.30953956],
           [ 0.21785541, 0.17505333, 0.31569323],
           [ 0.22000279, 0.17788891, 0.32185935],
           [ 0.22210836, 0.18072434, 0.32809006],
           [ 0.22418213, 0.18356266, 0.33434315],
           [ 0.2262221 , 0.18640462, 0.34062032],
           [ 0.22821552, 0.18924937, 0.34695853],
           [ 0.23017343, 0.19210006, 0.35331317],
           [ 0.23209137, 0.19495728, 0.35969247],
           [ 0.23395668, 0.19782084, 0.36612828],
           [ 0.23577916, 0.20069365, 0.37258104],
           [ 0.23755595, 0.2035769 , 0.3790513 ],
           [ 0.23927601, 0.20647121, 0.38556163],
           [ 0.24093942, 0.20937861, 0.39210045],
           [ 0.24254746, 0.21230118, 0.39865318],
           [ 0.2440963 , 0.21524071, 0.40521875],
           [ 0.2455818 , 0.21819916, 0.41179552],
           [ 0.24699281, 0.22117861, 0.41839657],
           [ 0.24833066, 0.22418177, 0.42500332],
           [ 0.24959215, 0.22721132, 0.43160747],
           [ 0.25077214, 0.23027012, 0.43820368],
           [ 0.25186528, 0.23336132, 0.44478539],
           [ 0.252866  , 0.23648829, 0.45134461],
           [ 0.25376865, 0.23965469, 0.45787181],
           [ 0.25456757, 0.24286438, 0.46435576],
           [ 0.25525721, 0.24612144, 0.47078343],
           [ 0.25583228, 0.24943005, 0.47713997],
           [ 0.25628796, 0.25279443, 0.48340873],
           [ 0.25661512, 0.25621955, 0.48957708],
           [ 0.25680888, 0.25970984, 0.49562536],
           [ 0.25687291, 0.26326808, 0.50152514],
           [ 0.25680712, 0.26689714, 0.50725418],
           [ 0.25660517, 0.27060089, 0.51279636],
           [ 0.25627372, 0.27437999, 0.51812616],
           [ 0.2558254 , 0.27823281, 0.523219  ],
           [ 0.25525973, 0.28216003, 0.5280624 ],
           [ 0.25459786, 0.28615608, 0.53263702],
           [ 0.25385147, 0.29021676, 0.53693454],
           [ 0.25303784, 0.29433557, 0.54094998],
           [ 0.25217537, 0.29850489, 0.54468392],
           [ 0.25128177, 0.30271674, 0.54814227],
           [ 0.25037292, 0.30696328, 0.55133524],
           [ 0.24946824, 0.31123536, 0.55427663],
           [ 0.24857612, 0.31552728, 0.55698221],
           [ 0.2477157 , 0.31982991, 0.55947045],
           [ 0.24689121, 0.3241392 , 0.56175861],
           [ 0.24611215, 0.32844959, 0.56386485],
           [ 0.24538978, 0.33275513, 0.56580822],
           [ 0.24472203, 0.33705469, 0.56760298],
           [ 0.24411647, 0.3413441 , 0.56926586],
           [ 0.24357904, 0.34561997, 0.57081275],
           [ 0.24310562, 0.34988262, 0.57225403],
           [ 0.24269783, 0.35413056, 0.5736016 ],
           [ 0.24236192, 0.35836085, 0.57486937],
           [ 0.2420947 , 0.36257399, 0.5760654 ],
           [ 0.24189401, 0.36677027, 0.57719727],
           [ 0.24175956, 0.37094938, 0.57827294],
           [ 0.24169076, 0.37511123, 0.57929958],
           [ 0.2416897 , 0.37925483, 0.58028581],
           [ 0.24175313, 0.38338117, 0.58123598],
           [ 0.24187844, 0.387491  , 0.58215425],
           [ 0.24206427, 0.39158472, 0.58304526],
           [ 0.24230913, 0.39566275, 0.58391314],
           [ 0.24261144, 0.39972561, 0.5847616 ],
           [ 0.24296954, 0.40377384, 0.58559395],
           [ 0.24338171, 0.40780801, 0.58641316],
           [ 0.24384618, 0.41182872, 0.58722185],
           [ 0.24436114, 0.4158366 , 0.58802239],
           [ 0.24492561, 0.41983198, 0.58881765],
           [ 0.24553674, 0.42381585, 0.58960858],
           [ 0.24619263, 0.42778886, 0.59039677],
           [ 0.24689148, 0.43175165, 0.59118371],
           [ 0.24763144, 0.43570484, 0.59197068],
           [ 0.24841072, 0.43964906, 0.59275883],
           [ 0.24922752, 0.44358493, 0.59354913],
           [ 0.25008005, 0.44751306, 0.59434245],
           [ 0.25096657, 0.45143404, 0.59513951],
           [ 0.25188534, 0.45534848, 0.59594094],
           [ 0.25283469, 0.45925694, 0.59674727],
           [ 0.25381294, 0.46316   , 0.5975589 ],
           [ 0.25481847, 0.46705822, 0.59837617],
           [ 0.25584972, 0.47095213, 0.59919934],
           [ 0.25690514, 0.47484228, 0.60002857],
           [ 0.25798324, 0.47872916, 0.60086398],
           [ 0.25908258, 0.4826133 , 0.60170558],
           [ 0.26020178, 0.48649518, 0.60255336],
           [ 0.2613397 , 0.4903752 , 0.60340742],
           [ 0.26249484, 0.4942539 , 0.60426741],
           [ 0.26366598, 0.49813174, 0.6051331 ],
           [ 0.26485195, 0.50200914, 0.60600423],
           [ 0.26605166, 0.50588653, 0.6068805 ],
           [ 0.26726407, 0.5097643 , 0.60776157],
           [ 0.26848824, 0.51364284, 0.60864705],
           [ 0.26972326, 0.51752253, 0.60953651],
           [ 0.27096833, 0.52140372, 0.61042947],
           [ 0.27222271, 0.52528675, 0.61132543],
           [ 0.27348573, 0.52917194, 0.61222386],
           [ 0.27475681, 0.53305961, 0.61312416],
           [ 0.27603547, 0.53695005, 0.61402574],
           [ 0.27732128, 0.54084353, 0.61492795],
           [ 0.27861393, 0.5447403 , 0.61583014],
           [ 0.27991319, 0.54864062, 0.61673159],
           [ 0.28121892, 0.5525447 , 0.6176316 ],
           [ 0.28253107, 0.55645275, 0.61852942],
           [ 0.28384971, 0.56036495, 0.61942427],
           [ 0.28517499, 0.56428149, 0.62031537],
           [ 0.28650717, 0.56820249, 0.62120191],
           [ 0.28784651, 0.57212815, 0.62208291],
           [ 0.28919353, 0.57605855, 0.62295759],
           [ 0.29054888, 0.57999377, 0.62382514],
           [ 0.29191327, 0.58393389, 0.62468468],
           [ 0.29328753, 0.58787895, 0.62553534],
           [ 0.29467261, 0.59182898, 0.62637622],
           [ 0.29606961, 0.59578401, 0.6272064 ],
           [ 0.29747971, 0.599744  , 0.62802499],
           [ 0.29890426, 0.60370894, 0.62883105],
           [ 0.30034472, 0.60767877, 0.62962366],
           [ 0.3018027 , 0.6116534 , 0.6304019 ],
           [ 0.30327995, 0.61563273, 0.63116484],
           [ 0.30477834, 0.61961664, 0.63191155],
           [ 0.30629992, 0.62360498, 0.63264111],
           [ 0.30784684, 0.62759757, 0.63335259],
           [ 0.30942143, 0.63159422, 0.63404509],
           [ 0.31102618, 0.63559469, 0.63471769],
           [ 0.31266369, 0.63959874, 0.6353695 ],
           [ 0.31433675, 0.64360608, 0.63599965],
           [ 0.31604829, 0.6476164 , 0.63660727],
           [ 0.31780141, 0.65162937, 0.63719152],
           [ 0.31959934, 0.65564462, 0.63775156],
           [ 0.32144548, 0.65966175, 0.6382866 ],
           [ 0.32334339, 0.66368034, 0.63879587],
           [ 0.32529678, 0.66769992, 0.63927863],
           [ 0.32730951, 0.67171999, 0.63973418],
           [ 0.32938557, 0.67574005, 0.64016185],
           [ 0.33152913, 0.67975951, 0.64056102],
           [ 0.33374413, 0.68377791, 0.6409304 ],
           [ 0.3360351 , 0.68779458, 0.6412696 ],
           [ 0.33840684, 0.69180878, 0.64157857],
           [ 0.34086403, 0.69581978, 0.64185693],
           [ 0.34341147, 0.69982684, 0.64210435],
           [ 0.34605405, 0.70382918, 0.64232058],
           [ 0.34879674, 0.70782594, 0.64250547],
           [ 0.3516446 , 0.71181627, 0.64265896],
           [ 0.35460272, 0.71579925, 0.64278108],
           [ 0.35767625, 0.71977391, 0.64287199],
           [ 0.36086992, 0.72373958, 0.64292927],
           [ 0.36418945, 0.7276949 , 0.64295573],
           [ 0.36763999, 0.73163877, 0.64295205],
           [ 0.37122661, 0.73557007, 0.64291896],
           [ 0.37495428, 0.73948763, 0.64285736],
           [ 0.37882784, 0.74339025, 0.64276831],
           [ 0.38285235, 0.74727697, 0.64264931],
           [ 0.38703226, 0.75114621, 0.64250555],
           [ 0.39137183, 0.75499667, 0.64233873],
           [ 0.39587503, 0.75882703, 0.64215083],
           [ 0.40054593, 0.76263603, 0.64194247],
           [ 0.40538835, 0.76642231, 0.64171516],
           [ 0.41040452, 0.77018443, 0.64147423],
           [ 0.41559684, 0.77392103, 0.64122273],
           [ 0.42096796, 0.77763083, 0.64096223],
           [ 0.42651956, 0.78131247, 0.64069607],
           [ 0.43225139, 0.78496472, 0.64043042],
           [ 0.43816347, 0.78858638, 0.64016943],
           [ 0.44425693, 0.79217623, 0.63991482],
           [ 0.45052876, 0.79573333, 0.63967426],
           [ 0.45697666, 0.79925675, 0.63945293],
           [ 0.46359865, 0.80274561, 0.63925487],
           [ 0.47039042, 0.80619928, 0.63908644],
           [ 0.47734697, 0.80961729, 0.63895382],
           [ 0.48446331, 0.81299926, 0.63886245],
           [ 0.49173307, 0.81634505, 0.63881848],
           [ 0.49914951, 0.81965467, 0.63882777],
           [ 0.50670501, 0.82292834, 0.63889632],
           [ 0.51439085, 0.82616658, 0.63903043],
           [ 0.52219973, 0.82936979, 0.63923462],
           [ 0.53012282, 0.83253876, 0.63951422],
           [ 0.53814812, 0.83567489, 0.63987637],
           [ 0.54626958, 0.83877878, 0.64032322],
           [ 0.55447837, 0.84185159, 0.6408588 ],
           [ 0.56276148, 0.84489535, 0.64148939],
           [ 0.57111152, 0.84791128, 0.64221712],
           [ 0.57952181, 0.85090053, 0.64304356],
           [ 0.5879841 , 0.85386466, 0.64397109],
           [ 0.59648484, 0.85680645, 0.64500466],
           [ 0.60501947, 0.85972701, 0.64614391],
           [ 0.61358282, 0.86262763, 0.64738888],
           [ 0.62216818, 0.86550998, 0.64874031],
           [ 0.63076931, 0.86837576, 0.65019861],
           [ 0.6393757 , 0.87122773, 0.65176583],
           [ 0.64798434, 0.87406707, 0.65344053],
           [ 0.65659293, 0.87689477, 0.65522105],
           [ 0.6651972 , 0.87971238, 0.65710661],
           [ 0.67379331, 0.88252137, 0.65909617],
           [ 0.68237784, 0.88532317, 0.66118854],
           [ 0.69094781, 0.88811911, 0.66338232],
           [ 0.69950063, 0.8909105 , 0.66567599],
           [ 0.70803409, 0.89369855, 0.66806789],
           [ 0.71654633, 0.8964844 , 0.67055629],
           [ 0.72503584, 0.89926913, 0.67313935],
           [ 0.7335014 , 0.90205374, 0.6758152 ],
           [ 0.7419421 , 0.90483916, 0.6785819 ],
           [ 0.75035729, 0.90762623, 0.68143751],
           [ 0.75874656, 0.91041576, 0.68438007],
           [ 0.76710972, 0.91320846, 0.68740763],
           [ 0.77544679, 0.91600497, 0.69051825],
           [ 0.78375799, 0.91880591, 0.69371001],
           [ 0.79204369, 0.92161178, 0.69698104],
           [ 0.8003044 , 0.92442306, 0.70032949],
           [ 0.80854079, 0.92724016, 0.70375359],
           [ 0.81675365, 0.93006344, 0.7072516 ],
           [ 0.82494386, 0.93289321, 0.71082186],
           [ 0.83310566, 0.93573198, 0.71446311],
           [ 0.84124229, 0.9385793 , 0.71817346],
           [ 0.84935864, 0.94143411, 0.72195118],
           [ 0.85745594, 0.94429655, 0.72579485],
           [ 0.8655355 , 0.94716668, 0.72970312],
           [ 0.87359867, 0.95004456, 0.73367476],
           [ 0.8816326 , 0.95293526, 0.73770822],
           [ 0.88965121, 0.95583441, 0.74180237],
           [ 0.89765699, 0.95874159, 0.7459562 ],
           [ 0.90565146, 0.96165671, 0.7501688 ],
           [ 0.9136274 , 0.96458287, 0.75443868],
           [ 0.92158503, 0.96752052, 0.75876468],
           [ 0.92953534, 0.97046601, 0.76314675],
           [ 0.93747992, 0.97341911, 0.76758435],
           [ 0.94540698, 0.97638475, 0.77207538],
           [ 0.95332337, 0.97936076, 0.77661978],
           [ 0.96123821, 0.98234397, 0.78121815],
           [ 0.96914884, 0.98533575, 0.78586971],
           [ 0.97704185, 0.98834183, 0.79057175],
           [ 0.98493745, 0.99135452, 0.79532716],
           [ 0.99283718, 0.99437346, 0.8001362 ]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
