
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in pycam02ucs.cm.viscm
parameters = {'xp': [18.5244900767035, 38.81613452720423, 31.318835561314433, 26.83769135181708, 14.945424026612574, 0.0],
              'yp': [5.3490351872872, 5.033423417915618, 18.1321526456771, 27.61149616576765, 10.893381230335233, 0.0],
              'min_Jp': 15,
              'max_Jp': 95}

cm_data = [[ 0.23605636, 0.03529748, 0.06943744],
           [ 0.24100216, 0.03645747, 0.07203246],
           [ 0.24594281, 0.03762149, 0.07460911],
           [ 0.25089381, 0.03876029, 0.07716551],
           [ 0.25584517, 0.03989183, 0.07970262],
           [ 0.26080251, 0.04099314, 0.08221948],
           [ 0.26576674, 0.04204947, 0.08471559],
           [ 0.27073125, 0.04308157, 0.08719176],
           [ 0.2757103 , 0.04406225, 0.08964513],
           [ 0.280689  , 0.04502128, 0.09207801],
           [ 0.2856782 , 0.04593789, 0.09448789],
           [ 0.29067463, 0.046819  , 0.09687492],
           [ 0.29567262, 0.04767654, 0.09923998],
           [ 0.30068793, 0.04847913, 0.1015787 ],
           [ 0.30570613, 0.04925629, 0.10389404],
           [ 0.31073013, 0.05000264, 0.10618475],
           [ 0.31576962, 0.05069836, 0.10844733],
           [ 0.32081338, 0.051367  , 0.11068434],
           [ 0.32586362, 0.05200433, 0.11289448],
           [ 0.3309303 , 0.0525894 , 0.11507352],
           [ 0.33600266, 0.05314516, 0.11722421],
           [ 0.34108131, 0.05367069, 0.11934559],
           [ 0.34617448, 0.05414818, 0.12143346],
           [ 0.3512776 , 0.05458756, 0.12348844],
           [ 0.35638806, 0.05499475, 0.12551057],
           [ 0.36150633, 0.05536891, 0.12749858],
           [ 0.36663878, 0.05569562, 0.12944818],
           [ 0.37178172, 0.05598316, 0.13135965],
           [ 0.37693297, 0.05623658, 0.13323265],
           [ 0.38209283, 0.05645532, 0.13506562],
           [ 0.38726151, 0.05663896, 0.13685687],
           [ 0.39244086, 0.05678317, 0.13860362],
           [ 0.39763217, 0.05688474, 0.14030311],
           [ 0.40283182, 0.05695245, 0.14195559],
           [ 0.40803974, 0.0569867 , 0.14355911],
           [ 0.41325574, 0.05698815, 0.14511166],
           [ 0.41847954, 0.0569578 , 0.14661115],
           [ 0.42371075, 0.05689701, 0.14805546],
           [ 0.42894883, 0.05680756, 0.1494424 ],
           [ 0.43419316, 0.0566917 , 0.15076979],
           [ 0.43944294, 0.05655221, 0.15203539],
           [ 0.44469726, 0.05639244, 0.15323702],
           [ 0.44995505, 0.05621639, 0.15437248],
           [ 0.45521509, 0.05602873, 0.15543963],
           [ 0.46047601, 0.0558349 , 0.1564364 ],
           [ 0.46573629, 0.05564106, 0.15736082],
           [ 0.47099432, 0.05545405, 0.15821095],
           [ 0.47625192, 0.05527092, 0.15898043],
           [ 0.48150354, 0.05511075, 0.15967186],
           [ 0.486747  , 0.0549832 , 0.16028395],
           [ 0.49198001, 0.05489873, 0.16081569],
           [ 0.49720286, 0.05486041, 0.16126216],
           [ 0.50241221, 0.0548824 , 0.16162363],
           [ 0.50760343, 0.05498327, 0.16190307],
           [ 0.51277604, 0.055169  , 0.16209682],
           [ 0.51792734, 0.05545236, 0.16220493],
           [ 0.52305208, 0.05585384, 0.16223297],
           [ 0.52815138, 0.05637398, 0.16217425],
           [ 0.53321862, 0.05703661, 0.1620384 ],
           [ 0.53825351, 0.05784533, 0.16182217],
           [ 0.54325161, 0.05881548, 0.16153233],
           [ 0.54821164, 0.05995167, 0.16116863],
           [ 0.55312973, 0.06126497, 0.16073839],
           [ 0.558005  , 0.06275633, 0.16024132],
           [ 0.56283369, 0.06443348, 0.15968656],
           [ 0.56761519, 0.06629402, 0.15907416],
           [ 0.57234666, 0.06834024, 0.15841244],
           [ 0.57702676, 0.07056925, 0.15770548],
           [ 0.58165431, 0.0729768 , 0.15695715],
           [ 0.58622754, 0.07555913, 0.1561749 ],
           [ 0.59074564, 0.07830966, 0.1553625 ],
           [ 0.59520759, 0.08122188, 0.15452537],
           [ 0.59961233, 0.08428892, 0.15366992],
           [ 0.60395923, 0.08750309, 0.15280055],
           [ 0.60824759, 0.09085689, 0.15192244],
           [ 0.61247664, 0.09434294, 0.15104188],
           [ 0.61664581, 0.09795388, 0.15016404],
           [ 0.62075455, 0.10168277, 0.1492933 ],
           [ 0.62480216, 0.10552294, 0.14843641],
           [ 0.62878806, 0.1094681 , 0.14759896],
           [ 0.63271161, 0.1135125 , 0.14678623],
           [ 0.63657214, 0.11765076, 0.14600414],
           [ 0.64036897, 0.12187775, 0.14525938],
           [ 0.6441014 , 0.1261888 , 0.14455832],
           [ 0.64776867, 0.13057974, 0.14390725],
           [ 0.65137002, 0.13504657, 0.14331304],
           [ 0.65490476, 0.13958536, 0.14278329],
           [ 0.65837217, 0.14419254, 0.14232539],
           [ 0.66177158, 0.14886467, 0.14194696],
           [ 0.66510231, 0.15359857, 0.14165564],
           [ 0.66836392, 0.15839066, 0.14145988],
           [ 0.67155603, 0.16323763, 0.14136778],
           [ 0.67467839, 0.16813609, 0.14138745],
           [ 0.67773093, 0.17308255, 0.14152696],
           [ 0.68071389, 0.17807325, 0.14179429],
           [ 0.68362765, 0.18310449, 0.14219685],
           [ 0.68647282, 0.18817247, 0.14274156],
           [ 0.68925026, 0.19327329, 0.14343469],
           [ 0.69196156, 0.19840215, 0.14428234],
           [ 0.69460803, 0.20355522, 0.14528888],
           [ 0.69719119, 0.20872863, 0.1464578 ],
           [ 0.69971287, 0.21391846, 0.14779166],
           [ 0.70217642, 0.21911867, 0.14929281],
           [ 0.7045832 , 0.22432695, 0.15096086],
           [ 0.70693528, 0.2295401 , 0.15279509],
           [ 0.7092368 , 0.23475218, 0.15479434],
           [ 0.71148941, 0.23996139, 0.15695555],
           [ 0.71369465, 0.24516618, 0.15927527],
           [ 0.71585857, 0.25035905, 0.16174941],
           [ 0.71797972, 0.25554309, 0.1643732 ],
           [ 0.72006376, 0.26071192, 0.16714113],
           [ 0.72211068, 0.26586686, 0.17004801],
           [ 0.72412471, 0.27100385, 0.17308755],
           [ 0.72610583, 0.27612434, 0.1762545 ],
           [ 0.72805897, 0.28122374, 0.17954176],
           [ 0.72998135, 0.28630683, 0.18294545],
           [ 0.73188145, 0.29136515, 0.18645645],
           [ 0.73375464, 0.29640553, 0.19007224],
           [ 0.73560419, 0.30142565, 0.19378648],
           [ 0.73743444, 0.30642218, 0.19759197],
           [ 0.73924224, 0.31139994, 0.20148645],
           [ 0.74102893, 0.31635876, 0.20546519],
           [ 0.74280115, 0.32129308, 0.20951949],
           [ 0.74455467, 0.32620861, 0.21364884],
           [ 0.74629042, 0.33110557, 0.21784921],
           [ 0.74800939, 0.33598414, 0.22211675],
           [ 0.74971442, 0.34084271, 0.22644611],
           [ 0.7514064 , 0.34568159, 0.23083365],
           [ 0.75308388, 0.35050328, 0.23527805],
           [ 0.75474753, 0.35530812, 0.23977628],
           [ 0.75639802, 0.36009651, 0.24432551],
           [ 0.75803592, 0.36486886, 0.24892308],
           [ 0.75966179, 0.36962563, 0.25356652],
           [ 0.7612761 , 0.37436725, 0.2582535 ],
           [ 0.76287932, 0.37909421, 0.26298186],
           [ 0.76447184, 0.38380698, 0.26774959],
           [ 0.76605405, 0.38850606, 0.27255481],
           [ 0.76762628, 0.39319192, 0.27739578],
           [ 0.76918883, 0.39786508, 0.28227086],
           [ 0.77074198, 0.40252603, 0.28717856],
           [ 0.77228598, 0.40717525, 0.29211747],
           [ 0.77382106, 0.41181324, 0.29708627],
           [ 0.77534742, 0.41644048, 0.30208376],
           [ 0.77686525, 0.42105744, 0.30710879],
           [ 0.77837472, 0.42566461, 0.31216031],
           [ 0.77987598, 0.43026243, 0.31723734],
           [ 0.78136918, 0.43485136, 0.32233896],
           [ 0.78285445, 0.43943184, 0.3274643 ],
           [ 0.78433192, 0.44400431, 0.33261256],
           [ 0.7858017 , 0.44856917, 0.33778299],
           [ 0.7872639 , 0.45312683, 0.34297487],
           [ 0.78872016, 0.45767666, 0.34818589],
           [ 0.7901716 , 0.46221839, 0.35341429],
           [ 0.79161598, 0.46675401, 0.35866201],
           [ 0.79305338, 0.47128388, 0.36392851],
           [ 0.79448389, 0.47580837, 0.36921324],
           [ 0.79590758, 0.48032781, 0.37451573],
           [ 0.79732536, 0.48484204, 0.37983461],
           [ 0.79874102, 0.48934908, 0.38516542],
           [ 0.80015027, 0.49385203, 0.39051246],
           [ 0.80155319, 0.49835121, 0.39587532],
           [ 0.80294987, 0.50284691, 0.40125361],
           [ 0.80434127, 0.5073389 , 0.40664602],
           [ 0.80573189, 0.51182485, 0.41204743],
           [ 0.80711664, 0.51630818, 0.41746308],
           [ 0.80849561, 0.52078914, 0.42289263],
           [ 0.80986892, 0.52526798, 0.42833575],
           [ 0.81124166, 0.52974208, 0.43378676],
           [ 0.81261066, 0.53421362, 0.43924887],
           [ 0.81397435, 0.5386838 , 0.44472359],
           [ 0.81533287, 0.54315282, 0.4502106 ],
           [ 0.81669164, 0.54761797, 0.45570396],
           [ 0.81804727, 0.55208146, 0.46120716],
           [ 0.8193981 , 0.55654448, 0.4667218 ],
           [ 0.82074446, 0.5610071 , 0.47224741],
           [ 0.82209351, 0.5654658 , 0.4777763 ],
           [ 0.82343818, 0.56992464, 0.48331585],
           [ 0.82477864, 0.57438378, 0.48886578],
           [ 0.82611883, 0.57884143, 0.49442183],
           [ 0.82745885, 0.58329784, 0.49998384],
           [ 0.8287951 , 0.58775511, 0.50555549],
           [ 0.83012886, 0.59221284, 0.51113538],
           [ 0.83146578, 0.59666845, 0.51671758],
           [ 0.8327994 , 0.60112544, 0.52230874],
           [ 0.83412997, 0.60558393, 0.52790853],
           [ 0.83546465, 0.61004065, 0.53350956],
           [ 0.83679726, 0.61449887, 0.53911813],
           [ 0.83812737, 0.61895905, 0.54473466],
           [ 0.83946118, 0.62341843, 0.55035278],
           [ 0.84079447, 0.62787931, 0.55597679],
           [ 0.84212584, 0.63234256, 0.56160808],
           [ 0.84346121, 0.63680564, 0.56724066],
           [ 0.84479692, 0.6412705 , 0.57287823],
           [ 0.84613135, 0.64573812, 0.57852239],
           [ 0.84747066, 0.6502059 , 0.58416701],
           [ 0.84881064, 0.65467602, 0.5898163 ],
           [ 0.85015004, 0.65914923, 0.59547148],
           [ 0.85149567, 0.66362272, 0.60112588],
           [ 0.85284187, 0.66809925, 0.60678508],
           [ 0.85418868, 0.67257901, 0.61244905],
           [ 0.85554259, 0.67705939, 0.61811153],
           [ 0.85689709, 0.68154344, 0.62377885],
           [ 0.85825448, 0.68603039, 0.62944884],
           [ 0.85961805, 0.69051904, 0.63511837],
           [ 0.86098306, 0.69501165, 0.64079203],
           [ 0.86235347, 0.69950673, 0.64646609],
           [ 0.86372898, 0.70400466, 0.6521409 ],
           [ 0.86510687, 0.70850676, 0.65781907],
           [ 0.86649279, 0.71301092, 0.66349536],
           [ 0.86788271, 0.71751901, 0.66917362],
           [ 0.869277  , 0.72203109, 0.67485355],
           [ 0.87068003, 0.72654561, 0.68053118],
           [ 0.87208702, 0.73106471, 0.68621101],
           [ 0.87350146, 0.73558719, 0.69188989],
           [ 0.87492328, 0.7401133 , 0.69756799],
           [ 0.8763502 , 0.74464415, 0.70324744],
           [ 0.87778757, 0.74917785, 0.70892352],
           [ 0.87923119, 0.75371626, 0.7146001 ],
           [ 0.8806828 , 0.75825891, 0.72027569],
           [ 0.88214442, 0.76280522, 0.72594861],
           [ 0.88361314, 0.76735654, 0.73162155],
           [ 0.88509303, 0.7719115 , 0.73729103],
           [ 0.88658192, 0.77647116, 0.74295904],
           [ 0.88808029, 0.78103554, 0.7486253 ],
           [ 0.88959091, 0.7856038 , 0.75428751],
           [ 0.89111096, 0.79017723, 0.75994825],
           [ 0.89264372, 0.7947548 , 0.76560481],
           [ 0.89418811, 0.79933714, 0.77125826],
           [ 0.89574424, 0.80392441, 0.77690862],
           [ 0.89731486, 0.80851582, 0.78255374],
           [ 0.89889772, 0.8131124 , 0.78819564],
           [ 0.90049562, 0.81771336, 0.79383214],
           [ 0.90210801, 0.82231911, 0.79946386],
           [ 0.90373524, 0.82692974, 0.80509065],
           [ 0.90537962, 0.83154465, 0.81071083],
           [ 0.90703981, 0.83616452, 0.81632562],
           [ 0.90871829, 0.8407887 , 0.82193324],
           [ 0.91041491, 0.84541748, 0.82753398],
           [ 0.91213057, 0.85005074, 0.83312732],
           [ 0.91386714, 0.85468808, 0.83871202],
           [ 0.91562445, 0.85932976, 0.8442884 ],
           [ 0.91740482, 0.86397523, 0.84985489],
           [ 0.91920879, 0.86862452, 0.85541133],
           [ 0.92103803, 0.8732773 , 0.86095667],
           [ 0.92289448, 0.87793315, 0.86648973],
           [ 0.92477958, 0.8825918 , 0.87200971],
           [ 0.92669605, 0.8872526 , 0.87751487],
           [ 0.92864616, 0.89191502, 0.88300387],
           [ 0.93063333, 0.89657817, 0.88847456],
           [ 0.93266145, 0.90124101, 0.89392449],
           [ 0.93473589, 0.90590202, 0.89935023],
           [ 0.93686346, 0.91055922, 0.90474739],
           [ 0.93905471, 0.9152094 , 0.91010904],
           [ 0.94132632, 0.91984736, 0.9154241 ],
           [ 0.94371151, 0.9244625 , 0.92067015],
           [ 0.94634709, 0.92901013, 0.92575324]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
