
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in pycam02ucs.cm.viscm
parameters = {'xp': [-0.62142369703696687, -1.833657945842333, -0.9520330376202466, -21.780421494367047, -1.7234548323145731, -32.359920393032084, -5.2499544652029186, 0.0],
              'yp': [-17.387103134609646, -20.693196540442472, -45.048084630077618, -35.901226207273467, -12.538166139388167, -17.387103134609646, -6.8076042359446092, 0.0],
              'min_Jp': 15,
              'max_Jp': 95}

cm_data = [[ 0.0931763 , 0.11117333, 0.26151239],
           [ 0.09501859, 0.11404783, 0.26726174],
           [ 0.09696374, 0.11685935, 0.27307323],
           [ 0.09894608, 0.11962843, 0.27895796],
           [ 0.10095308, 0.12237182, 0.28486368],
           [ 0.10296282, 0.12509163, 0.29081557],
           [ 0.10496919, 0.12779277, 0.29680302],
           [ 0.10696791, 0.13047857, 0.30281954],
           [ 0.10895646, 0.13315177, 0.3088586 ],
           [ 0.1109293 , 0.1358123 , 0.31492993],
           [ 0.11288435, 0.13846141, 0.32103257],
           [ 0.11481983, 0.14110006, 0.32716614],
           [ 0.11673422, 0.14372908, 0.33333054],
           [ 0.11862618, 0.14634914, 0.33952584],
           [ 0.12049569, 0.14896155, 0.34574763],
           [ 0.12234061, 0.15156624, 0.35200018],
           [ 0.12415974, 0.15416362, 0.35828434],
           [ 0.12595204, 0.15675416, 0.3646004 ],
           [ 0.12771658, 0.1593383 , 0.37094853],
           [ 0.12945242, 0.16191651, 0.3773288 ],
           [ 0.13115867, 0.16448923, 0.38374118],
           [ 0.13283443, 0.16705693, 0.39018557],
           [ 0.13447947, 0.16962038, 0.39665961],
           [ 0.13609224, 0.17217971, 0.4031653 ],
           [ 0.13767135, 0.17473515, 0.40970398],
           [ 0.1392158 , 0.17728718, 0.41627535],
           [ 0.14072458, 0.17983627, 0.42287909],
           [ 0.14219662, 0.18238291, 0.42951481],
           [ 0.14363072, 0.18492757, 0.43618236],
           [ 0.14502527, 0.18747057, 0.44288261],
           [ 0.14637894, 0.19001244, 0.44961519],
           [ 0.14769037, 0.19255372, 0.4563796 ],
           [ 0.14895812, 0.19509499, 0.4631753 ],
           [ 0.15018062, 0.19763683, 0.47000175],
           [ 0.15135593, 0.20017976, 0.47685912],
           [ 0.15248089, 0.20272392, 0.48375032],
           [ 0.15355462, 0.20527041, 0.4906717 ],
           [ 0.154575  , 0.20781995, 0.49762254],
           [ 0.15553975, 0.21037331, 0.50460208],
           [ 0.15644637, 0.21293126, 0.5116095 ],
           [ 0.15729216, 0.21549466, 0.51864395],
           [ 0.15807416, 0.21806441, 0.52570451],
           [ 0.15878825, 0.22064121, 0.53279215],
           [ 0.1594301 , 0.22322589, 0.53990728],
           [ 0.15999746, 0.22582007, 0.54704506],
           [ 0.16048622, 0.22842497, 0.55420386],
           [ 0.16089188, 0.23104196, 0.56138183],
           [ 0.16120952, 0.23367248, 0.56857686],
           [ 0.16143377, 0.23631816, 0.57578653],
           [ 0.16155872, 0.23898076, 0.583008  ],
           [ 0.16157793, 0.24166222, 0.590238  ],
           [ 0.16148435, 0.24436471, 0.59747268],
           [ 0.16127025, 0.2470906 , 0.60470753],
           [ 0.1609272 , 0.24984253, 0.61193725],
           [ 0.16044598, 0.25262344, 0.61915562],
           [ 0.15981655, 0.25543657, 0.62635531],
           [ 0.15902323, 0.2582851 , 0.63353349],
           [ 0.15805184, 0.26117304, 0.64068173],
           [ 0.15689338, 0.26410533, 0.64778267],
           [ 0.15553362, 0.26708693, 0.65482235],
           [ 0.1539574 , 0.27012323, 0.66178456],
           [ 0.15212884, 0.27321974, 0.66866731],
           [ 0.15004087, 0.27638362, 0.67543723],
           [ 0.14768102, 0.27962185, 0.68206438],
           [ 0.14499545, 0.28294239, 0.68854289],
           [ 0.14199585, 0.28635262, 0.69481765],
           [ 0.13863186, 0.2898614 , 0.70086942],
           [ 0.1349136 , 0.29347486, 0.70664362],
           [ 0.13079338, 0.29720146, 0.71211193],
           [ 0.12629615, 0.30104363, 0.71721849],
           [ 0.12142429, 0.30500298, 0.72192403],
           [ 0.11618831, 0.30907824, 0.72619426],
           [ 0.11064197, 0.31326107, 0.72999963],
           [ 0.10483874, 0.31754025, 0.7333275 ],
           [ 0.09884412, 0.32190111, 0.73617986],
           [ 0.09274008, 0.32632566, 0.73857346],
           [ 0.08660745, 0.33079572, 0.74053763],
           [ 0.0805196 , 0.33529476, 0.74210907],
           [ 0.07455574, 0.339807  , 0.74332937],
           [ 0.06880939, 0.34431686, 0.74424457],
           [ 0.0633252 , 0.34881721, 0.74489033],
           [ 0.05820686, 0.35329584, 0.74531085],
           [ 0.05350594, 0.35774924, 0.74553506],
           [ 0.04931799, 0.36217032, 0.74559801],
           [ 0.04569546, 0.3665586 , 0.74551969],
           [ 0.04274431, 0.37090778, 0.74533281],
           [ 0.04048845, 0.37522119, 0.7450453 ],
           [ 0.0389932 , 0.37949488, 0.7446826 ],
           [ 0.03830251, 0.38372944, 0.7442575 ],
           [ 0.03837933, 0.38792678, 0.74377722],
           [ 0.03920747, 0.39208653, 0.74325491],
           [ 0.0407716 , 0.39620746, 0.7427065 ],
           [ 0.04296193, 0.40029296, 0.74213151],
           [ 0.04571434, 0.40434384, 0.7415372 ],
           [ 0.04895176, 0.40836099, 0.74092981],
           [ 0.05260077, 0.41234509, 0.74031605],
           [ 0.05659405, 0.41629659, 0.73970312],
           [ 0.06086504, 0.42021778, 0.73909024],
           [ 0.06536138, 0.42410971, 0.73848087],
           [ 0.07003878, 0.42797345, 0.73787795],
           [ 0.07486024, 0.43181006, 0.73728405],
           [ 0.07979525, 0.43562059, 0.73670134],
           [ 0.08481877, 0.43940606, 0.73613168],
           [ 0.08991042, 0.44316747, 0.73557667],
           [ 0.09505364, 0.44690577, 0.73503767],
           [ 0.10023504, 0.45062191, 0.73451581],
           [ 0.10544388, 0.45431673, 0.73401239],
           [ 0.11067144, 0.45799109, 0.73352828],
           [ 0.11591079, 0.46164592, 0.73306355],
           [ 0.12115649, 0.465282  , 0.7326188 ],
           [ 0.12640422, 0.46890008, 0.73219451],
           [ 0.13165064, 0.47250087, 0.73179107],
           [ 0.13689318, 0.47608507, 0.73140878],
           [ 0.14212993, 0.4796533 , 0.73104786],
           [ 0.14735951, 0.4832062 , 0.73070847],
           [ 0.15258099, 0.48674433, 0.73039073],
           [ 0.1577938 , 0.49026825, 0.73009467],
           [ 0.16299771, 0.49377848, 0.7298203 ],
           [ 0.16819273, 0.49727551, 0.72956758],
           [ 0.1733791 , 0.50075979, 0.72933643],
           [ 0.17855726, 0.50423175, 0.72912674],
           [ 0.18372781, 0.50769178, 0.72893837],
           [ 0.18889149, 0.51114026, 0.72877114],
           [ 0.19404917, 0.51457753, 0.72862486],
           [ 0.19920183, 0.51800389, 0.72849931],
           [ 0.20435054, 0.52141964, 0.72839426],
           [ 0.20949647, 0.52482502, 0.72830945],
           [ 0.21464085, 0.52822026, 0.72824461],
           [ 0.219785  , 0.53160557, 0.72819947],
           [ 0.2249303 , 0.5349811 , 0.72817373],
           [ 0.23007819, 0.53834701, 0.7281671 ],
           [ 0.23523017, 0.5417034 , 0.72817927],
           [ 0.2403878 , 0.54505036, 0.72820993],
           [ 0.24555267, 0.54838795, 0.72825879],
           [ 0.25072643, 0.5517162 , 0.72832553],
           [ 0.25591078, 0.55503511, 0.72840987],
           [ 0.26110744, 0.55834464, 0.72851152],
           [ 0.26631817, 0.56164475, 0.72863021],
           [ 0.27154477, 0.56493533, 0.72876568],
           [ 0.27678906, 0.56821629, 0.7289177 ],
           [ 0.28205286, 0.57148747, 0.72908607],
           [ 0.28733802, 0.57474871, 0.72927062],
           [ 0.29264639, 0.57799981, 0.7294712 ],
           [ 0.2979798 , 0.58124056, 0.72968773],
           [ 0.30334008, 0.5844707 , 0.72992014],
           [ 0.30872901, 0.58768997, 0.73016845],
           [ 0.31414834, 0.5908981 , 0.73043272],
           [ 0.31959975, 0.59409477, 0.73071307],
           [ 0.32508485, 0.59727967, 0.73100971],
           [ 0.33060514, 0.60045248, 0.73132291],
           [ 0.33616202, 0.60361287, 0.73165302],
           [ 0.34175676, 0.60676052, 0.73200048],
           [ 0.34739074, 0.60989508, 0.73236543],
           [ 0.35306469, 0.61301625, 0.73274877],
           [ 0.3587791 , 0.61612376, 0.7331515 ],
           [ 0.3645344 , 0.61921734, 0.73357446],
           [ 0.37033081, 0.62229676, 0.73401859],
           [ 0.37616825, 0.62536185, 0.73448491],
           [ 0.3820464 , 0.62841247, 0.7349745 ],
           [ 0.3879646 , 0.63144854, 0.73548853],
           [ 0.39392195, 0.63447006, 0.73602825],
           [ 0.39991721, 0.63747708, 0.73659491],
           [ 0.40594886, 0.64046972, 0.73718984],
           [ 0.41201433, 0.64344829, 0.73781513],
           [ 0.41811207, 0.64641303, 0.73847157],
           [ 0.42423981, 0.6493643 , 0.73916043],
           [ 0.43039507, 0.65230255, 0.73988294],
           [ 0.43657523, 0.65522829, 0.74064027],
           [ 0.44277754, 0.65814212, 0.74143349],
           [ 0.44899916, 0.66104468, 0.74226358],
           [ 0.45523722, 0.66393667, 0.74313142],
           [ 0.46148884, 0.66681883, 0.74403774],
           [ 0.46775119, 0.66969195, 0.74498318],
           [ 0.4740215 , 0.67255684, 0.74596821],
           [ 0.48029712, 0.67541433, 0.74699317],
           [ 0.48657552, 0.67826525, 0.74805828],
           [ 0.49285435, 0.68111044, 0.7491636 ],
           [ 0.49913141, 0.68395072, 0.75030908],
           [ 0.50540471, 0.68678692, 0.75149454],
           [ 0.51167243, 0.68961982, 0.75271968],
           [ 0.51793296, 0.6924502 , 0.75398412],
           [ 0.52418488, 0.69527879, 0.75528737],
           [ 0.53042697, 0.69810631, 0.75662886],
           [ 0.53665817, 0.70093342, 0.75800798],
           [ 0.54287759, 0.70376077, 0.75942404],
           [ 0.5490794 , 0.70659004, 0.76087991],
           [ 0.55526676, 0.70942105, 0.76237214],
           [ 0.56143995, 0.7122542 , 0.76389941],
           [ 0.56759867, 0.71509001, 0.76546091],
           [ 0.57374272, 0.71792894, 0.76705581],
           [ 0.57987197, 0.72077145, 0.76868332],
           [ 0.58598289, 0.72361876, 0.77034495],
           [ 0.59207312, 0.72647184, 0.7720415 ],
           [ 0.59814827, 0.72932985, 0.77376842],
           [ 0.60420847, 0.73219314, 0.77552495],
           [ 0.61025387, 0.73506205, 0.77731037],
           [ 0.61627838, 0.73793842, 0.77912812],
           [ 0.62228412, 0.74082215, 0.78097622],
           [ 0.62827566, 0.74371251, 0.78285113],
           [ 0.63425321, 0.74660979, 0.78475227],
           [ 0.64021122, 0.74951572, 0.78668281],
           [ 0.64615044, 0.75243049, 0.78864186],
           [ 0.65207654, 0.755353  , 0.79062532],
           [ 0.65798965, 0.75828355, 0.79263277],
           [ 0.66388068, 0.76122481, 0.79466979],
           [ 0.6697578 , 0.76417499, 0.79673076],
           [ 0.6756228 , 0.76713394, 0.79881424],
           [ 0.68147106, 0.77010319, 0.80092296],
           [ 0.68730201, 0.77308319, 0.80305705],
           [ 0.69312163, 0.77607266, 0.80521241],
           [ 0.6989276 , 0.77907249, 0.80739031],
           [ 0.70471525, 0.78208427, 0.80959361],
           [ 0.71049221, 0.78510618, 0.81181716],
           [ 0.71625694, 0.78813893, 0.81406178],
           [ 0.72200403, 0.7911843 , 0.81633084],
           [ 0.72774085, 0.79424052, 0.81861938],
           [ 0.73346579, 0.79730828, 0.82092829],
           [ 0.73917474, 0.80038902, 0.82326014],
           [ 0.7448736 , 0.80348134, 0.82561092],
           [ 0.75056043, 0.80658604, 0.82798176],
           [ 0.75623327, 0.80970394, 0.83037385],
           [ 0.76189593, 0.8128342 , 0.83278453],
           [ 0.7675464 , 0.81597764, 0.83521502],
           [ 0.77318467, 0.81913453, 0.8376652 ],
           [ 0.77881242, 0.82230461, 0.84013382],
           [ 0.78442818, 0.82548856, 0.84262174],
           [ 0.79003289, 0.82868636, 0.84512821],
           [ 0.79562649, 0.83189825, 0.84765312],
           [ 0.80120893, 0.8351245 , 0.85019639],
           [ 0.80678051, 0.83836525, 0.85275762],
           [ 0.81234017, 0.84162106, 0.85533742],
           [ 0.81789016, 0.84489151, 0.85793406],
           [ 0.82342843, 0.84817744, 0.86054876],
           [ 0.8289543 , 0.85147931, 0.86318182],
           [ 0.83447136, 0.85479626, 0.86583048],
           [ 0.83997543, 0.85812981, 0.86849747],
           [ 0.84546684, 0.86148012, 0.8711823 ],
           [ 0.85094933, 0.86484627, 0.87388198],
           [ 0.85641738, 0.86823022, 0.87660018],
           [ 0.86187194, 0.87163193, 0.87933588],
           [ 0.86731711, 0.8750504 , 0.88208562],
           [ 0.872746  , 0.87848802, 0.88485409],
           [ 0.87815874, 0.88194502, 0.88764074],
           [ 0.8835619 , 0.88541964, 0.89043992],
           [ 0.88894628, 0.88891503, 0.89325809],
           [ 0.89431024, 0.89243199, 0.89609591],
           [ 0.89966112, 0.89596856, 0.89894662],
           [ 0.90499137, 0.89952741, 0.90181531],
           [ 0.9102966 , 0.90311022, 0.90470462],
           [ 0.91557418, 0.90671817, 0.90761568],
           [ 0.92083077, 0.91034961, 0.91054117],
           [ 0.92605296, 0.91400905, 0.91349121],
           [ 0.93123405, 0.91769896, 0.91647033],
           [ 0.93636444, 0.92142267, 0.919486  ],
           [ 0.94142592, 0.92518603, 0.92255498],
           [ 0.94634709, 0.92901013, 0.92575324]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
