import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::CodeStar::GitHubRepository`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 */
export interface CfnGitHubRepositoryProps {
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryAccessToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryaccesstoken
     */
    readonly repositoryAccessToken: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryname
     */
    readonly repositoryName: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryowner
     */
    readonly repositoryOwner: string;
    /**
     * `AWS::CodeStar::GitHubRepository.Code`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-code
     */
    readonly code?: CfnGitHubRepository.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.EnableIssues`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-enableissues
     */
    readonly enableIssues?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.IsPrivate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-isprivate
     */
    readonly isPrivate?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositorydescription
     */
    readonly repositoryDescription?: string;
}
/**
 * A CloudFormation `AWS::CodeStar::GitHubRepository`
 *
 * @cloudformationResource AWS::CodeStar::GitHubRepository
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 */
export declare class CfnGitHubRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeStar::GitHubRepository";
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryAccessToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryaccesstoken
     */
    repositoryAccessToken: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryname
     */
    repositoryName: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryowner
     */
    repositoryOwner: string;
    /**
     * `AWS::CodeStar::GitHubRepository.Code`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-code
     */
    code: CfnGitHubRepository.CodeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.EnableIssues`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-enableissues
     */
    enableIssues: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.IsPrivate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-isprivate
     */
    isPrivate: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositorydescription
     */
    repositoryDescription: string | undefined;
    /**
     * Create a new `AWS::CodeStar::GitHubRepository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGitHubRepositoryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnGitHubRepository {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-code.html
     */
    interface CodeProperty {
        /**
         * `CfnGitHubRepository.CodeProperty.S3`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-code.html#cfn-codestar-githubrepository-code-s3
         */
        readonly s3: CfnGitHubRepository.S3Property | cdk.IResolvable;
    }
}
export declare namespace CfnGitHubRepository {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html
     */
    interface S3Property {
        /**
         * `CfnGitHubRepository.S3Property.Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-bucket
         */
        readonly bucket: string;
        /**
         * `CfnGitHubRepository.S3Property.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-key
         */
        readonly key: string;
        /**
         * `CfnGitHubRepository.S3Property.ObjectVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-objectversion
         */
        readonly objectVersion?: string;
    }
}
