#  Copyright 2022 Ruiguo (Ray) Yang
#
#     Licensed under the Apache License, Version 2.0 (the "License");
#     you may not use this file except in compliance with the License.
#     You may obtain a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#     Unless required by applicable law or agreed to in writing, software
#     distributed under the License is distributed on an "AS IS" BASIS,
#     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#     See the License for the specific language governing permissions and
#     limitations under the License.
#

from __future__ import annotations

from dataclasses import dataclass
from typing import Any, Optional

from testscribe.namedvalues import NamedValues


@dataclass(frozen=True)
class RuntimeValues:
    # parameters to the constructor if the target is a method
    init_values: NamedValues
    instance: Any  # class instance
    # The init_values and values have been transformed to a format suitable to be
    # saved in a YAML format.
    values: Optional[NamedValues]
    # The transformed result
    # The result is None if there is an exception.
    result: Any
    exception: Exception
