// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

import React from 'react';


const MitoIcon = (props: {height?: string, width?: string}): JSX.Element => {
    return (
        <svg width={props.width || "25"} height={props.height || "25"} viewBox="0 0 36 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M4.27806 14.4605C4.41192 13.3117 5.01895 12.0216 5.97434 10.7002C7.05826 9.20103 8.57046 7.68957 10.2741 6.33985C11.9773 4.99054 13.8647 3.80854 15.6941 2.96488C17.5272 2.11946 19.2841 1.62217 20.731 1.62217H20.8262L20.8973 1.55886C22.3577 0.258248 24.1677 0.253529 25.9155 1.11776C27.6712 1.98588 29.3356 3.7235 30.4197 5.84055C31.0401 7.05223 31.4658 8.37926 31.6121 9.72767C31.4497 10.4602 31.1397 11.1739 30.6606 11.8437C29.3761 13.639 26.8438 15.1631 22.5518 15.856L22.4863 15.8666L22.4347 15.9082C21.4334 16.7156 20.5213 17.566 19.6548 18.3822C19.5897 18.4435 19.5249 18.5047 19.4603 18.5656C18.6629 19.3172 17.9036 20.033 17.1378 20.6632C15.4886 22.0206 13.8431 22.9522 11.813 22.9575C7.78218 22.385 5.10127 18.758 4.27806 14.4605ZM8.07142 22.403C6.88109 21.2513 5.86085 19.9151 5.17471 18.5227C6.56859 21.1106 8.80658 23.0423 11.761 23.4551L11.7783 23.4575H11.7956C14.0044 23.4575 15.7662 22.4397 17.4555 21.0493C18.235 20.4078 19.0063 19.6806 19.8006 18.9319C19.8661 18.8701 19.9318 18.8082 19.9976 18.7462C20.8491 17.9441 21.7325 17.1207 22.6972 16.339C27.0236 15.6292 29.6835 14.0688 31.0672 12.1346C31.3017 11.8069 31.4986 11.4697 31.6603 11.1258C31.6376 11.6681 31.5653 12.2087 31.4378 12.7414C30.8855 15.0491 29.2908 17.2422 26.141 18.8137C25.1942 19.2071 24.2969 19.8633 23.4233 20.6105C22.8835 21.0722 22.3406 21.5797 21.7977 22.0873C21.4643 22.399 21.131 22.7107 20.7983 23.0118C19.0215 24.6198 17.2161 25.9694 15.1112 25.9694C12.9939 25.9694 10.2755 24.5356 8.07142 22.403ZM31.7045 7.69414C31.4887 6.97391 31.204 6.27528 30.8647 5.61267C29.932 3.7912 28.5772 2.22312 27.0733 1.21431C27.108 1.23321 27.1426 1.25235 27.1771 1.27174C29.0479 2.32337 30.567 4.0771 31.291 6.01628C31.4961 6.56563 31.6371 7.12861 31.7045 7.69414ZM10.479 5.54883C12.213 4.17852 14.1208 2.97754 15.9474 2.1189C17.788 1.25371 19.5255 0.745911 20.9111 0.745911H20.9596L21.0046 0.727788C21.1373 0.67428 21.2705 0.625511 21.4039 0.58136C21.1408 0.730055 20.8844 0.909881 20.6364 1.12282C19.1081 1.14374 17.3123 1.66796 15.4847 2.51083C13.799 3.28822 12.0713 4.34354 10.479 5.54883Z" fill="#00090F"/>
            <path d="M4.27806 14.4605C4.41192 13.3117 5.01895 12.0216 5.97434 10.7002C7.05826 9.20103 8.57046 7.68957 10.2741 6.33985C11.9773 4.99054 13.8647 3.80854 15.6941 2.96488C17.5272 2.11946 19.2841 1.62217 20.731 1.62217H20.8262L20.8973 1.55886C22.3577 0.258248 24.1677 0.253529 25.9155 1.11776C27.6712 1.98588 29.3356 3.7235 30.4197 5.84055C31.0401 7.05223 31.4658 8.37926 31.6121 9.72767C31.4497 10.4602 31.1397 11.1739 30.6606 11.8437C29.3761 13.639 26.8438 15.1631 22.5518 15.856L22.4863 15.8666L22.4347 15.9082C21.4334 16.7156 20.5213 17.566 19.6548 18.3822C19.5897 18.4435 19.5249 18.5047 19.4603 18.5656C18.6629 19.3172 17.9036 20.033 17.1378 20.6632C15.4886 22.0206 13.8431 22.9522 11.813 22.9575C7.78218 22.385 5.10127 18.758 4.27806 14.4605ZM8.07142 22.403C6.88109 21.2513 5.86085 19.9151 5.17471 18.5227C6.56859 21.1106 8.80658 23.0423 11.761 23.4551L11.7783 23.4575H11.7956C14.0044 23.4575 15.7662 22.4397 17.4555 21.0493C18.235 20.4078 19.0063 19.6806 19.8006 18.9319C19.8661 18.8701 19.9318 18.8082 19.9976 18.7462C20.8491 17.9441 21.7325 17.1207 22.6972 16.339C27.0236 15.6292 29.6835 14.0688 31.0672 12.1346C31.3017 11.8069 31.4986 11.4697 31.6603 11.1258C31.6376 11.6681 31.5653 12.2087 31.4378 12.7414C30.8855 15.0491 29.2908 17.2422 26.141 18.8137C25.1942 19.2071 24.2969 19.8633 23.4233 20.6105C22.8835 21.0722 22.3406 21.5797 21.7977 22.0873C21.4643 22.399 21.131 22.7107 20.7983 23.0118C19.0215 24.6198 17.2161 25.9694 15.1112 25.9694C12.9939 25.9694 10.2755 24.5356 8.07142 22.403ZM31.7045 7.69414C31.4887 6.97391 31.204 6.27528 30.8647 5.61267C29.932 3.7912 28.5772 2.22312 27.0733 1.21431C27.108 1.23321 27.1426 1.25235 27.1771 1.27174C29.0479 2.32337 30.567 4.0771 31.291 6.01628C31.4961 6.56563 31.6371 7.12861 31.7045 7.69414ZM10.479 5.54883C12.213 4.17852 14.1208 2.97754 15.9474 2.1189C17.788 1.25371 19.5255 0.745911 20.9111 0.745911H20.9596L21.0046 0.727788C21.1373 0.67428 21.2705 0.625511 21.4039 0.58136C21.1408 0.730055 20.8844 0.909881 20.6364 1.12282C19.1081 1.14374 17.3123 1.66796 15.4847 2.51083C13.799 3.28822 12.0713 4.34354 10.479 5.54883Z" fill="url(#paint0_linear)"/>
            <path d="M4.27806 14.4605C4.41192 13.3117 5.01895 12.0216 5.97434 10.7002C7.05826 9.20103 8.57046 7.68957 10.2741 6.33985C11.9773 4.99054 13.8647 3.80854 15.6941 2.96488C17.5272 2.11946 19.2841 1.62217 20.731 1.62217H20.8262L20.8973 1.55886C22.3577 0.258248 24.1677 0.253529 25.9155 1.11776C27.6712 1.98588 29.3356 3.7235 30.4197 5.84055C31.0401 7.05223 31.4658 8.37926 31.6121 9.72767C31.4497 10.4602 31.1397 11.1739 30.6606 11.8437C29.3761 13.639 26.8438 15.1631 22.5518 15.856L22.4863 15.8666L22.4347 15.9082C21.4334 16.7156 20.5213 17.566 19.6548 18.3822C19.5897 18.4435 19.5249 18.5047 19.4603 18.5656C18.6629 19.3172 17.9036 20.033 17.1378 20.6632C15.4886 22.0206 13.8431 22.9522 11.813 22.9575C7.78218 22.385 5.10127 18.758 4.27806 14.4605ZM8.07142 22.403C6.88109 21.2513 5.86085 19.9151 5.17471 18.5227C6.56859 21.1106 8.80658 23.0423 11.761 23.4551L11.7783 23.4575H11.7956C14.0044 23.4575 15.7662 22.4397 17.4555 21.0493C18.235 20.4078 19.0063 19.6806 19.8006 18.9319C19.8661 18.8701 19.9318 18.8082 19.9976 18.7462C20.8491 17.9441 21.7325 17.1207 22.6972 16.339C27.0236 15.6292 29.6835 14.0688 31.0672 12.1346C31.3017 11.8069 31.4986 11.4697 31.6603 11.1258C31.6376 11.6681 31.5653 12.2087 31.4378 12.7414C30.8855 15.0491 29.2908 17.2422 26.141 18.8137C25.1942 19.2071 24.2969 19.8633 23.4233 20.6105C22.8835 21.0722 22.3406 21.5797 21.7977 22.0873C21.4643 22.399 21.131 22.7107 20.7983 23.0118C19.0215 24.6198 17.2161 25.9694 15.1112 25.9694C12.9939 25.9694 10.2755 24.5356 8.07142 22.403ZM31.7045 7.69414C31.4887 6.97391 31.204 6.27528 30.8647 5.61267C29.932 3.7912 28.5772 2.22312 27.0733 1.21431C27.108 1.23321 27.1426 1.25235 27.1771 1.27174C29.0479 2.32337 30.567 4.0771 31.291 6.01628C31.4961 6.56563 31.6371 7.12861 31.7045 7.69414ZM10.479 5.54883C12.213 4.17852 14.1208 2.97754 15.9474 2.1189C17.788 1.25371 19.5255 0.745911 20.9111 0.745911H20.9596L21.0046 0.727788C21.1373 0.67428 21.2705 0.625511 21.4039 0.58136C21.1408 0.730055 20.8844 0.909881 20.6364 1.12282C19.1081 1.14374 17.3123 1.66796 15.4847 2.51083C13.799 3.28822 12.0713 4.34354 10.479 5.54883Z" stroke="black" strokeWidth="0.5"/>
            <g filter="url(#filter0_d)">
                <path d="M22.5916 16.1028C18.6195 19.3058 16.0425 23.2075 11.7956 23.2075C7.55216 22.6146 4.79526 18.7684 4 14.3321C4 8.89088 15.1567 0.495911 20.9111 0.495911C29.6603 -3.03026 39.906 13.3076 22.5916 16.1028Z" fill="#4FBFE8"/>
                <path d="M22.5518 15.856L22.4863 15.8666L22.4347 15.9082C21.4334 16.7156 20.5213 17.566 19.6548 18.3822C19.5897 18.4435 19.5249 18.5046 19.4603 18.5655C18.663 19.3171 17.9036 20.0329 17.1378 20.6632C15.4886 22.0206 13.8431 22.9522 11.813 22.9575C7.73525 22.3784 5.03904 18.6732 4.25006 14.3102C4.25756 13.0333 4.91743 11.5494 6.03489 10.0223C7.15426 8.49265 8.71139 6.94887 10.4529 5.56953C12.1938 4.19062 14.1116 2.98186 15.9474 2.1189C17.788 1.25371 19.5255 0.745911 20.9111 0.745911H20.9596L21.0046 0.727787C23.1081 -0.119971 25.3091 0.221693 27.1771 1.27174C29.0479 2.32337 30.567 4.0771 31.291 6.01628C32.0133 7.95094 31.9406 10.0545 30.6606 11.8437C29.3761 13.639 26.8438 15.1631 22.5518 15.856Z" stroke="#0A0A0A" strokeWidth="0.5"/>
            </g>
            <defs>
                <filter id="filter0_d" x="0" y="0" width="36" height="31.2075" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                    <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                    <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/>
                    <feOffset dy="4"/>
                    <feGaussianBlur stdDeviation="2"/>
                    <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
                    <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/>
                    <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow" result="shape"/>
                </filter>
                <linearGradient id="paint0_linear" x1="24.6767" y1="23.0067" x2="-1.7759" y2="-21.8983" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#D17485"/>
                    <stop offset="1" stopColor="white" stopOpacity="0"/>
                </linearGradient>
            </defs>
        </svg>
    )
}

export default MitoIcon;


