# Stormwater-Management-Model

ORD Stormwater Management Model (aka "SWMM")

## Introduction
This is the open source SWMM source code repository maintained by the Open
Water Analytics group.

SWMM is a dynamic hydrology-hydraulic water quality simulation model. It is
used for single event or long-term (continuous) simulation of runoff quantity
and quality from primarily urban areas. SWMM source code is written in the C
Programming Language and released under combination a of MIT-License and Public
Domain. For more information on licensing, please see the [LICENSE](https://github.com/OpenWaterAnalytics/Stormwater-Management-Model/blob/develop/LICENSE).

## Project Information

[![license](https://img.shields.io/github/license/mashape/apistatus.svg)](https://github.com/OpenWaterAnalytics/Stormwater-Management-Model/blob/develop/LICENSE)
[![docs](https://img.shields.io/badge/docs-passing-green.svg)](http://wateranalytics.org/Stormwater-Management-Model/)

![build](https://github.com/OpenWaterAnalytics/Stormwater-Management-Model/workflows/Build%20and%20Test/badge.svg?branch=master)

## Citing This Work

Open source software is typically developed by unpaid community-forward volunteers
who see greater purpose for their code bases.  The contributors dedicate much of
their own time to make robust software so that it can be used and easily understood
by users.  When you use any of the compiled or raw code, build scripts, testing
or testing artifacts found in this project consider the amount of time it took
the contributing members to make it.  The following link provides the appropriate
way to cite this software. Show your appreciation through proper citation!

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5484299.svg)](https://doi.org/10.5281/zenodo.5484299)

## Contributing

Everyone is welcome to contribute to this project.

See [CONTRIBUTING.md](https://github.com/OpenWaterAnalytics/Stormwater-Management-Model/wiki/Contributing) for instructions on setting your development environment.

## OWA-SWMM Testing

To run the test suite for please refer to the [REGRESSION_TESTING.md](https://github.com/OpenWaterAnalytics/Stormwater-Management-Model/wiki/Testing-System)

## Code of Conduct

The SWMM Project follows the [Contributor Covenant Code of Conduct](https://github.com/OpenWaterAnalytics/Stormwater-Management-Model/wiki/Code-of-Conduct)
