from setuptools import setup
from pycomm3 import __version__
import os


def read(file_name):
    return open(os.path.join(os.path.dirname(__file__), file_name)).read()


setup(
    name="pycomm3",
    version=__version__,
    author='Ian Ottoway',
    author_email="ian@ottoway.dev",
    url="https://github.com/ottowayi/pycomm3",
    description="A Python Ethernet/IP library for communicating with Allen-Bradley PLCs.",
    long_description=read('README.rst'),
    license="MIT",
    packages=['pycomm3', 'pycomm3.packets'],
    python_requires='>=3.6',
    install_requires=['autologging',
                      'pywin32;platform_system=="Windows"'],
    include_package_data=True,
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Intended Audience :: Manufacturing',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Scientific/Engineering :: Interface Engine/Protocol Translator',
        'Topic :: Scientific/Engineering :: Human Machine Interfaces',
    ],

)

# Build and Publish Commands:
#
# python setup.py sdist bdist_wheel
# twine upload --skip-existing dist/*
