"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTimeEdit(PySide6.QtWidgets.QDateTimeEdit):
    """
    https://doc.qt.io/qt-6/qtimeedit.html

    **Detailed Description**

    ![](images/windows-timeedit.png)

    Many of the properties and functions provided by QTimeEdit are implemented
    in **QDateTimeEdit** . These are the relevant properties of this class:

    * **time**  holds the time displayed by the widget.
      * **minimumTime**
    defines the minimum (earliest) time that can be set by the user.
      *
    **maximumTime**  defines the maximum (latest) time that can be set by the
    user.
      * **displayFormat**  contains a string that is used to format the
    time displayed in the widget.

    **See also** **QDateEdit**  and **QDateTimeEdit** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtimeedit.html#QTimeEdit

        **QTimeEdit::QTimeEdit(QWidget * parent = nullptr)**

        Constructs an empty time editor with a **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        time: PySide6.QtCore.QTime,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtimeedit.html#QTimeEdit-1

        **QTimeEdit::QTimeEdit(QTime time , QWidget * parent = nullptr)**

        Constructs an empty time editor with a **parent**. The time is set to
        **time**.
        """
        ...
