"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStyleOption(object):
    """
    https://doc.qt.io/qt-6/qstyleoption.html

    **Detailed Description**

    QStyleOption and its subclasses contain all the information that **QStyle**
    functions need to draw a graphical element.

    For performance reasons, there are few member functions and the access to
    the member variables is direct (i.e., using the `.` or `->` operator). This
    makes the structures straightforward to use and emphasizes that these are
    simply parameters used by the style functions.

    The caller of a **QStyle**  function usually creates QStyleOption objects on
    the stack. This combined with Qt's extensive use of **implicit sharing**
    for types such as **QString** , **QPalette** , and **QColor**  ensures that
    no memory allocation needlessly takes place.

    The following code snippet shows how to use a specific QStyleOption subclass
    to paint a push button:

    void MyPushButton::paintEvent(**QPaintEvent**  *)
        {
    **QStyleOptionButton**  option;
            option.initFrom(this);
    option.state = isDown() ? **QStyle** ::State_Sunken : **QStyle**
    ::State_Raised;
            if (isDefault())
                option.features |=
    **QStyleOptionButton** ::DefaultButton;
            option.text = text();
    option.icon = icon();

            **QPainter**  painter(this);
    style()->drawControl(**QStyle** ::CE_PushButton, &option, &painter, this);
    }

    In our example, the control is a **QStyle::CE_PushButton** , and according
    to the **QStyle::drawControl** () documentation the corresponding class is
    **QStyleOptionButton** .

    When reimplementing **QStyle**  functions that take a QStyleOption
    parameter, you often need to cast the QStyleOption to a subclass. For
    safety, you can use **qstyleoption_cast** () to ensure that the pointer type
    is correct. For example:

    void MyStyle::drawPrimitive(PrimitiveElement element,
    const **QStyleOption**  *option,
    **QPainter**  *painter,
                                    const **QWidget**
    *widget)
        {
            if (element == PE_FrameFocusRect) {
                const
    **QStyleOptionFocusRect**  *focusRectOption =
    qstyleoption_cast<const **QStyleOptionFocusRect**  *>(option);
    if (focusRectOption) {
                    // ...
                }
            }
    // ...
        }

    The **qstyleoption_cast** () function will return 0 if the object to which
    `option` points is not of the correct type.

    For an example demonstrating how style options can be used, see the
    **Styles**  example.

    **See also** **QStyle**  and **QStylePainter** .
    """

    SO_Default: QStyleOption.OptionType = ...
    SO_FocusRect: QStyleOption.OptionType = ...
    SO_Button: QStyleOption.OptionType = ...
    SO_Tab: QStyleOption.OptionType = ...
    SO_MenuItem: QStyleOption.OptionType = ...
    SO_Frame: QStyleOption.OptionType = ...
    SO_ProgressBar: QStyleOption.OptionType = ...
    SO_ToolBox: QStyleOption.OptionType = ...
    SO_Header: QStyleOption.OptionType = ...
    SO_DockWidget: QStyleOption.OptionType = ...
    SO_ViewItem: QStyleOption.OptionType = ...
    SO_TabWidgetFrame: QStyleOption.OptionType = ...
    SO_TabBarBase: QStyleOption.OptionType = ...
    SO_RubberBand: QStyleOption.OptionType = ...
    SO_ToolBar: QStyleOption.OptionType = ...
    SO_GraphicsItem: QStyleOption.OptionType = ...
    SO_CustomBase: QStyleOption.OptionType = ...
    SO_Complex: QStyleOption.OptionType = ...
    SO_Slider: QStyleOption.OptionType = ...
    SO_SpinBox: QStyleOption.OptionType = ...
    SO_ToolButton: QStyleOption.OptionType = ...
    SO_ComboBox: QStyleOption.OptionType = ...
    SO_TitleBar: QStyleOption.OptionType = ...
    SO_GroupBox: QStyleOption.OptionType = ...
    SO_SizeGrip: QStyleOption.OptionType = ...
    SO_ComplexCustomBase: QStyleOption.OptionType = ...
    Type: QStyleOption.StyleOptionType = ...
    Version: QStyleOption.StyleOptionVersion = ...

    class OptionType(Enum):
        SO_Default: QStyleOption.OptionType = ...
        SO_FocusRect: QStyleOption.OptionType = ...
        SO_Button: QStyleOption.OptionType = ...
        SO_Tab: QStyleOption.OptionType = ...
        SO_MenuItem: QStyleOption.OptionType = ...
        SO_Frame: QStyleOption.OptionType = ...
        SO_ProgressBar: QStyleOption.OptionType = ...
        SO_ToolBox: QStyleOption.OptionType = ...
        SO_Header: QStyleOption.OptionType = ...
        SO_DockWidget: QStyleOption.OptionType = ...
        SO_ViewItem: QStyleOption.OptionType = ...
        SO_TabWidgetFrame: QStyleOption.OptionType = ...
        SO_TabBarBase: QStyleOption.OptionType = ...
        SO_RubberBand: QStyleOption.OptionType = ...
        SO_ToolBar: QStyleOption.OptionType = ...
        SO_GraphicsItem: QStyleOption.OptionType = ...
        SO_CustomBase: QStyleOption.OptionType = ...
        SO_Complex: QStyleOption.OptionType = ...
        SO_Slider: QStyleOption.OptionType = ...
        SO_SpinBox: QStyleOption.OptionType = ...
        SO_ToolButton: QStyleOption.OptionType = ...
        SO_ComboBox: QStyleOption.OptionType = ...
        SO_TitleBar: QStyleOption.OptionType = ...
        SO_GroupBox: QStyleOption.OptionType = ...
        SO_SizeGrip: QStyleOption.OptionType = ...
        SO_ComplexCustomBase: QStyleOption.OptionType = ...

    class StyleOptionType(Enum):
        Type: QStyleOption.StyleOptionType = ...

    class StyleOptionVersion(Enum):
        Version: QStyleOption.StyleOptionVersion = ...

    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOption) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoption.html#QStyleOption

        **QStyleOption::QStyleOption(int version = QStyleOption::Version, int
        type = SO_Default)**

        Constructs a QStyleOption with the specified **version** and **type**.

        The version has no special meaning for QStyleOption; it can be used by
        subclasses to distinguish between different version of the same option
        type.

        The **state**  member variable is initialized to **QStyle::State_None**
        .

        **See also** **version**  and **type** .
        """
        ...

    @overload
    def __init__(self, version: int = ..., type: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoption.html#QStyleOption-1

        **QStyleOption::QStyleOption(const QStyleOption & other )**

        Constructs a copy of **other**.
        """
        ...

    def initFrom(self, w: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoption.html#initFrom

        **void QStyleOption::initFrom(const QWidget * widget )**

        Initializes the **state** , **direction** , **rect** , **palette** ,
        **fontMetrics**  and **styleObject**  member variables based on the
        specified **widget**.

        This is a convenience function; the member variables can also be
        initialized manually.

        **See also** **QWidget::layoutDirection** (), **QWidget::rect** (),
        **QWidget::palette** (), and **QWidget::fontMetrics** ().
        """
        ...
