"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStackedLayout(PySide6.QtWidgets.QLayout):
    """
    https://doc.qt.io/qt-6/qstackedlayout.html

    **Detailed Description**

    QStackedLayout can be used to create a user interface similar to the one
    provided by **QTabWidget** . There is also a convenience **QStackedWidget**
    class built on top of QStackedLayout.

    A QStackedLayout can be populated with a number of child widgets ("pages").
    For example:

    **QWidget**  *firstPageWidget = new **QWidget** ;
            **QWidget**
    *secondPageWidget = new **QWidget** ;
            **QWidget**  *thirdPageWidget
    = new **QWidget** ;

            **QStackedLayout**  *stackedLayout = new
    **QStackedLayout** ;
            stackedLayout->addWidget(firstPageWidget);
    stackedLayout->addWidget(secondPageWidget);
    stackedLayout->addWidget(thirdPageWidget);

            **QVBoxLayout**
    *mainLayout = new **QVBoxLayout** ;
    mainLayout->addLayout(stackedLayout);
            setLayout(mainLayout);

    QStackedLayout provides no intrinsic means for the user to switch page. This
    is typically done through a **QComboBox**  or a **QListWidget**  that stores
    the titles of the QStackedLayout's pages. For example:

    **QComboBox**  *pageComboBox = new **QComboBox** ;
    pageComboBox->addItem(tr("Page 1"));
            pageComboBox->addItem(tr("Page
    2"));
            pageComboBox->addItem(tr("Page 3"));
    connect(pageComboBox, &**QComboBox** ::activated,
    stackedLayout, &**QStackedLayout** ::setCurrentIndex);

    When populating a layout, the widgets are added to an internal list. The
    **indexOf** () function returns the index of a widget in that list. The
    widgets can either be added to the end of the list using the **addWidget**
    () function, or inserted at a given index using the **insertWidget** ()
    function. The **removeWidget** () function removes the widget at the given
    index from the layout. The number of widgets contained in the layout, can be
    obtained using the **count** () function.

    The **widget** () function returns the widget at a given index position. The
    index of the widget that is shown on screen is given by **currentIndex** ()
    and can be changed using **setCurrentIndex** (). In a similar manner, the
    currently shown widget can be retrieved using the **currentWidget** ()
    function, and altered using the **setCurrentWidget** () function.

    Whenever the current widget in the layout changes or a widget is removed
    from the layout, the **currentChanged** () and **widgetRemoved** () signals
    are emitted respectively.

    **See also** **QStackedWidget**  and **QTabWidget** .
    """

    StackOne: QStackedLayout.StackingMode = ...
    StackAll: QStackedLayout.StackingMode = ...

    class StackingMode(Enum):
        StackOne: QStackedLayout.StackingMode = ...
        StackAll: QStackedLayout.StackingMode = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#QStackedLayout

        **QStackedLayout::QStackedLayout()**

        Constructs a QStackedLayout with no parent.

        This QStackedLayout must be installed on a widget later on to become
        effective.

        **See also** **addWidget** () and **insertWidget** ().
        """
        ...

    @overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#QStackedLayout-1

        **QStackedLayout::QStackedLayout(QWidget * parent )**

        Constructs a new QStackedLayout with the given **parent**.

        This layout will install itself on the **parent** widget and manage the
        geometry of its children.
        """
        ...

    @overload
    def __init__(self, parentLayout: PySide6.QtWidgets.QLayout) -> None:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#QStackedLayout-2

        **QStackedLayout::QStackedLayout(QLayout * parentLayout )**

        Constructs a new QStackedLayout and inserts it into the given
        **parentLayout**.
        """
        ...

    def addItem(self, item: PySide6.QtWidgets.QLayoutItem) -> None:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#addItem

        **[override virtual] void QStackedLayout::addItem(QLayoutItem * item )**

        Reimplements: **QLayout::addItem** (QLayoutItem *item).
        """
        ...

    def addWidget(self, w: PySide6.QtWidgets.QWidget) -> int:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#addWidget

        **int QStackedLayout::addWidget(QWidget * widget )**

        Adds the given **widget** to the end of this layout and returns the
        index position of the **widget**.

        If the **QStackedLayout**  is empty before this function is called, the
        given **widget** becomes the current widget.

        **See also** **insertWidget** (), **removeWidget** (), and
        **setCurrentWidget** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#count-prop

        **[read-only] count : const int**

        This property holds the number of widgets contained in the layout

        **Access functions:**

        virtual int **count** () const override

        **See also** **currentIndex** () and **widget** ().
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index position of the widget that is visible

        The current index is -1 if there is no current widget.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )

        **See also** **currentWidget** () and **indexOf** ().
        """
        ...

    def currentWidget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#currentWidget

        **QWidget *QStackedLayout::currentWidget() const**

        Returns the current widget, or `nullptr` if there are no widgets in this
        layout.

        **See also** **currentIndex** () and **setCurrentWidget** ().
        """
        ...

    def hasHeightForWidth(self) -> bool:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#hasHeightForWidth

        **[override virtual] bool QStackedLayout::hasHeightForWidth() const**

        Reimplements: **QLayoutItem::hasHeightForWidth() const** .
        """
        ...

    def heightForWidth(self, width: int) -> int:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#heightForWidth

        **[override virtual] int QStackedLayout::heightForWidth(int width )
        const**

        Reimplements: **QLayoutItem::heightForWidth(int) const** .
        """
        ...

    def insertWidget(self, index: int, w: PySide6.QtWidgets.QWidget) -> int:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#insertWidget

        **int QStackedLayout::insertWidget(int index , QWidget * widget )**

        Inserts the given **widget** at the given **index** in this
        **QStackedLayout** . If **index** is out of range, the widget is
        appended (in which case it is the actual index of the **widget** that is
        returned).

        If the **QStackedLayout**  is empty before this function is called, the
        given **widget** becomes the current widget.

        Inserting a new widget at an index less than or equal to the current
        index will increment the current index, but keep the current widget.

        **See also** **addWidget** (), **removeWidget** (), and
        **setCurrentWidget** ().
        """
        ...

    def itemAt(self, arg__1: int) -> PySide6.QtWidgets.QLayoutItem:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#itemAt

        **[override virtual] QLayoutItem *QStackedLayout::itemAt(int index )
        const**

        Reimplements: **QLayout::itemAt(int index) const** .
        """
        ...

    def minimumSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#minimumSize

        **[override virtual] QSize QStackedLayout::minimumSize() const**

        Reimplements: **QLayout::minimumSize() const** .
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index position of the widget that is visible

        The current index is -1 if there is no current widget.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )

        **See also** **currentWidget** () and **indexOf** ().
        """
        ...

    def setCurrentWidget(self, w: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#setCurrentWidget

        **[slot] void QStackedLayout::setCurrentWidget(QWidget * widget )**

        Sets the current widget to be the specified **widget**. The new current
        widget must already be contained in this stacked layout.

        **See also** **setCurrentIndex** () and **currentWidget** ().
        """
        ...

    def setGeometry(self, rect: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#setGeometry

        **[override virtual] void QStackedLayout::setGeometry(const QRect & rect
        )**

        Reimplements: **QLayout::setGeometry** (const QRect &r).
        """
        ...

    def setStackingMode(
        self, stackingMode: PySide6.QtWidgets.QStackedLayout.StackingMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#stackingMode-prop

        **stackingMode : StackingMode**

        determines the way visibility of child widgets are handled.

        The default value is **StackOne** . Setting the property to **StackAll**
        allows you to make use of the layout for overlay widgets that do
        additional drawing on top of other widgets, for example, graphical
        editors.

        **Access functions:**

        QStackedLayout::StackingMode **stackingMode** () const
        void
        **setStackingMode** (QStackedLayout::StackingMode **stackingMode** )

        **Member Function Documentation**
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#sizeHint

        **[override virtual] QSize QStackedLayout::sizeHint() const**

        Reimplements: **QLayoutItem::sizeHint() const** .
        """
        ...

    def stackingMode(self) -> PySide6.QtWidgets.QStackedLayout.StackingMode:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#stackingMode-prop

        **stackingMode : StackingMode**

        determines the way visibility of child widgets are handled.

        The default value is **StackOne** . Setting the property to **StackAll**
        allows you to make use of the layout for overlay widgets that do
        additional drawing on top of other widgets, for example, graphical
        editors.

        **Access functions:**

        QStackedLayout::StackingMode **stackingMode** () const
        void
        **setStackingMode** (QStackedLayout::StackingMode **stackingMode** )

        **Member Function Documentation**
        """
        ...

    def takeAt(self, arg__1: int) -> PySide6.QtWidgets.QLayoutItem:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#takeAt

        **[override virtual] QLayoutItem *QStackedLayout::takeAt(int index )**

        Reimplements: **QLayout::takeAt** (int index).
        """
        ...

    @overload
    def widget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#widget

        **QWidget *QStackedLayout::widget(int index ) const**

        Returns the widget at the given **index** , or `nullptr` if there is no
        widget at the given position.

        **See also** **currentWidget** () and **indexOf** ().
        """
        ...

    @overload
    def widget(self, arg__1: int) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#widget

        **QWidget *QStackedLayout::widget(int index ) const**

        Returns the widget at the given **index** , or `nullptr` if there is no
        widget at the given position.

        **See also** **currentWidget** () and **indexOf** ().
        """
        ...

    @property
    def currentChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#currentChanged

        **[signal] void QStackedLayout::currentChanged(int index )**

        This signal is emitted whenever the current widget in the layout
        changes. The **index** specifies the index of the new current widget, or
        -1 if there isn't a new one (for example, if there are no widgets in the
        **QStackedLayout** )

        **Note:** Notifier signal for property **currentIndex** .

        **See also** **currentWidget** () and **setCurrentWidget** ().
        """
        ...

    @property
    def widgetRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qstackedlayout.html#widgetRemoved

        **[signal] void QStackedLayout::widgetRemoved(int index )**

        This signal is emitted whenever a widget is removed from the layout. The
        widget's **index** is passed as parameter.

        **See also** **removeWidget** ().
        """
        ...
