"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QRubberBand(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qrubberband.html

    **Detailed Description**

    A rubber band is often used to show a new bounding area (as in a
    **QSplitter**  or a **QDockWidget**  that is undocking). Historically this
    has been implemented using a **QPainter**  and XOR, but this approach
    doesn't always work properly since rendering can happen in the window below
    the rubber band, but before the rubber band has been "erased".

    You can create a QRubberBand whenever you need to render a rubber band
    around a given area (or to represent a single line), then call
    **setGeometry** (), **move** () or **resize** () to position and size it. A
    common pattern is to do this in conjunction with mouse events. For example:

    void Widget::mousePressEvent(**QMouseEvent**  *event)
        {
            origin =
    event->pos();
            if (!rubberBand)
                rubberBand = new
    **QRubberBand** (**QRubberBand** ::Rectangle, this);
    rubberBand->setGeometry(**QRect** (origin, **QSize** ()));
    rubberBand->show();
        }

        void
    Widget::mouseMoveEvent(**QMouseEvent**  *event)
        {
    rubberBand->setGeometry(**QRect** (origin, event->pos()).normalized());
    }

        void Widget::mouseReleaseEvent(**QMouseEvent**  *event)
        {
    rubberBand->hide();
            // determine selection, for example using
    QRect::intersects()
            // and QRect::contains().
        }

    If you pass a parent to QRubberBand's constructor, the rubber band will
    display only inside its parent, but stays on top of other child widgets. If
    no parent is passed, QRubberBand will act as a top-level widget.

    Call **show** () to make the rubber band visible; also when the rubber band
    is not a top-level. Hiding or destroying the widget will make the rubber
    band disappear. The rubber band can be a **Rectangle**  or a **Line**
    (vertical or horizontal), depending on the **shape** () it was given when
    constructed.
    """

    Line: QRubberBand.Shape = ...
    Rectangle: QRubberBand.Shape = ...

    class Shape(Enum):
        Line: QRubberBand.Shape = ...
        Rectangle: QRubberBand.Shape = ...

    def __init__(
        self,
        arg__1: PySide6.QtWidgets.QRubberBand.Shape,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#QRubberBand

        **QRubberBand::QRubberBand(QRubberBand::Shape s , QWidget * p =
        nullptr)**

        Constructs a rubber band of shape **s** , with parent **p**.

        By default a rectangular rubber band ( **s** is `Rectangle`) will use a
        mask, so that a small border of the rectangle is all that is visible.
        Some styles (e.g., native macOS) will change this and call
        **QWidget::setWindowOpacity** () to make a semi-transparent filled
        selection rectangle.
        """
        ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#changeEvent

        **[override virtual protected] void QRubberBand::changeEvent(QEvent * e
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qrubberband.html#event

        **[override virtual protected] bool QRubberBand::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionRubberBand) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#initStyleOption

        **[virtual protected] void
        QRubberBand::initStyleOption(QStyleOptionRubberBand * option ) const**

        Initialize **option** with the values from this **QRubberBand** . This
        method is useful for subclasses when they need a
        **QStyleOptionRubberBand** , but don't want to fill in all the
        information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    @overload
    def move(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#move

        **void QRubberBand::move(int x , int y )**

        Moves the rubberband to point ( **x** , **y** ).

        **See also** **resize** ().
        """
        ...

    @overload
    def move(self, x: int, y: int) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#move-1

        **void QRubberBand::move(const QPoint & p )**

        This is an overloaded function.

        Moves the rubberband to point **p**.

        **See also** **resize** ().
        """
        ...

    def moveEvent(self, arg__1: PySide6.QtGui.QMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#moveEvent

        **[override virtual protected] void QRubberBand::moveEvent(QMoveEvent
        *)**

        Reimplements: **QWidget::moveEvent** (QMoveEvent *event).
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#paintEvent

        **[override virtual protected] void QRubberBand::paintEvent(QPaintEvent
        *)**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    @overload
    def resize(self, s: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#resize

        **void QRubberBand::resize(int width , int height )**

        Resizes the rubberband so that its width is **width** , and its height
        is **height**.

        **See also** **move** ().
        """
        ...

    @overload
    def resize(self, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#resize-1

        **void QRubberBand::resize(const QSize & size )**

        This is an overloaded function.

        Resizes the rubberband so that its new size is **size**.

        **See also** **move** ().
        """
        ...

    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#resizeEvent

        **[override virtual protected] void
        QRubberBand::resizeEvent(QResizeEvent *)**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    @overload
    def setGeometry(self, r: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#setGeometry

        **void QRubberBand::setGeometry(const QRect & rect )**

        Sets the geometry of the rubber band to **rect** , specified in the
        coordinate system of its parent widget.

        **See also** **QWidget::geometry** .
        """
        ...

    @overload
    def setGeometry(self, x: int, y: int, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#setGeometry-1

        **void QRubberBand::setGeometry(int x , int y , int width , int height
        )**

        This is an overloaded function.

        Sets the geometry of the rubberband to the rectangle whose top-left
        corner lies at the point ( **x** , **y** ), and with dimensions
        specified by **width** and **height**. The geometry is specified in the
        parent widget's coordinate system.
        """
        ...

    def shape(self) -> PySide6.QtWidgets.QRubberBand.Shape:
        """
        https://doc.qt.io/qt-6/qrubberband.html#shape

        **QRubberBand::Shape QRubberBand::shape() const**

        Returns the shape of this rubber band. The shape can only be set upon
        construction.
        """
        ...

    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qrubberband.html#showEvent

        **[override virtual protected] void QRubberBand::showEvent(QShowEvent *
        e )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...
