"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QProxyStyle(PySide6.QtWidgets.QCommonStyle):
    """
    https://doc.qt.io/qt-6/qproxystyle.html

    **Detailed Description**

    A QProxyStyle wraps a **QStyle**  (usually the default system style) for the
    purpose of dynamically overriding painting or other specific style behavior.

    The following example shows how to override the shortcut underline behavior
    on any platform:

    #include "textedit.h"
        #include <QApplication>
        #include <QProxyStyle>
    class MyProxyStyle : public **QProxyStyle**
        {
          public:
            int
    styleHint(StyleHint hint, const **QStyleOption**  *option = nullptr,
    const **QWidget**  *widget = nullptr, **QStyleHintReturn**  *returnData =
    nullptr) const override
            {
                if (hint ==
    QStyle::SH_UnderlineShortcut)
                    return 0;
                return
    **QProxyStyle** ::styleHint(hint, option, widget, returnData);
            }
    };

        int main(int argc, char **argv)
        {
    Q_INIT_RESOURCE(textedit);

            **QApplication**  a(argc, argv);
    a.setStyle(new MyProxyStyle);
            TextEdit mw;
            mw.resize(700,
    800);
            mw.show();
            //...
        }

    Warning: The **common styles**  provided by Qt will respect this hint,
    because they call **QStyle::proxy** (), but there is no guarantee that
    **QStyle::proxy** () will be called for user defined or system controlled
    styles. It would not work on a Mac, for example, where menus are handled by
    the operating system.

    When a proxy style should be set on a specific widget only, you have to make
    sure to not set the proxy on the global application style which is returned
    by **QWidget::style** (). You have to create a separate custom style for the
    widget similar to:

    ...
        auto proxy = new MyProxyStyle(**QApplication** ::style()->name());
    proxy->setParent(widget);   // take ownership to avoid memleak
    widget->setStyle(proxy);
        ...

    **See also** **QStyle** .
    """

    @overload
    def __init__(self, key: str) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#QProxyStyle

        **QProxyStyle::QProxyStyle(QStyle * style = nullptr)**

        Constructs a QProxyStyle object for overriding behavior in the specified
        **style** , or in the default native **style**  if **style** is not
        specified.

        Ownership of **style** is transferred to QProxyStyle.
        """
        ...

    @overload
    def __init__(self, style: Optional[PySide6.QtWidgets.QStyle] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#QProxyStyle-1

        **QProxyStyle::QProxyStyle(const QString & key )**

        Constructs a QProxyStyle object for overriding behavior in the base
        style specified by style **key** , or in the current **application
        style**  if the specified style **key** is unrecognized.

        **See also** **QStyleFactory::create** ().
        """
        ...

    def baseStyle(self) -> PySide6.QtWidgets.QStyle:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#baseStyle

        **QStyle *QProxyStyle::baseStyle() const**

        Returns the proxy base style object. If no base style is set on the
        proxy style, **QProxyStyle**  will create an instance of the application
        style instead.

        **See also** **setBaseStyle** () and **QStyle** .
        """
        ...

    def drawComplexControl(
        self,
        control: PySide6.QtWidgets.QStyle.ComplexControl,
        option: PySide6.QtWidgets.QStyleOptionComplex,
        painter: PySide6.QtGui.QPainter,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#drawComplexControl

        **[override virtual] void
        QProxyStyle::drawComplexControl(QStyle::ComplexControl control , const
        QStyleOptionComplex * option , QPainter * painter , const QWidget *
        widget = nullptr) const**

        Reimplements: **QCommonStyle::drawComplexControl(QStyle::ComplexControl
        cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)
        const** .
        """
        ...

    def drawControl(
        self,
        element: PySide6.QtWidgets.QStyle.ControlElement,
        option: PySide6.QtWidgets.QStyleOption,
        painter: PySide6.QtGui.QPainter,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#drawControl

        **[override virtual] void
        QProxyStyle::drawControl(QStyle::ControlElement element , const
        QStyleOption * option , QPainter * painter , const QWidget * widget =
        nullptr) const**

        Reimplements: **QCommonStyle::drawControl(QStyle::ControlElement
        element, const QStyleOption *opt, QPainter *p, const QWidget *widget)
        const** .
        """
        ...

    def drawItemPixmap(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: PySide6.QtCore.QRect,
        alignment: int,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#drawItemPixmap

        **[override virtual] void QProxyStyle::drawItemPixmap(QPainter * painter
        , const QRect & rect , int alignment , const QPixmap & pixmap ) const**

        Reimplements: **QStyle::drawItemPixmap(QPainter *painter, const QRect
        &rectangle, int alignment, const QPixmap &pixmap) const** .
        """
        ...

    def drawItemText(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: PySide6.QtCore.QRect,
        flags: int,
        pal: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
        enabled: bool,
        text: str,
        textRole: PySide6.QtGui.QPalette.ColorRole = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#drawItemText

        **[override virtual] void QProxyStyle::drawItemText(QPainter * painter ,
        const QRect & rect , int flags , const QPalette & pal , bool enabled ,
        const QString & text , QPalette::ColorRole textRole = QPalette::NoRole)
        const**

        Reimplements: **QStyle::drawItemText(QPainter *painter, const QRect
        &rectangle, int alignment, const QPalette &palette, bool enabled, const
        QString &text, QPalette::ColorRole textRole) const** .
        """
        ...

    def drawPrimitive(
        self,
        element: PySide6.QtWidgets.QStyle.PrimitiveElement,
        option: PySide6.QtWidgets.QStyleOption,
        painter: PySide6.QtGui.QPainter,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#drawPrimitive

        **[override virtual] void
        QProxyStyle::drawPrimitive(QStyle::PrimitiveElement element , const
        QStyleOption * option , QPainter * painter , const QWidget * widget =
        nullptr) const**

        Reimplements: **QCommonStyle::drawPrimitive(QStyle::PrimitiveElement pe,
        const QStyleOption *opt, QPainter *p, const QWidget *widget) const** .
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#event

        **[override virtual protected] bool QProxyStyle::event(QEvent * e )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def generatedIconPixmap(
        self,
        iconMode: PySide6.QtGui.QIcon.Mode,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
        opt: PySide6.QtWidgets.QStyleOption,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#generatedIconPixmap

        **[override virtual] QPixmap
        QProxyStyle::generatedIconPixmap(QIcon::Mode iconMode , const QPixmap &
        pixmap , const QStyleOption * opt ) const**

        Reimplements: **QCommonStyle::generatedIconPixmap(QIcon::Mode iconMode,
        const QPixmap &pixmap, const QStyleOption *opt) const** .
        """
        ...

    def hitTestComplexControl(
        self,
        control: PySide6.QtWidgets.QStyle.ComplexControl,
        option: PySide6.QtWidgets.QStyleOptionComplex,
        pos: PySide6.QtCore.QPoint,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtWidgets.QStyle.SubControl:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#hitTestComplexControl

        **[override virtual] QStyle::SubControl
        QProxyStyle::hitTestComplexControl(QStyle::ComplexControl control ,
        const QStyleOptionComplex * option , const QPoint & pos , const QWidget
        * widget = nullptr) const**

        Reimplements:
        **QCommonStyle::hitTestComplexControl(QStyle::ComplexControl cc, const
        QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)
        const** .
        """
        ...

    def itemPixmapRect(
        self,
        r: PySide6.QtCore.QRect,
        flags: int,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#itemPixmapRect

        **[override virtual] QRect QProxyStyle::itemPixmapRect(const QRect & r ,
        int flags , const QPixmap & pixmap ) const**

        Reimplements: **QStyle::itemPixmapRect(const QRect &rectangle, int
        alignment, const QPixmap &pixmap) const** .
        """
        ...

    def itemTextRect(
        self,
        fm: PySide6.QtGui.QFontMetrics,
        r: PySide6.QtCore.QRect,
        flags: int,
        enabled: bool,
        text: str,
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#itemTextRect

        **[override virtual] QRect QProxyStyle::itemTextRect(const QFontMetrics
        & fm , const QRect & r , int flags , bool enabled , const QString & text
        ) const**

        Reimplements: **QStyle::itemTextRect(const QFontMetrics &metrics, const
        QRect &rectangle, int alignment, bool enabled, const QString &text)
        const** .
        """
        ...

    def layoutSpacing(
        self,
        control1: PySide6.QtWidgets.QSizePolicy.ControlType,
        control2: PySide6.QtWidgets.QSizePolicy.ControlType,
        orientation: PySide6.QtCore.Qt.Orientation,
        option: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#layoutSpacing

        **[override virtual] int
        QProxyStyle::layoutSpacing(QSizePolicy::ControlType control1 ,
        QSizePolicy::ControlType control2 , Qt::Orientation orientation , const
        QStyleOption * option = nullptr, const QWidget * widget = nullptr)
        const**

        Reimplements: **QCommonStyle::layoutSpacing(QSizePolicy::ControlType
        control1, QSizePolicy::ControlType control2, Qt::Orientation
        orientation, const QStyleOption *option, const QWidget *widget) const**
        .

        This slot is called by layoutSpacing() to determine the spacing that
        should be used between **control1** and **control2** in a layout.
        **orientation** specifies whether the controls are laid out side by side
        or stacked vertically. The **option** parameter can be used to pass
        extra information about the parent widget. The **widget** parameter is
        optional and can also be used if **option** is `nullptr`.

        The default implementation returns -1.

        **See also** **combinedLayoutSpacing** ().
        """
        ...

    def pixelMetric(
        self,
        metric: PySide6.QtWidgets.QStyle.PixelMetric,
        option: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#pixelMetric

        **[override virtual] int QProxyStyle::pixelMetric(QStyle::PixelMetric
        metric , const QStyleOption * option = nullptr, const QWidget * widget =
        nullptr) const**

        Reimplements: **QCommonStyle::pixelMetric(QStyle::PixelMetric m, const
        QStyleOption *opt, const QWidget *widget) const** .
        """
        ...

    @overload
    def polish(self, app: PySide6.QtWidgets.QApplication) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#polish

        **[override virtual] void QProxyStyle::polish(QWidget * widget )**

        Reimplements: **QCommonStyle::polish** (QWidget *widget).
        """
        ...

    @overload
    def polish(
        self,
        arg__1: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#polish-1

        **[override virtual] void QProxyStyle::polish(QPalette & pal )**

        Reimplements: **QCommonStyle::polish** (QPalette &pal).
        """
        ...

    @overload
    def polish(
        self,
        pal: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#polish-2

        **[override virtual] void QProxyStyle::polish(QApplication * app )**

        Reimplements: **QCommonStyle::polish** (QApplication *app).
        """
        ...

    @overload
    def polish(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#polish

        **[override virtual] void QProxyStyle::polish(QWidget * widget )**

        Reimplements: **QCommonStyle::polish** (QWidget *widget).
        """
        ...

    def setBaseStyle(self, style: PySide6.QtWidgets.QStyle) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#setBaseStyle

        **void QProxyStyle::setBaseStyle(QStyle * style )**

        Sets the base style that should be proxied.

        Ownership of **style** is transferred to **QProxyStyle** .

        If style is `nullptr`, a desktop-dependent style will be assigned
        automatically.

        **See also** **baseStyle** ().
        """
        ...

    def sizeFromContents(
        self,
        type: PySide6.QtWidgets.QStyle.ContentsType,
        option: PySide6.QtWidgets.QStyleOption,
        size: PySide6.QtCore.QSize,
        widget: PySide6.QtWidgets.QWidget,
    ) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#sizeFromContents

        **[override virtual] QSize
        QProxyStyle::sizeFromContents(QStyle::ContentsType type , const
        QStyleOption * option , const QSize & size , const QWidget * widget )
        const**

        Reimplements: **QCommonStyle::sizeFromContents(QStyle::ContentsType ct,
        const QStyleOption *opt, const QSize &csz, const QWidget *widget)
        const** .
        """
        ...

    def standardIcon(
        self,
        standardIcon: PySide6.QtWidgets.QStyle.StandardPixmap,
        option: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#standardIcon

        **[override virtual] QIcon
        QProxyStyle::standardIcon(QStyle::StandardPixmap standardIcon , const
        QStyleOption * option = nullptr, const QWidget * widget = nullptr)
        const**

        Reimplements: **QStyle::standardIcon(QStyle::StandardPixmap
        standardIcon, const QStyleOption *option, const QWidget *widget) const**
        .

        Returns an icon for the given **standardIcon**.

        Reimplement this slot to provide your own icons in a **QStyle**
        subclass. The **option** argument can be used to pass extra information
        required to find the appropriate icon. The **widget** argument is
        optional and can also be used to help find the icon.
        """
        ...

    def standardPalette(self) -> PySide6.QtGui.QPalette:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#standardPalette

        **[override virtual] QPalette QProxyStyle::standardPalette() const**

        Reimplements: **QStyle::standardPalette() const** .
        """
        ...

    def standardPixmap(
        self,
        standardPixmap: PySide6.QtWidgets.QStyle.StandardPixmap,
        opt: PySide6.QtWidgets.QStyleOption,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#standardPixmap

        **[override virtual] QPixmap
        QProxyStyle::standardPixmap(QStyle::StandardPixmap standardPixmap ,
        const QStyleOption * opt , const QWidget * widget = nullptr) const**

        Reimplements: **QCommonStyle::standardPixmap(QStyle::StandardPixmap sp,
        const QStyleOption *option, const QWidget *widget) const** .
        """
        ...

    def styleHint(
        self,
        hint: PySide6.QtWidgets.QStyle.StyleHint,
        option: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
        returnData: Optional[PySide6.QtWidgets.QStyleHintReturn] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#styleHint

        **[override virtual] int QProxyStyle::styleHint(QStyle::StyleHint hint ,
        const QStyleOption * option = nullptr, const QWidget * widget = nullptr,
        QStyleHintReturn * returnData = nullptr) const**

        Reimplements: **QCommonStyle::styleHint(QStyle::StyleHint sh, const
        QStyleOption *opt, const QWidget *widget, QStyleHintReturn *hret)
        const** .
        """
        ...

    def subControlRect(
        self,
        cc: PySide6.QtWidgets.QStyle.ComplexControl,
        opt: PySide6.QtWidgets.QStyleOptionComplex,
        sc: PySide6.QtWidgets.QStyle.SubControl,
        widget: PySide6.QtWidgets.QWidget,
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#subControlRect

        **[override virtual] QRect
        QProxyStyle::subControlRect(QStyle::ComplexControl cc , const
        QStyleOptionComplex * option , QStyle::SubControl sc , const QWidget *
        widget ) const**

        Reimplements: **QCommonStyle::subControlRect(QStyle::ComplexControl cc,
        const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget
        *widget) const** .
        """
        ...

    def subElementRect(
        self,
        element: PySide6.QtWidgets.QStyle.SubElement,
        option: PySide6.QtWidgets.QStyleOption,
        widget: PySide6.QtWidgets.QWidget,
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#subElementRect

        **[override virtual] QRect
        QProxyStyle::subElementRect(QStyle::SubElement element , const
        QStyleOption * option , const QWidget * widget ) const**

        Reimplements: **QCommonStyle::subElementRect(QStyle::SubElement sr,
        const QStyleOption *opt, const QWidget *widget) const** .
        """
        ...

    @overload
    def unpolish(self, app: PySide6.QtWidgets.QApplication) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#unpolish

        **[override virtual] void QProxyStyle::unpolish(QWidget * widget )**

        Reimplements: **QCommonStyle::unpolish** (QWidget *widget).
        """
        ...

    @overload
    def unpolish(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qproxystyle.html#unpolish-1

        **[override virtual] void QProxyStyle::unpolish(QApplication * app )**

        Reimplements: **QCommonStyle::unpolish** (QApplication *application).
        """
        ...
