"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QPinchGesture(PySide6.QtWidgets.QGesture):
    """
    https://doc.qt.io/qt-6/qpinchgesture.html

    **Detailed Description**

    A pinch gesture is a form of touch user input in which the user typically
    touches two points on the input device with a thumb and finger, before
    moving them closer together or further apart to change the scale factor,
    zoom, or level of detail of the user interface.

    For an overview of gesture handling in Qt and information on using gestures
    in your applications, see the **Gestures in Widgets and Graphics View**
    document.

    ![](images/pinchgesture.png)

    Instead of repeatedly applying the same pinching gesture, the user may
    continue to touch the input device in one place, and apply a second touch to
    a new point, continuing the gesture. When this occurs, gesture events will
    continue to be delivered to the target object, containing an instance of
    QPinchGesture in the **Qt::GestureUpdated**  state.

    **See also** **QPanGesture**  and **QSwipeGesture** .
    """

    ScaleFactorChanged: QPinchGesture.ChangeFlag = ...
    RotationAngleChanged: QPinchGesture.ChangeFlag = ...
    CenterPointChanged: QPinchGesture.ChangeFlag = ...

    class ChangeFlag(Enum):
        ScaleFactorChanged: QPinchGesture.ChangeFlag = ...
        RotationAngleChanged: QPinchGesture.ChangeFlag = ...
        CenterPointChanged: QPinchGesture.ChangeFlag = ...

    class ChangeFlags(object):
        ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        ...

    def centerPoint(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#centerPoint-prop

        **centerPoint : QPointF**

        This property holds the current center point

        The center point is the midpoint between the two input points in the
        gesture.

        **Access functions:**

        QPointF **centerPoint** () const
        void **setCenterPoint** (const
        QPointF & **value** )

        **See also** **startCenterPoint**  and **lastCenterPoint** .
        """
        ...

    def changeFlags(self) -> PySide6.QtWidgets.QPinchGesture.ChangeFlags:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#changeFlags-prop

        **changeFlags : ChangeFlags**

        This property holds the property of the gesture that has changed in the
        current step

        This property indicates which of the other properties has changed since
        the previous gesture event included information about this gesture. You
        can use this information to determine which aspect of your user
        interface needs to be updated.

        **Access functions:**

        QPinchGesture::ChangeFlags **changeFlags** () const
        void
        **setChangeFlags** (QPinchGesture::ChangeFlags **value** )

        **See also** **totalChangeFlags** , **scaleFactor** , **rotationAngle**
        , and **centerPoint** .
        """
        ...

    def lastCenterPoint(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#lastCenterPoint-prop

        **lastCenterPoint : QPointF**

        This property holds the last position of the center point recorded for
        this gesture

        **Access functions:**

        QPointF **lastCenterPoint** () const
        void **setLastCenterPoint**
        (const QPointF & **value** )

        **See also** **centerPoint**  and **startCenterPoint** .
        """
        ...

    def lastRotationAngle(self) -> float:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#lastRotationAngle-prop

        **lastRotationAngle : qreal**

        This property holds the last reported angle covered by the gesture
        motion

        The last rotation angle is the angle as reported in the
        **rotationAngle**  property when a previous gesture event was delivered
        for this gesture.

        **Access functions:**

        qreal **lastRotationAngle** () const
        void **setLastRotationAngle**
        (qreal **value** )

        **See also** **rotationAngle**  and **totalRotationAngle** .
        """
        ...

    def lastScaleFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#lastScaleFactor-prop

        **lastScaleFactor : qreal**

        This property holds the last scale factor recorded for this gesture

        The last scale factor contains the scale factor reported in the
        **scaleFactor**  property when a previous gesture event included
        information about this gesture.

        If no previous event was delivered with information about this gesture
        (i.e., this gesture object contains information about the first movement
        in the gesture) then this property contains zero.

        **Access functions:**

        qreal **lastScaleFactor** () const
        void **setLastScaleFactor** (qreal
        **value** )

        **See also** **scaleFactor**  and **totalScaleFactor** .
        """
        ...

    def rotationAngle(self) -> float:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#rotationAngle-prop

        **rotationAngle : qreal**

        This property holds the angle covered by the gesture motion

        **Access functions:**

        qreal **rotationAngle** () const
        void **setRotationAngle** (qreal
        **value** )

        **See also** **totalRotationAngle**  and **lastRotationAngle** .
        """
        ...

    def scaleFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#scaleFactor-prop

        **scaleFactor : qreal**

        This property holds the current scale factor

        The scale factor measures the scale factor associated with the distance
        between two of the user's inputs on a touch device.

        **Access functions:**

        qreal **scaleFactor** () const
        void **setScaleFactor** (qreal
        **value** )

        **See also** **totalScaleFactor**  and **lastScaleFactor** .
        """
        ...

    def setCenterPoint(
        self,
        value: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#centerPoint-prop

        **centerPoint : QPointF**

        This property holds the current center point

        The center point is the midpoint between the two input points in the
        gesture.

        **Access functions:**

        QPointF **centerPoint** () const
        void **setCenterPoint** (const
        QPointF & **value** )

        **See also** **startCenterPoint**  and **lastCenterPoint** .
        """
        ...

    def setChangeFlags(
        self, value: PySide6.QtWidgets.QPinchGesture.ChangeFlags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#changeFlags-prop

        **changeFlags : ChangeFlags**

        This property holds the property of the gesture that has changed in the
        current step

        This property indicates which of the other properties has changed since
        the previous gesture event included information about this gesture. You
        can use this information to determine which aspect of your user
        interface needs to be updated.

        **Access functions:**

        QPinchGesture::ChangeFlags **changeFlags** () const
        void
        **setChangeFlags** (QPinchGesture::ChangeFlags **value** )

        **See also** **totalChangeFlags** , **scaleFactor** , **rotationAngle**
        , and **centerPoint** .
        """
        ...

    def setLastCenterPoint(
        self,
        value: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#lastCenterPoint-prop

        **lastCenterPoint : QPointF**

        This property holds the last position of the center point recorded for
        this gesture

        **Access functions:**

        QPointF **lastCenterPoint** () const
        void **setLastCenterPoint**
        (const QPointF & **value** )

        **See also** **centerPoint**  and **startCenterPoint** .
        """
        ...

    def setLastRotationAngle(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#lastRotationAngle-prop

        **lastRotationAngle : qreal**

        This property holds the last reported angle covered by the gesture
        motion

        The last rotation angle is the angle as reported in the
        **rotationAngle**  property when a previous gesture event was delivered
        for this gesture.

        **Access functions:**

        qreal **lastRotationAngle** () const
        void **setLastRotationAngle**
        (qreal **value** )

        **See also** **rotationAngle**  and **totalRotationAngle** .
        """
        ...

    def setLastScaleFactor(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#lastScaleFactor-prop

        **lastScaleFactor : qreal**

        This property holds the last scale factor recorded for this gesture

        The last scale factor contains the scale factor reported in the
        **scaleFactor**  property when a previous gesture event included
        information about this gesture.

        If no previous event was delivered with information about this gesture
        (i.e., this gesture object contains information about the first movement
        in the gesture) then this property contains zero.

        **Access functions:**

        qreal **lastScaleFactor** () const
        void **setLastScaleFactor** (qreal
        **value** )

        **See also** **scaleFactor**  and **totalScaleFactor** .
        """
        ...

    def setRotationAngle(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#rotationAngle-prop

        **rotationAngle : qreal**

        This property holds the angle covered by the gesture motion

        **Access functions:**

        qreal **rotationAngle** () const
        void **setRotationAngle** (qreal
        **value** )

        **See also** **totalRotationAngle**  and **lastRotationAngle** .
        """
        ...

    def setScaleFactor(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#scaleFactor-prop

        **scaleFactor : qreal**

        This property holds the current scale factor

        The scale factor measures the scale factor associated with the distance
        between two of the user's inputs on a touch device.

        **Access functions:**

        qreal **scaleFactor** () const
        void **setScaleFactor** (qreal
        **value** )

        **See also** **totalScaleFactor**  and **lastScaleFactor** .
        """
        ...

    def setStartCenterPoint(
        self,
        value: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#startCenterPoint-prop

        **startCenterPoint : QPointF**

        This property holds the starting position of the center point

        **Access functions:**

        QPointF **startCenterPoint** () const
        void **setStartCenterPoint**
        (const QPointF & **value** )

        **See also** **centerPoint**  and **lastCenterPoint** .
        """
        ...

    def setTotalChangeFlags(
        self, value: PySide6.QtWidgets.QPinchGesture.ChangeFlags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#totalChangeFlags-prop

        **totalChangeFlags : ChangeFlags**

        This property holds the property of the gesture that has change

        This property indicates which of the other properties has changed since
        the gesture has started. You can use this information to determine which
        aspect of your user interface needs to be updated.

        **Access functions:**

        QPinchGesture::ChangeFlags **totalChangeFlags** () const
        void
        **setTotalChangeFlags** (QPinchGesture::ChangeFlags **value** )

        **See also** **changeFlags** , **scaleFactor** , **rotationAngle** , and
        **centerPoint** .
        """
        ...

    def setTotalRotationAngle(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#totalRotationAngle-prop

        **totalRotationAngle : qreal**

        This property holds the total angle covered by the gesture

        This total angle measures the complete angle covered by the gesture.
        Usually, this is equal to the value held by the **rotationAngle**
        property, except in the case where the user performs multiple rotations
        by removing and repositioning one of the touch points, as described
        above. In this case, the total angle will be the sum of the rotation
        angles for the multiple stages of the gesture.

        **Access functions:**

        qreal **totalRotationAngle** () const
        void **setTotalRotationAngle**
        (qreal **value** )

        **See also** **rotationAngle**  and **lastRotationAngle** .
        """
        ...

    def setTotalScaleFactor(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#totalScaleFactor-prop

        **totalScaleFactor : qreal**

        This property holds the total scale factor

        The total scale factor measures the total change in scale factor from
        the original value to the current scale factor.

        **Access functions:**

        qreal **totalScaleFactor** () const
        void **setTotalScaleFactor**
        (qreal **value** )

        **See also** **scaleFactor**  and **lastScaleFactor** .

        **Member Function Documentation**
        """
        ...

    def startCenterPoint(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#startCenterPoint-prop

        **startCenterPoint : QPointF**

        This property holds the starting position of the center point

        **Access functions:**

        QPointF **startCenterPoint** () const
        void **setStartCenterPoint**
        (const QPointF & **value** )

        **See also** **centerPoint**  and **lastCenterPoint** .
        """
        ...

    def totalChangeFlags(self) -> PySide6.QtWidgets.QPinchGesture.ChangeFlags:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#totalChangeFlags-prop

        **totalChangeFlags : ChangeFlags**

        This property holds the property of the gesture that has change

        This property indicates which of the other properties has changed since
        the gesture has started. You can use this information to determine which
        aspect of your user interface needs to be updated.

        **Access functions:**

        QPinchGesture::ChangeFlags **totalChangeFlags** () const
        void
        **setTotalChangeFlags** (QPinchGesture::ChangeFlags **value** )

        **See also** **changeFlags** , **scaleFactor** , **rotationAngle** , and
        **centerPoint** .
        """
        ...

    def totalRotationAngle(self) -> float:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#totalRotationAngle-prop

        **totalRotationAngle : qreal**

        This property holds the total angle covered by the gesture

        This total angle measures the complete angle covered by the gesture.
        Usually, this is equal to the value held by the **rotationAngle**
        property, except in the case where the user performs multiple rotations
        by removing and repositioning one of the touch points, as described
        above. In this case, the total angle will be the sum of the rotation
        angles for the multiple stages of the gesture.

        **Access functions:**

        qreal **totalRotationAngle** () const
        void **setTotalRotationAngle**
        (qreal **value** )

        **See also** **rotationAngle**  and **lastRotationAngle** .
        """
        ...

    def totalScaleFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qpinchgesture.html#totalScaleFactor-prop

        **totalScaleFactor : qreal**

        This property holds the total scale factor

        The total scale factor measures the total change in scale factor from
        the original value to the current scale factor.

        **Access functions:**

        qreal **totalScaleFactor** () const
        void **setTotalScaleFactor**
        (qreal **value** )

        **See also** **scaleFactor**  and **lastScaleFactor** .

        **Member Function Documentation**
        """
        ...
