"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QHBoxLayout(PySide6.QtWidgets.QBoxLayout):
    """
    https://doc.qt.io/qt-6/qhboxlayout.html

    **Detailed Description**

    This class is used to construct horizontal box layout objects. See
    **QBoxLayout**  for details.

    The simplest use of the class is like this:

    **QWidget**  *window = new **QWidget** ;
            **QPushButton**  *button1 =
    new **QPushButton** ("One");
            **QPushButton**  *button2 = new
    **QPushButton** ("Two");
            **QPushButton**  *button3 = new
    **QPushButton** ("Three");
            **QPushButton**  *button4 = new
    **QPushButton** ("Four");
            **QPushButton**  *button5 = new
    **QPushButton** ("Five");

            **QHBoxLayout**  *layout = new
    **QHBoxLayout** (window);
            layout->addWidget(button1);
    layout->addWidget(button2);
            layout->addWidget(button3);
    layout->addWidget(button4);
            layout->addWidget(button5);
    window->show();

    First, we create the widgets we want to add to the layout. Then, we create
    the QHBoxLayout object, setting `window` as parent by passing it in the
    constructor; next we add the widgets to the layout. `window` will be the
    parent of the widgets that are added to the layout.

    If you don't pass a parent `window` to the constructor, you can at a later
    point use **QWidget::setLayout** () to install the QHBoxLayout object onto
    `window`. At that point, the widgets in the layout are reparented to have
    `window` as their parent.

    ![Horizontal box layout with five child widgets](images/qhboxlayout-
    with-5-children.png)

    **See also** **QVBoxLayout** , **QGridLayout** , **QStackedLayout** ,
    **Layout Management** , and **Basic Layouts Example** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qhboxlayout.html#QHBoxLayout

        **QHBoxLayout::QHBoxLayout()**

        Constructs a new horizontal box. You must add it to another layout.
        """
        ...

    @overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qhboxlayout.html#QHBoxLayout-1

        **QHBoxLayout::QHBoxLayout(QWidget * parent )**

        Constructs a new top-level horizontal box with parent **parent**.

        The layout is set directly as the top-level layout for **parent**. There
        can be only one top-level layout for a widget. It is returned by
        **QWidget::layout** ().

        **See also** **QWidget::setLayout** ().
        """
        ...
